/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.SingleExprIDHolder;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLToken;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public abstract class BaseExpr
implements Expr,
ExpressionTypes {
    protected static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    protected boolean encounteredException = false;
    protected ErrorCollectionException collectionException = null;
    private EJBQLToken mainEJBQLToken = null;
    private EJBQLToken preEJBQLToken = null;
    private EJBQLToken postEJBQLToken = null;
    protected QueryContext globalContext;
    protected QueryNode queryTree;
    protected int type;
    protected Expr term1 = null;
    protected Expr term2 = null;
    protected Expr term3 = null;
    protected Expr term4 = null;
    protected Expr term5 = null;
    protected Expr term6 = null;
    protected Vector terms = null;
    protected long ival;
    protected double fval;
    protected String sval;
    protected int termCount;
    protected int termVectorSize = 0;
    private int nextTerm = 1;
    private StringBuffer sqlStringBuffer;
    public String debugClassName = "BaseExpr";

    public BaseExpr(int n) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
    }

    protected BaseExpr(int n, Expr expr) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
    }

    protected BaseExpr(int n, Expr expr, Expr expr2) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
        this.term2 = expr2;
        if (expr2 != null) {
            ++this.termCount;
        }
    }

    protected BaseExpr(int n, Expr expr, Expr expr2, Expr expr3) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
        this.term2 = expr2;
        if (expr2 != null) {
            ++this.termCount;
        }
        this.term3 = expr3;
        if (expr3 != null) {
            ++this.termCount;
        }
    }

    protected BaseExpr(int n, Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
        this.term2 = expr2;
        if (expr2 != null) {
            ++this.termCount;
        }
        this.term3 = expr3;
        if (expr3 != null) {
            ++this.termCount;
        }
        this.term4 = expr4;
        if (expr4 != null) {
            ++this.termCount;
        }
    }

    protected BaseExpr(int n, Expr expr, Expr expr2, Expr expr3, Expr expr4, Expr expr5) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
        this.term2 = expr2;
        if (expr2 != null) {
            ++this.termCount;
        }
        this.term3 = expr3;
        if (expr3 != null) {
            ++this.termCount;
        }
        this.term4 = expr4;
        if (expr4 != null) {
            ++this.termCount;
        }
        this.term5 = expr5;
        if (expr5 != null) {
            ++this.termCount;
        }
    }

    protected BaseExpr(int n, Expr expr, Expr expr2, Expr expr3, Expr expr4, Expr expr5, Expr expr6) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.termCount = 0;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
        this.term2 = expr2;
        if (expr2 != null) {
            ++this.termCount;
        }
        this.term3 = expr3;
        if (expr3 != null) {
            ++this.termCount;
        }
        this.term4 = expr4;
        if (expr4 != null) {
            ++this.termCount;
        }
        this.term5 = expr5;
        if (expr5 != null) {
            ++this.termCount;
        }
        this.term6 = expr6;
        if (expr6 != null) {
            ++this.termCount;
        }
    }

    protected BaseExpr(int n, Expr expr, Vector vector) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.term1 = expr;
        if (expr != null) {
            ++this.termCount;
        }
        this.terms = vector;
        this.termVectorSize = vector.size();
    }

    protected BaseExpr(int n, String string) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug(" Expr Constructor called for: '" + TYPE_NAMES[n] + "'");
        }
        this.type = n;
        this.sval = n == 18 ? string.substring(1, string.length() - 1) : string;
        if (n == 19) {
            this.sval = string;
            this.ival = Long.parseLong(string);
        } else if (n == 20) {
            this.fval = Double.valueOf(string);
            this.sval = string;
        } else if (n == 25) {
            this.sval = string;
            this.ival = Integer.valueOf(string).intValue();
        } else if (n == 53) {
            this.sval = string;
        }
    }

    public final void init(QueryContext queryContext, QueryNode queryNode) throws ErrorCollectionException {
        this.globalContext = queryContext;
        this.queryTree = queryNode;
        this.init_method();
        this.throwCollectionException();
    }

    public final void calculate() throws ErrorCollectionException {
        this.calculate_method();
        this.throwCollectionException();
    }

    public abstract void init_method() throws ErrorCollectionException;

    public abstract void calculate_method() throws ErrorCollectionException;

    protected abstract Expr invertForNOT() throws ErrorCollectionException;

    public void addCollectionException(Exception exception) {
        if (this.collectionException == null) {
            this.collectionException = new ErrorCollectionException((Throwable)exception);
            return;
        }
        this.collectionException.add((Throwable)exception);
    }

    public void addCollectionExceptionAndThrow(Exception exception) throws ErrorCollectionException {
        this.addCollectionException(exception);
        throw this.collectionException;
    }

    public void throwCollectionException() throws ErrorCollectionException {
        if (this.collectionException != null) {
            throw this.collectionException;
        }
    }

    public void markExcAndAddCollectionException(Exception exception) {
        this.encounteredException = true;
        this.getMainEJBQLToken().setHadException(true);
        this.addCollectionException(exception);
    }

    public void markExcAndThrowCollectionException(Exception exception) throws ErrorCollectionException {
        this.markExcAndAddCollectionException(exception);
        this.throwCollectionException();
    }

    public String getMainEJBQL() {
        if (this.mainEJBQLToken == null) {
            return "";
        }
        return this.getMainEJBQLToken().getTokenText();
    }

    public void setMainEJBQL(String string) {
        EJBQLToken eJBQLToken = new EJBQLToken();
        this.appendMainEJBQL(string);
    }

    private EJBQLToken getMainEJBQLToken() {
        if (this.mainEJBQLToken == null) {
            this.mainEJBQLToken = new EJBQLToken();
        }
        return this.mainEJBQLToken;
    }

    private EJBQLToken getPreEJBQLToken() {
        if (this.preEJBQLToken == null) {
            this.preEJBQLToken = new EJBQLToken();
        }
        return this.preEJBQLToken;
    }

    private EJBQLToken getPostEJBQLToken() {
        if (this.postEJBQLToken == null) {
            this.postEJBQLToken = new EJBQLToken();
        }
        return this.postEJBQLToken;
    }

    public void prependPreEJBQL(String string) {
        this.getPreEJBQLToken().prependTokenText(string);
    }

    public void appendMainEJBQL(String string) {
        if (string == null) {
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        this.getMainEJBQLToken().appendTokenText(string);
    }

    public void appendMainEJBQL(EJBQLToken eJBQLToken) {
        if (eJBQLToken == null) {
            return;
        }
        String string = eJBQLToken.getTokenText();
        if (string == null) {
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        this.getMainEJBQLToken().appendTokenText(string);
    }

    public void appendPostEJBQL(String string) {
        this.getPostEJBQLToken().appendTokenText(string);
    }

    public abstract void appendEJBQLTokens(List var1);

    protected void appendNewEJBQLTokenToList(String string, List list) {
        EJBQLToken eJBQLToken = new EJBQLToken(string);
        list.add(eJBQLToken);
    }

    protected void appendPreEJBQLTokensToList(List list) {
        if (this.preEJBQLToken == null) {
            return;
        }
        list.add(this.getPreEJBQLToken());
    }

    protected void appendMainEJBQLTokenToList(List list) {
        if (this.mainEJBQLToken == null) {
            return;
        }
        list.add(this.getMainEJBQLToken());
    }

    protected void appendPostEJBQLTokensToList(List list) {
        if (this.postEJBQLToken == null) {
            return;
        }
        list.add(this.getPostEJBQLToken());
    }

    protected void setPreEJBQLFrom(BaseExpr baseExpr) {
        this.preEJBQLToken = null;
        String string = baseExpr.getPreEJBQLToken().getTokenText();
        if (string != null && string.length() > 0) {
            this.prependPreEJBQL(string);
        }
    }

    protected void setPostEJBQLFrom(BaseExpr baseExpr) {
        this.postEJBQLToken = null;
        String string = baseExpr.getPostEJBQLToken().getTokenText();
        if (string != null && string.length() > 0) {
            this.appendPostEJBQL(string);
        }
    }

    public String printEJBQLTree() {
        ArrayList arrayList = new ArrayList();
        this.appendEJBQLTokens(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        for (EJBQLToken eJBQLToken : arrayList) {
            stringBuffer.append(eJBQLToken.getTokenText());
        }
        return stringBuffer.toString();
    }

    protected void clearSQLBuf() {
        if (this.sqlStringBuffer != null) {
            this.sqlStringBuffer.setLength(0);
        }
    }

    protected void appendSQLBuf(String string) {
        if (this.sqlStringBuffer == null) {
            this.sqlStringBuffer = new StringBuffer();
        }
        this.sqlStringBuffer.append(string);
    }

    public StringBuffer getSQLBuf() {
        if (this.sqlStringBuffer == null) {
            this.sqlStringBuffer = new StringBuffer();
        }
        return this.sqlStringBuffer;
    }

    public String toSQL() throws ErrorCollectionException {
        return "";
    }

    public boolean encounteredException() {
        return this.encounteredException;
    }

    public QueryContext getGlobalContext() {
        return this.globalContext;
    }

    public QueryNode getQueryTree() {
        return this.queryTree;
    }

    public int type() {
        return this.type;
    }

    public Expr getTerm1() {
        return this.term1;
    }

    public Expr getTerm2() {
        return this.term2;
    }

    public Expr getTerm3() {
        return this.term3;
    }

    public Expr getTerm4() {
        return this.term4;
    }

    public Expr getTerm5() {
        return this.term5;
    }

    public Expr getTerm6() {
        return this.term6;
    }

    public int numTerms() {
        return this.termCount;
    }

    public boolean hasMoreTerms() {
        return this.nextTerm <= this.termCount;
    }

    public Expr getNextTerm() {
        return this.getTerm(this.nextTerm++);
    }

    public Expr getTerm(int n) {
        switch (n) {
            case 1: {
                return this.term1;
            }
            case 2: {
                return this.term2;
            }
            case 3: {
                return this.term3;
            }
            case 4: {
                return this.term4;
            }
            case 5: {
                return this.term5;
            }
            case 6: {
                return this.term6;
            }
        }
        return null;
    }

    public int getCurrTermNumber() {
        return this.nextTerm - 1;
    }

    public void setNextTerm(int n) {
        this.nextTerm = n;
    }

    public void replaceTermAt(Expr expr, int n) {
        switch (n) {
            case 1: {
                this.term1 = expr;
                break;
            }
            case 2: {
                this.term2 = expr;
                break;
            }
            case 3: {
                this.term3 = expr;
                break;
            }
            case 4: {
                this.term4 = expr;
                break;
            }
            case 5: {
                this.term5 = expr;
                break;
            }
            case 6: {
                this.term6 = expr;
                break;
            }
        }
    }

    public void resetTermNumber() {
        this.nextTerm = 1;
    }

    public Vector getTermVector() {
        return this.terms;
    }

    public int termVectSize() {
        return this.termVectorSize;
    }

    public String getSval() {
        return this.sval;
    }

    public void setSval(String string) {
        this.sval = string;
    }

    public long getIval() {
        return this.ival;
    }

    public double getFval() {
        return this.fval;
    }

    public String getTypeName() {
        return BaseExpr.getTypeName(this.type);
    }

    public static void addBlanksForStringLength(StringBuffer stringBuffer, String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n <= 0) {
            return;
        }
        stringBuffer.append(BaseExpr.getBlankString(n));
    }

    public static String getBlankString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static int numType(String string) {
        if (string.indexOf(46) == -1 && string.indexOf(69) == -1) {
            return 19;
        }
        return 20;
    }

    public static String getTypeName(int n) {
        if (n > TYPE_NAMES.length) {
            return "UNKNOWN TYPE";
        }
        return TYPE_NAMES[n];
    }

    public static int finderStringOrId(String string) {
        if (string.startsWith("@@")) {
            return 40;
        }
        int n = string.indexOf(">>");
        if (n == -1) {
            return 17;
        }
        if (string.indexOf("find", n) != -1) {
            return 35;
        }
        return 17;
    }

    public static String getEjbNameFromFinderString(String string) {
        int n = string.indexOf(">>");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getSelectCast(String string) {
        if (string.length() < 3) {
            return "";
        }
        if (40 != BaseExpr.finderStringOrId(string)) {
            return "";
        }
        return string.substring(2);
    }

    public static Expr getExpressionFromTerms(Expr expr, int n) {
        expr.resetTermNumber();
        while (expr.hasMoreTerms()) {
            Expr expr2 = expr.getNextTerm();
            if (expr2.type() != n) continue;
            return expr2;
        }
        return null;
    }

    public static ExprID getExprIDFromSingleExprIDHolder(Expr expr) throws ErrorCollectionException {
        if (!(expr instanceof SingleExprIDHolder)) {
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, " Internal Error:  attempt to execute: SingleExprIDHolder.getExprID() on an Expr of Class: '" + expr.getClass().getName() + "' which does not implement SingleExprIDHolder");
            expr.markExcAndThrowCollectionException(illegalExpressionException);
        }
        return ((SingleExprIDHolder)((Object)expr)).getExprID();
    }

    public static Expr getAggregateExpressionFromSubQuerySelect(Expr expr) {
        if (expr.type() != 43) {
            return null;
        }
        Expr expr2 = null;
        expr.resetTermNumber();
        while (expr.hasMoreTerms() && (expr2 = expr.getNextTerm()).type() != 34) {
            expr2 = null;
        }
        if (expr2 == null) {
            return null;
        }
        if (expr2.getTermVector() == null) {
            return null;
        }
        Enumeration enumeration = expr2.getTermVector().elements();
        while (enumeration.hasMoreElements()) {
            expr2 = (Expr)enumeration.nextElement();
            if (expr2.type() != 44 && expr2.type() != 45 && expr2.type() != 46 && expr2.type() != 47 && expr2.type() != 48) continue;
            return expr2;
        }
        return null;
    }

    public static String getComparisonOpStringFromType(int n) throws ErrorCollectionException {
        switch (n) {
            case 10: {
                return "<> ";
            }
            case 5: {
                return "= ";
            }
            case 6: {
                return "< ";
            }
            case 7: {
                return "> ";
            }
            case 8: {
                return "<= ";
            }
            case 9: {
                return ">= ";
            }
        }
        throw new ErrorCollectionException("Internal Error, attempt to perform toSQL using an unknown operand type code: '" + n + "', '" + BaseExpr.getTypeName(n) + "'.");
    }

    public String toString() {
        String string = this.toVal();
        return TYPE_NAMES[this.type()] + ": " + (string == null ? this.term1 + "," + this.term2 : string);
    }

    private String toVal() {
        switch (this.type()) {
            case 17: 
            case 18: 
            case 25: 
            case 40: {
                return this.getSval();
            }
            case 19: {
                return this.getIval() + "";
            }
            case 20: {
                return this.getFval() + "";
            }
        }
        return null;
    }

    public void dump() {
        StringBuffer stringBuffer = new StringBuffer();
        BaseExpr.dump(this, 0, stringBuffer);
        System.out.println(stringBuffer.toString());
    }

    public String dumpString() {
        StringBuffer stringBuffer = new StringBuffer();
        BaseExpr.dump(this, 0, stringBuffer);
        return stringBuffer.toString();
    }

    private static void dump(Expr expr, int n, StringBuffer stringBuffer) {
        if (expr.type() == 72) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("| ");
        }
        stringBuffer.append(TYPE_NAMES[expr.type()]);
        switch (expr.type()) {
            case 17: 
            case 25: 
            case 35: 
            case 40: 
            case 53: 
            case 61: 
            case 62: {
                stringBuffer.append(" -- " + expr.getSval()).append("\n");
                break;
            }
            case 18: {
                stringBuffer.append(" -- \"" + expr.getSval() + "\"").append("\n");
                break;
            }
            case 19: {
                stringBuffer.append(" -- " + expr.getIval()).append("\n");
                break;
            }
            case 20: {
                stringBuffer.append(" -- " + expr.getFval()).append("\n");
                break;
            }
            case 16: {
                stringBuffer.append("-- NULL").append("\n");
                break;
            }
            default: {
                stringBuffer.append("\n");
            }
        }
        if (expr.getTerm1() != null) {
            BaseExpr.dump(expr.getTerm1(), n + 1, stringBuffer);
        }
        if (expr.getTerm2() != null) {
            BaseExpr.dump(expr.getTerm2(), n + 1, stringBuffer);
        }
        if (expr.getTerm3() != null) {
            BaseExpr.dump(expr.getTerm3(), n + 1, stringBuffer);
        }
        if (expr.getTerm4() != null) {
            BaseExpr.dump(expr.getTerm4(), n + 1, stringBuffer);
        }
        if (expr.getTerm5() != null) {
            BaseExpr.dump(expr.getTerm5(), n + 1, stringBuffer);
        }
        if (expr.getTerm6() != null) {
            BaseExpr.dump(expr.getTerm6(), n + 1, stringBuffer);
        }
        if (expr.getTermVector() != null) {
            Enumeration enumeration = expr.getTermVector().elements();
            while (enumeration.hasMoreElements()) {
                BaseExpr.dump((Expr)enumeration.nextElement(), n + 1, stringBuffer);
            }
        }
    }

    public static Expr find(Expr expr, int n) {
        if (debugLogger.isDebugEnabled()) {
            BaseExpr.debug("Checking NODE: " + TYPE_NAMES[expr.type()] + "  for type: " + TYPE_NAMES[n]);
        }
        if (expr.type() == n) {
            return expr;
        }
        Expr expr2 = null;
        if (expr.getTerm1() != null && (expr2 = BaseExpr.find(expr.getTerm1(), n)) != null) {
            return expr2;
        }
        if (expr.getTerm2() != null && (expr2 = BaseExpr.find(expr.getTerm2(), n)) != null) {
            return expr2;
        }
        if (expr.getTerm3() != null && (expr2 = BaseExpr.find(expr.getTerm3(), n)) != null) {
            return expr2;
        }
        if (expr.getTerm4() != null && (expr2 = BaseExpr.find(expr.getTerm4(), n)) != null) {
            return expr2;
        }
        if (expr.getTerm5() != null && (expr2 = BaseExpr.find(expr.getTerm5(), n)) != null) {
            return expr2;
        }
        if (expr.getTerm6() != null && (expr2 = BaseExpr.find(expr.getTerm6(), n)) != null) {
            return expr2;
        }
        if (expr.getTermVector() != null) {
            Enumeration enumeration = expr.getTermVector().elements();
            while (enumeration.hasMoreElements()) {
                expr2 = BaseExpr.find((Expr)enumeration.nextElement(), n);
                if (expr2 == null) continue;
                return expr2;
            }
        }
        return null;
    }

    public static String findIdForVariable(Expr expr, int n) {
        if (expr.type() == 5 && expr.getTerm2() != null && expr.getTerm2().type() == 25 && expr.getTerm2().getIval() == (long)n && expr.getTerm1() != null && expr.getTerm1().type() == 17) {
            if (debugLogger.isDebugEnabled()) {
                BaseExpr.debug(" VARIABLE NODE: " + expr.getTerm2().getIval() + ".  returning ID: " + expr.getTerm1().getSval());
            }
            return expr.getTerm1().getSval();
        }
        String string = null;
        if (expr.getTerm1() != null && (string = BaseExpr.findIdForVariable(expr.getTerm1(), n)) != null) {
            return string;
        }
        if (expr.getTerm2() != null && (string = BaseExpr.findIdForVariable(expr.getTerm2(), n)) != null) {
            return string;
        }
        if (expr.getTerm3() != null && (string = BaseExpr.findIdForVariable(expr.getTerm3(), n)) != null) {
            return string;
        }
        if (expr.getTerm4() != null && (string = BaseExpr.findIdForVariable(expr.getTerm4(), n)) != null) {
            return string;
        }
        if (expr.getTerm5() != null && (string = BaseExpr.findIdForVariable(expr.getTerm5(), n)) != null) {
            return string;
        }
        if (expr.getTerm6() != null && (string = BaseExpr.findIdForVariable(expr.getTerm6(), n)) != null) {
            return string;
        }
        if (expr.getTermVector() != null) {
            Enumeration enumeration = expr.getTermVector().elements();
            while (enumeration.hasMoreElements()) {
                string = BaseExpr.findIdForVariable((Expr)enumeration.nextElement(), n);
                if (string == null) continue;
                return string;
            }
        }
        return string;
    }

    protected static void requireTerm(Expr expr, int n) throws ErrorCollectionException {
        IllegalExpressionException illegalExpressionException;
        Expr expr2 = null;
        switch (n) {
            case 1: {
                expr2 = expr.getTerm1();
                break;
            }
            case 2: {
                expr2 = expr.getTerm2();
                break;
            }
            case 3: {
                expr2 = expr.getTerm3();
                break;
            }
            default: {
                illegalExpressionException = new IllegalExpressionException(7, ExpressionTypes.TYPE_NAMES[expr.type()] + " error attempt to requireTerm " + "on term number " + n);
                expr.markExcAndThrowCollectionException(illegalExpressionException);
            }
        }
        if (expr2 == null) {
            illegalExpressionException = new IllegalExpressionException(7, ExpressionTypes.TYPE_NAMES[expr.type()] + " expression has term Number" + n + " == null, this is required to be non-null");
            expr.markExcAndThrowCollectionException(illegalExpressionException);
        }
    }

    protected static void verifyStringExpressionTerm(Expr expr, int n) throws ErrorCollectionException {
        Expr expr2 = null;
        switch (n) {
            case 1: {
                expr2 = expr.getTerm1();
                break;
            }
            case 2: {
                expr2 = expr.getTerm2();
                break;
            }
            case 3: {
                expr2 = expr.getTerm3();
                break;
            }
            default: {
                IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, expr.getTypeName() + " error attempt to verifyStringExpressionTerm " + "on term number " + n);
                expr.markExcAndThrowCollectionException(illegalExpressionException);
            }
        }
        try {
            BaseExpr.verifyStringExpressionType(expr2);
        }
        catch (RDBMSException rDBMSException) {
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, expr.getTypeName() + " function argument " + n + " is of the wrong type: " + rDBMSException.toString());
            expr2.markExcAndThrowCollectionException(illegalExpressionException);
        }
    }

    private static void verifyStringExpressionType(Expr expr) throws RDBMSException {
        if (expr != null && expr.type() != 17 && expr.type() != 18 && expr.type() != 25 && expr.type() != 54 && expr.type() != 55) {
            Loggable loggable = EJBLogger.logfinderInvalidStringExpressionLoggable();
            throw new RDBMSException(expr.getTypeName() + "  " + loggable.getMessage());
        }
    }

    protected void verifyArithmeticExpressionTerm(Expr expr, int n) throws ErrorCollectionException {
        Expr expr2 = null;
        switch (n) {
            case 1: {
                expr2 = expr.getTerm1();
                break;
            }
            case 2: {
                expr2 = expr.getTerm2();
                break;
            }
            case 3: {
                expr2 = expr.getTerm3();
                break;
            }
            default: {
                IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, ExpressionTypes.TYPE_NAMES[expr.type()] + " error attempt to verifyArithmeticExpressionTerm " + "on term number " + n);
                expr.markExcAndThrowCollectionException(illegalExpressionException);
            }
        }
        try {
            this.verifyArithmeticExpressionType(expr2);
        }
        catch (RDBMSException rDBMSException) {
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, ExpressionTypes.TYPE_NAMES[expr.type()] + " function argument " + n + " is of the wrong type: " + rDBMSException.toString());
            expr2.markExcAndThrowCollectionException(illegalExpressionException);
        }
    }

    private void verifyArithmeticExpressionType(Expr expr) throws RDBMSException {
        if (expr != null && expr.type() != 17 && expr.type() != 19 && expr.type() != 20 && expr.type() != 23 && expr.type() != 24 && expr.type() != 22 && expr.type() != 21 && expr.type() != 25 && expr.type() != 57 && expr.type() != 56 && expr.type() != 58 && expr.type() != 59 && expr.type() != 76) {
            Loggable loggable = EJBLogger.logfinderInvalidArithExpressionLoggable();
            throw new RDBMSException(ExpressionTypes.TYPE_NAMES[expr.type()] + "  " + loggable.getMessage());
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseExpr] " + string);
    }
}

