/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.FieldGroup;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprParser;
import weblogic.ejb.container.cmp.rdbms.finders.Expression;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.ejb.container.internal.QueryCachingHandler;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLCompilerException;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLToken;
import weblogic.ejb20.cmp.rdbms.finders.InvalidFinderException;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.ErrorCollectionException;

public class EjbqlFinder
extends Finder {
    private String stopOnMethod = "findTestDisjointOR";
    public static final int FINDER_EXPRESSION_IN = 0;
    public static final int FINDER_EXPRESSION_NOT_IN = 1;
    public static final int REMOTE_BEAN_EQ = 2;
    public static final int REMOTE_BEAN_NOT_EQ = 3;
    public static final int EJBQL_REWRITE_REASON_FACTOR_OUT_NOT = 1;
    public static final String EJBQL_REWRITE_REASON_FACTOR_OUT_NOT_TEXT = "EJB QL 'NOT' Expressions have been factored out and removed to preserve any generated SQL joins.";
    public static final String EJBQL_REWRITE_REASON_DEFAULT_TEXT = "(Reason for rewrite not specified)";
    private String ejbQuery = null;
    private String whereSql = null;
    private String orderbySql = null;
    private String groupbySql = null;
    private String selectHint = null;
    private boolean includeResultCacheHint = false;
    private String sqlQuery = null;
    private String sqlQueryForUpdate = null;
    private String sqlQueryForUpdateSelective = null;
    private String sqlQueryForUpdateNoWait = null;
    private Expression ejbqlExpression = null;
    private Expr ejbqlExpr = null;
    private RDBMSBean keyBean = null;
    protected Map corrVarMap = null;
    protected Map globalRangeVariableMap = null;
    protected List tableJoinList = null;
    private String groupName = null;
    private String cachingName = null;
    private String orderbyColBuf = null;
    private StringBuffer subQueryColumnBuf = null;
    private QueryContext queryContext = null;
    private boolean testParser = false;
    private boolean isNativeQuery = false;
    private boolean isGeneratedRelationFinder = false;
    private boolean isAggregateQuery = false;
    private String selectTablePK = null;
    private String selectJoinBuf = null;
    private List remoteFinderNodes = null;
    private List remoteBeanParamList = null;
    private int remoteBeanCommand = 0;
    private boolean isPreparedQueryFinder = false;

    public EjbqlFinder(String string, String string2, boolean bl) throws InvalidFinderException {
        super(string, false);
        this.testParser = bl;
        this.setEjbQuery(string2);
    }

    public EjbqlFinder(String string, String string2) throws InvalidFinderException {
        super(string, false);
        this.setEjbQuery(string2);
    }

    public int getRemoteBeanCommand() {
        return this.remoteBeanCommand;
    }

    public void setRemoteBeanCommand(int n) {
        this.remoteBeanCommand = n;
    }

    public void addGlobalASMap(String string, String string2) throws IllegalExpressionException {
        this.addGlobalRangeVariable(string, string2);
    }

    public void addGlobalRangeVariable(String string, String string2) throws IllegalExpressionException {
        if (this.globalRangeVariableMap == null) {
            this.globalRangeVariableMap = new HashMap();
        }
        if (this.globalRangeVariableMap.containsKey(string)) {
            Loggable loggable = EJBLogger.logduplicateRangeVariableDefinitionLoggable((String)string);
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        this.globalRangeVariableMap.put(string, string2);
    }

    public int GlobalASMapSize() {
        return this.globalRangeVariableMapSize();
    }

    public int globalRangeVariableMapSize() {
        if (this.globalRangeVariableMap == null) {
            this.globalRangeVariableMap = new HashMap();
        }
        return this.globalRangeVariableMap.size();
    }

    public String getGlobalASMap(String string) throws IllegalExpressionException {
        return this.getGlobalRangeVariableMap(string);
    }

    public String getGlobalRangeVariableMap(String string) throws IllegalExpressionException {
        if (this.globalRangeVariableMap == null) {
            Loggable loggable = EJBLogger.logejbqlMissingRangeVariableDeclarationLoggable((String)string);
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        String string2 = (String)this.globalRangeVariableMap.get(string);
        if (string2 != null) {
            return string2;
        }
        Loggable loggable = EJBLogger.logejbqlMissingRangeVariableDeclarationLoggable((String)string);
        throw new IllegalExpressionException(7, loggable.getMessage());
    }

    public void setMethods(Method[] methodArray) throws Exception {
        assert (methodArray[0] != null);
        super.setMethod(methodArray[0]);
        if (this.isFindByPrimaryKey()) {
            Class clazz = this.getKeyBean().getCMPBeanDescriptor().getPrimaryKeyClass();
            this.setParameterClassTypes(new Class[]{clazz});
        } else {
            this.setParameterClassTypes(methodArray[0].getParameterTypes());
        }
    }

    public List getGlobalASMapIdList() {
        return this.getGlobalRangeVariableMapIdList();
    }

    public Map getGlobalRangeVariableMap() {
        return this.globalRangeVariableMap;
    }

    public List getGlobalRangeVariableMapIdList() {
        ArrayList arrayList = new ArrayList();
        if (this.globalRangeVariableMap == null) {
            return arrayList;
        }
        Iterator iterator = this.globalRangeVariableMap.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public List getIDsFromGlobalASMapForSchema(String string) {
        return this.getIDsFromGlobalRangeVariableMapForSchema(string);
    }

    public List getIDsFromGlobalRangeVariableMapForSchema(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.globalRangeVariableMap == null) {
            return arrayList;
        }
        for (String string2 : this.globalRangeVariableMap.keySet()) {
            String string3 = (String)this.globalRangeVariableMap.get(string2);
            if (!string3.equals(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean isGeneratedRelationFinder() {
        return this.isGeneratedRelationFinder;
    }

    public void setIsGeneratedRelationFinder(boolean bl) {
        this.isGeneratedRelationFinder = bl;
    }

    public boolean isAggregateQuery() {
        return this.isAggregateQuery;
    }

    public void setSelectHint(String string) {
        this.selectHint = string;
    }

    public String getSelectHint() {
        return this.selectHint;
    }

    public void setIncludeResultCacheHint(boolean bl) {
        this.includeResultCacheHint = bl;
    }

    public void setKeyBean(RDBMSBean rDBMSBean) {
        this.keyBean = rDBMSBean;
    }

    public RDBMSBean getKeyBean() {
        return this.keyBean;
    }

    public void setSelectJoinBuf(String string) {
        this.selectJoinBuf = string;
    }

    public String getSelectJoinBuf() {
        return this.selectJoinBuf;
    }

    public void setOrderbyColBuf(String string) {
        this.orderbyColBuf = string;
    }

    public String getOrderbyColBuf() {
        return this.orderbyColBuf;
    }

    public void setEjbQuery(String string) {
        this.ejbQuery = string;
        this.whereSql = null;
    }

    public String getEjbQuery() {
        return this.ejbQuery;
    }

    public String getFromSql(int n) throws IllegalExpressionException {
        return this.generateTableSQL(n);
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public ParamNode getParamNodeForVariableNumber(int n) {
        List list = this.getExternalMethodParmList();
        ParamNode paramNode = null;
        for (ParamNode paramNode2 : list) {
            if (paramNode2.getVariableNumber() != n) continue;
            paramNode = paramNode2;
            break;
        }
        return paramNode;
    }

    public void setOrderbySql(String string) {
        this.orderbySql = string;
    }

    public String getOrderbySql() {
        return this.orderbySql;
    }

    public void setGroupbySql(String string) {
        this.groupbySql = string;
    }

    public String getGroupbySql() {
        return this.groupbySql;
    }

    public void addRemoteBeanParamList(ParamNode paramNode) {
        if (this.remoteBeanParamList == null) {
            this.remoteBeanParamList = new ArrayList();
        }
        this.remoteBeanParamList.add(paramNode);
    }

    public ParamNode getRemoteBeanParam() {
        if (!this.hasRemoteBeanParam()) {
            return null;
        }
        return (ParamNode)this.remoteBeanParamList.get(0);
    }

    public boolean hasRemoteBeanParam() {
        if (this.remoteBeanParamList == null) {
            return false;
        }
        return this.remoteBeanParamList.size() != 0;
    }

    public void addSubQueryColumnBuf(String string) {
        if (this.subQueryColumnBuf == null) {
            this.subQueryColumnBuf = new StringBuffer();
        }
        if (this.subQueryColumnBuf.length() > 0) {
            this.subQueryColumnBuf.append(", ");
        }
        this.subQueryColumnBuf.append(string).append(" ");
    }

    public String getSubQueryColumnBuf() {
        if (this.subQueryColumnBuf == null) {
            return "";
        }
        return this.subQueryColumnBuf.toString();
    }

    public String getSQLQuery() {
        return this.sqlQuery;
    }

    public String getSQLQueryForUpdateSelective() {
        return this.sqlQueryForUpdateSelective;
    }

    public String getSQLQueryForUpdate() {
        return this.sqlQueryForUpdate;
    }

    public String getSQLQueryForUpdateNoWait() {
        return this.sqlQueryForUpdateNoWait;
    }

    public String getTableAndFieldForCmpField(String string) throws IllegalExpressionException {
        return this.queryContext.getTableAndColumnFromMainQuery(string);
    }

    public String getMainJoinBuffer() throws IllegalExpressionException {
        return this.queryContext.getMainJoinBuffer();
    }

    public Expression getWLQLExpression() {
        return this.ejbqlExpression;
    }

    public Expr getEJBQLExpr() {
        return this.ejbqlExpr;
    }

    public void setIsPreparedQueryFinder(boolean bl) {
        this.isPreparedQueryFinder = bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EjbqlFinder)) {
            return false;
        }
        EjbqlFinder ejbqlFinder = (EjbqlFinder)object;
        if (!this.getName().equals(ejbqlFinder.getName())) {
            return false;
        }
        if (this.getEJBQLExpr() == null ? ejbqlFinder.getEJBQLExpr() != null : !this.getEJBQLExpr().equals(ejbqlFinder.getEJBQLExpr())) {
            return false;
        }
        Class[] classArray = this.getParameterClassTypes();
        Class[] classArray2 = ejbqlFinder.getParameterClassTypes();
        if (classArray2.length != classArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i].equals(classArray[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getEJBQLExpr().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[EjbqlFinder ");
        stringBuffer.append("ejbQuery = " + this.ejbQuery + "; ");
        stringBuffer.append("Expr = " + this.getEJBQLExpr() + "; ");
        stringBuffer.append("whereSql = " + this.whereSql + " ");
        stringBuffer.append("]]");
        return stringBuffer.toString();
    }

    public void parseExpression() throws EJBQLCompilerException {
        ExprParser exprParser = null;
        exprParser = new ExprParser(this);
        Expr expr = null;
        if (!this.ejbQuery.equals("")) {
            if (this.testParser) {
                System.out.println("\n\n+++++++++ PARSE QUERY: \n     " + this.ejbQuery);
            }
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("\n Parse EJB QL: " + this.ejbQuery);
            }
            expr = exprParser.parse(this.ejbQuery);
            if (this.testParser && expr != null) {
                expr.dump();
            }
        }
        this.ejbqlExpr = expr;
    }

    private static void get_line(String string) {
        System.out.print(string);
        System.out.flush();
        try {
            int n;
            while ((n = System.in.read()) != 10) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computeSQLQuery(RDBMSBean rDBMSBean) throws EJBQLCompilerException {
        try {
            Object object;
            Object object2;
            String string;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n ");
                EjbqlFinder.debug(" -------------------------------------------------------  ");
                EjbqlFinder.debug("\n           computeSQLQuery for " + this.getName() + "  EJB QL: " + this.ejbQuery + "\n");
                if (this.getName().startsWith(this.stopOnMethod)) {
                    EjbqlFinder.get_line("              press key to continue ");
                }
                ((BaseExpr)this.ejbqlExpr).dump();
            }
            this.queryContext = new QueryContext(rDBMSBean, this, this.ejbqlExpr);
            String string2 = "";
            this.queryContext.generateQuery();
            string2 = this.queryContext.getWhereSql();
            string2 = string2.trim();
            if (string2.compareTo("WHERE") == 0) {
                string2 = "";
            }
            this.initExternalMethodParmList();
            List list = null;
            list = this.queryContext.getMainQuerySelectList();
            if (!this.isSelect && !this.isSelectInEntity && list.size() > 0) {
                object7 = (SelectNode)list.get(0);
                if (((SelectNode)object7).getSelectType() != 61) {
                    Loggable loggable = EJBLogger.logFinderDoesNotReturnBeanLoggable((String)this.getName(), (String)this.getEjbQuery());
                    IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage(), new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                    throw this.newEJBQLCompilerException((Exception)illegalExpressionException, this.queryContext);
                }
                object6 = ((SelectNode)object7).getSelectTarget();
                object5 = ((SelectNode)object7).getSelectBean();
                if (object5 != null && !((RDBMSBean)object5).getEjbName().equals(rDBMSBean.getEjbName())) {
                    Loggable loggable = EJBLogger.logFinderReturnsBeanOfWrongTypeLoggable((String)this.getName(), (String)rDBMSBean.getEjbName(), (String)((RDBMSBean)object5).getEjbName());
                    IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage(), new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                    throw this.newEJBQLCompilerException((Exception)illegalExpressionException, this.queryContext);
                }
            }
            if (this.isSelect && !this.isNativeQuery) {
                object7 = list.iterator();
                while (object7.hasNext()) {
                    object6 = (SelectNode)object7.next();
                    if (!((SelectNode)object6).isCorrelatedSubQuery()) continue;
                    object7.remove();
                }
                if (list.size() > 1 && !this.isResultSetFinder()) {
                    object6 = EJBLogger.logSelectMultipleFieldsButReturnCollectionLoggable((String)this.returnClassType.getName());
                    object5 = new IllegalExpressionException(7, object6.getMessage(), new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                    throw this.newEJBQLCompilerException((Exception)object5, this.queryContext);
                }
            }
            object7 = this.recomputeSelectInEntity(rDBMSBean);
            object6 = new StringBuffer();
            ((StringBuffer)object6).append("SELECT ");
            if (this.selectHint != null) {
                ((StringBuffer)object6).append(this.selectHint).append(" ");
            } else if (this.includeResultCacheHint) {
                ((StringBuffer)object6).append("/*+ RESULT_CACHE */ ");
            }
            int n = ((StringBuffer)object6).length();
            if (this.isSelectDistinct() || this.isSetFinder()) {
                ((StringBuffer)object6).append("DISTINCT ");
            }
            int n2 = ((StringBuffer)object6).length();
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            Iterator iterator = list.iterator();
            int n3 = 0;
            block15: while (iterator.hasNext()) {
                if (++n3 > 1) {
                    ((StringBuffer)object6).append(", ");
                }
                if (((SelectNode)(object4 = (SelectNode)iterator.next())).getSelectType() == 61) {
                    if (this.finderLoadsBean) {
                        ((StringBuffer)object6).append(this.generateFieldGroupSQLForFinder(((SelectNode)object4).getSelectBean(), ((SelectNode)object4).getSelectTarget(), this.getGroupName(), false, null));
                        continue;
                    }
                    ((StringBuffer)object6).append(this.generatePrimaryKeySQL(((SelectNode)object4).getSelectBean(), ((SelectNode)object4).getSelectTarget()));
                    continue;
                }
                if (((SelectNode)object4).getIsAggregate()) {
                    this.isAggregateQuery = true;
                    ((StringBuffer)object6).append(((SelectNode)object4).getSelectTypeName());
                    ((StringBuffer)object6).append("(");
                    if (((SelectNode)object4).getIsAggregateDistinct()) {
                        ((StringBuffer)object6).append("DISTINCT ");
                    }
                    ((StringBuffer)object6).append(((SelectNode)object4).getDbmsTarget()).append(" ");
                    ((StringBuffer)object6).append(") ");
                    continue;
                }
                switch (((SelectNode)object4).getSelectType()) {
                    case 17: {
                        ((StringBuffer)object6).append(((SelectNode)object4).getDbmsTarget()).append(" ");
                        continue block15;
                    }
                    case 70: 
                    case 71: {
                        ((StringBuffer)object6).append(((SelectNode)object4).getSelectTypeName());
                        ((StringBuffer)object6).append("( ");
                        ((StringBuffer)object6).append(((SelectNode)object4).getDbmsTarget()).append(" ");
                        ((StringBuffer)object6).append(") ");
                        continue block15;
                    }
                }
                throw new AssertionError("Unknown type!");
            }
            if (this.finderLoadsBean) {
                object4 = null;
                object4 = this.queryContext.getMainQuerySelectListForCachingElement();
                Iterator iterator2 = object4.iterator();
                while (iterator2.hasNext()) {
                    object3 = (SelectNode)iterator2.next();
                    if (debugLogger.isDebugEnabled()) {
                        EjbqlFinder.debug("\n ------------------  BEGIN  relationship caching for caching element " + ((SelectNode)object3).getSelectTarget() + "----");
                    }
                    ((StringBuffer)object6).append(", ");
                    ((StringBuffer)object6).append(this.generateFieldGroupSQLForFinder(((SelectNode)object3).getSelectBean(), ((SelectNode)object3).getSelectTarget(), ((SelectNode)object3).getCachingElementGroupName(), true, ((SelectNode)object3).getPrevBean()));
                    if (!debugLogger.isDebugEnabled()) continue;
                    EjbqlFinder.debug("\n ------------------  END    relationship caching for caching element " + ((SelectNode)object3).getSelectTarget() + "----\n");
                }
            }
            if ((object4 = this.getOrderbyColBuf()) != null) {
                ((StringBuffer)object6).append(", ");
                ((StringBuffer)object6).append((String)object4);
            }
            ((StringBuffer)object6).append(" FROM ");
            int n4 = ((StringBuffer)object6).length();
            object3 = this.generateTableSQL(0);
            String string3 = this.generateTableSQL(1);
            ((StringBuffer)object6).append((String)object3);
            int n5 = ((StringBuffer)object6).length();
            StringBuffer stringBuffer = new StringBuffer();
            if (string2.length() > 0) {
                ((StringBuffer)object6).append(string2);
            }
            if (((String)object7).length() > 0) {
                if (string2.length() > 0) {
                    ((StringBuffer)object6).append(" AND ");
                } else {
                    string2 = " WHERE ";
                    ((StringBuffer)object6).append(string2);
                }
                ((StringBuffer)object6).append((String)object7);
            }
            if ((string = this.queryContext.getMainQueryJoinBuffer()).length() > 0) {
                if (string2.length() > 0) {
                    ((StringBuffer)object6).append(" AND ");
                } else {
                    string2 = "WHERE ";
                    ((StringBuffer)object6).append(string2);
                }
                ((StringBuffer)object6).append(string);
                ((StringBuffer)object6).append(" ");
            }
            if (this.groupbySql != null) {
                ((StringBuffer)object6).append(this.groupbySql).append(" ");
            }
            if (this.orderbySql != null) {
                if (rDBMSBean.getUseSelectForUpdate()) {
                    Loggable loggable = EJBLogger.logselectForUpdateSpecifiedWithOrderByLoggable((String)this.getName(), (String)rDBMSBean.getEjbName());
                    throw new IllegalExpressionException(7, loggable.getMessage(), new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                }
                ((StringBuffer)object6).append(this.orderbySql);
            }
            this.sqlQuery = ((StringBuffer)object6).toString();
            if (n < n2) {
                ((StringBuffer)object6).replace(n, n2, " ");
            }
            int n6 = rDBMSBean.getDatabaseType();
            switch (n6) {
                case 2: 
                case 5: 
                case 7: {
                    this.sqlQueryForUpdateNoWait = ((StringBuffer)object6).toString() + RDBMSUtils.selectForUpdateToString(2);
                    ((StringBuffer)object6).replace(n4, n5, string3);
                    this.sqlQueryForUpdate = ((StringBuffer)object6).toString();
                    this.assignSqlQueryForUpdateSelective();
                    break;
                }
                case 4: {
                    this.sqlQueryForUpdate = ((StringBuffer)object6).toString() + " FOR READ ONLY WITH RS USE AND KEEP UPDATE LOCKS";
                    this.sqlQueryForUpdateNoWait = ((StringBuffer)object6).toString() + RDBMSUtils.selectForUpdateToString(2);
                    this.assignSqlQueryForUpdateSelective();
                    break;
                }
                case 0: 
                case 3: 
                case 6: 
                case 8: 
                case 9: {
                    this.sqlQueryForUpdate = ((StringBuffer)object6).toString() + RDBMSUtils.selectForUpdateToString(1);
                    this.sqlQueryForUpdateNoWait = ((StringBuffer)object6).toString() + RDBMSUtils.selectForUpdateToString(2);
                    this.assignSqlQueryForUpdateSelective();
                    break;
                }
                case 1: {
                    this.sqlQueryForUpdate = ((StringBuffer)object6).toString() + RDBMSUtils.selectForUpdateToString(1);
                    this.sqlQueryForUpdateSelective = this.cachingName != null ? (this.allOrAnyBeansHaveSelectForUpdate(false) ? this.sqlQueryForUpdate : (!((String)(object2 = this.perhapsAppendForUpdateOf())).equals("") ? this.sqlQueryForUpdate + (String)object2 : this.sqlQuery)) : (this.rdbmsBean.getUseSelectForUpdate() ? this.sqlQueryForUpdate : this.sqlQuery);
                    this.sqlQueryForUpdateNoWait = ((StringBuffer)object6).toString() + RDBMSUtils.selectForUpdateToString(2);
                    break;
                }
                default: {
                    throw new AssertionError("Undefined database type " + n6);
                }
            }
            if (debugLogger.isDebugEnabled()) {
                object2 = this.queryContext.getSQLGenEJBQLTokenList();
                EjbqlFinder.debug("\n\n\n\n +++++++++  view the EJBQL Token List +++++++++++=\n");
                object = new StringBuffer();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    ((StringBuffer)object).append(((EJBQLToken)iterator.next()).getTokenText());
                }
                EjbqlFinder.debug("  '" + ((StringBuffer)object).toString() + "'\n\n\n +++++++++++++++++++++++++++++++++++++++++++++\n");
                EjbqlFinder.debug("SQL Query is: " + this.sqlQuery);
                EjbqlFinder.debug("SQL Query with FOR UPDATE is: " + this.sqlQueryForUpdate);
                EjbqlFinder.debug("SQL Query with FOR UPDATE NOWAIT is: " + this.sqlQueryForUpdateNoWait);
                if (this.cachingName != null && n6 == 1) {
                    EjbqlFinder.debug("SQL Query for case SelectForUpdateDisabled for dbtype Oracle is: " + this.sqlQueryForUpdateSelective);
                }
                EjbqlFinder.debug("              ------------------------------------------------------- \n\n\n\n\n\n");
                if (this.getName().equals(this.stopOnMethod)) {
                    EjbqlFinder.get_line("              press key to continue ");
                }
            }
            object2 = this.queryContext.getMainQueryTree();
            ((QueryNode)object2).checkAllORCrossProducts();
            object = this.queryContext.getWarnings();
            if (object != null) {
                EJBQLCompilerException eJBQLCompilerException = this.newEJBQLCompilerException((Exception)object, this.queryContext);
                EJBLogger eJBLogger = new EJBLogger();
                EJBLogger.logWarningFromEJBQLCompiler((String)eJBQLCompilerException.getMessage());
            }
        }
        catch (IllegalExpressionException illegalExpressionException) {
            illegalExpressionException.setDescriptorErrorInfo(new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
            throw this.newEJBQLCompilerException((Exception)illegalExpressionException, this.queryContext);
        }
    }

    public boolean allOrAnyBeansHaveSelectForUpdate(boolean bl) {
        List list = null;
        list = this.queryContext.getMainQuerySelectListForCachingElement();
        if (list.size() != 0) {
            for (SelectNode selectNode : list) {
                RDBMSBean rDBMSBean = selectNode.getSelectBean();
                if (bl) {
                    if (!rDBMSBean.getUseSelectForUpdate()) continue;
                    return true;
                }
                if (rDBMSBean.getUseSelectForUpdate()) continue;
                return false;
            }
            if (this.rdbmsBean.getUseSelectForUpdate()) {
                return true;
            }
        }
        return false;
    }

    private void assignSqlQueryForUpdateSelective() {
        this.sqlQueryForUpdateSelective = this.cachingName != null && this.allOrAnyBeansHaveSelectForUpdate(true) ? this.sqlQueryForUpdate : (this.rdbmsBean.getUseSelectForUpdate() ? this.sqlQueryForUpdate : this.sqlQuery);
    }

    public String perhapsAppendForUpdateOf() {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        String string5 = null;
        String string2 = null;
        String string32 = null;
        String string4 = null;
        int n = 0;
        ArrayList<RDBMSBean> arrayList = new ArrayList<RDBMSBean>();
        list = this.queryContext.getMainQuerySelectListForCachingElement();
        for (Object object2 : list) {
            RDBMSBean rDBMSBean = ((SelectNode)object2).getSelectBean();
            arrayList.add(rDBMSBean);
        }
        arrayList.add(this.rdbmsBean);
        object2 = new Comparator(){

            public int compare(Object object, Object object2) {
                RDBMSBean rDBMSBean = (RDBMSBean)object;
                RDBMSBean rDBMSBean2 = (RDBMSBean)object2;
                return rDBMSBean.getLockOrder() - rDBMSBean2.getLockOrder();
            }
        };
        Collections.sort(arrayList, object2);
        for (RDBMSBean rDBMSBean : arrayList) {
            if (!rDBMSBean.getUseSelectForUpdate()) continue;
            for (String string32 : rDBMSBean.getTables()) {
                string4 = this.queryContext.getAliasForTableName(string32);
                Map map = rDBMSBean.getPKCmpf2ColumnForTable(string32);
                for (String string5 : map.keySet()) {
                    string2 = (String)map.get(string5);
                }
                if (n == 0) {
                    stringBuffer.append("OF ");
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string4 + "." + string2);
                ++n;
            }
        }
        if (debugLogger.isDebugEnabled()) {
            EjbqlFinder.debug("perhapsAppendForUpdateOf returns: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String recomputeSelectInEntity(RDBMSBean rDBMSBean) throws IllegalExpressionException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSelectInEntity) {
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            Class clazz = cMPBeanDescriptor.getBeanClass();
            boolean bl = cMPBeanDescriptor.hasComplexPrimaryKey();
            Class clazz2 = null;
            if (bl) {
                clazz2 = cMPBeanDescriptor.getPrimaryKeyClass();
            }
            int n = this.externalMethodParmList.size();
            String string = "param" + n;
            int n2 = n + 1;
            ParamNode paramNode = new ParamNode(rDBMSBean, string, n2, Object.class, "", "", false, true, clazz2, bl, false);
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug(" created inEntity ParamNode: " + paramNode.toString());
            }
            List list = rDBMSBean.getPrimaryKeyFields();
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                String string2;
                String string3 = (String)list.get(i);
                clazz2 = cMPBeanDescriptor.getFieldClass(string3);
                if (clazz2 == null) {
                    throw new IllegalExpressionException(7, "finder: " + this.getName() + ", the EJB QL for ejbSelect<>InEntity Finders, query recompute: " + "could not get pkClass for pkField: " + string3, new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                }
                boolean bl2 = RDBMSUtils.isOracleNLSDataType(rDBMSBean, string3);
                if (i == 0 && !bl) {
                    paramNode.setPrimaryKeyClass(clazz2);
                    paramNode.setOracleNLSDataType(bl2);
                }
                ParamNode paramNode2 = new ParamNode(rDBMSBean, string, n2, clazz2, string3, "", false, false, clazz2, false, bl2);
                if (debugLogger.isDebugEnabled()) {
                    EjbqlFinder.debug(" added Sub ParamNode to inEntity ParamNode: " + paramNode2.toString());
                }
                paramNode.addParamSubList(paramNode2);
                String string4 = null;
                List list2 = this.getIDsFromGlobalRangeVariableMapForSchema(rDBMSBean.getAbstractSchemaName());
                if (list2.size() < 1) {
                    string2 = EJBLogger.lograngeVariableNotFoundLoggable((String)rDBMSBean.getEjbName(), (String)rDBMSBean.getAbstractSchemaName());
                    throw new IllegalExpressionException(7, string2.getMessage(), new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                }
                string2 = (String)list2.get(0);
                String string5 = string2 + "." + string3;
                try {
                    string4 = this.queryContext.getTableAndColumnFromMainQuery(string5);
                }
                catch (Exception exception) {
                    throw new IllegalExpressionException(7, "In Bean Parameter processing.  Could not get table and Field for path expression: " + string5, new DescriptorErrorInfo("<ejb-ql>", (Object)rDBMSBean.getEjbName(), (Object)this.getName()));
                }
                stringBuffer.append(string4).append(" = ? ");
                stringBuffer.append(" AND ");
            }
            if (stringBuffer.length() > 5) {
                stringBuffer.setLength(stringBuffer.length() - 5);
            }
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug(" ejbSelect<>InEntity SQL is: " + stringBuffer.toString());
            }
            this.addInternalInEntityParmList(paramNode);
        }
        return stringBuffer.toString();
    }

    public List getExternalMethodAndInEntityParmList() {
        ArrayList<ParamNode> arrayList = new ArrayList<ParamNode>(this.externalMethodParmList);
        for (ParamNode paramNode : this.internalInEntityParmList) {
            arrayList.add(paramNode);
        }
        return arrayList;
    }

    public int getPKOrGroupColumnCount() {
        if (this.finderLoadsBean) {
            return this.getGroupColumnCount();
        }
        return this.getPKColumnCount();
    }

    public int getPKColumnCount() {
        return this.rdbmsBean.getPrimaryKeyFields().size();
    }

    public int getGroupColumnCount() {
        String string = this.getGroupName();
        FieldGroup fieldGroup = this.rdbmsBean.getFieldGroup(string);
        if (fieldGroup == null) {
            return this.rdbmsBean.getPrimaryKeyFields().size();
        }
        HashSet<String> hashSet = new HashSet<String>();
        TreeSet treeSet = new TreeSet(fieldGroup.getCmpFields());
        treeSet.addAll(this.rdbmsBean.getPrimaryKeyFields());
        for (Object object : treeSet) {
            hashSet.add(this.rdbmsBean.getCmpColumnForField((String)object));
        }
        for (String string2 : fieldGroup.getCmrFields()) {
            for (String string3 : this.rdbmsBean.getForeignKeyColNames(string2)) {
                hashSet.add(string3);
            }
        }
        return hashSet.size();
    }

    public String getGroupName() {
        if (this.groupName == null) {
            return "defaultGroup";
        }
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getCachingName() {
        return this.cachingName;
    }

    public void setCachingName(String string) {
        this.cachingName = string;
    }

    public void setSqlSelectDistinct(boolean bl) {
        if (bl) {
            RDBMSBean rDBMSBean = this.getRDBMSBean();
            Loggable loggable = null;
            loggable = rDBMSBean != null ? EJBLogger.logSqlSelectDistinctDeprecatedLoggable((String)rDBMSBean.getEjbName(), (String)this.getName()) : EJBLogger.logSqlSelectDistinctDeprecatedLoggable((String)"UNKNOWN", (String)this.getName());
            loggable.log();
            this.setSelectDistinct(bl);
        }
    }

    public void setNativeQuery(boolean bl) {
        this.isNativeQuery = bl;
    }

    public String generateFieldGroupSQLForFinder(RDBMSBean rDBMSBean, String string, String string2, boolean bl, RDBMSBean rDBMSBean2) throws IllegalExpressionException {
        return this.generateFieldGroupSQL(rDBMSBean, string, string2, bl, rDBMSBean2, true);
    }

    public String generateFieldGroupSQLForNonFinder() throws IllegalExpressionException {
        SelectNode selectNode;
        Iterator iterator = null;
        iterator = this.queryContext.getMainQuerySelectList().iterator();
        if (iterator.hasNext()) {
            selectNode = (SelectNode)iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalExpressionException(7, "Internal Error during Non-Finder FieldGroup SQL Generation:  found more than one SelectNode for FieldGroup: '" + this.getGroupName() + "', query: '" + this.getEjbQuery() + "'", new DescriptorErrorInfo("<ejb-ql>", (Object)this.getRDBMSBean().getEjbName(), (Object)this.getName()));
            }
        } else {
            throw new IllegalExpressionException(7, "Internal Error during Non-Finder FieldGroup SQL Generation:  could not get SelectNode for FieldGroup: '" + this.getGroupName() + "', query: '" + this.getEjbQuery() + "'", new DescriptorErrorInfo("<ejb-ql>", (Object)this.getRDBMSBean().getEjbName(), (Object)this.getName()));
        }
        return this.generateFieldGroupSQLForNonFinder(selectNode.getSelectBean(), selectNode.getSelectTarget(), this.getGroupName(), false, null);
    }

    public String generateFieldGroupSQLForNonFinder(RDBMSBean rDBMSBean, String string, String string2, boolean bl, RDBMSBean rDBMSBean2) throws IllegalExpressionException {
        return this.generateFieldGroupSQL(rDBMSBean, string, string2, bl, rDBMSBean2, false);
    }

    private String generateFieldGroupSQL(RDBMSBean rDBMSBean, String string, String string2, boolean bl, RDBMSBean rDBMSBean2, boolean bl2) throws IllegalExpressionException {
        String string3;
        Iterator iterator;
        Object object;
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        FieldGroup fieldGroup = rDBMSBean.getFieldGroup(string2);
        if (debugLogger.isDebugEnabled()) {
            EjbqlFinder.debug("rdbms ejb name- " + rDBMSBean.getEjbName());
            EjbqlFinder.debug("ejb name- " + rDBMSBean.getCMPBeanDescriptor().getEJBName());
            EjbqlFinder.debug("groupName- " + string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList arrayList = bl2 ? new ArrayList(rDBMSBean.getPrimaryKeyFields()) : new ArrayList();
        TreeSet treeSet = new TreeSet(fieldGroup.getCmpFields());
        for (Object object2 : treeSet) {
            if (arrayList.contains(object2)) continue;
            arrayList.add(object2);
        }
        for (String string5 : arrayList) {
            string4 = string + "." + string5;
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("  generateFieldGroupSQL: lookup: SQL SELECT ID for '" + string4 + "'");
            }
            object = null;
            object = this.queryContext.getTableAndColumnFromMainQuery(string4);
            hashSet.add((String)object);
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("fieldName- " + string5 + ", columnName- " + (String)object);
            }
            assert (object != null);
            stringBuffer.append((String)object);
            stringBuffer.append(", ");
        }
        for (String string5 : fieldGroup.getCmrFields()) {
            string4 = null;
            object = null;
            string4 = this.queryContext.replaceIdAliases(string) + "." + string5;
            object = this.queryContext.getTableAndFKColumnListForLocal11or1NPathForMainQuery(string4);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (hashSet.contains(string3)) continue;
                stringBuffer.append(string3);
                stringBuffer.append(", ");
            }
        }
        if (bl) {
            String string6;
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("\n--- BEGIN Caching Element FK Column Insertion ---");
                EjbqlFinder.debug("selectTarget=" + string);
                EjbqlFinder.debug("start sb=" + stringBuffer);
            }
            if (rDBMSBean == rDBMSBean2.getRelatedRDBMSBean(string6 = string.substring(string.lastIndexOf(".") + 1))) {
                string4 = null;
                object = null;
                string4 = this.queryContext.replaceIdAliases(string);
                object = this.queryContext.getTableAndFKColumnListForLocal11or1NPathForMainQuery(string4);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    if (debugLogger.isDebugEnabled()) {
                        EjbqlFinder.debug(" adding Caching Element Column: '" + string3 + "'");
                    }
                    stringBuffer.append(string3);
                    stringBuffer.append(", ");
                }
            }
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("end   sb=" + stringBuffer + "\n");
                EjbqlFinder.debug("\n--- END   Caching Element FK Column Insertion ---");
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        if (debugLogger.isDebugEnabled()) {
            EjbqlFinder.debug("returning: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String generatePrimaryKeySQL(RDBMSBean rDBMSBean, String string) throws IllegalExpressionException {
        Iterator iterator = rDBMSBean.getPrimaryKeyFields().iterator();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = string + "." + string2;
            String string4 = null;
            string4 = this.queryContext.getTableAndColumnFromMainQuery(string3);
            assert (string4 != null);
            stringBuffer.append(string4);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private String generateTableSQL(int n) throws IllegalExpressionException {
        return this.queryContext.getMainQueryTree().getFROMDeclaration(n);
    }

    public String replaceCorrVars(String string) {
        Object object;
        StringBuffer stringBuffer;
        if (this.corrVarMap == null || string.length() == 0) {
            return string;
        }
        int n = string.indexOf("=>");
        if (n != -1) {
            stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append(".");
            object = "";
            if (string.length() > n + 2) {
                object = string.substring(n + 2);
            }
            stringBuffer.append((String)object);
            string = stringBuffer.toString();
        }
        stringBuffer = new StringBuffer();
        object = new StringTokenizer(string, ".");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2;
            String string3 = string2 = ((StringTokenizer)object).nextToken();
            CorrelationVarInfo correlationVarInfo = (CorrelationVarInfo)this.corrVarMap.get(string2);
            if (correlationVarInfo != null) {
                string3 = correlationVarInfo.getValue();
            }
            stringBuffer.append(string3);
            stringBuffer.append(".");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void addToCorrVarMap(String string, CorrelationVarInfo correlationVarInfo) throws IllegalExpressionException {
        if (this.corrVarMap == null) {
            this.corrVarMap = new HashMap();
        }
        if (this.corrVarMap.get(string) != null) {
            Loggable loggable = EJBLogger.logcorrelationVarDefinedMultipleTimesLoggable((String)string);
            throw new IllegalExpressionException(7, loggable.getMessage(), new DescriptorErrorInfo("<ejb-ql>", (Object)this.getRDBMSBean().getEjbName(), (Object)this.getName()));
        }
        this.corrVarMap.put(string, correlationVarInfo);
    }

    public void updateTableJoinList(String string) {
        if (this.tableJoinList == null) {
            this.tableJoinList = new ArrayList();
        }
        if (!this.tableJoinList.contains(string)) {
            this.tableJoinList.add(string);
        }
    }

    private void initExternalMethodParmList() {
        for (int i = 0; i < this.parameterClassTypes.length; ++i) {
            int n = i + 1;
            ParamNode paramNode = this.getInternalQueryParmNode(i);
            if (paramNode != null) {
                ParamNode paramNode2 = new ParamNode(paramNode.getRDBMSBean(), "param" + i, n, this.parameterClassTypes[i], paramNode.getId(), paramNode.getRemoteHomeName(), paramNode.isBeanParam(), paramNode.isSelectInEntity(), paramNode.getPrimaryKeyClass(), paramNode.hasCompoundKey(), paramNode.isOracleNLSDataType());
                if (paramNode.hasCompoundKey()) {
                    for (ParamNode paramNode3 : paramNode.getParamSubList()) {
                        ParamNode paramNode4 = new ParamNode(paramNode3.getRDBMSBean(), "param" + i, n, this.parameterClassTypes[i], paramNode3.getId(), paramNode3.getRemoteHomeName(), paramNode3.isBeanParam(), paramNode3.isSelectInEntity(), paramNode3.getPrimaryKeyClass(), paramNode3.hasCompoundKey(), paramNode3.isOracleNLSDataType());
                        paramNode2.addParamSubList(paramNode4);
                    }
                }
                this.externalMethodParmList.add(paramNode2);
                continue;
            }
            paramNode = new ParamNode(null, "param" + i, n, this.parameterClassTypes[i], "", "", false, false, null, false, false);
            this.externalMethodParmList.add(paramNode);
        }
    }

    public String toUserLevelString(boolean bl) {
        String string = "N/A";
        if (this.rdbmsBean != null) {
            string = this.rdbmsBean.getEjbName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Query:");
        if (bl) {
            stringBuffer.append("\n\t");
        } else {
            stringBuffer.append(", ");
        }
        if (string != null) {
            stringBuffer.append("EJB Name:        " + string);
            if (bl) {
                stringBuffer.append("\n\t");
            } else {
                stringBuffer.append(", ");
            }
        }
        if (this.methodName != null) {
            stringBuffer.append("Method Name:     " + this.methodName);
            if (bl) {
                stringBuffer.append("\n\t");
            } else {
                stringBuffer.append(", ");
            }
        }
        if (this.parameterClassTypes != null) {
            stringBuffer.append("Parameter Types: (");
            for (int i = 0; i < this.parameterClassTypes.length; ++i) {
                stringBuffer.append("" + this.parameterClassTypes[i].getName());
                if (i >= this.parameterClassTypes.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            if (bl) {
                stringBuffer.append("\n\t");
            } else {
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isContentValid() {
        if (this.ejbQuery == null || this.ejbQuery.equals("")) {
            return false;
        }
        this.sqlQuery = null;
        try {
            this.parseExpression();
        }
        catch (EJBQLCompilerException eJBQLCompilerException) {
            return false;
        }
        return true;
    }

    public EJBQLCompilerException newEJBQLCompilerException(Exception exception, List list) {
        ErrorCollectionException errorCollectionException = !(exception instanceof ErrorCollectionException) ? new ErrorCollectionException((Throwable)exception) : (ErrorCollectionException)((Object)exception);
        return this.newEJBQLCompilerException(errorCollectionException, false, 0, "", list);
    }

    public EJBQLCompilerException newEJBQLCompilerException(Exception exception, QueryContext queryContext) {
        ErrorCollectionException errorCollectionException = !(exception instanceof ErrorCollectionException) ? new ErrorCollectionException((Throwable)exception) : (ErrorCollectionException)((Object)exception);
        return this.newEJBQLCompilerException(errorCollectionException, queryContext.getEjbqlRewritten(), queryContext.getEjbqlRewrittenReasons(), queryContext.getOriginalEjbql(), queryContext.getSQLGenEJBQLTokenList());
    }

    public EJBQLCompilerException newEJBQLCompilerException(ErrorCollectionException errorCollectionException, boolean bl, int n, String string, List list) {
        String string2 = this.decodeEjbqlRewrittenReasons(bl, n);
        return new EJBQLCompilerException(errorCollectionException, bl, string2, string, list, this.toUserLevelString(true), this.newDescriptorErrorInfo());
    }

    private String decodeEjbqlRewrittenReasons(boolean bl, int n) {
        if (!bl) {
            return "";
        }
        String string = "\n       ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n2 = n;
        if ((1 | n) != 0) {
            Loggable loggable = EJBLogger.logEJBQL_REWRITE_REASON_FACTOR_OUT_NOT_TEXTLoggable();
            String string2 = loggable.getMessage();
            stringBuffer.append(string2).append(string);
            --n2;
        }
        if (stringBuffer.length() <= string.length()) {
            stringBuffer.append(EJBQL_REWRITE_REASON_DEFAULT_TEXT);
        }
        if (debugLogger.isDebugEnabled() && n2 != 0) {
            throw new AssertionError(" unhandled rewrite reason in EjbqlFinder.decodeEjbqlRewrittenReasons().  Remaining reasons integer codes are " + n2);
        }
        return stringBuffer.toString();
    }

    public DescriptorErrorInfo newDescriptorErrorInfo() {
        String string = "";
        String string2 = "";
        if (this.rdbmsBean != null) {
            string2 = this.rdbmsBean.getEjbName();
        }
        if (this.getName() != null) {
            string = this.getName();
        }
        return new DescriptorErrorInfo("<ejb-ql>", (Object)string2, (Object)string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"WHERE aa.bb.cc.name = 'www'", "WHERE x > y", "WHERE x = 2 AND y <> -3", "WHERE $x_id = ?1", "WHERE _$x_id <= fieldx", "WHERE xxx IN ('a', 'b', 'c')", "WHERE xxx IN (1, 2, 3)", "WHERE xxx IN (BeanB>>findByName())", "WHERE xxx IN (BeanB>>findByName(?1, ?2))", "WHERE xxx IN (BeanB>>findByName('param1-literal', 'param2-literal'))", "FROM O IN orders WHERE O.orderID = ?1 ORDERBY accountBean.id", "SELECT S FROM S FOR subAccount, I FOR S.institution WHERE ( I.zip = '94702' AND S.subBalance > 20000 ) ORDERBY I.zip, S.subBalance", "WHERE (a = ?1 AND b = ?2) AND (c = ?3 AND d = ?4)", "WHERE a = ?1 AND b = ?2 AND c = ?3", "WHERE ( a = ?1 AND b = ?2 ) AND c = ?3 AND d = ?4 AND e = ?5", "SELECT S FROM S FOR subAccount WHERE S.subAccountType = ?1 AND S.subBalance > ?2", "SELECT stud.firstname FROM StudentBean AS stud WHERE stud.firstname IN (SELECT stud1.firstname FROM StudentBean AS stud1 WHERE stud1.firstname LIKE '%d%' OR stud1.firstname LIKE '%i%' AND stud1.testid = ?1)"};
        if (stringArray.length == 1) {
            stringArray2 = stringArray;
        }
        int n = stringArray2.length;
        boolean bl = true;
        if (stringArray.length == 1) {
            stringArray2 = stringArray;
        }
        Localizer localizer = L10nLookup.getLocalizer((Locale)Locale.getDefault(), (String)"weblogic.ejb.container.EJBTextTextLocalizer");
        for (int i = 0; i < n; ++i) {
            EjbqlFinder ejbqlFinder = null;
            try {
                ejbqlFinder = new EjbqlFinder("findTest", stringArray2[i], bl);
            }
            catch (InvalidFinderException invalidFinderException) {
                System.out.println(invalidFinderException.getMessage());
                continue;
            }
            try {
                ejbqlFinder.parseExpression();
                continue;
            }
            catch (EJBQLCompilerException eJBQLCompilerException) {
                System.out.println(localizer.get("error") + eJBQLCompilerException.toString());
            }
        }
        System.out.println(localizer.get("completeButCheck"));
    }

    public static String printQueryType(int n) {
        switch (n) {
            case 0: {
                return "IS_FINDER_LOCAL_BEAN";
            }
            case 2: {
                return "IS_SELECT_THIS_BEAN";
            }
            case 3: {
                return "IS_SELECT_THIS_BEAN_FIELD";
            }
            case 4: {
                return "IS_SELECT_LOCAL_BEAN";
            }
            case 5: {
                return "IS_SELECT_LOCAL_BEAN_FIELD";
            }
            case 6: {
                return "IS_SELECT_RESULT_SET";
            }
        }
        return "UNKNOWN_QUERY_TYPE";
    }

    public static String generateGroupSQLNonFinder(RDBMSBean rDBMSBean, String string, int n) throws IllegalExpressionException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "bean";
        List list = rDBMSBean.getPrimaryKeyFields();
        String string3 = "SELECT OBJECT(" + string2 + ") FROM " + rDBMSBean.getAbstractSchemaName() + " AS " + string2;
        try {
            String string4;
            EjbqlFinder ejbqlFinder = new EjbqlFinder("find__WL_Group_" + string, string3);
            ejbqlFinder.setRDBMSBean(rDBMSBean);
            ejbqlFinder.setGroupName(string);
            ejbqlFinder.setFinderLoadsBean(false);
            ejbqlFinder.setParameterClassTypes(new Class[0]);
            ejbqlFinder.parseExpression();
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("groupSqlNonFinder: group: '" + string + "',parsed expression: '" + string3 + "'");
            }
            ejbqlFinder.computeSQLQuery(rDBMSBean);
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("groupSqlNonFinder: group: '" + string + "', computed WHERE clause for expression: '" + string3 + "'");
            }
            stringBuffer.append("SELECT ");
            stringBuffer.append(ejbqlFinder.generateFieldGroupSQLForNonFinder());
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(" WHERE ");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                String string5 = ejbqlFinder.getTableAndFieldForCmpField(string2 + "." + string4);
                if (debugLogger.isDebugEnabled()) {
                    EjbqlFinder.debug("groupSqlNonFinder: group: '" + string + "', for Pk field: '" + string4 + "', got Pk column: '" + string5 + "'");
                }
                stringBuffer2.append(string5).append(" = ? ");
                if (!iterator.hasNext()) continue;
                stringBuffer2.append(" AND ");
            }
            stringBuffer.append(" FROM ");
            stringBuffer.append(ejbqlFinder.getFromSql(n));
            stringBuffer.append(stringBuffer2.toString());
            string4 = ejbqlFinder.getMainJoinBuffer();
            if (string4.length() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(string4);
            int n2 = rDBMSBean.getDatabaseType();
            switch (n2) {
                case 2: 
                case 5: 
                case 7: {
                    if (n == 0 || n == 1 || n != 2) break;
                    stringBuffer.append(RDBMSUtils.selectForUpdateToString(n));
                    break;
                }
                case 4: {
                    if (n == 1) {
                        stringBuffer.append(" FOR READ ONLY WITH RS USE AND KEEP UPDATE LOCKS");
                        break;
                    }
                    if (n != 2) break;
                    stringBuffer.append(RDBMSUtils.selectForUpdateToString(2));
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: 
                case 8: 
                case 9: {
                    stringBuffer.append(RDBMSUtils.selectForUpdateToString(n));
                    break;
                }
                default: {
                    throw new AssertionError("Undefined database type " + n2);
                }
            }
            if (debugLogger.isDebugEnabled()) {
                EjbqlFinder.debug("groupSqlNonFinder: group: '" + string + "'  query is: '" + stringBuffer.toString() + "'");
            }
        }
        catch (Exception exception) {
            throw new IllegalExpressionException(7, "Internal Error while attempting to generate an Internal Finder for FieldGroup: '" + string + "'.  With Query: '" + stringBuffer.toString() + "'    " + exception.toString(), new DescriptorErrorInfo("<group-name>", (Object)rDBMSBean.getEjbName(), (Object)string));
        }
        return stringBuffer.toString();
    }

    public CorrelationVarInfo newCorrelationVarInfo(String string, String string2, boolean bl) {
        return new CorrelationVarInfo(string, string2, bl);
    }

    public QueryCachingHandler getQueryCachingHandler(Object[] objectArray, TTLManager tTLManager) {
        if (!this.isQueryCachingEnabled()) {
            return new QueryCachingHandler(this);
        }
        return new QueryCachingHandler(this.getEjbQuery(), this.getMaxElements(), (Finder)this, tTLManager);
    }

    protected boolean checkIfQueryCachingLegal(RDBMSBean rDBMSBean) {
        if (!super.checkIfQueryCachingLegal(rDBMSBean)) {
            return false;
        }
        if (this.isPreparedQueryFinder) {
            this.log.logWarning(this.fmt.QUERY_CACHING_NOT_SUPORTED_FOR_PREPARED_QUERY_FINDER(rDBMSBean.getEjbName(), this.getName()));
            return false;
        }
        String string = this.getCachingName();
        if (string == null) {
            return true;
        }
        RelationshipCaching relationshipCaching = rDBMSBean.getRelationshipCaching(string);
        List list = relationshipCaching.getCachingElements();
        for (int i = 0; i < list.size(); ++i) {
            RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)list.get(i);
            if (this.checkIfQueryCachingLegal(cachingElement, rDBMSBean.getRelatedRDBMSBean(cachingElement.getCmrField()))) continue;
            this.log.logWarning(this.fmt.QUERY_CACHING_FINDER_HAS_RW_CACHING_ELEMENT_CMR_FIELD(rDBMSBean.getEjbName(), this.getName(), cachingElement.toString()));
            return false;
        }
        return true;
    }

    private boolean checkIfQueryCachingLegal(RelationshipCaching.CachingElement cachingElement, RDBMSBean rDBMSBean) {
        String string = cachingElement.getCmrField();
        if (!rDBMSBean.isReadOnly()) {
            return false;
        }
        List list = cachingElement.getCachingElements();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                RelationshipCaching.CachingElement cachingElement2 = (RelationshipCaching.CachingElement)list.get(i);
                if (this.checkIfQueryCachingLegal(cachingElement2, rDBMSBean.getRelatedRDBMSBean(cachingElement2.getCmrField()))) continue;
                return false;
            }
        }
        return true;
    }

    private static void debug(String string) {
        debugLogger.debug("[EjbqlFinder] " + string);
    }

    public class CorrelationVarInfo {
        String id = "";
        String value = "";
        boolean isCollectionValue = false;
        boolean isRemoteInterfaceRef = false;

        public CorrelationVarInfo(String string, String string2, boolean bl) {
            this.id = string;
            this.value = string2;
            this.isCollectionValue = bl;
        }

        public void setIsRemoteInterfaceRef(boolean bl) {
            this.isRemoteInterfaceRef = bl;
        }

        public String getValue() {
            return this.value;
        }
    }
}

