/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.utils.ErrorCollectionException;

public final class ExprARITH_FUNCTION
extends BaseExpr
implements Expr,
ExpressionTypes {
    protected ExprARITH_FUNCTION(int n, Expr expr) {
        super(n, expr);
        this.debugClassName = "ExprARITH_FUNCTION - " + ExprARITH_FUNCTION.getTypeName(n);
    }

    protected ExprARITH_FUNCTION(int n, Expr expr, Expr expr2) {
        super(n, expr, expr2);
        this.debugClassName = "ExprARITH_FUNCTION - " + ExprARITH_FUNCTION.getTypeName(n);
    }

    public void init_method() throws ErrorCollectionException {
        switch (this.type()) {
            case 58: 
            case 59: {
                ExprARITH_FUNCTION.requireTerm(this, 1);
                try {
                    this.verifyArithmeticExpressionTerm(this, 1);
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                this.throwCollectionException();
                try {
                    this.term1.init(this.globalContext, this.queryTree);
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                this.throwCollectionException();
                break;
            }
            case 76: {
                ExprARITH_FUNCTION.requireTerm(this, 1);
                ExprARITH_FUNCTION.requireTerm(this, 2);
                try {
                    this.verifyArithmeticExpressionTerm(this, 1);
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                try {
                    this.verifyArithmeticExpressionTerm(this, 2);
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                this.throwCollectionException();
                try {
                    this.term1.init(this.globalContext, this.queryTree);
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                try {
                    this.term2.init(this.globalContext, this.queryTree);
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                this.throwCollectionException();
                break;
            }
            default: {
                Exception exception = new Exception("Internal Error in " + this.debugClassName + ", unknown function type " + this.type());
                this.markExcAndThrowCollectionException(exception);
            }
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        switch (this.type()) {
            case 58: 
            case 59: {
                try {
                    this.term1.calculate();
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                this.throwCollectionException();
                break;
            }
            case 76: {
                try {
                    this.term1.calculate();
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                try {
                    this.term2.calculate();
                }
                catch (ErrorCollectionException errorCollectionException) {
                    this.addCollectionException((Exception)((Object)errorCollectionException));
                }
                this.throwCollectionException();
                break;
            }
            default: {
                Exception exception = new Exception("Internal Error in " + this.debugClassName + ", unknown function type " + this.type());
                this.markExcAndThrowCollectionException(exception);
            }
        }
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        this.appendMainEJBQLTokenToList(list);
        if (this.term1 != null) {
            this.appendNewEJBQLTokenToList("( ", list);
            this.term1.appendEJBQLTokens(list);
            if (this.term2 != null) {
                this.appendNewEJBQLTokenToList(", ", list);
                this.term2.appendEJBQLTokens(list);
            }
            this.appendNewEJBQLTokenToList(") ", list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type()) {
            case 58: {
                this.getAbsFunction(stringBuffer);
                break;
            }
            case 59: {
                this.getSqrtFunction(stringBuffer);
                break;
            }
            case 76: {
                this.getModFunction(stringBuffer);
                break;
            }
            default: {
                Exception exception = new Exception("Internal Error in " + this.debugClassName + ", unknown function type " + this.type());
                this.markExcAndThrowCollectionException(exception);
            }
        }
        return stringBuffer.toString();
    }

    private void getAbsFunction(StringBuffer stringBuffer) throws ErrorCollectionException {
        int n = this.globalContext.getDatabaseType();
        if (n == 4 || n == 1 || n == 2 || n == 7 || n == 5 || n == 9) {
            stringBuffer.append(" ABS( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(" )");
        } else {
            stringBuffer.append(" { fn ABS( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(" ) } ");
        }
    }

    private void getSqrtFunction(StringBuffer stringBuffer) throws ErrorCollectionException {
        int n = this.globalContext.getDatabaseType();
        if (n == 4 || n == 1 || n == 2 || n == 7 || n == 5 || n == 9) {
            stringBuffer.append(" SQRT( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(" ) ");
        } else {
            stringBuffer.append(" { fn SQRT( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(" ) } ");
        }
    }

    private void getModFunction(StringBuffer stringBuffer) throws ErrorCollectionException {
        int n = this.globalContext.getDatabaseType();
        if (n == 4 || n == 1 || n == 3 || n == 8 || n == 6 || n == 9) {
            stringBuffer.append(" MOD( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(", ");
            stringBuffer.append(this.term2.toSQL());
            stringBuffer.append(" ) ");
        } else if (n == 2 || n == 7 || n == 5) {
            stringBuffer.append(" ( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(" % ");
            stringBuffer.append(this.term2.toSQL());
            stringBuffer.append(" ) ");
        } else {
            stringBuffer.append(" { fn Mod( ");
            stringBuffer.append(this.term1.toSQL());
            stringBuffer.append(", ");
            stringBuffer.append(this.term2.toSQL());
            stringBuffer.append(" ) } ");
        }
    }
}

