/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExprVARIABLE;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.SingleExprIDHolder;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.utils.ErrorCollectionException;

public final class ExprCASE
extends BaseExpr
implements Expr,
ExpressionTypes,
SingleExprIDHolder {
    protected ExprCASE(int n, Expr expr) {
        super(n, expr);
        this.debugClassName = "ExprSTRING_FUNCTION - " + ExprCASE.getTypeName(n);
    }

    public void init_method() throws ErrorCollectionException {
        ExprCASE.requireTerm(this, 1);
        if (this.term1.type() != 19) {
            try {
                ExprCASE.verifyStringExpressionTerm(this, 1);
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.addCollectionException((Exception)((Object)errorCollectionException));
            }
        }
        try {
            this.term1.init(this.globalContext, this.queryTree);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        switch (this.term1.type()) {
            case 17: {
                this.validateID((ExprID)this.term1);
                break;
            }
            case 25: {
                this.validateVARIABLE((ExprVARIABLE)this.term1);
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type for Upper or Lower target: " + ExpressionTypes.TYPE_NAMES[this.term1.type()]));
            }
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        this.term1.calculate();
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        this.appendMainEJBQLTokenToList(list);
        this.appendNewEJBQLTokenToList("( ", list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendNewEJBQLTokenToList(") ", list);
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type()) {
            case 70: {
                stringBuffer.append("UPPER( ");
                break;
            }
            case 71: {
                stringBuffer.append("LOWER( ");
                break;
            }
            default: {
                Exception exception = new Exception("Internal Error in " + this.debugClassName + ", unknown function type " + this.type());
                this.markExcAndThrowCollectionException(exception);
            }
        }
        stringBuffer.append(this.term1.toSQL());
        if (this.globalContext.getDatabaseType() == 4 && this.term1.type() == 25) {
            stringBuffer.append("||''");
        }
        stringBuffer.append(" ) ");
        return stringBuffer.toString();
    }

    public ExprID getExprID() {
        try {
            return (ExprID)this.term1;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)"InternalError: getExprID() can only be called when the argument is a path expression");
        }
    }

    private void validateVARIABLE(ExprVARIABLE exprVARIABLE) throws ErrorCollectionException {
        int n = exprVARIABLE.getVariableNumber();
        Class clazz = this.globalContext.getFinderParameterTypeAt(n - 1);
        if (clazz != String.class && clazz != Character.class && clazz != Character.TYPE) {
            EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, eJBTextTextFormatter.caseOperatorUsedOnNonStringField(this.globalContext.getEjbName(), "?" + n));
            exprVARIABLE.markExcAndThrowCollectionException(illegalExpressionException);
        }
    }

    private void validateID(ExprID exprID) throws ErrorCollectionException {
        String string = exprID.getEjbqlID();
        if (exprID.isPathExpressionEndingInCmpFieldWithNoSQLGen()) {
            JoinNode joinNode = exprID.getJoinNodeForLastCmrFieldWithSQLGen();
            RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
            String string2 = exprID.getLastField();
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            Class clazz = cMPBeanDescriptor.getFieldClass(string2);
            if (clazz != String.class && clazz != Character.class && clazz != Character.TYPE) {
                EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
                IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, eJBTextTextFormatter.caseOperatorUsedOnNonStringField(this.globalContext.getEjbName(), string));
                exprID.markExcAndThrowCollectionException(illegalExpressionException);
            }
        } else {
            EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, eJBTextTextFormatter.caseOperatorUsedOnNonStringField(this.globalContext.getEjbName(), string));
            exprID.markExcAndThrowCollectionException(illegalExpressionException);
        }
    }
}

