/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExprNOT_EQUAL;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.EjbEntityRef;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public class ExprEQUAL
extends BaseExpr
implements Expr,
ExpressionTypes {
    private static final int TYPE_EQ_CMP_FIELD = 0;
    private static final int TYPE_EQ_SUBQUERY_BEAN = 1;
    private static final int TYPE_EQ_ON_BEAN = 2;
    private static final int TYPE_EQ_ON_BOOLEAN_LITERAL = 3;
    private static final int OP_EQ_ON_BEAN = 0;
    private static final int OP_SUBQUERY_IN_ON_BEAN = 1;
    private static final int OP_EQ_SUBQUERY_ANY_ON_BEAN = 2;
    private static final int OP_EQ_SUBQUERY_ALL_ON_BEAN = 3;
    private static final int OP_EQ_SUBQUERY_ON_BEAN = 4;
    private static final int OP_NOT_EQ_ON_BEAN = 5;
    private static final int OP_SUBQUERY_NOT_IN_ON_BEAN = 6;
    private static final int OP_NOT_EQ_SUBQUERY_ANY_ON_BEAN = 7;
    private static final int OP_NOT_EQ_SUBQUERY_ALL_ON_BEAN = 8;
    private static final int OP_NOT_EQ_SUBQUERY_ON_BEAN = 9;
    private int eqType;
    protected boolean isEqual = true;
    private StringBuffer preCalcSQLBuf = null;

    protected ExprEQUAL(int n, Expr expr, Expr expr2) {
        super(n, expr, expr2);
        this.debugClassName = "ExprEQUAL ";
    }

    public void init_method() throws ErrorCollectionException {
        ExprEQUAL.requireTerm(this, 1);
        ExprEQUAL.requireTerm(this, 2);
        try {
            this.term1.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        try {
            this.term2.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        try {
            this.eqType = this.getEqType();
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
            this.throwCollectionException();
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        this.preCalcSQLBuf = new StringBuffer();
        switch (this.eqType) {
            case 1: {
                ExprEQUAL.doCalcEQonSubQuerySelectBean(this.globalContext, this.queryTree, this, this.preCalcSQLBuf, this.isEqual, false);
                return;
            }
            case 2: {
                ExprEQUAL.doCalcEQonBean(this.globalContext, this.queryTree, this, this.preCalcSQLBuf, this.isEqual);
                return;
            }
            case 3: {
                ExprEQUAL.doCalcEQonBooleanLiteral(this.globalContext, this.queryTree, this, this.preCalcSQLBuf, this.isEqual);
                return;
            }
            case 0: {
                ExprEQUAL.doSimpleEQ(this.globalContext, this.queryTree, this, this.preCalcSQLBuf, this.isEqual);
                return;
            }
        }
        this.markExcAndThrowCollectionException(new Exception("Internal Error. " + this.debugClassName + " unknown EQ Type: '" + this.eqType + "'"));
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        ExprNOT_EQUAL exprNOT_EQUAL = new ExprNOT_EQUAL(10, this.term1, this.term2);
        exprNOT_EQUAL.setPreEJBQLFrom(this);
        exprNOT_EQUAL.setMainEJBQL("<> ");
        exprNOT_EQUAL.setPostEJBQLFrom(this);
        return exprNOT_EQUAL;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        if (this.term2 != null) {
            this.term2.appendEJBQLTokens(list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        return this.preCalcSQLBuf.toString();
    }

    private int getEqType() throws ErrorCollectionException {
        if (ExprEQUAL.isCalcEQonSubQuerySelectBean(this)) {
            return 1;
        }
        if (ExprEQUAL.isCalcEQonBean(this)) {
            return 2;
        }
        if (ExprEQUAL.isCalcEQonBooleanLiteral(this)) {
            return 3;
        }
        return 0;
    }

    public static boolean isCalcEQonSubQuerySelectBean(Expr expr) throws ErrorCollectionException {
        Expr expr2;
        Expr expr3;
        if (expr.type() != 5 && expr.type() != 10 && expr.type() != 13) {
            return false;
        }
        boolean bl = false;
        if (expr.getTerm2() == null) {
            return false;
        }
        if (expr.getTerm1().type() == 43) {
            expr3 = expr.getTerm1();
            expr2 = expr.getTerm2();
        } else if (expr.getTerm2().type() == 43) {
            expr3 = expr.getTerm2();
            expr2 = expr.getTerm1();
        } else {
            return false;
        }
        Expr expr4 = BaseExpr.getExpressionFromTerms(expr3, 34);
        if (expr4 == null) {
            return false;
        }
        expr4 = BaseExpr.getAggregateExpressionFromSubQuerySelect(expr3);
        if (expr4 != null) {
            return false;
        }
        if (expr2 instanceof ExprID) {
            if (((ExprID)expr2).isPathExpressionEndingInCmpFieldWithNoSQLGen()) {
                return false;
            }
        } else if (expr2.type() == 25) {
            Loggable loggable = EJBLogger.logejbqlSubQueryBeansCannotTestVariablesLoggable();
            expr2.markExcAndThrowCollectionException((Exception)((Object)new ErrorCollectionException(loggable.getMessage())));
        }
        return true;
    }

    public static boolean isCalcEQonBean(Expr expr) throws ErrorCollectionException {
        ExprID exprID;
        if (expr.type() != 5 && expr.type() != 10) {
            return false;
        }
        if (expr.getTerm1().type() == 17) {
            exprID = (ExprID)expr.getTerm1();
            Expr expr2 = expr.getTerm2();
        } else if (expr.getTerm2().type() == 17) {
            exprID = (ExprID)expr.getTerm2();
            Expr expr3 = expr.getTerm1();
        } else {
            return false;
        }
        return !exprID.isPathExpressionEndingInCmpFieldWithNoSQLGen();
    }

    public static boolean isCalcEQonBooleanLiteral(Expr expr) {
        Expr expr2;
        if (expr.type() != 5 && expr.type() != 10) {
            return false;
        }
        if (expr.getTerm1().type() == 17) {
            Expr expr3 = expr.getTerm1();
            expr2 = expr.getTerm2();
        } else if (expr.getTerm2().type() == 17) {
            Expr expr4 = expr.getTerm2();
            expr2 = expr.getTerm1();
        } else {
            return false;
        }
        return expr2.type() == 14 || expr2.type() == 15;
    }

    private static void doSimpleEQ(QueryContext queryContext, QueryNode queryNode, Expr expr, StringBuffer stringBuffer, boolean bl) throws ErrorCollectionException {
        try {
            if (expr.getTerm1() instanceof ExprID) {
                ((ExprID)expr.getTerm1()).calcTableAndColumnForCmpField();
            } else {
                expr.getTerm1().calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            expr.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (expr.getTerm2() instanceof ExprID) {
                ((ExprID)expr.getTerm2()).calcTableAndColumnForCmpField();
            } else {
                expr.getTerm2().calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            expr.addCollectionException((Exception)((Object)errorCollectionException));
        }
        expr.throwCollectionException();
        stringBuffer.append(expr.getTerm1().toSQL());
        try {
            stringBuffer.append(BaseExpr.getComparisonOpStringFromType(expr.type()));
        }
        catch (ErrorCollectionException errorCollectionException) {
            expr.markExcAndThrowCollectionException((Exception)((Object)errorCollectionException));
        }
        stringBuffer.append(expr.getTerm2().toSQL());
        expr.throwCollectionException();
    }

    private static void doCalcEQonBean(QueryContext queryContext, QueryNode queryNode, Expr expr, StringBuffer stringBuffer, boolean bl) throws ErrorCollectionException {
        Expr expr2;
        ExprID exprID = null;
        Expr expr3 = null;
        if (expr.getTerm1().type() == 17) {
            exprID = (ExprID)expr.getTerm1();
            expr3 = expr.getTerm2();
        } else if (expr.getTerm2().type() == 17) {
            exprID = (ExprID)expr.getTerm2();
            expr3 = expr.getTerm1();
        }
        String string = exprID.getDealiasedEjbqlID();
        if (expr3.type() != 25 && expr3.type() != 17) {
            expr2 = EJBLogger.logejbqlCanOnlyTestBeanVsSameBeanTypeLoggable((String)string);
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, expr2.getMessage());
            expr.markExcAndThrowCollectionException((Exception)((Object)new ErrorCollectionException((Throwable)illegalExpressionException)));
        }
        if (expr3.type() == 17) {
            try {
                exprID.calculate();
            }
            catch (ErrorCollectionException errorCollectionException) {
                expr.addCollectionException((Exception)((Object)errorCollectionException));
            }
            try {
                expr3.calculate();
            }
            catch (ErrorCollectionException errorCollectionException) {
                expr.addCollectionException((Exception)((Object)errorCollectionException));
            }
            expr.throwCollectionException();
            try {
                if (bl) {
                    ExprEQUAL.doCalcEQonBean_ID_ID(queryContext, queryNode, exprID, expr3, stringBuffer, 0);
                } else {
                    ExprEQUAL.doCalcEQonBean_ID_ID(queryContext, queryNode, exprID, expr3, stringBuffer, 5);
                }
            }
            catch (ErrorCollectionException errorCollectionException) {
                expr.addCollectionExceptionAndThrow((Exception)((Object)errorCollectionException));
            }
            return;
        }
        expr2 = expr3;
        int n = Integer.parseInt(expr2.getSval());
        Class clazz = queryContext.getFinderParameterTypeAt(n - 1);
        if (exprID.isPathExpressionEndingInRemoteInterfaceWithSQLGen()) {
            Object object;
            try {
                exprID.calculate();
            }
            catch (Exception exception) {
                expr.addCollectionException(exception);
            }
            expr.throwCollectionException();
            String string2 = clazz.getName();
            if (!string2.equals("javax.ejb.EJBObject")) {
                object = new IllegalExpressionException(7, "<cmr-field> " + string + ", the input parameter to be " + "tested against this field must be of type " + "javax.ejb.EJBObject.  Instead, it is: " + clazz.getName());
                exprID.markExcAndAddCollectionException((Exception)object);
                expr.addCollectionExceptionAndThrow((Exception)object);
            }
            object = exprID.getRDBMSBeanWithSQLGen();
            String string3 = exprID.getLastField();
            EjbEntityRef ejbEntityRef = exprID.getEntityRefWithSQLGen(string3);
            String string4 = ejbEntityRef.getHome();
            String string5 = "param" + (n - 1);
            ParamNode paramNode = new ParamNode((RDBMSBean)object, string5, n, clazz, string, string4, true, false, null, false, queryContext.isOracleNLSDataType(string3));
            queryContext.addFinderInternalQueryParmList(paramNode);
            queryContext.addFinderRemoteBeanParamList(paramNode);
            if (bl) {
                queryContext.setFinderRemoteBeanCommandEQ(true);
            } else {
                queryContext.setFinderRemoteBeanCommandEQ(false);
            }
            return;
        }
        try {
            exprID.calculate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            expr.addCollectionException((Exception)((Object)errorCollectionException));
        }
        expr.throwCollectionException();
        try {
            if (bl) {
                ExprEQUAL.doCalcEQonBean_ID_VARIABLE(queryContext, queryNode, exprID, expr2, stringBuffer, 0);
            } else {
                ExprEQUAL.doCalcEQonBean_ID_VARIABLE(queryContext, queryNode, exprID, expr2, stringBuffer, 5);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            expr.addCollectionExceptionAndThrow((Exception)((Object)errorCollectionException));
        }
    }

    public static void doCalcEQonSubQuerySelectBean(QueryContext queryContext, QueryNode queryNode, Expr expr, StringBuffer stringBuffer, boolean bl) throws ErrorCollectionException {
        ExprEQUAL.doCalcEQonSubQuerySelectBean(queryContext, queryNode, expr, stringBuffer, bl, false);
    }

    public static void doCalcEQonSubQuerySelectBean(QueryContext queryContext, QueryNode queryNode, Expr expr, StringBuffer stringBuffer, boolean bl, boolean bl2) throws ErrorCollectionException {
        Object object;
        Expr expr2;
        int n = 0;
        Expr expr3 = expr.getTerm1();
        Expr expr4 = expr.getTerm2();
        if (expr.getTerm2().type() == 43) {
            expr3 = expr.getTerm2();
            expr4 = expr.getTerm1();
        }
        if ((expr2 = expr3.getTerm1()).type() != 19) {
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, "Error in doCalcEQonSubQuerySelectBean(), the first term in SUBQUERY token is not INTEGER as expected !");
            expr2.markExcAndAddCollectionException(illegalExpressionException);
            expr.addCollectionExceptionAndThrow(illegalExpressionException);
        }
        int n2 = (int)expr2.getIval();
        Expr expr5 = expr3.getTerm2();
        if (bl2) {
            n = bl ? 1 : 6;
        } else if (expr5.type() == 64) {
            n = bl ? 2 : 7;
        } else if (expr5.type() == 49) {
            n = bl ? 3 : 8;
        } else if (expr5.type() == 34) {
            n = bl ? 4 : 9;
        } else {
            object = new IllegalExpressionException(7, "Error in doCalcEQonSubQuerySelectBean(), unable to handle Expression type: '" + expr5.type() + "'");
            expr3.markExcAndAddCollectionException((Exception)object);
            expr.addCollectionExceptionAndThrow((Exception)object);
        }
        if (expr4 instanceof ExprID) {
            IllegalExpressionException illegalExpressionException;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ExprEQUAL.doCalcEQonBean_ID_ID(queryContext, queryNode, expr4, null, stringBuffer, n);
            switch (n) {
                case 2: 
                case 7: {
                    stringBuffer.append("ANY ");
                    break;
                }
                case 3: 
                case 8: {
                    stringBuffer.append("ALL ");
                    break;
                }
            }
            expr3.calculate();
            stringBuffer.append(expr3.toSQL());
            object = ((ExprID)expr4).getDealiasedEjbqlID();
            RDBMSBean rDBMSBean = ((ExprID)expr4).getRDBMSBeanWithSQLGen();
            QueryNode queryNode2 = queryNode.getQueryNodeForQueryId(n2);
            if (queryNode2 == null) {
                object5 = new IllegalExpressionException(7, "Unable to locate SubQuery Node for SubQuery number '" + n2 + "'");
                expr3.markExcAndAddCollectionException((Exception)object5);
                expr.addCollectionExceptionAndThrow((Exception)object5);
            }
            if ((object5 = queryNode2.getSelectList()).size() > 1) {
                object4 = EJBLogger.logejbqlSubQuerySelectCanOnlyHaveOneItemLoggable();
                object3 = new IllegalExpressionException(7, object4.getMessage());
                expr3.markExcAndAddCollectionException((Exception)object3);
                expr.addCollectionExceptionAndThrow((Exception)object3);
            }
            if ((object3 = ((SelectNode)(object4 = (SelectNode)object5.get(0))).getSelectBean()) == null) {
                object2 = EJBLogger.logejbqlCanOnlyTestBeanVsSameBeanTypeLoggable((String)object);
                illegalExpressionException = new IllegalExpressionException(7, object2.getMessage());
                expr3.markExcAndAddCollectionException(illegalExpressionException);
                expr.addCollectionExceptionAndThrow(illegalExpressionException);
            }
            if (!((RDBMSBean)object3).equals(rDBMSBean)) {
                object2 = EJBLogger.logejbqlCanOnlyTestBeanVsSameBeanTypeLoggable((String)object);
                illegalExpressionException = new IllegalExpressionException(7, object2.getMessage());
                expr3.markExcAndAddCollectionException(illegalExpressionException);
                expr.addCollectionExceptionAndThrow(illegalExpressionException);
            }
            if ((object2 = rDBMSBean.getCMPBeanDescriptor()).hasComplexPrimaryKey()) {
                illegalExpressionException = EJBLogger.logejbqlSubQueryBeansCanOnlyHaveSimplePKsLoggable((String)object);
                IllegalExpressionException illegalExpressionException2 = new IllegalExpressionException(7, illegalExpressionException.getMessage());
                expr3.markExcAndAddCollectionException(illegalExpressionException2);
                expr.addCollectionExceptionAndThrow(illegalExpressionException2);
            }
            return;
        }
        if (expr4.type() == 25) {
            object = EJBLogger.logejbqlSubQueryBeansCannotTestVariablesLoggable();
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, object.getMessage());
            expr4.markExcAndAddCollectionException(illegalExpressionException);
            expr.addCollectionExceptionAndThrow(illegalExpressionException);
        }
    }

    private static void doCalcEQonBean_ID_ID(QueryContext queryContext, QueryNode queryNode, Expr expr, Expr expr2, StringBuffer stringBuffer, int n) throws ErrorCollectionException {
        Object object;
        Object object2;
        boolean bl = false;
        switch (n) {
            case 0: 
            case 5: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        String string = ((ExprID)expr).getDealiasedEjbqlID();
        RDBMSBean rDBMSBean = ((ExprID)expr).getRDBMSBeanWithSQLGen();
        String string2 = null;
        if (bl) {
            string2 = ((ExprID)expr2).getDealiasedEjbqlID();
            object2 = ((ExprID)expr2).getRDBMSBeanWithSQLGen();
            if (!rDBMSBean.equals(object2)) {
                Loggable loggable = EJBLogger.logejbqlCanOnlyTestBeanVsSameBeanTypeLoggable((String)string);
                object = new IllegalExpressionException(7, loggable.getMessage());
                expr2.markExcAndAddCollectionException((Exception)object);
            }
        }
        object2 = rDBMSBean.getCMPBeanDescriptor();
        boolean bl2 = object2.hasComplexPrimaryKey();
        object = rDBMSBean.getPrimaryKeyFields();
        int n2 = object.size();
        String string3 = null;
        String string4 = null;
        if (bl) {
            stringBuffer.append("(");
        }
        block18: for (int i = 0; i < n2; ++i) {
            Loggable loggable;
            String string5 = (String)object.get(i);
            String string6 = string + (string.length() > 0 ? "." : "") + string5;
            String string7 = null;
            try {
                string7 = ExprID.calcTableAndColumn(queryContext, queryNode, string6);
            }
            catch (Exception exception) {
                loggable = EJBLogger.logfinderCouldNotGetTableAndFieldLoggable((String)string);
                expr.markExcAndThrowCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
            }
            switch (n) {
                case 0: 
                case 5: {
                    string3 = string2 + (string2.length() > 0 ? "." : "") + string5;
                    try {
                        string4 = ExprID.calcTableAndColumn(queryContext, queryNode, string3);
                        break;
                    }
                    catch (Exception exception) {
                        loggable = EJBLogger.logfinderCouldNotGetTableAndFieldLoggable((String)string2);
                        expr2.markExcAndThrowCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
                    }
                }
            }
            switch (n) {
                case 0: {
                    stringBuffer.append(string7).append(" = ").append(string4).append(" AND ");
                    continue block18;
                }
                case 5: {
                    stringBuffer.append(string7).append(" != ").append(string4).append("  OR ");
                    continue block18;
                }
                case 1: {
                    stringBuffer.append(string7).append(" IN ");
                    continue block18;
                }
                case 6: {
                    stringBuffer.append(string7).append(" NOT IN ");
                    continue block18;
                }
                case 2: 
                case 3: 
                case 4: {
                    stringBuffer.append(string7).append(" = ");
                    continue block18;
                }
                case 7: 
                case 8: 
                case 9: {
                    stringBuffer.append(string7).append(" <> ");
                    continue block18;
                }
                default: {
                    expr.markExcAndThrowCollectionException(new IllegalExpressionException(7, "unknown operation encountered for Equality on Bean: '" + n + "'"));
                }
            }
        }
        if (bl) {
            if (stringBuffer.length() > 5) {
                stringBuffer.setLength(stringBuffer.length() - 5);
            }
            stringBuffer.append(")");
        }
        if (debugLogger.isDebugEnabled()) {
            ExprEQUAL.debug(" Bean equal SQL is: " + stringBuffer.toString() + "\n\n\n");
        }
    }

    private static void doCalcEQonBean_ID_VARIABLE(QueryContext queryContext, QueryNode queryNode, Expr expr, Expr expr2, StringBuffer stringBuffer, int n) throws ErrorCollectionException {
        int n2 = Integer.parseInt(expr2.getSval());
        Class clazz = queryContext.getFinderParameterTypeAt(n2 - 1);
        String string = clazz.getName();
        String string2 = ((ExprID)expr).getDealiasedEjbqlID();
        RDBMSBean rDBMSBean = ((ExprID)expr).getRDBMSBeanWithSQLGen();
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        boolean bl = false;
        String string3 = "";
        if (cMPBeanDescriptor.hasLocalClientView() && (string3 = cMPBeanDescriptor.getLocalInterfaceName()).equals(string)) {
            bl = true;
        }
        if (!bl && cMPBeanDescriptor.hasRemoteClientView() && (string3 = cMPBeanDescriptor.getRemoteInterfaceName()).equals(string)) {
            bl = true;
        }
        if (!bl) {
            Loggable loggable = EJBLogger.logejbqlWrongBeanTestedAgainstVariableLoggable((String)string2, (String)string3, (String)Integer.toString(n2), (String)string);
            expr.markExcAndThrowCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
        }
        boolean bl2 = cMPBeanDescriptor.hasComplexPrimaryKey();
        Class clazz2 = null;
        if (bl2) {
            clazz2 = cMPBeanDescriptor.getPrimaryKeyClass();
        }
        String string4 = "param" + (n2 - 1);
        ParamNode paramNode = new ParamNode(rDBMSBean, string4, n2, clazz, string2, "", true, false, clazz2, bl2, false);
        if (debugLogger.isDebugEnabled()) {
            ExprEQUAL.debug(" processing Bean Parameter Node: " + paramNode);
        }
        String string5 = string2;
        List list = rDBMSBean.getPrimaryKeyFields();
        int n3 = list.size();
        stringBuffer.append("(");
        block6: for (int i = 0; i < n3; ++i) {
            String string6 = (String)list.get(i);
            clazz2 = cMPBeanDescriptor.getFieldClass(string6);
            if (clazz2 == null) {
                if (debugLogger.isDebugEnabled()) {
                    ExprEQUAL.debug("  PK CLASS: " + string6 + " is NULL !!!!");
                }
                Loggable loggable = EJBLogger.logfinderNoPKClassForFieldLoggable((String)string6);
                expr.markExcAndThrowCollectionException(new IllegalExpressionException(7, "Bean: " + rDBMSBean.getEjbName() + "  " + loggable.getMessage()));
            }
            boolean bl3 = queryContext.isOracleNLSDataType(string6);
            if (i == 0 && !bl2) {
                paramNode.setPrimaryKeyClass(clazz2);
                paramNode.setOracleNLSDataType(bl3);
            }
            String string7 = string5 + (string5.length() > 0 ? "." : "") + string6;
            ParamNode paramNode2 = new ParamNode(rDBMSBean, "N_A", n2, clazz2, string6, "", false, false, clazz2, false, bl3);
            if (debugLogger.isDebugEnabled()) {
                ExprEQUAL.debug(" added ParamNode: " + paramNode2.toString());
            }
            paramNode.addParamSubList(paramNode2);
            String string8 = null;
            try {
                string8 = ExprID.calcTableAndColumn(queryContext, queryNode, string7);
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logfinderCouldNotGetTableAndFieldLoggable((String)string2);
                expr.markExcAndThrowCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
            }
            switch (n) {
                case 0: {
                    stringBuffer.append(string8).append(" = ? ").append(" AND ");
                    continue block6;
                }
                case 5: {
                    stringBuffer.append(string8).append(" != ? ").append("  OR ");
                    continue block6;
                }
                default: {
                    expr.markExcAndThrowCollectionException(new IllegalExpressionException(7, "unknown operation: " + n + ", encountered for QJB QL WHERE clause testing Equality of Bean " + "of Interface type '" + string3 + "' to Input Variable '?" + n2 + "'."));
                }
            }
        }
        if (stringBuffer.length() > 5) {
            stringBuffer.setLength(stringBuffer.length() - 5);
        }
        stringBuffer.append(")");
        if (debugLogger.isDebugEnabled()) {
            ExprEQUAL.debug(" Bean Parameter SQL is: " + stringBuffer.toString());
        }
        queryContext.addFinderInternalQueryParmList(paramNode);
    }

    private static void doCalcEQonBooleanLiteral(QueryContext queryContext, QueryNode queryNode, Expr expr, StringBuffer stringBuffer, boolean bl) throws ErrorCollectionException {
        Expr expr2 = null;
        Expr expr3 = null;
        if (expr.getTerm1().type() == 17) {
            expr2 = expr.getTerm1();
            expr3 = expr.getTerm2();
        } else if (expr.getTerm2().type() == 17) {
            expr2 = expr.getTerm2();
            expr3 = expr.getTerm1();
        }
        String string = ((ExprID)expr2).getDealiasedEjbqlID();
        String string2 = ((ExprID)expr2).calcTableAndColumnForCmpField();
        if (expr3.type() == 14) {
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append(" = ");
            } else {
                stringBuffer.append(" <> ");
            }
            stringBuffer.append("1 ");
            return;
        }
        if (expr3.type() == 15) {
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append(" = ");
            } else {
                stringBuffer.append(" <> ");
            }
            stringBuffer.append("0 ");
            return;
        }
        Loggable loggable = EJBLogger.logfinderInvalidBooleanLiteralLoggable();
        expr2.markExcAndThrowCollectionException(new IllegalExpressionException(7, "<cmr-field> " + string + ", " + loggable.getMessage()));
    }

    private static void debug(String string) {
        debugLogger.debug("[ExprEQUAL] " + string);
    }
}

