/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.SingleExprIDHolder;
import weblogic.ejb.container.persistence.spi.EjbEntityRef;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public final class ExprID
extends BaseExpr
implements Expr,
SingleExprIDHolder,
ExpressionTypes {
    private static final char DOT = '.';
    public static final int ABSTRACT_SCHEMA_NAME = 0;
    public static final int RANGE_VARIABLE = 1;
    public static final int COLLECTION_MEMBER_ID = 2;
    public static final int PATH_EXPRESSION_CMP = 3;
    public static final int PATH_EXPRESSION_CMR = 4;
    private String ejbqlId;
    private String dealiasedEjbqlId;
    private String sqlString = null;
    private boolean prepForSQLGenDone = false;
    private char[] allowBackwardIdChars = new char[]{'@', '-'};

    protected ExprID(int n, String string) {
        super(n, string);
        this.ejbqlId = string;
        this.debugClassName = "ExprID - '" + this.ejbqlId + "' ";
    }

    public void init_method() throws ErrorCollectionException {
        if (this.ejbqlId == null || this.ejbqlId.length() <= 0) {
            throw new AssertionError((Object)" ERROR encountered a NULL or EMPTY ejbqlId ");
        }
        this.validateID();
    }

    public void calculate_method() throws ErrorCollectionException {
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public String toSQL() throws ErrorCollectionException {
        if (this.sqlString == null) {
            this.calcTableAndColumnForCmpField();
        }
        return this.sqlString;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        this.appendMainEJBQLTokenToList(list);
        this.appendPostEJBQLTokensToList(list);
    }

    public ExprID getExprID() {
        return this;
    }

    private void validateID() throws ErrorCollectionException {
        Exception exception;
        char[] cArray = this.ejbqlId.toCharArray();
        if (cArray.length > 0 && cArray[0] != '.' && !Character.isJavaIdentifierStart(cArray[0])) {
            Loggable loggable = EJBLogger.logInvalidStartCharacterForEJBQLIdentifierLoggable((char)cArray[0], (String)this.ejbqlId);
            exception = new Exception(loggable.getMessage());
            this.globalContext.addWarning(exception);
            if (this.allowBackwardsCompatibleChar(cArray[0])) {
                loggable = EJBLogger.logEJBQLCharAllowedForBackwardsCompatibilityLoggable((char)cArray[0], (String)this.ejbqlId);
                exception = new Exception(loggable.getMessage());
                this.globalContext.addWarning(exception);
            }
        }
        if (cArray.length > 1) {
            for (int i = 1; i < cArray.length; ++i) {
                if (cArray[i] == '.' || Character.isJavaIdentifierPart(cArray[i])) continue;
                exception = EJBLogger.logInvalidPartCharacterForEJBQLIdentifierLoggable((char)cArray[i], (String)this.ejbqlId);
                Exception exception2 = new Exception(exception.getMessage());
                this.globalContext.addWarning(exception2);
                if (!this.allowBackwardsCompatibleChar(cArray[i])) continue;
                exception = EJBLogger.logEJBQLCharAllowedForBackwardsCompatibilityLoggable((char)cArray[i], (String)this.ejbqlId);
                exception2 = new Exception(exception.getMessage());
                this.globalContext.addWarning(exception2);
            }
        }
    }

    private boolean allowBackwardsCompatibleChar(char c) {
        for (int i = 0; i < this.allowBackwardIdChars.length; ++i) {
            if (this.allowBackwardIdChars[i] != c) continue;
            return true;
        }
        return false;
    }

    public int getRelationshipTypeForPathExpressionWithNoSQLGen() throws ErrorCollectionException {
        try {
            return this.queryTree.getRelationshipTypeForPathExpressionWithNoSQLGen(this.getDealiasedEjbqlID());
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
            return -1;
        }
    }

    public boolean isPathExpressionEndingInCmpFieldWithNoSQLGen() throws ErrorCollectionException {
        int n = this.getRelationshipTypeForPathExpressionWithNoSQLGen();
        return n == 0;
    }

    private boolean isPathExpressionEndingInCmpFieldWithSQLGen() throws ErrorCollectionException {
        String string;
        if (!this.prepForSQLGenDone) {
            this.prepareIdentifierForSQLGen();
        }
        if ((string = this.getDealiasedEjbqlID()) == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = this.globalContext.pathExpressionEndsInField(this.queryTree, string);
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
        return bl;
    }

    public boolean isPathExpressionEndingInRemoteInterfaceWithSQLGen() throws ErrorCollectionException {
        String string;
        if (!this.prepForSQLGenDone) {
            this.prepareIdentifierForSQLGen();
        }
        if ((string = this.getDealiasedEjbqlID()) == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = this.globalContext.pathExpressionEndsInRemoteInterface(this.queryTree, string);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.markExcAndThrowCollectionException(illegalExpressionException);
        }
        return bl;
    }

    public boolean isPathExpressionEndingInBlobClobColumnWithSQLGen() throws ErrorCollectionException {
        String string;
        if (!this.prepForSQLGenDone) {
            this.prepareIdentifierForSQLGen();
        }
        if (!this.isPathExpressionEndingInCmpFieldWithSQLGen()) {
            return false;
        }
        RDBMSBean rDBMSBean = this.getRDBMSBeanWithSQLGen();
        return rDBMSBean.isBlobCmpColumnTypeForField(string = QueryContext.getLastFieldFromId(this.getEjbqlID())) || rDBMSBean.isClobCmpColumnTypeForField(string);
    }

    public RDBMSBean getRDBMSBeanWithSQLGen() throws ErrorCollectionException {
        RDBMSBean rDBMSBean = null;
        if (!this.prepForSQLGenDone) {
            this.prepareIdentifierForSQLGen();
        }
        String string = this.getDealiasedEjbqlID();
        try {
            rDBMSBean = this.queryTree.getLastRDBMSBeanForPathExpression(string);
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
        if (rDBMSBean == null) {
            this.markExcAndThrowCollectionException(new IllegalExpressionException(7, "Fatal Internal Error, could not get RDBMSBean for path expression: '" + string + "'"));
        }
        return rDBMSBean;
    }

    public EjbEntityRef getEntityRefWithSQLGen(String string) throws ErrorCollectionException {
        RDBMSBean rDBMSBean = null;
        try {
            rDBMSBean = this.getRDBMSBeanWithSQLGen();
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
        if (rDBMSBean == null) {
            throw new ErrorCollectionException(" getEntityRefFromRDBMSBean passed NULL RDBMSBean ! ");
        }
        EjbEntityRef ejbEntityRef = rDBMSBean.getEjbEntityRef(string);
        if (ejbEntityRef == null) {
            this.markExcAndThrowCollectionException(new Exception(" <cmr-field> " + string + " could not get EjbEntityRef from RDBMSBean: " + rDBMSBean.getEjbName() + " ! "));
        }
        return ejbEntityRef;
    }

    public String getEjbqlID() {
        return this.ejbqlId;
    }

    public void setEjbqlID(String string) {
        this.ejbqlId = string;
        this.prepForSQLGenDone = false;
    }

    public String getDealiasedEjbqlID() {
        if (debugLogger.isDebugEnabled()) {
            ExprID.debug(" getDealiasedEjbqlID  on '" + this.ejbqlId + "'");
        }
        if (debugLogger.isDebugEnabled() && this.globalContext == null) {
            ExprID.debug("  globalContext is  NULL !");
        }
        this.dealiasedEjbqlId = this.globalContext.replaceIdAliases(this.ejbqlId);
        return this.dealiasedEjbqlId;
    }

    public void setSQL(String string) {
        this.sqlString = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String calcTableAndColumnForCmpField() throws ErrorCollectionException {
        if (!this.prepForSQLGenDone) {
            this.prepareIdentifierForSQLGen();
        }
        String string = this.getDealiasedEjbqlID();
        if (!this.isPathExpressionEndingInCmpFieldWithSQLGen()) {
            this.markExcAndThrowCollectionException(new IllegalExpressionException(7, " Internal Error:  in ExprID.calcTableAndColumnForCmpField() attempt to execute Method on a pathExpression that is not terminated by a cmp-field:  '" + string + "'"));
        }
        String string2 = null;
        try {
            JoinNode joinNode = this.getJoinTreeForID();
            string2 = JoinNode.getTableAndField(this.queryTree, joinNode, string);
            if (this.queryTree.thisQueryNodeOwnsId(string)) {
                // empty if block
            }
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.markExcAndThrowCollectionException(illegalExpressionException);
        }
        this.setSQL(string2 + " ");
        return string2;
    }

    public JoinNode getJoinTreeForID() throws ErrorCollectionException {
        String string = this.getDealiasedEjbqlID();
        JoinNode joinNode = null;
        try {
            joinNode = this.queryTree.getJoinTreeForId(string);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            throw new ErrorCollectionException(illegalExpressionException.getMessage());
        }
        if (joinNode == null) {
            this.markExcAndThrowCollectionException(new IllegalExpressionException(7, " Internal Error:  in ExprID.getJoinTreeForID() attempt to get joinTree for ID: '" + string + "' yielded a NULL joinTree."));
        }
        return joinNode;
    }

    public JoinNode getJoinNodeForLastCmrFieldWithSQLGen() throws ErrorCollectionException {
        String string = this.getDealiasedEjbqlID();
        if (!this.prepForSQLGenDone) {
            this.prepareIdentifierForSQLGen();
        }
        JoinNode joinNode = this.getJoinTreeForID();
        JoinNode joinNode2 = null;
        try {
            joinNode2 = JoinNode.getNode(joinNode, string);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.markExcAndThrowCollectionException(illegalExpressionException);
        }
        return joinNode2;
    }

    public String getFirstField() {
        return JoinNode.getFirstFieldFromId(this.getDealiasedEjbqlID());
    }

    public String getLastField() {
        return JoinNode.getLastFieldFromId(this.getDealiasedEjbqlID());
    }

    public int countPathNodes() {
        return JoinNode.countPathNodes(this.getEjbqlID());
    }

    public void prepareIdentifierForSQLGen() throws ErrorCollectionException {
        try {
            this.queryTree.prepareIdentifierForSQLGen(this.getDealiasedEjbqlID());
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.markExcAndThrowCollectionException(illegalExpressionException);
        }
        this.prepForSQLGenDone = true;
    }

    public static ExprID newInitExprID(QueryContext queryContext, QueryNode queryNode, String string) throws ErrorCollectionException {
        ExprID exprID = new ExprID(17, string);
        exprID.init(queryContext, queryNode);
        return exprID;
    }

    public static String calcTableAndColumn(QueryContext queryContext, QueryNode queryNode, String string) throws ErrorCollectionException {
        ExprID exprID = new ExprID(17, string);
        exprID.init(queryContext, queryNode);
        exprID.calculate();
        return exprID.calcTableAndColumnForCmpField();
    }

    private static void debug(String string) {
        debugLogger.debug("[ExprID] " + string);
    }
}

