/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public class ExprIN
extends BaseExpr
implements Expr,
ExpressionTypes {
    private int numRHSTerms = 0;
    private boolean notIn = false;

    protected ExprIN(int n, Expr expr, Vector vector, boolean bl) {
        super(n, expr, vector);
        this.numRHSTerms = vector.size();
        this.notIn = bl;
        this.debugClassName = "ExprIN ";
    }

    protected ExprIN(int n, Expr expr, Vector vector) {
        this(n, expr, vector, false);
    }

    public void init_method() throws ErrorCollectionException {
        Loggable loggable;
        ExprIN.requireTerm(this, 1);
        try {
            this.term1.init(this.globalContext, this.queryTree);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        if (this.term1 instanceof ExprID) {
            // empty if block
        }
        if (this.terms == null) {
            loggable = EJBLogger.logExpressionRequiresXLoggable((String)"IN", (String)"Vector");
            this.markExcAndAddCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
        }
        if (this.numRHSTerms <= 0) {
            loggable = EJBLogger.logExpressionWrongNumberOfTermsLoggable((String)"IN", (String)Integer.toString(this.numRHSTerms));
            this.markExcAndAddCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
        }
        for (int i = 0; i < this.numRHSTerms; ++i) {
            Expr expr = (Expr)this.terms.elementAt(i);
            try {
                expr.init(this.globalContext, this.queryTree);
                continue;
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.addCollectionException((Exception)((Object)errorCollectionException));
            }
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        try {
            if (this.term1 instanceof ExprID) {
                ((ExprID)this.term1).calcTableAndColumnForCmpField();
            } else {
                this.term1.calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        for (int i = 0; i < this.numRHSTerms; ++i) {
            Expr expr = (Expr)this.terms.elementAt(i);
            try {
                if (expr instanceof ExprID) {
                    ((ExprID)expr).calcTableAndColumnForCmpField();
                    continue;
                }
                expr.calculate();
                continue;
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.addCollectionException((Exception)((Object)errorCollectionException));
            }
        }
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        if (this.notIn) {
            ExprIN exprIN = new ExprIN(13, this.term1, this.terms, false);
            exprIN.setPreEJBQLFrom(this);
            exprIN.setMainEJBQL("IN ");
            exprIN.setPostEJBQLFrom(this);
            return exprIN;
        }
        ExprIN exprIN = new ExprIN(13, this.term1, this.terms, true);
        exprIN.setPreEJBQLFrom(this);
        exprIN.setMainEJBQL("NOT IN ");
        exprIN.setPostEJBQLFrom(this);
        return exprIN;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        this.appendNewEJBQLTokenToList("(", list);
        Enumeration enumeration = this.terms.elements();
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            expr.appendEJBQLTokens(list);
            if (!enumeration.hasMoreElements()) continue;
            this.appendNewEJBQLTokenToList(", ", list);
        }
        this.appendNewEJBQLTokenToList(") ", list);
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        this.clearSQLBuf();
        if (this.notIn) {
            this.appendSQLBuf("NOT ( ");
        }
        this.appendSQLBuf(this.term1.toSQL());
        this.appendSQLBuf("IN ( ");
        for (int i = 0; i < this.numRHSTerms; ++i) {
            if (i > 0) {
                this.appendSQLBuf(", ");
            }
            Expr expr = (Expr)this.terms.elementAt(i);
            this.appendSQLBuf(expr.toSQL());
        }
        this.appendSQLBuf(") ");
        if (this.notIn) {
            this.appendSQLBuf(") ");
        }
        return this.getSQLBuf().toString();
    }
}

