/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import java.util.Map;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.utils.ErrorCollectionException;

public class ExprISEMPTY
extends BaseExpr
implements Expr,
ExpressionTypes {
    protected boolean isEmpty = true;
    private int relationshipType;
    private String fullEjbqlId;
    private String fullDealiasedEjbqlId;
    private ExprID lhsExprID = null;
    private String lhsPathExpression = null;
    private JoinNode lhsJoinNode = null;
    private RDBMSBean lhsBean = null;
    private String lhsTableAlias = null;
    private String lhsBeanCMRField = null;
    private StringBuffer preCalcSQLBuf = null;

    protected ExprISEMPTY(int n, Expr expr, boolean bl) {
        super(n, expr);
        this.isEmpty = bl;
        this.debugClassName = "ExprISEMPTY ";
    }

    public void init_method() throws ErrorCollectionException {
        Exception exception;
        Object object;
        ExprISEMPTY.requireTerm(this, 1);
        if (this.term1.type() != 17) {
            object = EJBLogger.logfinderArgMustBeCollectionValuedLoggable((String)"IS [NOT] EMPTY");
            exception = new Exception(object.getMessage());
            this.term1.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        try {
            this.term1.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception2) {
            this.addCollectionExceptionAndThrow(exception2);
        }
        this.fullEjbqlId = ((ExprID)this.term1).getEjbqlID();
        this.fullDealiasedEjbqlId = ((ExprID)this.term1).getDealiasedEjbqlID();
        try {
            this.relationshipType = ((ExprID)this.term1).getRelationshipTypeForPathExpressionWithNoSQLGen();
        }
        catch (Exception exception3) {
            this.term1.markExcAndAddCollectionException(exception3);
            this.addCollectionExceptionAndThrow(exception3);
        }
        if (this.relationshipType != 4 && this.relationshipType != 6 && this.relationshipType != 8) {
            object = RDBMSUtils.relationshipTypeToString(this.relationshipType);
            exception = EJBLogger.logfinderArgMustBeCollectionValuedLoggable((String)"IS (NOT) EMPTY");
            Exception exception4 = new Exception(exception.getMessage());
            this.term1.markExcAndAddCollectionException(exception4);
            this.addCollectionExceptionAndThrow(exception4);
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        this.term1.calculate();
        this.lhsExprID = this.globalContext.setupForLHSPrimaryKeysWithNoReferenceToRHS((ExprID)this.term1);
        this.lhsPathExpression = this.lhsExprID.getDealiasedEjbqlID();
        try {
            this.lhsJoinNode = this.queryTree.getJoinNodeForLastId(this.lhsPathExpression);
        }
        catch (Exception exception) {
            this.term1.markExcAndThrowCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        this.lhsBean = this.lhsJoinNode.getRDBMSBean();
        this.lhsTableAlias = this.lhsJoinNode.getTableAlias();
        this.lhsBeanCMRField = QueryContext.getLastFieldFromId(this.fullDealiasedEjbqlId);
        this.preCalcSQLBuf = new StringBuffer();
        switch (this.relationshipType) {
            case 8: {
                this.compute_remote_w_join_table(this.preCalcSQLBuf);
                return;
            }
            case 6: {
                this.compute_many_to_many(this.preCalcSQLBuf);
                return;
            }
            case 4: {
                this.compute_one_to_many(this.preCalcSQLBuf);
                return;
            }
        }
        this.markExcAndThrowCollectionException(new Exception("Internal Error,  IS [NOT] EMPTY cannot handle lhs relationship type number '" + this.relationshipType + "'  " + RDBMSUtils.relationshipTypeToString(this.relationshipType)));
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        if (this.isEmpty) {
            ExprISEMPTY exprISEMPTY = new ExprISEMPTY(41, this.term1, false);
            exprISEMPTY.setPreEJBQLFrom(this);
            exprISEMPTY.setMainEJBQL("IS EMPTY ");
            exprISEMPTY.setPostEJBQLFrom(this);
            return exprISEMPTY;
        }
        ExprISEMPTY exprISEMPTY = new ExprISEMPTY(41, this.term1, true);
        exprISEMPTY.setPreEJBQLFrom(this);
        exprISEMPTY.setMainEJBQL("IS NOT EMPTY ");
        exprISEMPTY.setPostEJBQLFrom(this);
        return exprISEMPTY;
    }

    private void compute_remote_w_join_table(StringBuffer stringBuffer) throws ErrorCollectionException {
        Object object;
        Object object2;
        Object object3;
        if (this.lhsBean.containsFkField(this.lhsBeanCMRField)) {
            object3 = EJBLogger.logfinderArgMustBeCollectionValuedLoggable((String)"IS (NOT) EMPTY");
            object2 = new Exception(object3.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object2);
            this.addCollectionExceptionAndThrow((Exception)object2);
        }
        if ((object3 = this.lhsBean.getJoinTableName(this.lhsBeanCMRField)) == null) {
            object2 = EJBLogger.logfinderCouldNotGetJoinTableLoggable();
            object = new Exception(" IS (NOT) EMPTY  '" + this.fullEjbqlId + "'  " + object2.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        if (!this.lhsBean.isForeignKeyField(this.lhsBeanCMRField)) {
            object2 = EJBLogger.logfinderCMRFieldNotFKLoggable((String)this.lhsBean.getEjbName(), (String)this.lhsBeanCMRField, (String)RDBMSUtils.relationshipTypeToString(this.relationshipType));
            object = new Exception(object2.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        object2 = this.lhsBean.getForeignKeyColNames(this.lhsBeanCMRField).iterator();
        object = this.lhsBean.getCmpFieldToColumnMap();
        stringBuffer.append(" ( 0 ");
        if (this.isEmpty) {
            stringBuffer.append("=");
        } else {
            stringBuffer.append("<");
        }
        stringBuffer.append(" (SELECT COUNT(*)  FROM ").append((String)object3).append(" WHERE ");
        while (object2.hasNext()) {
            String string = (String)object2.next();
            String string2 = (String)object.get(this.lhsBean.getRelatedPkFieldName(this.lhsBeanCMRField, string));
            stringBuffer.append(this.lhsTableAlias + "." + RDBMSUtils.escQuotedID(string2) + " = " + RDBMSUtils.escQuotedID((String)object3) + "." + RDBMSUtils.escQuotedID(string));
            if (object2.hasNext()) {
                stringBuffer.append(" AND ");
            } else {
                stringBuffer.append(" ");
            }
            this.addToSelectList(this.lhsBean, this.lhsTableAlias + "." + RDBMSUtils.escQuotedID(string2));
        }
        stringBuffer.append(") ) ");
    }

    private void compute_many_to_many(StringBuffer stringBuffer) throws ErrorCollectionException {
        Object object;
        Object object2;
        String string = this.lhsBean.getJoinTableName(this.lhsBeanCMRField);
        if (string == null) {
            object2 = EJBLogger.logfinderCouldNotGetJoinTableLoggable();
            object = new Exception(" IS (NOT) EMPTY  '" + this.fullEjbqlId + "'  " + object2.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        if (!this.lhsBean.isForeignKeyField(this.lhsBeanCMRField)) {
            object2 = EJBLogger.logfinderCMRFieldNotFKLoggable((String)this.lhsBean.getEjbName(), (String)this.lhsBeanCMRField, (String)RDBMSUtils.relationshipTypeToString(this.relationshipType));
            object = new Exception(object2.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        object2 = this.lhsBean.getForeignKeyColNames(this.lhsBeanCMRField).iterator();
        object = this.lhsBean.getCmpFieldToColumnMap();
        stringBuffer.append(" ( 0 ");
        if (this.isEmpty) {
            stringBuffer.append("=");
        } else {
            stringBuffer.append("<");
        }
        stringBuffer.append(" (SELECT COUNT(*)  FROM ").append(string).append(" WHERE ");
        while (object2.hasNext()) {
            String string2 = (String)object2.next();
            String string3 = (String)object.get(this.lhsBean.getRelatedPkFieldName(this.lhsBeanCMRField, string2));
            stringBuffer.append(this.lhsTableAlias + "." + RDBMSUtils.escQuotedID(string3) + " = " + RDBMSUtils.escQuotedID(string) + "." + RDBMSUtils.escQuotedID(string2));
            if (object2.hasNext()) {
                stringBuffer.append(" AND ");
            } else {
                stringBuffer.append(" ");
            }
            this.addToSelectList(this.lhsBean, this.lhsTableAlias + "." + RDBMSUtils.escQuotedID(string3));
        }
        stringBuffer.append(") ) ");
    }

    private void compute_one_to_many(StringBuffer stringBuffer) throws ErrorCollectionException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        RDBMSBean rDBMSBean = null;
        try {
            rDBMSBean = this.queryTree.getLastRDBMSBeanForPathExpressionWithNoSQLGen(this.fullDealiasedEjbqlId);
        }
        catch (Exception exception) {
            object4 = EJBLogger.logFinderCouldNotGetLastJoinNodeLoggable((String)RDBMSUtils.relationshipTypeToString(this.relationshipType), (String)this.fullEjbqlId, (String)exception.toString());
            object3 = new Exception(object4.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object3);
            this.addCollectionExceptionAndThrow((Exception)object3);
        }
        Map map = this.lhsBean.getCmpFieldToColumnMap();
        object4 = null;
        try {
            object4 = this.lhsBean.getRelatedFieldName(this.lhsBeanCMRField);
        }
        catch (Exception exception) {
            this.term1.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        if (((String)object4).length() < 1) {
            object3 = EJBLogger.logFinderCouldNotFindCMRPointingToBeanLoggable((String)rDBMSBean.getEjbName(), (String)this.lhsBean.getEjbName());
            object2 = new Exception(object3.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object2);
            this.addCollectionExceptionAndThrow((Exception)object2);
        }
        if ((object3 = rDBMSBean.getTableForCmrField((String)object4)) == null) {
            object2 = EJBLogger.logfinderCouldNotGetFKTableLoggable();
            object = new Exception(" cmr-field: '" + (String)object4 + "'  " + object2.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        object2 = rDBMSBean.getForeignKeyColNames((String)object4).iterator();
        stringBuffer.append(" ( 0 ");
        if (this.isEmpty) {
            stringBuffer.append("=");
        } else {
            stringBuffer.append("<");
        }
        stringBuffer.append(" (SELECT COUNT(*)  FROM ").append(RDBMSUtils.escQuotedID((String)object3)).append(" WHERE ");
        while (object2.hasNext()) {
            object = (String)object2.next();
            String string = (String)map.get(rDBMSBean.getRelatedPkFieldName((String)object4, (String)object));
            stringBuffer.append(this.lhsTableAlias + "." + RDBMSUtils.escQuotedID(string) + " = " + (String)object3 + "." + RDBMSUtils.escQuotedID((String)object));
            if (object2.hasNext()) {
                stringBuffer.append(" AND ");
            } else {
                stringBuffer.append(" ");
            }
            this.addToSelectList(this.lhsBean, this.lhsTableAlias + "." + RDBMSUtils.escQuotedID(string));
        }
        stringBuffer.append(") ) ");
    }

    private void addToSelectList(RDBMSBean rDBMSBean, String string) {
        SelectNode selectNode = new SelectNode();
        selectNode.setSelectType(17);
        selectNode.setSelectTypeName(ExpressionTypes.TYPE_NAMES[17]);
        selectNode.setSelectBean(rDBMSBean);
        selectNode.setDbmsTarget(string);
        selectNode.setCorrelatedSubQuery();
        this.queryTree.addSelectList(selectNode);
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        return this.preCalcSQLBuf.toString();
    }
}

