/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExprVARIABLE;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.utils.ErrorCollectionException;

public class ExprISMEMBER
extends BaseExpr
implements Expr,
ExpressionTypes {
    private int lhsRelationshipType;
    private int lhsArgType;
    private boolean lhsIsVariable = false;
    private int databaseType;
    private String lhsFullEjbqlId;
    private String lhsFullDealiasedEjbqlId;
    private String lhsLastPathExpressionElement;
    RDBMSBean lhsBean = null;
    Class lhsInterface = null;
    String lhsInterfaceName = null;
    ExprID truncatedLhsExprID = null;
    ExprID lhsExprIDForQuery = null;
    RDBMSBean lhsPrevBean = null;
    String lhsPrevTableName = null;
    String lhsPrevTableAlias = null;
    private boolean lhsIsRangeVariableIdentifier = false;
    private boolean lhsIsCollectionMemberIdentifier = false;
    private String rhsEjbqlId;
    private String rhsDealiasedEjbqlId;
    private String rhsLastPathExpressionElement;
    protected boolean isMember = true;
    boolean lhsRhsShareRoot = false;
    int lhsNumberOfPathNodes = 0;
    boolean rhsSharesSelectRoot = false;
    SelectNode rhsSelectNodeMatch = null;
    RDBMSBean rhsBean = null;
    Class rhsInterface = null;
    String rhsInterfaceName = null;
    List rhsPKFieldList = null;
    String rhsLastTableName = null;
    String rhsLocalSubqueryLastTableAlias = null;
    private StringBuffer preCalcSQLBuf = null;

    protected ExprISMEMBER(int n, Expr expr, ExprID exprID, boolean bl) {
        super(n, expr, exprID);
        this.isMember = bl;
        this.debugClassName = "ExprISMEMBER ";
    }

    public void init_method() throws ErrorCollectionException {
        Exception exception;
        Object object;
        String string;
        ExprISMEMBER.requireTerm(this, 1);
        ExprISMEMBER.requireTerm(this, 2);
        if (this.term1.type() != 17 && this.term1.type() != 25) {
            string = this.term1.getSval();
            if (string == null) {
                string = "???";
            }
            object = EJBLogger.logfinderMemberLHSWrongTypeLoggable((String)string);
            exception = new IllegalExpressionException(7, object.getMessage());
            this.term1.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        if (this.term2.type() != 17) {
            string = this.term2.getSval();
            if (string == null) {
                string = "???";
            }
            object = EJBLogger.logfinderMemberRHSWrongTypeLoggable((String)string);
            exception = new Exception(object.getMessage());
            this.term2.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        try {
            this.term1.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception2) {
            this.addCollectionException(exception2);
        }
        try {
            this.term2.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception3) {
            this.addCollectionException(exception3);
        }
        this.throwCollectionException();
        this.lhsArgType = this.term1.type();
        this.databaseType = this.globalContext.getDatabaseType();
        if (this.lhsArgType == 25) {
            this.lhsIsVariable = true;
            this.lhsRelationshipType = -1;
        } else {
            this.lhsFullEjbqlId = ((ExprID)this.term1).getEjbqlID();
            this.lhsFullDealiasedEjbqlId = ((ExprID)this.term1).getDealiasedEjbqlID();
            try {
                this.lhsRelationshipType = ((ExprID)this.term1).getRelationshipTypeForPathExpressionWithNoSQLGen();
            }
            catch (Exception exception4) {
                this.term1.markExcAndAddCollectionException(exception4);
                this.addCollectionExceptionAndThrow(exception4);
            }
            this.lhsIsRangeVariableIdentifier = this.queryTree.isRangeVariableInScope(this.lhsFullDealiasedEjbqlId);
            this.lhsIsCollectionMemberIdentifier = this.queryTree.isCollectionMemberInScope(this.lhsFullDealiasedEjbqlId);
            if (this.lhsRelationshipType != 2 && this.lhsRelationshipType != 3 && this.lhsRelationshipType != 5 && !this.lhsIsRangeVariableIdentifier && !this.lhsIsCollectionMemberIdentifier) {
                string = EJBLogger.logfinderMemberLHSWrongTypeLoggable((String)this.lhsFullEjbqlId);
                object = new IllegalExpressionException(7, string.getMessage());
                this.term1.markExcAndAddCollectionException((Exception)object);
                this.addCollectionExceptionAndThrow((Exception)object);
            }
            this.lhsLastPathExpressionElement = QueryContext.getLastFieldFromId(this.lhsFullDealiasedEjbqlId);
            this.lhsNumberOfPathNodes = ((ExprID)this.term1).countPathNodes();
            string = ((ExprID)this.term1).getFirstField();
            this.lhsRhsShareRoot = string.equals(object = ((ExprID)this.term2).getFirstField());
        }
        this.rhsEjbqlId = ((ExprID)this.term2).getEjbqlID();
        this.rhsDealiasedEjbqlId = ((ExprID)this.term2).getDealiasedEjbqlID();
        int n = 0;
        try {
            n = ((ExprID)this.term2).getRelationshipTypeForPathExpressionWithNoSQLGen();
        }
        catch (Exception exception5) {
            this.term2.markExcAndAddCollectionException(exception5);
            this.addCollectionExceptionAndThrow(exception5);
        }
        if (n != 6 && n != 4) {
            object = EJBLogger.logfinderMemberRHSWrongTypeLoggable((String)this.rhsEjbqlId);
            exception = new IllegalExpressionException(7, object.getMessage());
            this.term2.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        this.rhsSelectNodeMatch = this.queryTree.selectListRootMatch(this.rhsDealiasedEjbqlId);
        if (this.rhsSelectNodeMatch != null) {
            this.rhsSharesSelectRoot = true;
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        Object object;
        Object object2;
        try {
            this.term2.calculate();
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        this.throwCollectionException();
        this.preCalcSQLBuf = new StringBuffer();
        try {
            this.rhsBean = this.queryTree.getLastRDBMSBeanForPathExpressionWithNoSQLGen(this.rhsDealiasedEjbqlId);
        }
        catch (Exception exception) {
            this.term2.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        this.rhsInterface = QueryContext.getInterfaceClass(this.rhsBean);
        this.rhsInterfaceName = this.rhsInterface.getName();
        this.rhsPKFieldList = this.rhsBean.getPrimaryKeyFields();
        this.rhsLastTableName = this.rhsBean.getTableName();
        String string = ((ExprID)this.term2).getFirstField();
        if (!this.queryTree.isRangeVariableInScope(string)) {
            object2 = EJBLogger.logejbqlMissingRangeVariableDeclarationLoggable((String)string);
            object = new IllegalExpressionException(7, object2.getMessage());
            this.term2.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        if (this.lhsIsVariable) {
            try {
                this.globalContext.addFinderBeanInputParameter(((ExprVARIABLE)this.term1).getVariableNumber(), this.rhsBean);
            }
            catch (Exception exception) {
                this.term1.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
        } else {
            try {
                this.term1.calculate();
            }
            catch (Exception exception) {
                this.addCollectionException(exception);
            }
            this.throwCollectionException();
            try {
                this.lhsBean = this.queryTree.getLastRDBMSBeanForPathExpressionWithNoSQLGen(this.lhsFullDealiasedEjbqlId);
            }
            catch (Exception exception) {
                this.term1.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
            this.lhsInterface = QueryContext.getInterfaceClass(this.lhsBean);
            this.lhsInterfaceName = this.lhsInterface.getName();
            if (!this.lhsInterfaceName.equals(this.rhsInterfaceName)) {
                object2 = EJBLogger.logfinderMemberMismatchLoggable((String)this.lhsInterfaceName, (String)this.rhsInterfaceName);
                this.markExcAndThrowCollectionException(new Exception(object2.getMessage()));
            }
            if (this.lhsRelationshipType == 2 || this.lhsRelationshipType == 5) {
                object2 = null;
                try {
                    this.lhsExprIDForQuery = this.truncatedLhsExprID = this.globalContext.setupForLHSForeignKeysWithNoReferenceToRHS((ExprID)this.term1);
                    object2 = this.queryTree.getJoinNodeForLastId(this.truncatedLhsExprID.getDealiasedEjbqlID());
                    this.lhsPrevBean = ((JoinNode)object2).getRDBMSBean();
                    this.lhsPrevTableName = this.lhsPrevBean.getTableForCmrField(this.lhsLastPathExpressionElement);
                    this.lhsPrevTableAlias = ((JoinNode)object2).getFKTableAliasAndSQLForCmrf(this.lhsLastPathExpressionElement);
                }
                catch (Exception exception) {
                    this.term1.markExcAndAddCollectionException(exception);
                    this.addCollectionExceptionAndThrow(exception);
                }
            } else {
                try {
                    this.lhsExprIDForQuery = (ExprID)this.term1;
                    this.lhsExprIDForQuery.prepareIdentifierForSQLGen();
                }
                catch (Exception exception) {
                    this.term1.markExcAndAddCollectionException(exception);
                    this.addCollectionExceptionAndThrow(exception);
                }
            }
        }
        if (this.isMember) {
            if (this.lhsIsVariable) {
                this.compute_member_11_fk_on_rhs(this.preCalcSQLBuf);
                return;
            }
            switch (this.lhsRelationshipType) {
                case 2: 
                case 5: {
                    this.compute_member_11orN1_fk_on_lhs(this.preCalcSQLBuf);
                    return;
                }
                case 1: 
                case 3: {
                    this.compute_member_11_fk_on_rhs(this.preCalcSQLBuf);
                    return;
                }
            }
            object2 = new Exception("Internal Error,  [NOT] MEMBER [OF] cannot handle lhs relationship type number '" + this.lhsRelationshipType + "'  " + RDBMSUtils.relationshipTypeToString(this.lhsRelationshipType));
            this.term1.markExcAndAddCollectionException((Exception)object2);
            this.addCollectionExceptionAndThrow((Exception)object2);
        }
        if (!this.isMember) {
            this.setup_not_member();
            object2 = this.setup_rhs_local_subquery();
            object = ExprID.newInitExprID(this.globalContext, (QueryNode)object2, this.rhsDealiasedEjbqlId);
            if (this.rhsPKFieldList.size() == 1) {
                this.compute_not_member_rhs_simple_key(this.preCalcSQLBuf, (QueryNode)object2, (ExprID)object);
                return;
            }
            this.compute_not_member_rhs_compound_key(this.preCalcSQLBuf, (QueryNode)object2, (ExprID)object);
            return;
        }
    }

    private void compute_member_11orN1_fk_on_lhs(StringBuffer stringBuffer) throws ErrorCollectionException {
        Object object;
        JoinNode joinNode = null;
        String string = null;
        try {
            joinNode = this.queryTree.getJoinNodeForLastId(this.rhsDealiasedEjbqlId);
            string = joinNode.getTableAlias();
        }
        catch (Exception exception) {
            this.term2.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        Map map = this.lhsPrevBean.getColumnMapForCmrfAndPkTable(this.lhsLastPathExpressionElement, this.rhsLastTableName);
        if (map == null) {
            object = new Exception("Internal Error !  In MEMBER OF: Could not find Map of Foreign Keys to Primary Keys for Foreign Key Bean: '" + this.lhsPrevBean.getEjbName() + "', To Primary Key Table Name: '" + this.rhsLastTableName + "'");
            this.term2.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        object = map.keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            String string3 = (String)map.get(string2);
            stringBuffer.append(this.lhsPrevTableAlias).append(".").append(string2).append(" = ");
            stringBuffer.append(string).append(".").append(string3).append(" ");
            if (!object.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
    }

    private void compute_member_11_fk_on_rhs(StringBuffer stringBuffer) throws ErrorCollectionException {
        Iterator iterator = this.rhsPKFieldList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = "?";
            if (!this.lhsIsVariable) {
                string2 = ExprID.calcTableAndColumn(this.globalContext, this.queryTree, this.lhsFullDealiasedEjbqlId + "." + string);
            }
            stringBuffer.append(string2);
            stringBuffer.append(" = ");
            String string3 = ExprID.calcTableAndColumn(this.globalContext, this.queryTree, this.rhsDealiasedEjbqlId + "." + string);
            stringBuffer.append(string3);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        stringBuffer.append(" ");
    }

    private void setup_not_member() throws ErrorCollectionException {
        if (!this.lhsIsVariable && this.lhsExprIDForQuery.countPathNodes() > 1) {
            if (debugLogger.isDebugEnabled()) {
                ExprISMEMBER.debug(" doMember: LHS path node count for parsedLHSId: '" + this.lhsExprIDForQuery.getEjbqlID() + "'  = '" + this.lhsExprIDForQuery.countPathNodes() + "'");
            }
            String string = this.lhsExprIDForQuery.getDealiasedEjbqlID();
            boolean bl = false;
            boolean bl2 = false;
            String string2 = "";
            block9: for (SelectNode selectNode : this.queryTree.getSelectList()) {
                int n = selectNode.getSelectType();
                String string3 = selectNode.getSelectTarget();
                string3 = this.globalContext.replaceIdAliases(string3);
                JoinNode joinNode = null;
                try {
                    joinNode = this.queryTree.getJoinTreeForId(string3);
                    string3 = JoinNode.getPathWithoutTrailingCmpField(joinNode, string3);
                }
                catch (Exception exception) {
                    this.markExcAndThrowCollectionException(exception);
                }
                int n2 = JoinNode.comparePaths(string, string3);
                switch (n2) {
                    case -1: {
                        continue block9;
                    }
                    case 0: {
                        bl2 = true;
                        string2 = string3;
                        continue block9;
                    }
                    case 1: {
                        if (JoinNode.countPathNodes(string3) < JoinNode.countPathNodes(string)) {
                            if (JoinNode.countPathNodes(string3) <= JoinNode.countPathNodes(string2)) continue block9;
                            bl2 = true;
                            string2 = string3;
                            continue block9;
                        }
                        bl2 = true;
                        bl = true;
                        continue block9;
                    }
                }
                Exception exception = new Exception("Internal Error !  unknown return type from JoinNode.comparePaths encountered in NOT MEMBER OF calculation, while examining LHS: '" + ((ExprID)this.term1).getEjbqlID() + "' and SELECT id: '" + string3 + "'");
                this.term1.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
            if (!bl2) {
                SelectNode selectNode;
                selectNode = EJBLogger.logNotMemberOfLHSNotInSelectLoggable((String)((ExprID)this.term1).getEjbqlID());
                Exception exception = new Exception(selectNode.getMessage());
                this.term1.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
            if (!bl) {
                if (debugLogger.isDebugEnabled()) {
                    ExprISMEMBER.debug(" doMember: selectPathLongerThanParsedLHS, mark LeftOuter Joins  from: '" + string2 + "'  to  '" + string + "'");
                }
                try {
                    JoinNode.markDoLeftOuterJoins(this.lhsExprIDForQuery.getJoinTreeForID(), string2, string);
                }
                catch (Exception exception) {
                    this.term1.markExcAndAddCollectionException(exception);
                    this.addCollectionExceptionAndThrow(exception);
                }
            }
        }
    }

    private QueryNode setup_rhs_local_subquery() throws ErrorCollectionException {
        Object object;
        Object object2;
        Object object3;
        QueryNode queryNode = this.globalContext.newQueryNode(null, -1);
        JoinNode joinNode = queryNode.getJoinTree();
        RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
        RDBMSBean rDBMSBean2 = null;
        String string = null;
        String string2 = null;
        String string3 = rDBMSBean.getAbstractSchemaName();
        if (string3 == null) {
            object3 = EJBLogger.logFinderCouldNotGetAbstractSchemaNameForBeanLoggable((String)rDBMSBean.getEjbName());
            object2 = new Exception(object3.getMessage());
            this.term2.markExcAndAddCollectionException((Exception)object2);
            this.addCollectionExceptionAndThrow((Exception)object2);
        }
        object3 = ((ExprID)this.term2).getFirstField();
        object2 = null;
        try {
            object2 = this.globalContext.getGlobalRangeVariableMap((String)object3);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.term2.markExcAndAddCollectionException(illegalExpressionException);
            this.addCollectionExceptionAndThrow(illegalExpressionException);
        }
        if (((String)object2).equals(string3)) {
            rDBMSBean2 = rDBMSBean;
        } else {
            rDBMSBean2 = rDBMSBean.getRDBMSBeanForAbstractSchema((String)object2);
            if (null == rDBMSBean2) {
                object = EJBLogger.logFinderCouldNotGetRDBMSBeanForAbstractSchemaNameLoggable((String)object2);
                Exception exception = new Exception(object.getMessage());
                this.term2.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
        }
        string = rDBMSBean2.getTableName();
        string2 = this.globalContext.registerTable(string);
        object = new JoinNode(joinNode, (String)object3, rDBMSBean2, string, string2, -1, false, false, "", this.globalContext, new ArrayList());
        joinNode.putChild((String)object3, (JoinNode)object);
        try {
            queryNode.addRangeVariable((String)object3, (String)object2);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.term2.markExcAndAddCollectionException(illegalExpressionException);
            this.addCollectionExceptionAndThrow(illegalExpressionException);
        }
        return queryNode;
    }

    private void compute_not_member_rhs_simple_key(StringBuffer stringBuffer, QueryNode queryNode, ExprID exprID) throws ErrorCollectionException {
        Object object;
        Object object2;
        Iterator<Object> iterator = this.rhsPKFieldList.iterator();
        String string = (String)iterator.next();
        String string2 = ExprID.calcTableAndColumn(this.globalContext, queryNode, this.rhsDealiasedEjbqlId + "." + string);
        if (this.lhsRelationshipType == 2 || this.lhsRelationshipType == 5) {
            if (this.truncatedLhsExprID == null) {
                object2 = new Exception("Internal Error, in compute_not_member_rhs_simple_key truncatedLhsExprID is NULL.  It should NOT be.");
                this.term1.markExcAndAddCollectionException((Exception)object2);
                this.addCollectionExceptionAndThrow((Exception)object2);
            }
            if ((object2 = this.lhsPrevBean.getColumnMapForCmrfAndPkTable(this.lhsLastPathExpressionElement, this.rhsLastTableName)) == null) {
                object = new Exception("Internal Error !  In NOT MEMBER OF: Could not find Map of Foreign Keys to Primary Keys for Foreign Key Bean: '" + this.lhsPrevBean.getEjbName() + "', To Primary Key Table Name: '" + this.rhsLastTableName + "'");
                this.term1.markExcAndAddCollectionException((Exception)object);
                this.addCollectionExceptionAndThrow((Exception)object);
            }
            iterator = object2.keySet().iterator();
            object = (String)iterator.next();
            stringBuffer.append(this.lhsPrevTableAlias).append(".").append((String)object).append(" ");
        } else {
            iterator = this.rhsPKFieldList.iterator();
            string = (String)iterator.next();
            object2 = "?";
            if (!this.lhsIsVariable) {
                object2 = ExprID.calcTableAndColumn(this.globalContext, this.queryTree, this.lhsFullDealiasedEjbqlId + "." + string);
            }
            stringBuffer.append((String)object2).append(" ");
        }
        stringBuffer.append("NOT IN ");
        stringBuffer.append("(SELECT ");
        stringBuffer.append(string2).append(" ");
        stringBuffer.append("FROM ");
        object2 = new StringBuffer();
        try {
            stringBuffer.append(queryNode.getFROMDeclaration(0));
            ((StringBuffer)object2).append(queryNode.getMainJoinBuffer());
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
        if (this.lhsRhsShareRoot && ((String)(object = this.getSubQueryCorrelatedRootSQL(this.lhsExprIDForQuery.getDealiasedEjbqlID(), this.rhsDealiasedEjbqlId, this.queryTree, queryNode))).length() > 0) {
            if (((StringBuffer)object2).length() > 0) {
                ((StringBuffer)object2).append(" AND ");
            }
            ((StringBuffer)object2).append((String)object);
        }
        if (this.rhsSharesSelectRoot) {
            object = this.rhsSelectNodeMatch.getSelectTarget();
            JoinNode joinNode = null;
            try {
                joinNode = this.queryTree.getJoinTreeForId((String)object);
            }
            catch (Exception exception) {
                this.markExcAndThrowCollectionException(exception);
            }
            String string3 = this.getSubQueryCorrelatedRootSQL((String)object, this.rhsDealiasedEjbqlId, this.queryTree, queryNode);
            if (string3.length() > 0) {
                if (((StringBuffer)object2).length() > 0) {
                    ((StringBuffer)object2).append(" AND ");
                }
                ((StringBuffer)object2).append(string3);
            }
        }
        if (((StringBuffer)object2).length() > 0) {
            stringBuffer.append("WHERE ");
            stringBuffer.append((StringBuffer)object2);
        }
        stringBuffer.append(") ");
    }

    private void compute_not_member_rhs_compound_key(StringBuffer stringBuffer, QueryNode queryNode, ExprID exprID) throws ErrorCollectionException {
        String string;
        Object object;
        Object object2;
        Object object3;
        JoinNode joinNode = null;
        try {
            joinNode = queryNode.getJoinNodeForLastId(this.rhsDealiasedEjbqlId);
        }
        catch (Exception exception) {
            this.term2.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        String string2 = joinNode.getTableAlias();
        String string3 = joinNode.getTableName();
        stringBuffer.append("NOT ");
        stringBuffer.append("EXISTS ");
        stringBuffer.append("(SELECT ");
        if (this.lhsRelationshipType == 2 || this.lhsRelationshipType == 5) {
            object3 = this.lhsPrevBean.getColumnMapForCmrfAndPkTable(this.lhsLastPathExpressionElement, string3);
            if (object3 == null) {
                object2 = new Exception("Internal Error !  In NOT MEMBER OF: Could not find Map of Foreign Keys to Primary Keys for Foreign Key Bean: '" + this.lhsPrevBean.getEjbName() + "', To Primary Key Table Name: '" + this.rhsLastTableName + "'");
                this.term2.markExcAndAddCollectionException((Exception)object2);
                this.addCollectionExceptionAndThrow((Exception)object2);
            }
            object2 = object3.keySet().iterator();
            object = (String)object2.next();
            string = (String)object3.get(object);
            stringBuffer.append(string2).append(".").append(string).append(" ");
            stringBuffer.append("FROM ");
            try {
                stringBuffer.append(queryNode.getFROMDeclaration(0));
            }
            catch (Exception exception) {
                this.term2.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
            stringBuffer.append("WHERE ");
            stringBuffer.append(this.lhsPrevTableAlias).append(".").append((String)object);
            stringBuffer.append(" = ");
            stringBuffer.append(string2).append(".").append(string);
            while (object2.hasNext()) {
                stringBuffer.append(" AND ");
                object = (String)object2.next();
                string = (String)object3.get(object);
                stringBuffer.append(this.lhsPrevTableAlias).append(".").append((String)object);
                stringBuffer.append(" = ");
                stringBuffer.append(string2).append(".").append(string);
            }
            stringBuffer.append(" ");
        } else {
            object3 = this.rhsPKFieldList.iterator();
            object2 = (String)object3.next();
            object = ExprID.calcTableAndColumn(this.globalContext, queryNode, this.rhsDealiasedEjbqlId + "." + (String)object2);
            stringBuffer.append((String)object).append(" ");
            stringBuffer.append("FROM ");
            try {
                stringBuffer.append(queryNode.getFROMDeclaration(0));
            }
            catch (Exception exception) {
                this.markExcAndThrowCollectionException(exception);
            }
            stringBuffer.append("WHERE ");
            object3 = this.rhsPKFieldList.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                string = "?";
                if (!this.lhsIsVariable) {
                    string = ExprID.calcTableAndColumn(this.globalContext, this.queryTree, this.lhsFullDealiasedEjbqlId + "." + (String)object2);
                }
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                object = ExprID.calcTableAndColumn(this.globalContext, queryNode, this.rhsDealiasedEjbqlId + "." + (String)object2);
                stringBuffer.append((String)object);
                if (object3.hasNext()) {
                    stringBuffer.append(" AND ");
                    continue;
                }
                stringBuffer.append(" ");
            }
        }
        object3 = new StringBuffer();
        try {
            ((StringBuffer)object3).append(queryNode.getMainJoinBuffer());
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
        if (this.lhsRhsShareRoot && ((String)(object2 = this.getSubQueryCorrelatedRootSQL(this.lhsExprIDForQuery.getDealiasedEjbqlID(), this.rhsDealiasedEjbqlId, this.queryTree, queryNode))).length() > 0) {
            if (((StringBuffer)object3).length() > 0) {
                ((StringBuffer)object3).append(" AND ");
            }
            ((StringBuffer)object3).append((String)object2);
        }
        if (this.rhsSharesSelectRoot) {
            object2 = this.rhsSelectNodeMatch.getSelectTarget();
            object = null;
            try {
                object = this.queryTree.getJoinTreeForId((String)object2);
            }
            catch (Exception exception) {
                this.markExcAndThrowCollectionException(exception);
            }
            string = this.getSubQueryCorrelatedRootSQL((String)object2, this.rhsDealiasedEjbqlId, this.queryTree, queryNode);
            if (string.length() > 0) {
                if (((StringBuffer)object3).length() > 0) {
                    ((StringBuffer)object3).append(" AND ");
                }
                ((StringBuffer)object3).append(string);
            }
        }
        if (((StringBuffer)object3).length() > 0) {
            stringBuffer.append("AND ");
            stringBuffer.append((StringBuffer)object3);
        }
        stringBuffer.append(") ");
    }

    private String getSubQueryCorrelatedRootSQL(String string, String string2, QueryNode queryNode, QueryNode queryNode2) throws ErrorCollectionException {
        StringBuffer stringBuffer = new StringBuffer();
        JoinNode joinNode = queryNode.getJoinTree();
        String string3 = JoinNode.getFirstFieldFromId(string);
        String string4 = JoinNode.getFirstFieldFromId(string2);
        JoinNode joinNode2 = null;
        RDBMSBean rDBMSBean = null;
        try {
            joinNode2 = JoinNode.getFirstNode(joinNode, string);
            rDBMSBean = joinNode2.getRDBMSBean();
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
        List list = rDBMSBean.getPrimaryKeyFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            String string6 = ExprID.calcTableAndColumn(this.globalContext, queryNode, string3 + "." + string5);
            String string7 = ExprID.calcTableAndColumn(this.globalContext, queryNode2, string4 + "." + string5);
            stringBuffer.append(string6).append(" = ").append(string7);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        return stringBuffer.toString();
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        if (this.isMember) {
            ExprISMEMBER exprISMEMBER = new ExprISMEMBER(63, this.term1, (ExprID)this.term2, false);
            exprISMEMBER.setPreEJBQLFrom(this);
            exprISMEMBER.setMainEJBQL("IS NOT MEMBER ");
            exprISMEMBER.setPostEJBQLFrom(this);
            return exprISMEMBER;
        }
        ExprISMEMBER exprISMEMBER = new ExprISMEMBER(62, this.term1, (ExprID)this.term2, true);
        exprISMEMBER.setPreEJBQLFrom(this);
        exprISMEMBER.setMainEJBQL("IS MEMBER ");
        exprISMEMBER.setPostEJBQLFrom(this);
        return exprISMEMBER;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        if (this.term2 != null) {
            this.term2.appendEJBQLTokens(list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        if (this.preCalcSQLBuf == null) {
            throw new ErrorCollectionException("Internal Error !  ExprISMEMBER.toSQL  preCalcSQLBuf is null !");
        }
        return this.preCalcSQLBuf.toString();
    }

    private static void debug(String string) {
        debugLogger.debug("[ExprISMEMBER] " + string);
    }
}

