/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public class ExprISNULL
extends BaseExpr
implements Expr,
ExpressionTypes {
    private int relationshipType;
    private int argType;
    private int databaseType;
    private String ejbqlId;
    private String dealiasedEjbqlId;
    private String lastPathExpressionElement;
    protected boolean isNull = true;
    private StringBuffer preCalcSQLBuf = null;

    protected ExprISNULL(int n, Expr expr, boolean bl) {
        super(n, expr);
        this.isNull = bl;
        this.debugClassName = "ExprISNULL ";
    }

    public void init_method() throws ErrorCollectionException {
        Object object;
        Object object2;
        Object object3;
        ExprISNULL.requireTerm(this, 1);
        this.term1.init(this.globalContext, this.queryTree);
        this.argType = this.term1.type();
        this.databaseType = this.globalContext.getDatabaseType();
        if (this.argType != 17 && this.argType != 25) {
            object3 = this.term1.getMainEJBQL();
            if (object3 == null) {
                object3 = "-- unknown --";
            }
            object2 = EJBLogger.logISNULLArgMustBePathExpressionOrVariableLoggable((String)object3);
            object = new Exception(object2.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        if (this.argType == 17) {
            this.ejbqlId = this.term1.getSval();
            this.dealiasedEjbqlId = this.globalContext.replaceIdAliases(this.ejbqlId);
            try {
                this.relationshipType = ((ExprID)this.term1).getRelationshipTypeForPathExpressionWithNoSQLGen();
            }
            catch (Exception exception) {
                object2 = new Exception("Error encountered while compiling EJB QL IS [NOT] NULL, " + exception.toString());
                this.term1.markExcAndAddCollectionException((Exception)object2);
                this.addCollectionExceptionAndThrow((Exception)object2);
            }
            if (this.relationshipType == 4 || this.relationshipType == 6) {
                object3 = null;
                try {
                    object2 = this.queryTree.getJoinNodeForLastId(this.dealiasedEjbqlId);
                    object3 = ((JoinNode)object2).getPrevNode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object2 = " - unknown - ";
                this.lastPathExpressionElement = ((ExprID)this.term1).getLastField();
                if (object3 != null) {
                    object = ((JoinNode)object3).getRDBMSBean();
                    object2 = ((RDBMSBean)object).getEjbName();
                }
                object = RDBMSUtils.relationshipTypeToString(this.relationshipType);
                Loggable loggable = EJBLogger.logFinderNotNullOnWrongTypeLoggable((String)object2, (String)this.lastPathExpressionElement, (String)object);
                Exception exception = new Exception(loggable.getMessage());
                this.term1.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
            this.lastPathExpressionElement = ((ExprID)this.term1).getLastField();
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        this.preCalcSQLBuf = new StringBuffer();
        if (this.argType == 25) {
            this.term1.calculate();
            String string = this.term1.toSQL();
            this.preCalcSQLBuf.append(" " + string + " IS " + (this.isNull ? "" : "NOT ") + "NULL ");
            return;
        }
        switch (this.relationshipType) {
            case 0: {
                this.term1.calculate();
                ((ExprID)this.term1).prepareIdentifierForSQLGen();
                this.preCalcSQLBuf.append(this.term1.toSQL());
                if (this.isNull) {
                    this.preCalcSQLBuf.append("IS NULL ");
                } else {
                    this.preCalcSQLBuf.append("IS NOT NULL ");
                }
                return;
            }
            case 2: 
            case 5: {
                this.compute11orN1_fk_on_lhs(this.preCalcSQLBuf, ((ExprID)this.term1).getDealiasedEjbqlID());
                return;
            }
            case 3: {
                this.compute11_fk_on_rhs(this.preCalcSQLBuf, ((ExprID)this.term1).getDealiasedEjbqlID());
                return;
            }
            case 7: {
                this.compute_remote_interface(this.preCalcSQLBuf, ((ExprID)this.term1).getDealiasedEjbqlID());
                return;
            }
            case 8: {
                Exception exception = new Exception("Cannot compute IS [NOT] NULL on path expression '" + ((ExprID)this.term1).getDealiasedEjbqlID() + "' that terminates in a remote relationship that involves a join table.");
                this.term1.markExcAndAddCollectionException(exception);
                this.addCollectionExceptionAndThrow(exception);
            }
        }
        Exception exception = new Exception("Internal Error, IS [NOT] NULL cannot handle relationship type number '" + this.relationshipType + "'  " + RDBMSUtils.relationshipTypeToString(this.relationshipType));
        this.term1.markExcAndAddCollectionException(exception);
        this.addCollectionExceptionAndThrow(exception);
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        if (this.isNull) {
            ExprISNULL exprISNULL = new ExprISNULL(3, this.term1, false);
            exprISNULL.setPreEJBQLFrom(this);
            exprISNULL.setMainEJBQL("IS NOT NULL ");
            exprISNULL.setPostEJBQLFrom(this);
            return exprISNULL;
        }
        ExprISNULL exprISNULL = new ExprISNULL(3, this.term1, true);
        exprISNULL.setPreEJBQLFrom(this);
        exprISNULL.setMainEJBQL("IS NULL ");
        exprISNULL.setPostEJBQLFrom(this);
        return exprISNULL;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        return this.preCalcSQLBuf.toString();
    }

    private void compute11orN1_fk_on_lhs(StringBuffer stringBuffer, String string) throws ErrorCollectionException {
        JoinNode joinNode;
        ExprID exprID = null;
        List list = null;
        try {
            exprID = this.prepareTruncatedPathExpression(string);
            list = this.globalContext.getTableAndFKColumnListForLocal11or1NPath(this.queryTree, this.dealiasedEjbqlId);
        }
        catch (Exception exception) {
            this.term1.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuffer.append(string2);
                if (this.isNull) {
                    stringBuffer.append(" IS NULL ");
                } else {
                    stringBuffer.append(" IS NOT NULL ");
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append("AND ");
            }
            return;
        }
        String string3 = " - unknown - ";
        try {
            joinNode = this.queryTree.getJoinNodeForLastId(exprID.getDealiasedEjbqlID());
            string3 = joinNode.getRDBMSBean().getEjbName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        joinNode = EJBLogger.logfinderCouldNotGetFKColumnsLoggable((String)string3, (String)this.lastPathExpressionElement, (String)"IS NULL");
        Exception exception = new Exception("(1 to 1) or (1 to N) Relationship.  " + joinNode.getMessage());
        this.term1.markExcAndAddCollectionException(exception);
        this.addCollectionExceptionAndThrow(exception);
    }

    private void compute11_fk_on_rhs(StringBuffer stringBuffer, String string) throws ErrorCollectionException {
        Object object;
        List list;
        Object object2;
        Object object3;
        Object object4;
        ExprID exprID = null;
        try {
            exprID = this.prepareTruncatedPathExpression(string);
        }
        catch (Exception exception) {
            this.term1.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        String string2 = exprID.getDealiasedEjbqlID();
        RDBMSBean rDBMSBean = exprID.getRDBMSBeanWithSQLGen();
        JoinNode joinNode = null;
        try {
            joinNode = this.queryTree.getJoinNodeForLastId(string2);
        }
        catch (Exception exception) {
            object4 = new Exception("Error encountered while compiling EJB QL IS [NOT] NULL, " + exception.toString());
            this.term1.markExcAndAddCollectionException((Exception)object4);
            this.addCollectionExceptionAndThrow((Exception)object4);
        }
        String string3 = joinNode.getTableName();
        object4 = joinNode.getRDBMSBean().getEjbName();
        String string4 = joinNode.getTableAlias();
        RDBMSBean rDBMSBean2 = null;
        try {
            rDBMSBean2 = this.queryTree.getLastRDBMSBeanForPathExpressionWithNoSQLGen(string);
        }
        catch (Exception exception) {
            object3 = new Exception("Error encountered while compiling EJB QL IS [NOT] NULL, " + exception.toString());
            this.term1.markExcAndAddCollectionException((Exception)object3);
            this.addCollectionExceptionAndThrow((Exception)object3);
        }
        String string5 = rDBMSBean.getRelatedFieldName(this.lastPathExpressionElement);
        object3 = rDBMSBean2.getTableForCmrField(string5);
        if (object3 == null) {
            object2 = new Exception("Internal Error,  " + this.debugClassName + ": " + " for path: '" + string + "', for the cmr-field: '" + string5 + "', we could not get the name of the Table on Bean: '" + rDBMSBean2.getEjbName() + "' that holds the Foreign Key Columns for the Relationship.  " + "RelatedFieldName used for lookup was: '" + string5 + "'");
            this.term1.markExcAndAddCollectionException((Exception)object2);
            this.addCollectionExceptionAndThrow((Exception)object2);
        }
        object2 = this.globalContext.registerTable((String)object3);
        this.queryTree.addTableAliasExclusionList((String)object2);
        Map map = rDBMSBean2.getColumnMapForCmrfAndPkTable(string5, string3);
        Iterator iterator = map.keySet().iterator();
        if (!iterator.hasNext()) {
            list = EJBLogger.logfinderFKColumnsMissingLoggable((String)"IS [NOT] NULL", (String)string, (String)object3, (String)string3);
            object = new Exception(list.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        if ((list = rDBMSBean.getPrimaryKeyFields()).size() == 1) {
            object = this.globalContext.registerTable(string3);
            this.queryTree.addTableAliasExclusionList((String)object);
            String string6 = (String)iterator.next();
            String string7 = (String)map.get(string6);
            stringBuffer.append(string4).append(".");
            stringBuffer.append(RDBMSUtils.escQuotedID(string7));
            stringBuffer.append(" ");
            if (this.isNull) {
                stringBuffer.append("NOT ");
            }
            stringBuffer.append("IN ( SELECT ");
            stringBuffer.append((String)object).append(".").append(RDBMSUtils.escQuotedID(string7));
            stringBuffer.append(" FROM ");
            stringBuffer.append(RDBMSUtils.escQuotedID(string3)).append(" ").append((String)object);
            stringBuffer.append(", ");
            stringBuffer.append(RDBMSUtils.escQuotedID((String)object3)).append(" ").append((String)object2);
            stringBuffer.append(" ");
            stringBuffer.append("WHERE ");
            stringBuffer.append((String)object).append(".").append(RDBMSUtils.escQuotedID(string7));
            stringBuffer.append(" = ");
            stringBuffer.append((String)object2).append(".").append(RDBMSUtils.escQuotedID(string6));
            stringBuffer.append(") ");
            return;
        }
        stringBuffer.append(" ( 0 ");
        if (this.isNull) {
            stringBuffer.append(" = ");
        } else {
            stringBuffer.append(" < ");
        }
        stringBuffer.append("( ");
        stringBuffer.append("SELECT COUNT(*) ");
        stringBuffer.append("FROM ").append((String)object3).append(" ").append((String)object2).append(" ");
        stringBuffer.append("WHERE ");
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string8 = (String)map.get(object);
            stringBuffer.append(string4).append(".").append(string8);
            stringBuffer.append(" = ");
            stringBuffer.append((String)object2).append(".").append((String)object);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        stringBuffer.append(" ) ) ");
    }

    private void compute_remote_interface(StringBuffer stringBuffer, String string) throws ErrorCollectionException {
        Object object;
        Loggable loggable;
        this.term1.calculate();
        ((ExprID)this.term1).prepareIdentifierForSQLGen();
        List list = null;
        try {
            list = this.globalContext.getTableAndFKColumnListForLocal11or1NPath(this.queryTree, ((ExprID)this.term1).getDealiasedEjbqlID());
        }
        catch (Exception exception) {
            this.term1.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        if (list.size() != 1) {
            loggable = EJBLogger.logFinderExpectedSingleFKLoggable((String)"Remote Relationship", (String)((ExprID)this.term1).getDealiasedEjbqlID(), (String)Integer.toString(list.size()));
            object = new Exception(loggable.getMessage());
            this.term1.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        loggable = list.iterator();
        object = (String)loggable.next();
        stringBuffer.append((String)object);
        if (this.isNull) {
            stringBuffer.append(" IS NULL ");
        } else {
            stringBuffer.append(" IS NOT NULL ");
        }
    }

    private ExprID prepareTruncatedPathExpression(String string) throws ErrorCollectionException {
        Object object;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            object = EJBLogger.logFinderNotNullOnBadPathLoggable((String)string);
            this.markExcAndThrowCollectionException(new Exception(object.getMessage()));
        }
        object = string.substring(0, n);
        ExprID exprID = ExprID.newInitExprID(this.globalContext, this.queryTree, (String)object);
        exprID.prepareIdentifierForSQLGen();
        return exprID;
    }
}

