/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.utils.ToStringUtils;
import weblogic.ejb20.cmp.rdbms.finders.ExpressionParserException;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public class ExprLIKE
extends BaseExpr
implements Expr,
ExpressionTypes {
    private boolean hasEscape = false;
    private boolean notLike = false;

    protected ExprLIKE(int n, Expr expr, Expr expr2, Expr expr3, boolean bl) {
        super(n, expr, expr2, expr3);
        this.notLike = bl;
        this.debugClassName = "ExprLIKE ";
    }

    protected ExprLIKE(int n, Expr expr, Expr expr2, Expr expr3) {
        this(n, expr, expr2, expr3, false);
    }

    public void init_method() throws ErrorCollectionException {
        Loggable loggable;
        if (this.term1 == null) {
            loggable = EJBLogger.logLIKEmissingArgumentLoggable();
            this.markExcAndThrowCollectionException(new ExpressionParserException(loggable.getMessage()));
        }
        try {
            this.term1.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        if (this.term1 instanceof ExprID) {
            // empty if block
        }
        if (this.term2 == null) {
            loggable = EJBLogger.logLIKEmissingArgumentLoggable();
            this.markExcAndThrowCollectionException(new ExpressionParserException(loggable.getMessage()));
        }
        try {
            this.term2.init(this.globalContext, this.queryTree);
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        if (this.term3 != null) {
            this.hasEscape = true;
            try {
                this.term3.init(this.globalContext, this.queryTree);
            }
            catch (Exception exception) {
                this.addCollectionException(exception);
            }
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        try {
            if (this.term1 instanceof ExprID) {
                ((ExprID)this.term1).calcTableAndColumnForCmpField();
            } else {
                this.term1.calculate();
            }
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        try {
            this.term2.calculate();
        }
        catch (Exception exception) {
            this.addCollectionException(exception);
        }
        if (this.hasEscape) {
            try {
                this.term3.calculate();
            }
            catch (Exception exception) {
                this.addCollectionException(exception);
            }
        }
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        if (this.notLike) {
            ExprLIKE exprLIKE = new ExprLIKE(11, this.term1, this.term2, this.term3, false);
            exprLIKE.setPreEJBQLFrom(this);
            exprLIKE.setMainEJBQL("LIKE ");
            exprLIKE.setPostEJBQLFrom(this);
            return exprLIKE;
        }
        ExprLIKE exprLIKE = new ExprLIKE(11, this.term1, this.term2, this.term3, true);
        exprLIKE.setPreEJBQLFrom(this);
        exprLIKE.setMainEJBQL("NOT LIKE ");
        exprLIKE.setPostEJBQLFrom(this);
        return exprLIKE;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        if (this.term2 != null) {
            this.term2.appendEJBQLTokens(list);
        }
        if (this.term3 != null) {
            this.term3.appendEJBQLTokens(list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        this.clearSQLBuf();
        if (this.notLike) {
            this.appendSQLBuf("NOT ( ");
        }
        this.appendSQLBuf("( ");
        this.appendSQLBuf(this.term1.toSQL());
        this.appendSQLBuf("LIKE ");
        String string = this.term2.toSQL();
        String string2 = "";
        if (this.hasEscape && (string2 = this.term3.toSQL()) != null && string2.length() > 0 && string2.equals("'\\'")) {
            if (this.term2.type() == 18) {
                string = ToStringUtils.escapeBackSlash(string);
            }
            string2 = "'\\\\'";
        }
        this.appendSQLBuf(string);
        this.appendSQLBuf(" ");
        if (string2.length() > 0) {
            this.appendSQLBuf("ESCAPE ");
            this.appendSQLBuf(string2);
            this.appendSQLBuf(" ");
        }
        this.appendSQLBuf(") ");
        if (this.notLike) {
            this.appendSQLBuf(") ");
        }
        return this.getSQLBuf().toString();
    }
}

