/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprAND;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.ORJoinData;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.utils.ErrorCollectionException;

public class ExprOR
extends BaseExpr
implements Expr,
ExpressionTypes {
    private ORJoinData orDataTerm1 = null;
    private ORJoinData orDataTerm2 = null;
    private List orJoinDataList = null;

    protected ExprOR(int n, Expr expr, Expr expr2) {
        super(n, expr, expr2);
        this.debugClassName = "ExprOR  ";
    }

    public void init_method() throws ErrorCollectionException {
        ExprOR.requireTerm(this, 1);
        ExprOR.requireTerm(this, 2);
        if (this.orJoinDataList != null) {
            this.queryTree.addORJoinDataListList(this.orJoinDataList);
        }
        try {
            this.orDataTerm1 = this.init_OR_term(this.globalContext, this.queryTree, this.term1);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            this.orDataTerm2 = this.init_OR_term(this.globalContext, this.queryTree, this.term2);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        try {
            this.calculate_OR_term(this.term1, this.orDataTerm1);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            this.calculate_OR_term(this.term2, this.orDataTerm2);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        ExprAND exprAND = new ExprAND(0, this.term1, this.term2);
        exprAND.setPreEJBQLFrom(this);
        exprAND.setMainEJBQL("AND ");
        exprAND.setPostEJBQLFrom(this);
        return exprAND;
    }

    private ORJoinData init_OR_term(QueryContext queryContext, QueryNode queryNode, Expr expr) throws ErrorCollectionException {
        queryNode.pushOR(expr);
        try {
            expr.init(queryContext, queryNode);
        }
        catch (ErrorCollectionException errorCollectionException) {
            queryNode.popOR();
            throw errorCollectionException;
        }
        ORJoinData oRJoinData = queryNode.popOR();
        if (!(expr instanceof ExprOR)) {
            this.orJoinDataList.add(oRJoinData);
        }
        return oRJoinData;
    }

    private void calculate_OR_term(Expr expr, ORJoinData oRJoinData) throws ErrorCollectionException {
        this.queryTree.pushOR(oRJoinData);
        try {
            expr.calculate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.queryTree.popOR();
            throw errorCollectionException;
        }
        this.queryTree.popOR();
    }

    private void toSQL_OR_term(Expr expr, ORJoinData oRJoinData) throws ErrorCollectionException {
        String string = null;
        this.queryTree.pushOR(oRJoinData);
        try {
            this.appendSQLBuf("(");
            this.appendSQLBuf(expr.toSQL());
            string = this.queryTree.getCurrentORJoinBuffer();
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.queryTree.popOR();
            expr.markExcAndAddCollectionException(illegalExpressionException);
            this.addCollectionExceptionAndThrow(illegalExpressionException);
        }
        if (string.length() > 0) {
            this.appendSQLBuf(" AND ");
            this.appendSQLBuf(string);
        }
        this.appendSQLBuf(") ");
        this.queryTree.popOR();
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        this.appendMainEJBQLTokenToList(list);
        if (this.term2 != null) {
            this.term2.appendEJBQLTokens(list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        this.clearSQLBuf();
        this.toSQL_OR_term(this.term1, this.orDataTerm1);
        this.appendSQLBuf(" OR ");
        this.toSQL_OR_term(this.term2, this.orDataTerm2);
        return this.getSQLBuf().toString();
    }

    void setOrJoinDataList(List list) {
        this.orJoinDataList = list;
    }
}

