/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public class ExprORDERBY
extends BaseExpr
implements Expr,
ExpressionTypes {
    private boolean isResultSetFinder = false;
    private boolean hasIntegerArgument = false;
    private List selectList = null;
    private StringBuffer select_clause_buffer;
    private StringBuffer where_clause_buffer;

    protected ExprORDERBY(int n, Expr expr, Vector vector) {
        super(n, expr, vector);
        this.debugClassName = "ExprORDERBY ";
    }

    public void init_method() throws ErrorCollectionException {
        this.isResultSetFinder = this.globalContext.isResultSetFinder();
        this.selectList = this.queryTree.getSelectList();
        Enumeration enumeration = this.terms.elements();
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            try {
                expr.init(this.globalContext, this.queryTree);
            }
            catch (Exception exception) {
                expr.markExcAndAddCollectionException(exception);
                this.addCollectionException(exception);
            }
            if (expr.getTerm1().type() == 70 || expr.getTerm1().type() == 71) {
                expr = expr.getTerm1();
            }
            if (expr.getTerm1().type() != 19) continue;
            this.hasIntegerArgument = true;
            if (this.isResultSetFinder) continue;
            int n = (int)expr.getTerm1().getIval();
            String string = Integer.toString(n);
            Loggable loggable = EJBLogger.lognonResultSetFinderHasIntegerOrderByOrGroupByArgLoggable((String)"ORDERBY", (String)string);
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            expr.getTerm1().markExcAndThrowCollectionException(illegalExpressionException);
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        this.where_clause_buffer = new StringBuffer();
        if (!this.isResultSetFinder) {
            this.select_clause_buffer = new StringBuffer();
        }
        Enumeration enumeration = this.terms.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Expr expr = (Expr)enumeration.nextElement();
            Object object2 = expr;
            if (object2.getTerm1().type() == 70 || object2.getTerm1().type() == 71) {
                object2 = object2.getTerm1();
            }
            if (object2.getTerm1().type() == 19) {
                int n = (int)object2.getTerm1().getIval();
                object = Integer.toString(n);
                if (this.selectList.size() < n) {
                    Loggable loggable = EJBLogger.logintegerOrderByOrGroupByArgExceedsSelectListSizeLoggable((String)"ORDERBY", (String)object, (int)this.selectList.size());
                    IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
                    object2.getTerm1().markExcAndAddCollectionException(illegalExpressionException);
                    this.addCollectionException(illegalExpressionException);
                    continue;
                }
                this.where_clause_buffer.append(" ").append(expr.getTerm1().toSQL());
                this.hasIntegerArgument = true;
            } else if (object2.getTerm1() instanceof ExprID) {
                if (!((ExprID)object2.getTerm1()).isPathExpressionEndingInCmpFieldWithNoSQLGen()) {
                    Loggable loggable = EJBLogger.logejbqlArgNotACmpFieldLoggable((String)"ORDERBY", (String)object2.getTerm1().getSval());
                    object = new IllegalExpressionException(7, loggable.getMessage());
                    object2.getTerm1().markExcAndAddCollectionException((Exception)object);
                    this.addCollectionException((Exception)object);
                    continue;
                }
                if (((ExprID)object2.getTerm1()).isPathExpressionEndingInBlobClobColumnWithSQLGen()) {
                    Loggable loggable = EJBLogger.logcannotSpecifyBlobClobInOrderbyLoggable((String)((ExprID)object2.getTerm1()).getEjbqlID());
                    object = new IllegalExpressionException(7, loggable.getMessage());
                    object2.getTerm1().markExcAndAddCollectionException((Exception)object);
                    this.addCollectionException((Exception)object);
                    continue;
                }
                String string = expr.getTerm1().toSQL();
                this.where_clause_buffer.append(string);
                if (!this.isResultSetFinder) {
                    this.select_clause_buffer.append(string);
                }
            } else {
                throw new AssertionError((Object)"unexpected codepath");
            }
            if (expr.getTerm2() != null) {
                if (expr.getTerm2().type() == 67) {
                    this.where_clause_buffer.append(" DESC ");
                } else if (expr.getTerm2().type() == 66) {
                    this.where_clause_buffer.append(" ASC ");
                }
            }
            if (!enumeration.hasMoreElements()) continue;
            this.where_clause_buffer.append(", ");
            if (this.isResultSetFinder) continue;
            this.select_clause_buffer.append(", ");
        }
        if (this.hasIntegerArgument) {
            for (Object object2 : this.selectList) {
                if (((SelectNode)object2).getSelectType() != 61) continue;
                Loggable loggable = EJBLogger.logejbqlClauseNotAllowedInResultSetQueriesReturningBeansLoggable((String)"ORDERBY");
                this.markExcAndThrowCollectionException(new IllegalExpressionException(7, loggable.getMessage()));
            }
        }
        this.where_clause_buffer.append(" ");
        if (!this.isResultSetFinder) {
            this.select_clause_buffer.append(" ");
        }
        if (!this.isResultSetFinder) {
            this.globalContext.setOrderbyColBuf(this.select_clause_buffer.toString());
        }
        this.globalContext.setOrderbySql(" ORDER BY " + this.where_clause_buffer.toString() + " ");
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        this.appendMainEJBQLTokenToList(list);
        Enumeration enumeration = this.terms.elements();
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            expr.appendEJBQLTokens(list);
            if (!enumeration.hasMoreElements()) continue;
            this.appendNewEJBQLTokenToList(", ", list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        return "";
    }
}

