/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprFROM;
import weblogic.ejb.container.cmp.rdbms.finders.ExprGROUPBY;
import weblogic.ejb.container.cmp.rdbms.finders.ExprORDERBY;
import weblogic.ejb.container.cmp.rdbms.finders.ExprSELECT;
import weblogic.ejb.container.cmp.rdbms.finders.ExprSELECT_HINT;
import weblogic.ejb.container.cmp.rdbms.finders.ExprSUBQUERY;
import weblogic.ejb.container.cmp.rdbms.finders.ExprWHERE;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLToken;
import weblogic.utils.ErrorCollectionException;

public final class ExprROOT
extends BaseExpr
implements Expr,
ExpressionTypes {
    private ExprSELECT exprSELECT;
    private ExprFROM exprFROM;
    private ExprWHERE exprWHERE;
    private ExprORDERBY exprORDERBY;
    private ExprGROUPBY exprGROUPBY;
    private ExprSELECT_HINT exprSELECT_HINT;
    private List ejbqlTokenList = null;

    protected ExprROOT(int n, Expr expr) {
        super(n, expr);
        this.debugClassName = "ExprRoot";
    }

    protected ExprROOT(int n, Expr expr, Expr expr2) {
        super(n, expr, expr2);
        this.debugClassName = "ExprRoot";
    }

    protected ExprROOT(int n, Expr expr, Expr expr2, Expr expr3) {
        super(n, expr, expr2, expr3);
        this.debugClassName = "ExprRoot";
    }

    protected ExprROOT(int n, Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        super(n, expr, expr2, expr3, expr4);
        this.debugClassName = "ExprRoot";
    }

    protected ExprROOT(int n, Expr expr, Expr expr2, Expr expr3, Expr expr4, Expr expr5) {
        super(n, expr, expr2, expr3, expr4, expr5);
        this.debugClassName = "ExprRoot";
    }

    public void init_method() throws ErrorCollectionException {
        this.setExprVars();
        this.exprFROM.init(this.globalContext, this.queryTree);
        try {
            this.exprSELECT.init(this.globalContext, this.queryTree);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprWHERE != null) {
                this.exprWHERE.init(this.globalContext, this.queryTree);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprORDERBY != null) {
                this.exprORDERBY.init(this.globalContext, this.queryTree);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprGROUPBY != null) {
                this.exprGROUPBY.init(this.globalContext, this.queryTree);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprSELECT_HINT != null) {
                this.exprSELECT_HINT.init(this.globalContext, this.queryTree);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        try {
            this.exprSELECT.calculate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        this.exprFROM.calculate();
        try {
            if (this.exprWHERE != null) {
                this.exprWHERE.calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprORDERBY != null) {
                this.exprORDERBY.calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprGROUPBY != null) {
                this.exprGROUPBY.calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            if (this.exprSELECT_HINT != null) {
                this.exprSELECT_HINT.calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public void appendEJBQLTokens(List list) {
        this.resetTermNumber();
        while (this.hasMoreTerms()) {
            Expr expr = this.getNextTerm();
            expr.appendEJBQLTokens(list);
        }
    }

    public List getEJBQLTokenList() {
        this.ejbqlTokenList = new ArrayList();
        this.appendEJBQLTokens(this.ejbqlTokenList);
        return this.ejbqlTokenList;
    }

    protected String getEJBQLText() {
        List list = this.getEJBQLTokenList();
        StringBuffer stringBuffer = new StringBuffer();
        for (EJBQLToken eJBQLToken : list) {
            stringBuffer.append(eJBQLToken.getTokenText());
        }
        return stringBuffer.toString();
    }

    public String toSQL(Properties properties) {
        return "";
    }

    private void setExprVars() throws ErrorCollectionException {
        Object object;
        int n = this.numTerms();
        int n2 = 0;
        if (n > 0) {
            if (this.term1.type() != 34) {
                object = EJBLogger.logSelectClauseRequiredLoggable();
                this.term1.markExcAndThrowCollectionException(new IllegalExpressionException(7, object.getMessage()));
            }
            this.exprSELECT = (ExprSELECT)this.term1;
            ++n2;
            if (n < 2) {
                object = EJBLogger.logFromClauseRequiredLoggable();
                this.term1.markExcAndThrowCollectionException(new IllegalExpressionException(7, object.getMessage()));
            }
        }
        if (this.term2.type() != 27) {
            object = EJBLogger.logFromClauseRequiredLoggable();
            this.term2.markExcAndThrowCollectionException(new IllegalExpressionException(7, object.getMessage()));
        }
        this.exprFROM = (ExprFROM)this.term2;
        ++n2;
        this.setNextTerm(3);
        block6: while (this.hasMoreTerms()) {
            object = this.getNextTerm();
            switch (object.type()) {
                case 26: {
                    this.exprWHERE = (ExprWHERE)object;
                    continue block6;
                }
                case 36: {
                    this.exprORDERBY = (ExprORDERBY)object;
                    continue block6;
                }
                case 68: {
                    this.exprGROUPBY = (ExprGROUPBY)object;
                    continue block6;
                }
                case 60: {
                    this.exprSELECT_HINT = (ExprSELECT_HINT)object;
                    continue block6;
                }
            }
            this.markExcAndThrowCollectionException(new IllegalExpressionException(7, " unknown expr type: '" + object.type() + "' '" + BaseExpr.getTypeName(object.type()) + "' "));
        }
    }

    public String getWhereSql() throws ErrorCollectionException {
        if (this.exprWHERE == null) {
            return "";
        }
        return this.exprWHERE.toSQL();
    }

    ExprWHERE getExprWHERE() {
        return this.exprWHERE;
    }

    List getWHEREList() {
        ArrayList<ExprWHERE> arrayList = new ArrayList<ExprWHERE>();
        ExprWHERE exprWHERE = this.getWHEREchildFromParent(this);
        if (exprWHERE == null) {
            return arrayList;
        }
        if (debugLogger.isDebugEnabled()) {
            ExprROOT.debug("\n\nadding main WHERE clause to whereExprList");
        }
        arrayList.add(exprWHERE);
        this.addWHEREfromSUBQUERYs(arrayList, exprWHERE);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addWHEREfromSUBQUERYs(List list, Expr expr) {
        Object object;
        if (expr instanceof ExprSUBQUERY) {
            ExprWHERE exprWHERE;
            if (debugLogger.isDebugEnabled()) {
                ExprROOT.debug("addWHEREfromSUBQUERYs, found SUBQUERY");
            }
            if ((exprWHERE = this.getWHEREchildFromParent(expr)) == null) {
                if (!debugLogger.isDebugEnabled()) return;
                ExprROOT.debug("addWHEREfromSUBQUERYs   SUBQUERY has no WHERE clause terminate searching.");
                return;
            }
            if (debugLogger.isDebugEnabled()) {
                ExprROOT.debug("addWHEREfromSUBQUERYs  found SUBQUERY WHERE adding.");
            }
            list.add(exprWHERE);
            this.addWHEREfromSUBQUERYs(list, exprWHERE);
            return;
        }
        if (expr.numTerms() == 0) {
            if (!debugLogger.isDebugEnabled()) return;
            ExprROOT.debug("addWHEREfromSUBQUERYs,  term NOT SUBQUERY, no subterms, exiting.");
            return;
        }
        expr.resetTermNumber();
        while (expr.hasMoreTerms() && (object = expr.getNextTerm()) != null) {
            this.addWHEREfromSUBQUERYs(list, (Expr)object);
        }
        if (expr.termVectSize() <= 0) return;
        object = expr.getTermVector();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            Expr expr2 = (Expr)enumeration.nextElement();
            if (expr2 == null) {
                return;
            }
            this.addWHEREfromSUBQUERYs(list, expr2);
        }
    }

    private ExprWHERE getWHEREchildFromParent(Expr expr) {
        expr.resetTermNumber();
        while (expr.hasMoreTerms()) {
            Expr expr2 = expr.getNextTerm();
            if (!(expr2 instanceof ExprWHERE)) continue;
            return (ExprWHERE)expr2;
        }
        return null;
    }

    private static void debug(String string) {
        debugLogger.debug("[ExprROOT] " + string);
    }
}

