/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RelationshipCaching;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprAGGREGATE;
import weblogic.ejb.container.cmp.rdbms.finders.ExprCASE;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public final class ExprSELECT
extends BaseExpr
implements Expr,
ExpressionTypes {
    private boolean processSelectListForInitializationDone = false;
    private List completeSelectList = null;

    protected ExprSELECT(int n, Expr expr, Vector vector) {
        super(n, expr, vector);
        this.debugClassName = "ExprSELECT";
    }

    public void init_method() throws ErrorCollectionException {
        this.setMainQuerySelectDistinct();
        this.setMainQueryResultSetFinder();
        this.createEjbQLSelectList();
        this.createRelationshipCachingList();
        this.processSelectListForInitialization();
        this.processSelectPathsEndingInCmrFields();
        this.mainQueryResultSetFinderCheck();
    }

    public void calculate_method() throws ErrorCollectionException {
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        this.appendMainEJBQLTokenToList(list);
        if (this.term1 != null) {
            this.term1.appendEJBQLTokens(list);
        }
        Enumeration enumeration = this.terms.elements();
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            expr.appendEJBQLTokens(list);
            if (!enumeration.hasMoreElements()) continue;
            this.appendNewEJBQLTokenToList(", ", list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL(Properties properties) {
        return "";
    }

    private void setMainQuerySelectDistinct() throws ErrorCollectionException {
        if (!this.queryTree.isMainQuery()) {
            return;
        }
        if (this.term1.type() == 51) {
            this.globalContext.setMainQuerySelectDistinct();
        }
    }

    private void setMainQueryResultSet() throws ErrorCollectionException {
        if (!this.queryTree.isMainQuery()) {
            return;
        }
        if (this.globalContext.isResultSetFinder()) {
            this.globalContext.setMainQueryResultSetFinder();
        }
    }

    private void createEjbQLSelectList() throws ErrorCollectionException {
        boolean bl = false;
        Vector vector = this.terms;
        if (vector.size() < 1) {
            Loggable loggable = EJBLogger.logExpressionRequiresXLoggable((String)"SELECT", (String)"target");
            Object object = new IllegalExpressionException(7, loggable.getMessage());
            this.markExcAndThrowCollectionException((Exception)object);
        }
        for (Object object : vector) {
            Object object2;
            SelectNode selectNode;
            block10: {
                Object object3;
                object.init(this.globalContext, this.queryTree);
                selectNode = new SelectNode();
                this.queryTree.addSelectList(selectNode);
                selectNode.setSelectItemBaseExpr((Expr)object);
                if (debugLogger.isDebugEnabled()) {
                    ExprSELECT.debug(" create Select list item for: '" + TYPE_NAMES[object.type()] + "'");
                }
                if (object instanceof ExprAGGREGATE) {
                    selectNode.setIsAggregate(true);
                    if (object.getTerm2() != null) {
                        object.getTerm2().init(this.globalContext, this.queryTree);
                        if (object.getTerm2().type() == 51) {
                            selectNode.setIsAggregateDistinct(true);
                        }
                    }
                }
                if (object instanceof ExprCASE && !(object.getTerm1() instanceof ExprID)) {
                    object2 = EJBLogger.logejbqlSelectCaseMustBePathExpressionLoggable((String)this.globalContext.getEjbName(), (String)object.getTerm1().getMainEJBQL());
                    object3 = new IllegalExpressionException(7, object2.getMessage());
                    object.getTerm1().markExcAndThrowCollectionException((Exception)object3);
                }
                selectNode.setSelectType(object.type());
                selectNode.setSelectTypeName(ExpressionTypes.TYPE_NAMES[object.type()]);
                object2 = "";
                object3 = null;
                try {
                    object3 = BaseExpr.getExprIDFromSingleExprIDHolder((Expr)object);
                    ((BaseExpr)object3).init(this.globalContext, this.queryTree);
                    object2 = ((ExprID)object3).getEjbqlID();
                    if (debugLogger.isDebugEnabled()) {
                        ExprSELECT.debug(" got from ExprID: '" + (String)object2 + "'");
                    }
                    if (!(object instanceof ExprAGGREGATE)) break block10;
                    ((ExprAGGREGATE)object).validate();
                }
                catch (Exception exception) {
                    this.markExcAndAddCollectionException(exception);
                    continue;
                }
            }
            selectNode.setSelectTarget((String)object2);
        }
        this.throwCollectionException();
    }

    private void processSelectListForInitialization() throws ErrorCollectionException {
        boolean bl = false;
        List list = this.getCompleteSelectList();
        for (SelectNode selectNode : list) {
            Expr expr = selectNode.getSelectItemBaseExpr();
            if (debugLogger.isDebugEnabled()) {
                ExprSELECT.debug("  processSelectListForInitialization  Expr: '" + TYPE_NAMES[expr.type()] + "'");
            }
            try {
                IllegalExpressionException illegalExpressionException;
                Loggable loggable;
                int n;
                ExprID exprID = BaseExpr.getExprIDFromSingleExprIDHolder(expr);
                exprID.init(this.globalContext, this.queryTree);
                String string = exprID.getEjbqlID();
                if (expr.type() == 61 && (n = exprID.countPathNodes()) == 1 && !this.queryTree.containsCollectionMember(string) && this.queryTree.getRangeVariableMap(string) == null) {
                    loggable = EJBLogger.logejbqlSelectObjectMustBeRangeOrCollectionIdLoggable((String)string);
                    illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
                    exprID.markExcAndThrowCollectionException(illegalExpressionException);
                }
                if (expr.type() == 17 && (n = exprID.countPathNodes()) < 2) {
                    if (this.queryTree.thisQueryNodeOwnsId(string)) {
                        loggable = EJBLogger.logejbqlSELECTmustUseOBJECTargumentLoggable((String)string);
                        illegalExpressionException = new IllegalExpressionException(6, loggable.getMessage());
                        this.globalContext.addWarning(illegalExpressionException);
                    } else {
                        loggable = EJBLogger.logInvalidEJBQLSELECTExpressionLoggable((String)string);
                        illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
                        exprID.markExcAndThrowCollectionException(illegalExpressionException);
                    }
                }
                if (debugLogger.isDebugEnabled()) {
                    ExprSELECT.debug("  about to  exprID.prepareIdentifierForSQLGen()  Expr: '" + TYPE_NAMES[exprID.type()] + "' val: '" + exprID.getEjbqlID() + "'");
                }
                exprID.prepareIdentifierForSQLGen();
                if (this.globalContext.identifierIsRangeVariable(string)) {
                    if (debugLogger.isDebugEnabled()) {
                        ExprSELECT.debug("  '" + string + "' is Range Variable");
                    }
                    if (selectNode.getIsAggregate() || selectNode.getIsAggregateDistinct()) {
                        Expr expr2 = selectNode.getSelectItemBaseExpr();
                        if (expr2.type() != 48) continue;
                        this.initializeCountRangeVariable(selectNode, exprID);
                        continue;
                    }
                    this.initializeRangeVariable(selectNode, exprID);
                    continue;
                }
                if (exprID.isPathExpressionEndingInCmpFieldWithNoSQLGen()) {
                    this.initializeCmpField(selectNode, exprID);
                    continue;
                }
                if (selectNode.getIsAggregate() || selectNode.getIsAggregateDistinct()) {
                    Expr expr3 = selectNode.getSelectItemBaseExpr();
                    if (expr3.type() != 48) continue;
                    this.initializeCountCmrField(selectNode, exprID);
                    continue;
                }
                this.initializeCmrField(selectNode, exprID);
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.addCollectionException((Exception)((Object)errorCollectionException));
            }
        }
        this.processSelectListForInitializationDone = true;
        this.throwCollectionException();
    }

    private void processSelectPathsEndingInCmrFields() throws ErrorCollectionException {
        if (!this.processSelectListForInitializationDone) {
            throw new AssertionError((Object)" processSelectsOnPathsEndingInCmrFields() can  only be called after processSelectListForInitialization() has completed. \n The globalContext \n   QueryIsFinderLocalBean or \n   QueryIsSelectLocalBean \n information must be determined by processSelectListForInitialization()  first before calling processSelectsOnPathsEndingInCmrFields()");
        }
        if (!this.queryTree.isMainQuery()) {
            return;
        }
        if (!(this.globalContext.getQueryIsSelectThisBean() || this.globalContext.getQueryIsSelectLocalBean() || this.globalContext.getQueryIsFinderLocalBean())) {
            return;
        }
        List list = this.getCompleteSelectList();
        if (list.size() > 1) {
            return;
        }
        Iterator iterator = list.iterator();
        SelectNode selectNode = (SelectNode)iterator.next();
        Expr expr = selectNode.getSelectItemBaseExpr();
        ExprID exprID = BaseExpr.getExprIDFromSingleExprIDHolder(expr);
        String string = exprID.getDealiasedEjbqlID();
        int n = exprID.countPathNodes();
        if (n <= 1) {
            return;
        }
        int n2 = n - 1;
        String string2 = JoinNode.getFirstNFieldsFromId(string, n2);
        String string3 = string;
        JoinNode joinNode = this.queryTree.getJoinTree();
        try {
            JoinNode.markDoLeftOuterJoins(joinNode, string2, string3);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            Loggable loggable = EJBLogger.logMayNotComplyWithEJB21_11_2_7_1_mustReturnAnyNullBeansLoggable((String)string);
            IllegalExpressionException illegalExpressionException2 = new IllegalExpressionException(6, loggable.getMessage());
            this.globalContext.addWarning(illegalExpressionException2);
        }
    }

    private void initializeCountRangeVariable(SelectNode selectNode, ExprID exprID) throws ErrorCollectionException {
        String string = exprID.getEjbqlID();
        assert (string.indexOf(".") == -1) : "Attempt to call initializeCountRangeVariable on a path expression with more than 1 path member '" + string + "'";
        JoinNode joinNode = this.getRangeVariableJoinNode(exprID);
        RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
        List list = rDBMSBean.getPrimaryKeyFields();
        String string2 = (String)list.get(0);
        string = string + "." + string2;
        if (debugLogger.isDebugEnabled()) {
            ExprSELECT.debug("  COUNT new argument is: '" + string + "'");
        }
        exprID.setEjbqlID(string);
        exprID.init(this.globalContext, this.queryTree);
        exprID.prepareIdentifierForSQLGen();
        this.initializeCmpField(selectNode, exprID);
    }

    private void initializeRangeVariable(SelectNode selectNode, ExprID exprID) throws ErrorCollectionException {
        JoinNode joinNode = this.getRangeVariableJoinNode(exprID);
        selectNode.setDbmsTarget(joinNode.getTableAlias());
        RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
        selectNode.setSelectBean(rDBMSBean);
        int n = 61;
        selectNode.setSelectType(n);
        selectNode.setSelectTypeName(ExpressionTypes.TYPE_NAMES[n]);
        if (this.globalContext.queryIsSelect() || this.globalContext.queryIsSelectInEntity()) {
            if (rDBMSBean.getEjbName().equals(this.globalContext.getRDBMSBean().getEjbName())) {
                if (this.queryTree.isMainQuery()) {
                    this.globalContext.setQueryIsSelectThisBean();
                }
                this.queryTree.setQueryType(2);
            } else {
                if (this.queryTree.isMainQuery()) {
                    this.globalContext.setQueryIsSelectLocalBean();
                }
                this.queryTree.setQueryType(4);
            }
            if (this.queryTree.isMainQuery()) {
                this.globalContext.setQuerySelectBeanTarget(rDBMSBean);
            }
        }
    }

    private void initializeCmpField(SelectNode selectNode, ExprID exprID) throws ErrorCollectionException {
        Object object;
        String string;
        String string2 = exprID.getEjbqlID();
        if (debugLogger.isDebugEnabled()) {
            ExprSELECT.debug("  EJB QL SELECT CLAUSE: " + string2 + "  is a field");
        }
        if (selectNode.getSelectType() == 61) {
            string = EJBLogger.logejbqlSelectObjectMustBeIdentificationVarNotCMPFieldLoggable((String)exprID.getEjbqlID());
            object = new IllegalExpressionException(7, string.getMessage());
            exprID.markExcAndAddCollectionException((Exception)object);
            this.addCollectionExceptionAndThrow((Exception)object);
        }
        string = exprID.calcTableAndColumnForCmpField();
        if (debugLogger.isDebugEnabled()) {
            ExprSELECT.debug("  SELECT Table and Field : " + string);
        }
        if (this.queryTree.isMainQuery()) {
            this.globalContext.setQuerySelectFieldTableAndColumn(string);
        }
        selectNode.setDbmsTarget(string);
        object = exprID.getJoinNodeForLastCmrFieldWithSQLGen();
        RDBMSBean rDBMSBean = ((JoinNode)object).getRDBMSBean();
        selectNode.setSelectBean(rDBMSBean);
        String string3 = exprID.getLastField();
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getFieldClass(string3);
        if (clazz == null) {
            Loggable loggable = EJBLogger.logFinderCouldNotGetClassForIdBeanLoggable((String)"SELECT", (String)string3, (String)exprID.getEjbqlID(), (String)rDBMSBean.getEjbName());
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            exprID.markExcAndAddCollectionException(illegalExpressionException);
            this.addCollectionExceptionAndThrow(illegalExpressionException);
        }
        if (this.queryTree.isMainQuery()) {
            this.globalContext.setQuerySelectBeanTarget(rDBMSBean);
            this.globalContext.setQuerySelectFieldClass(clazz);
        }
        selectNode.setSelectClass(clazz);
        if (string2.indexOf(".") == -1) {
            this.queryTree.setQueryType(3);
            if (this.queryTree.isMainQuery()) {
                this.globalContext.setQueryIsSelectThisBeanField();
            }
        } else {
            this.queryTree.setQueryType(5);
            if (this.queryTree.isMainQuery()) {
                this.globalContext.setQueryIsSelectLocalBeanField();
            }
        }
    }

    private void initializeCountCmrField(SelectNode selectNode, ExprID exprID) throws ErrorCollectionException {
        String string = exprID.getEjbqlID();
        assert (string.indexOf(".") != -1) : "Attempt to call initializeCountCmrField on a path expression with only 1 path member '" + string + "'";
        JoinNode joinNode = null;
        try {
            joinNode = exprID.getJoinNodeForLastCmrFieldWithSQLGen();
        }
        catch (Exception exception) {
            exprID.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
        List list = rDBMSBean.getPrimaryKeyFields();
        String string2 = (String)list.get(0);
        string = string + "." + string2;
        if (debugLogger.isDebugEnabled()) {
            ExprSELECT.debug("  COUNT new argument is: '" + string + "'");
        }
        exprID.setEjbqlID(string);
        exprID.init(this.globalContext, this.queryTree);
        exprID.prepareIdentifierForSQLGen();
        this.initializeCmpField(selectNode, exprID);
    }

    private void initializeCmrField(SelectNode selectNode, ExprID exprID) throws ErrorCollectionException {
        if (debugLogger.isDebugEnabled()) {
            ExprSELECT.debug("  EJB QL SELECT CLAUSE: " + exprID.getEjbqlID() + "  is not a field, it must be a Bean");
        }
        int n = 61;
        selectNode.setSelectType(n);
        selectNode.setSelectTypeName(ExpressionTypes.TYPE_NAMES[n]);
        JoinNode joinNode = null;
        try {
            joinNode = exprID.getJoinNodeForLastCmrFieldWithSQLGen();
        }
        catch (Exception exception) {
            exprID.markExcAndAddCollectionException(exception);
            this.addCollectionExceptionAndThrow(exception);
        }
        RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
        if (this.queryTree.isMainQuery()) {
            this.globalContext.setQuerySelectBeanTarget(rDBMSBean);
        }
        selectNode.setSelectBean(rDBMSBean);
        selectNode.setDbmsTarget(joinNode.getTableAlias());
        if (!this.globalContext.queryIsSelect() && !this.globalContext.queryIsSelectInEntity()) {
            Object object;
            Object object2;
            List list;
            if (this.queryTree.isMainQuery() && !rDBMSBean.getEjbName().equals(this.globalContext.getRDBMSBean().getEjbName()) && !this.queryTree.containsInSelectListForCachingElement(selectNode)) {
                list = EJBLogger.logFinderSelectWrongBeanLoggable((String)this.globalContext.getFinderMethodName(), (String)this.globalContext.getRDBMSBean().getEjbName(), (String)rDBMSBean.getEjbName());
                object2 = new IllegalExpressionException(7, list.getMessage());
                exprID.markExcAndAddCollectionException((Exception)object2);
                this.addCollectionExceptionAndThrow((Exception)object2);
            }
            this.queryTree.setQueryType(0);
            if (this.queryTree.isMainQuery()) {
                this.globalContext.setQueryIsFinderLocalBean();
            }
            if (debugLogger.isDebugEnabled()) {
                ExprSELECT.debug("  EJB QL FINDER LOCAL BEAN set to " + rDBMSBean.getEjbName());
            }
            list = null;
            try {
                object2 = this.queryTree.getJoinTree();
                list = JoinNode.getTableAliasListFromChildren((JoinNode)object2);
            }
            catch (RDBMSException rDBMSException) {
                object = EJBLogger.logFinderCouldNotGetXForYLoggable((String)"Table Alias List", (String)"Join Children", (String)rDBMSException.getMessage());
                IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, object.getMessage());
                exprID.markExcAndAddCollectionException(illegalExpressionException);
                this.addCollectionExceptionAndThrow(illegalExpressionException);
            }
            int n2 = 0;
            object = "WL0";
            for (String string : list) {
                if (string == null || !string.equals(object)) continue;
                ++n2;
            }
            if (n2 == 0) {
                this.queryTree.addTableAliasExclusionList((String)object);
            }
        } else {
            this.queryTree.setQueryType(4);
            if (this.queryTree.isMainQuery()) {
                this.globalContext.setQueryIsSelectLocalBean();
            }
            if (debugLogger.isDebugEnabled()) {
                ExprSELECT.debug("  EJB QL SELECT LOCAL BEAN set to " + rDBMSBean.getEjbName());
            }
        }
    }

    private JoinNode getRangeVariableJoinNode(ExprID exprID) throws ErrorCollectionException {
        exprID.prepareIdentifierForSQLGen();
        String string = exprID.getEjbqlID();
        JoinNode joinNode = null;
        try {
            joinNode = this.queryTree.getJoinNodeForFirstId(string);
        }
        catch (Exception exception) {
            exprID.markExcAndThrowCollectionException(exception);
        }
        if (joinNode == null) {
            Loggable loggable = EJBLogger.logFinderSelectTargetNoJoinNodeLoggable((String)string);
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            exprID.markExcAndAddCollectionException(illegalExpressionException);
            this.addCollectionExceptionAndThrow(illegalExpressionException);
        }
        return joinNode;
    }

    private void setMainQueryResultSetFinder() {
        if (this.queryTree.isMainQuery() && this.globalContext.isResultSetFinder()) {
            this.globalContext.setMainQueryResultSetFinder();
        }
    }

    private void mainQueryResultSetFinderCheck() throws ErrorCollectionException {
        if (this.queryTree.isMainQuery() && this.globalContext.isResultSetFinder()) {
            List list = this.queryTree.getSelectList();
            for (SelectNode selectNode : list) {
                if (selectNode.getSelectType() != 61) continue;
                Loggable loggable = EJBLogger.logejbqlResultSetFinderCannotSelectBeansLoggable((String)selectNode.getSelectTarget(), (String)selectNode.getSelectTypeName());
                IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
                this.markExcAndThrowCollectionException(illegalExpressionException);
            }
        }
    }

    private List getCompleteSelectList() {
        if (this.completeSelectList != null) {
            return this.completeSelectList;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.queryTree.getSelectList());
        arrayList.addAll(this.queryTree.getSelectListForCachingElement());
        return arrayList;
    }

    private void createRelationshipCachingList() throws ErrorCollectionException {
        if (!this.queryTree.isMainQuery()) {
            return;
        }
        String string = this.globalContext.getRelationshipCachingName();
        if (string == null) {
            return;
        }
        this.parseRelationshipCaching(this.globalContext.getRDBMSBean(), string);
    }

    public void parseRelationshipCaching(RDBMSBean rDBMSBean, String string) throws ErrorCollectionException {
        Loggable loggable;
        RelationshipCaching relationshipCaching = rDBMSBean.getRelationshipCaching(string);
        if (relationshipCaching == null) {
            return;
        }
        SelectNode selectNode = (SelectNode)this.queryTree.getSelectList().get(0);
        if (selectNode.getSelectType() != 61) {
            loggable = EJBLogger.logrelationshipCachingCannotEnableIfSelectTypeIsNotObjectLoggable((String)rDBMSBean.getEjbName(), (String)this.globalContext.getFinderMethodName());
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            this.markExcAndThrowCollectionException(illegalExpressionException);
        }
        loggable = relationshipCaching.getCachingElements().iterator();
        this.parseCachingElements(rDBMSBean, (Iterator)loggable, selectNode.getSelectTarget());
    }

    private void parseCachingElements(RDBMSBean rDBMSBean, Iterator iterator, String string) throws ErrorCollectionException {
        try {
            while (iterator.hasNext()) {
                RelationshipCaching.CachingElement cachingElement = (RelationshipCaching.CachingElement)iterator.next();
                String string2 = cachingElement.getCmrField();
                String string3 = cachingElement.getGroupName();
                RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string2);
                SelectNode selectNode = new SelectNode();
                String string4 = string + "." + string2;
                selectNode.setSelectTarget(string4);
                selectNode.setSelectBean(rDBMSBean2);
                selectNode.setCachingElementGroupName(string3);
                selectNode.setPrevBean(rDBMSBean);
                ExprID exprID = new ExprID(17, string4);
                exprID.init(this.globalContext, this.queryTree);
                selectNode.setSelectItemBaseExpr(exprID);
                this.queryTree.addSelectListForCachingElement(selectNode);
                Iterator iterator2 = cachingElement.getCachingElements().iterator();
                if (!iterator2.hasNext()) continue;
                this.parseCachingElements(rDBMSBean2, iterator2, string + "." + string2);
            }
        }
        catch (Exception exception) {
            this.markExcAndThrowCollectionException(exception);
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[ExprSELECT] " + string);
    }
}

