/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.List;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprEXISTS;
import weblogic.ejb.container.cmp.rdbms.finders.ExprFROM;
import weblogic.ejb.container.cmp.rdbms.finders.ExprGROUPBY;
import weblogic.ejb.container.cmp.rdbms.finders.ExprINTEGER;
import weblogic.ejb.container.cmp.rdbms.finders.ExprSELECT;
import weblogic.ejb.container.cmp.rdbms.finders.ExprSIMPLE_QUALIFIER;
import weblogic.ejb.container.cmp.rdbms.finders.ExprWHERE;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public final class ExprSUBQUERY
extends BaseExpr
implements Expr,
ExpressionTypes {
    private int subqueryNumber = 0;
    private int queryTermCount = 0;
    private boolean hasQualifier = false;
    private boolean hasExistsQualifier = false;
    private String subqueryQualifier = null;
    private QueryNode subqueryTree = null;
    private ExprSIMPLE_QUALIFIER exprSIMPLE_QUALIFIER;
    private ExprEXISTS exprEXISTS;
    private ExprSELECT exprSELECT;
    private ExprFROM exprFROM;
    private ExprWHERE exprWHERE;
    private ExprGROUPBY exprGROUPBY;

    protected ExprSUBQUERY(int n, ExprINTEGER exprINTEGER, Expr expr) {
        super(n, (Expr)exprINTEGER, expr);
        this.queryTermCount = 1;
        this.debugClassName = "ExprSUBQUERY";
    }

    protected ExprSUBQUERY(int n, ExprINTEGER exprINTEGER, Expr expr, Expr expr2) {
        super(n, exprINTEGER, expr, expr2);
        this.queryTermCount = 2;
        this.debugClassName = "ExprSUBQUERY";
    }

    protected ExprSUBQUERY(int n, ExprINTEGER exprINTEGER, Expr expr, Expr expr2, Expr expr3) {
        super(n, exprINTEGER, expr, expr2, expr3);
        this.queryTermCount = 3;
        this.debugClassName = "ExprSUBQUERY";
    }

    protected ExprSUBQUERY(int n, ExprINTEGER exprINTEGER, Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        super(n, exprINTEGER, expr, expr2, expr3, expr4);
        this.queryTermCount = 4;
        this.debugClassName = "ExprSUBQUERY";
    }

    protected ExprSUBQUERY(int n, ExprINTEGER exprINTEGER, Expr expr, Expr expr2, Expr expr3, Expr expr4, Expr expr5) {
        super(n, exprINTEGER, expr, expr2, expr3, expr4, expr5);
        this.queryTermCount = 5;
        this.debugClassName = "ExprSUBQUERY";
    }

    public void init_method() throws ErrorCollectionException {
        try {
            this.setExprVars();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionExceptionAndThrow((Exception)((Object)errorCollectionException));
        }
        this.subqueryTree = this.globalContext.newQueryNode(this.queryTree, this.subqueryNumber);
        this.exprFROM.init(this.globalContext, this.subqueryTree);
        try {
            this.exprSELECT.init(this.globalContext, this.subqueryTree);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        if (this.exprWHERE != null) {
            try {
                this.exprWHERE.init(this.globalContext, this.subqueryTree);
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.addCollectionException((Exception)((Object)errorCollectionException));
            }
        }
        try {
            if (this.exprGROUPBY != null) {
                this.exprGROUPBY.init(this.globalContext, this.subqueryTree);
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
    }

    public void calculate_method() throws ErrorCollectionException {
        try {
            this.exprSELECT.calculate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        try {
            this.exprFROM.calculate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
        if (this.exprWHERE != null) {
            try {
                this.exprWHERE.calculate();
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.addCollectionException((Exception)((Object)errorCollectionException));
            }
        }
        try {
            if (this.exprGROUPBY != null) {
                this.exprGROUPBY.calculate();
            }
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionException((Exception)((Object)errorCollectionException));
        }
    }

    protected Expr invertForNOT() throws ErrorCollectionException {
        return this;
    }

    public void appendEJBQLTokens(List list) {
        this.appendPreEJBQLTokensToList(list);
        if (this.term2 != null) {
            this.term2.appendEJBQLTokens(list);
        }
        if (this.term3 != null) {
            this.term3.appendEJBQLTokens(list);
        }
        if (this.term4 != null) {
            this.term4.appendEJBQLTokens(list);
        }
        if (this.term5 != null) {
            this.term5.appendEJBQLTokens(list);
        }
        if (this.term6 != null) {
            this.term6.appendEJBQLTokens(list);
        }
        this.appendPostEJBQLTokensToList(list);
    }

    public String toSQL() throws ErrorCollectionException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasQualifier) {
            stringBuffer.append(this.subqueryQualifier).append(" ");
        }
        if (this.hasExistsQualifier) {
            stringBuffer.append(this.exprEXISTS.toSQL());
        }
        try {
            stringBuffer.append("( ");
            this.toSQLselect(stringBuffer);
            this.toSQLfrom(stringBuffer);
            this.toSQLwhere(stringBuffer);
            this.toSQLgroupby(stringBuffer);
            stringBuffer.append(") ");
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.addCollectionExceptionAndThrow((Exception)((Object)errorCollectionException));
        }
        return stringBuffer.toString();
    }

    private void setExprVars() throws ErrorCollectionException {
        IllegalExpressionException illegalExpressionException;
        Loggable loggable;
        String string;
        int n = this.numTerms();
        this.resetTermNumber();
        Expr expr = this.getNextTerm();
        if (expr.type() != 19) {
            string = "SUBQUERY INTEGER";
            loggable = EJBLogger.logejbqlSubQueryMissingClauseLoggable((String)string);
            illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            expr.markExcAndThrowCollectionException(illegalExpressionException);
        }
        this.subqueryNumber = (int)expr.getIval();
        expr = this.getNextTerm();
        if (expr.type() == 65) {
            this.hasExistsQualifier = true;
            this.exprEXISTS = (ExprEXISTS)expr;
            this.subqueryQualifier = " <ExprSUBQUERY: NOTSET> ";
            this.exprEXISTS = (ExprEXISTS)expr;
            expr = this.getNextTerm();
        } else if (expr.type() == 49) {
            this.hasQualifier = true;
            this.subqueryQualifier = "ALL";
            this.exprSIMPLE_QUALIFIER = (ExprSIMPLE_QUALIFIER)expr;
            expr = this.getNextTerm();
        } else if (expr.type() == 64) {
            this.hasQualifier = true;
            this.subqueryQualifier = "ANY";
            this.exprSIMPLE_QUALIFIER = (ExprSIMPLE_QUALIFIER)expr;
            expr = this.getNextTerm();
        }
        if (expr.type() != 34) {
            string = "SELECT";
            loggable = EJBLogger.logejbqlSubQueryMissingClauseLoggable((String)string);
            illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            expr.markExcAndThrowCollectionException(illegalExpressionException);
        }
        this.exprSELECT = (ExprSELECT)expr;
        expr = this.getNextTerm();
        if (expr.type() != 27) {
            string = "FROM";
            loggable = EJBLogger.logejbqlSubQueryMissingClauseLoggable((String)string);
            illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            expr.markExcAndThrowCollectionException(illegalExpressionException);
        }
        this.exprFROM = (ExprFROM)expr;
        if (n > this.getCurrTermNumber()) {
            expr = this.getNextTerm();
            this.exprWHERE = (ExprWHERE)expr;
        }
        if (n > this.getCurrTermNumber()) {
            expr = this.getNextTerm();
            this.exprGROUPBY = (ExprGROUPBY)expr;
        }
    }

    private void toSQLselect(StringBuffer stringBuffer) throws ErrorCollectionException {
        stringBuffer.append("SELECT ");
        List list = this.subqueryTree.getSelectList();
        if (list.size() > 1) {
            Loggable loggable = EJBLogger.logejbqlSubQuerySelectCanOnlyHaveOneItemLoggable();
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, loggable.getMessage());
            throw new ErrorCollectionException((Throwable)illegalExpressionException);
        }
        SelectNode selectNode = (SelectNode)list.get(0);
        if (selectNode.getIsAggregate()) {
            stringBuffer.append(selectNode.getSelectTypeName());
            stringBuffer.append("(");
            if (selectNode.getIsAggregateDistinct()) {
                stringBuffer.append("DISTINCT ");
            }
            stringBuffer.append(selectNode.getDbmsTarget()).append(" ");
            stringBuffer.append(") ");
        } else if (selectNode.getSelectType() == 17) {
            stringBuffer.append(selectNode.getDbmsTarget()).append(" ");
        } else if (selectNode.getSelectType() == 61) {
            String string = selectNode.getDbmsTarget();
            RDBMSBean rDBMSBean = selectNode.getSelectBean();
            List list2 = rDBMSBean.getPrimaryKeyFields();
            String string2 = (String)list2.get(0);
            String string3 = rDBMSBean.getCmpColumnForField(string2);
            stringBuffer.append(" ").append(string).append(".").append(string3).append(" ");
        } else {
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, " SELECT clause of a SubQuery has a SELECT target type: " + ExpressionTypes.TYPE_NAMES[selectNode.getSelectType()] + ".  This type is not supported as a SubQuery SELECT target. ");
            throw new ErrorCollectionException((Throwable)illegalExpressionException);
        }
    }

    private void toSQLfrom(StringBuffer stringBuffer) throws ErrorCollectionException {
        stringBuffer.append("FROM ");
        try {
            stringBuffer.append(this.subqueryTree.getFROMDeclaration(0));
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
    }

    private void toSQLwhere(StringBuffer stringBuffer) throws ErrorCollectionException {
        if (this.exprWHERE == null) {
            try {
                String string = this.subqueryTree.getMainORJoinBuffer();
                if (string.length() > 0) {
                    stringBuffer.append("WHERE ");
                    stringBuffer.append(string);
                }
            }
            catch (Exception exception) {
                throw new ErrorCollectionException((Throwable)exception);
            }
            return;
        }
        try {
            stringBuffer.append(this.exprWHERE.toSQL());
            String string = this.subqueryTree.getMainORJoinBuffer();
            if (string.length() > 0) {
                stringBuffer.append("AND ").append(string);
            }
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
    }

    ExprWHERE getExprWHERE() {
        return this.exprWHERE;
    }

    private void toSQLgroupby(StringBuffer stringBuffer) throws ErrorCollectionException {
        try {
            if (this.exprGROUPBY != null) {
                stringBuffer.append(this.exprGROUPBY.toSQL());
            }
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
    }
}

