/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.Enumeration;
import java.util.Vector;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.cmp.rdbms.finders.ExpressionTypes;

public final class Expression
implements ExpressionTypes {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    public int type;
    public Expression term1 = null;
    public Expression term2 = null;
    public Expression term3 = null;
    public Expression term4 = null;
    public Expression term5 = null;
    public Expression term6 = null;
    public Vector terms = null;
    private long ival;
    private double fval;
    private String sval;
    public int termCount;
    private int termVectorSize = 0;
    private int nextTerm = 1;

    public Expression(int n) {
        this.type = n;
        this.termCount = 0;
    }

    protected Expression(int n, Expression expression) {
        this.type = n;
        this.term1 = expression;
        this.termCount = 1;
    }

    protected Expression(int n, Expression expression, Expression expression2) {
        this.type = n;
        this.term1 = expression;
        this.term2 = expression2;
        this.termCount = 2;
    }

    protected Expression(int n, Expression expression, Expression expression2, Expression expression3) {
        this.type = n;
        this.term1 = expression;
        this.term2 = expression2;
        this.term3 = expression3;
        this.termCount = 3;
    }

    protected Expression(int n, Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        this.type = n;
        this.term1 = expression;
        this.term2 = expression2;
        this.term3 = expression3;
        this.term4 = expression4;
        this.termCount = 4;
    }

    protected Expression(int n, Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5) {
        this.type = n;
        this.term1 = expression;
        this.term2 = expression2;
        this.term3 = expression3;
        this.term4 = expression4;
        this.term5 = expression5;
        this.termCount = 5;
    }

    protected Expression(int n, Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Expression expression6) {
        this.type = n;
        this.term1 = expression;
        this.term2 = expression2;
        this.term3 = expression3;
        this.term4 = expression4;
        this.term5 = expression5;
        this.term6 = expression6;
        this.termCount = 6;
    }

    protected Expression(int n, Expression expression, Vector vector) {
        this.type = n;
        this.term1 = expression;
        this.terms = vector;
        this.termVectorSize = vector.size();
        this.termCount = 1 + this.termVectorSize;
    }

    protected Expression(int n, String string) {
        this.type = n;
        this.sval = n == 18 ? string.substring(1, string.length() - 1) : string;
        if (n == 19) {
            this.sval = string;
            this.ival = Double.valueOf(string).intValue();
        } else if (n == 20) {
            this.fval = Double.valueOf(string);
            this.sval = string;
        } else if (n == 25) {
            this.sval = string;
            this.ival = Integer.valueOf(string).intValue();
        } else if (n == 53) {
            this.sval = string;
        }
    }

    public int type() {
        return this.type;
    }

    public int numTerms() {
        return this.termCount + this.termVectorSize;
    }

    public int termVectSize() {
        return this.termVectorSize;
    }

    public void resetTermNumber() {
        this.nextTerm = 1;
    }

    public void setNextTerm(int n) {
        this.nextTerm = n;
    }

    public Expression getNextTerm() {
        return this.getTerm(this.nextTerm++);
    }

    public Expression getTerm(int n) {
        switch (n) {
            case 1: {
                return this.term1;
            }
            case 2: {
                return this.term2;
            }
            case 3: {
                return this.term3;
            }
            case 4: {
                return this.term4;
            }
            case 5: {
                return this.term5;
            }
            case 6: {
                return this.term6;
            }
        }
        return null;
    }

    public int getCurrTermNumber() {
        return this.nextTerm - 1;
    }

    public boolean hasMoreTerms() {
        return this.nextTerm <= this.termCount;
    }

    public String getSval() {
        return this.sval;
    }

    public void setSval(String string) {
        this.sval = string;
    }

    public long getIval() {
        return this.ival;
    }

    public double getFval() {
        return this.fval;
    }

    public static int numType(String string) {
        if (string.indexOf(46) == -1 && string.indexOf(69) == -1) {
            return 19;
        }
        return 20;
    }

    public static int finderStringOrId(String string) {
        if (string.startsWith("@@")) {
            return 40;
        }
        int n = string.indexOf(">>");
        if (n == -1) {
            return 17;
        }
        if (string.indexOf("find", n) != -1) {
            return 35;
        }
        return 17;
    }

    public static String getEjbNameFromFinderString(String string) {
        int n = string.indexOf(">>");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getSelectCast(String string) {
        if (string.length() < 3) {
            return "";
        }
        if (40 != Expression.finderStringOrId(string)) {
            return "";
        }
        return string.substring(2);
    }

    public static Expression getExpressionFromTerms(Expression expression, int n) {
        expression.resetTermNumber();
        while (expression.hasMoreTerms()) {
            Expression expression2 = expression.getNextTerm();
            if (expression2.type != n) continue;
            return expression2;
        }
        return null;
    }

    public static Expression getAggregateExpressionFromSubQuerySelect(Expression expression) {
        if (expression.type != 43) {
            return null;
        }
        Expression expression2 = null;
        expression.resetTermNumber();
        while (expression.hasMoreTerms()) {
            expression2 = expression.getNextTerm();
            if (expression2.type == 34) break;
            expression2 = null;
        }
        if (expression2 == null) {
            return null;
        }
        if (expression2.term2 == null) {
            return null;
        }
        if (expression2.term2.type == 44 || expression2.term2.type == 45 || expression2.term2.type == 46 || expression2.term2.type == 47 || expression2.term2.type == 48) {
            return expression2.term2;
        }
        return null;
    }

    public String toString() {
        String string = this.toVal();
        return TYPE_NAMES[this.type] + ": " + (string == null ? this.term1 + "," + this.term2 : string);
    }

    private String toVal() {
        switch (this.type()) {
            case 17: 
            case 18: 
            case 25: 
            case 40: {
                return this.getSval();
            }
            case 19: {
                return this.getIval() + "";
            }
            case 20: {
                return this.getFval() + "";
            }
        }
        return null;
    }

    public void dump() {
        Expression.dump(this, 0);
    }

    private static void dump(Expression expression, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("| ");
        }
        System.out.print(TYPE_NAMES[expression.type()]);
        switch (expression.type()) {
            case 17: 
            case 25: 
            case 35: 
            case 40: 
            case 53: 
            case 61: 
            case 62: {
                System.out.println(" -- " + expression.getSval());
                break;
            }
            case 18: {
                System.out.println(" -- \"" + expression.getSval() + "\"");
                break;
            }
            case 19: {
                System.out.println(" -- " + expression.getIval());
                break;
            }
            case 20: {
                System.out.println(" -- " + expression.getFval());
                break;
            }
            case 16: {
                System.out.println("-- NULL");
                break;
            }
            default: {
                System.out.println();
            }
        }
        if (expression.term1 != null) {
            Expression.dump(expression.term1, n + 1);
        }
        if (expression.term2 != null) {
            Expression.dump(expression.term2, n + 1);
        }
        if (expression.term3 != null) {
            Expression.dump(expression.term3, n + 1);
        }
        if (expression.term4 != null) {
            Expression.dump(expression.term4, n + 1);
        }
        if (expression.term5 != null) {
            Expression.dump(expression.term5, n + 1);
        }
        if (expression.term6 != null) {
            Expression.dump(expression.term6, n + 1);
        }
        if (expression.terms != null) {
            Enumeration enumeration = expression.terms.elements();
            while (enumeration.hasMoreElements()) {
                Expression.dump((Expression)enumeration.nextElement(), n + 1);
            }
        }
    }

    public static Expression find(Expression expression, int n) {
        if (debugLogger.isDebugEnabled()) {
            Expression.debug("Checking NODE: " + TYPE_NAMES[expression.type()] + "  for type: " + TYPE_NAMES[n]);
        }
        if (expression.type() == n) {
            return expression;
        }
        Expression expression2 = null;
        if (expression.term1 != null && (expression2 = Expression.find(expression.term1, n)) != null) {
            return expression2;
        }
        if (expression.term2 != null && (expression2 = Expression.find(expression.term2, n)) != null) {
            return expression2;
        }
        if (expression.term3 != null && (expression2 = Expression.find(expression.term3, n)) != null) {
            return expression2;
        }
        if (expression.term4 != null && (expression2 = Expression.find(expression.term4, n)) != null) {
            return expression2;
        }
        if (expression.term5 != null && (expression2 = Expression.find(expression.term5, n)) != null) {
            return expression2;
        }
        if (expression.terms != null) {
            Enumeration enumeration = expression.terms.elements();
            while (enumeration.hasMoreElements()) {
                expression2 = Expression.find((Expression)enumeration.nextElement(), n);
                if (expression2 == null) continue;
                return expression2;
            }
        }
        return null;
    }

    public static String findIdForVariable(Expression expression, int n) {
        if (expression.type() == 5 && expression.term2 != null && expression.term2.type() == 25 && expression.term2.getIval() == (long)n && expression.term1 != null && expression.term1.type() == 17) {
            if (debugLogger.isDebugEnabled()) {
                Expression.debug(" VARIABLE NODE: " + expression.term2.getIval() + ".  returning ID: " + expression.term1.getSval());
            }
            return expression.term1.getSval();
        }
        String string = null;
        if (expression.term1 != null && (string = Expression.findIdForVariable(expression.term1, n)) != null) {
            return string;
        }
        if (expression.term2 != null && (string = Expression.findIdForVariable(expression.term2, n)) != null) {
            return string;
        }
        if (expression.term3 != null && (string = Expression.findIdForVariable(expression.term3, n)) != null) {
            return string;
        }
        if (expression.term4 != null && (string = Expression.findIdForVariable(expression.term4, n)) != null) {
            return string;
        }
        if (expression.term5 != null && (string = Expression.findIdForVariable(expression.term5, n)) != null) {
            return string;
        }
        if (expression.term6 != null && (string = Expression.findIdForVariable(expression.term6, n)) != null) {
            return string;
        }
        if (expression.terms != null) {
            Enumeration enumeration = expression.terms.elements();
            while (enumeration.hasMoreElements()) {
                string = Expression.findIdForVariable((Expression)enumeration.nextElement(), n);
                if (string == null) continue;
                return string;
            }
        }
        return string;
    }

    private static void debug(String string) {
        debugLogger.debug("[Expression] " + string);
    }
}

