/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.cache.QueryCacheKey;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.cmp.rdbms.finders.RDBMSFinder;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.Log;
import weblogic.ejb.container.internal.QueryCachingHandler;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb20.cmp.rdbms.finders.InvalidFinderException;
import weblogic.utils.AssertionError;

public abstract class Finder {
    protected static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    public static final int IS_FINDER_LOCAL_BEAN = 0;
    public static final int IS_SELECT_THIS_BEAN = 2;
    public static final int IS_SELECT_THIS_BEAN_FIELD = 3;
    public static final int IS_SELECT_LOCAL_BEAN = 4;
    public static final int IS_SELECT_LOCAL_BEAN_FIELD = 5;
    public static final int IS_SELECT_RESULT_SET = 6;
    private boolean isSqlFinder = true;
    protected RDBMSBean rdbmsBean = null;
    protected String methodName = null;
    private boolean isFinder = false;
    protected boolean isSelect = false;
    protected boolean isSelectInEntity = false;
    private boolean keyFinder = false;
    private String resultTypeMapping = null;
    protected int queryType = 0;
    protected int maxElements = 0;
    private RDBMSBean selectBeanTarget = null;
    private String selectFieldColumn = null;
    private Class selectFieldClass = null;
    private boolean includeUpdates = true;
    protected Class returnClassType = null;
    protected Class[] parameterClassTypes = null;
    private Class[] exceptionClassTypes = null;
    private String modifierString = null;
    private String[] parameterClassNames = null;
    protected boolean finderLoadsBean = false;
    protected List externalMethodParmList = new ArrayList();
    private List internalQueryParmList = new ArrayList();
    protected List internalInEntityParmList = new ArrayList();
    private boolean isSelectDistinct = false;
    protected String sqlQuery = null;
    protected String sqlQueryForUpdate = null;
    private String sqlQueryForSelectForUpdateDisabled = null;
    protected String sqlQueryForUpdateNoWait = null;
    protected boolean queryCachingEnabled = false;
    protected boolean eagerRefreshEnabled = false;
    protected Integer finderIndex = null;
    protected TTLManager ownerManager = null;
    protected Object[] arguments = null;
    protected QueryCacheKey queryCacheKey = null;
    private Map queryCacheEntries;
    protected Log log;
    protected EJBComplianceTextFormatter fmt;

    public Finder(String string, boolean bl) throws InvalidFinderException {
        if (string.startsWith("ejbSelect") || string.equals("execute")) {
            if (string.endsWith("InEntity")) {
                this.isSelectInEntity = true;
            } else {
                this.isSelect = true;
            }
        } else {
            this.isFinder = true;
        }
        this.setName(string);
        this.isSqlFinder = bl;
        this.log = new Log();
        this.fmt = new EJBComplianceTextFormatter();
    }

    public String getSQLQuery() {
        throw new AssertionError("Should never be called");
    }

    public String getSQLQueryForUpdate() {
        throw new AssertionError("Should never be called");
    }

    public String getSQLQueryForUpdateNoWait() {
        throw new AssertionError("Should never be called");
    }

    public String getSQLQueryForUpdateSelective() {
        throw new AssertionError("Should never be called");
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int n) {
        this.queryType = n;
    }

    public boolean isSelectInEntity() {
        return this.isSelectInEntity;
    }

    public void setIsSelectInEntity(boolean bl) {
        this.isSelectInEntity = bl;
    }

    public boolean isSelectDistinct() {
        return this.isSelectDistinct;
    }

    public void setSelectDistinct(boolean bl) {
        this.isSelectDistinct = bl;
    }

    public void setSelectBeanTarget(RDBMSBean rDBMSBean) {
        this.selectBeanTarget = rDBMSBean;
    }

    public RDBMSBean getSelectBeanTarget() {
        return this.selectBeanTarget;
    }

    public void setSelectFieldColumn(String string) {
        this.selectFieldColumn = string;
    }

    public String getSelectFieldColumn() {
        return this.selectFieldColumn;
    }

    public void setSelectFieldClass(Class clazz) {
        this.selectFieldClass = clazz;
    }

    public Class getSelectFieldClass() {
        return this.selectFieldClass;
    }

    public void setFinderLoadsBean(boolean bl) {
        this.finderLoadsBean = bl;
    }

    public boolean finderLoadsBean() {
        return this.finderLoadsBean;
    }

    public boolean isFinder() {
        return this.isFinder;
    }

    public void setIsSelect(boolean bl) {
        this.isSelect = bl;
    }

    public boolean isSelect() {
        return this.isSelect;
    }

    public boolean isAggregateQuery() {
        return false;
    }

    protected void setName(String string) throws InvalidFinderException {
        if (string == null) {
            throw new InvalidFinderException(1, string);
        }
        if (string.equals("")) {
            throw new InvalidFinderException(2, string);
        }
        if (!(string.startsWith("find") || string.startsWith("ejbSelect") || string.equals("execute"))) {
            throw new InvalidFinderException(3, string);
        }
        this.methodName = string;
    }

    public String getName() {
        return this.methodName;
    }

    public void setReturnClassType(Class clazz) {
        this.returnClassType = clazz;
    }

    public Class getReturnClassType() {
        return this.returnClassType;
    }

    public void setParameterClassTypes(Class[] classArray) {
        this.parameterClassTypes = classArray;
        this.parameterClassNames = new String[this.parameterClassTypes.length];
        for (int i = 0; i < this.parameterClassTypes.length; ++i) {
            this.parameterClassNames[i] = this.parameterClassTypes[i].getName();
        }
    }

    public Class[] getParameterClassTypes() {
        return this.parameterClassTypes;
    }

    public Class getParameterTypeAt(int n) {
        if (n < this.parameterClassTypes.length) {
            return this.parameterClassTypes[n];
        }
        return null;
    }

    public void setParameterClassNames(String[] stringArray) {
        this.parameterClassNames = stringArray;
    }

    public String[] getParameterClassNames() {
        return this.parameterClassNames;
    }

    public void setExceptionClassTypes(Class[] classArray) {
        this.exceptionClassTypes = classArray;
    }

    public Class[] getExceptionClassTypes() {
        return this.exceptionClassTypes;
    }

    public void setModifierString(String string) {
        this.modifierString = string;
    }

    public String getModifierString() {
        return this.modifierString;
    }

    public void setRDBMSBean(RDBMSBean rDBMSBean) {
        this.rdbmsBean = rDBMSBean;
    }

    public RDBMSBean getRDBMSBean() {
        return this.rdbmsBean;
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public void setMaxElements(int n) {
        this.maxElements = n;
    }

    public void setIncludeUpdates(boolean bl) {
        this.includeUpdates = bl;
    }

    public boolean getIncludeUpdates() {
        return this.includeUpdates;
    }

    public String getResultTypeMapping() {
        return this.resultTypeMapping;
    }

    public void setResultTypeMapping(String string) {
        this.resultTypeMapping = string;
    }

    public boolean hasLocalResultType() {
        return "Local".equals(this.resultTypeMapping);
    }

    public boolean hasRemoteResultType() {
        return "Remote".equals(this.resultTypeMapping);
    }

    public boolean isMultiFinder() {
        if (this.getReturnClassType() == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(this.getReturnClassType());
    }

    public boolean isScalarFinder() {
        return !this.isMultiFinder();
    }

    public boolean isSetFinder() {
        if (this.getReturnClassType() == null) {
            return false;
        }
        return this.getReturnClassType().getName().equals("java.util.Set");
    }

    public boolean isResultSetFinder() {
        if (this.getReturnClassType() == null) {
            return false;
        }
        return ResultSet.class.isAssignableFrom(this.getReturnClassType());
    }

    public boolean isFindByPrimaryKey() {
        return this.getName().equals("findByPrimaryKey");
    }

    public boolean isKeyFinder() {
        return this.keyFinder;
    }

    public void setKeyFinder(boolean bl) {
        this.keyFinder = bl;
    }

    protected void setMethod(Method method) throws Exception {
        this.setReturnClassType(method.getReturnType());
        this.setExceptionClassTypes(method.getExceptionTypes());
        StringBuffer stringBuffer = new StringBuffer();
        int n = method.getModifiers();
        if (Modifier.isAbstract(n)) {
            n ^= 0x400;
        }
        stringBuffer.append(Modifier.toString(n)).append(" ");
        String string = stringBuffer.toString();
        int n2 = string.indexOf("strict ");
        if (n2 != -1) {
            stringBuffer.insert(n2 + "strict".length(), "fp");
        }
        this.setModifierString(stringBuffer.toString());
    }

    public abstract void setMethods(Method[] var1) throws Exception;

    public List getExternalMethodParmList() {
        return this.externalMethodParmList;
    }

    public List getExternalMethodAndInEntityParmList() {
        ArrayList arrayList = new ArrayList(this.externalMethodParmList);
        return arrayList;
    }

    public List getInternalQueryAndInEntityParmList() {
        ArrayList<ParamNode> arrayList = new ArrayList<ParamNode>(this.internalQueryParmList);
        for (ParamNode paramNode : this.internalInEntityParmList) {
            arrayList.add(paramNode);
        }
        return arrayList;
    }

    public void addInternalQueryParmList(ParamNode paramNode) {
        this.internalQueryParmList.add(paramNode);
    }

    protected ParamNode getInternalQueryParmNode(int n) {
        if (this.internalQueryParmList == null || this.internalQueryParmList.isEmpty() || n >= this.internalQueryParmList.size()) {
            return null;
        }
        return (ParamNode)this.internalQueryParmList.get(n);
    }

    public void addInternalInEntityParmList(ParamNode paramNode) {
        this.internalInEntityParmList.add(paramNode);
    }

    public List getInternalInEntityParmList() {
        return this.internalInEntityParmList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Finder ");
        stringBuffer.append("methodName = " + this.methodName + "; ");
        stringBuffer.append("Parameter types = " + this.parameterClassTypes + ";");
        stringBuffer.append("finderLoadsBean = " + new Boolean(this.finderLoadsBean) + ";");
        return stringBuffer.toString();
    }

    public boolean isSqlFinder() {
        return this.isSqlFinder;
    }

    public boolean isEjbqlFinder() {
        return !this.isSqlFinder;
    }

    public void setQueryCachingEnabled(RDBMSFinder rDBMSFinder, RDBMSBean rDBMSBean) {
        if (!rDBMSFinder.isQueryCachingEnabled()) {
            this.queryCachingEnabled = false;
            return;
        }
        if (!this.checkIfQueryCachingLegal(rDBMSBean)) {
            this.queryCachingEnabled = false;
            return;
        }
        this.queryCachingEnabled = true;
        if (rDBMSFinder.isEnableEagerRefresh()) {
            this.eagerRefreshEnabled = true;
        }
    }

    public void setQueryCachingEnabled(boolean bl) {
        if (!bl) {
            this.queryCachingEnabled = false;
            return;
        }
        if (!this.checkIfQueryCachingLegal(this.rdbmsBean)) {
            this.queryCachingEnabled = false;
            return;
        }
        this.queryCachingEnabled = true;
    }

    public boolean isQueryCachingEnabled() {
        return this.queryCachingEnabled;
    }

    public abstract QueryCachingHandler getQueryCachingHandler(Object[] var1, TTLManager var2);

    public String getFinderIndex() {
        if (!this.isQueryCachingEnabled()) {
            return null;
        }
        return this.generateFinderIndex();
    }

    protected String generateFinderIndex() {
        if (this.parameterClassNames == null) {
            throw new AssertionError("parameter class names is null; cannot generate finder index for query caching");
        }
        int n = this.methodName.hashCode();
        for (int i = 0; i < this.parameterClassNames.length; ++i) {
            n ^= this.parameterClassNames[i].hashCode();
        }
        return String.valueOf(n);
    }

    protected boolean checkIfQueryCachingLegal(RDBMSBean rDBMSBean) {
        if (!rDBMSBean.isReadOnly()) {
            this.log.logWarning(this.fmt.QUERY_CACHING_SUPPORTED_FOR_RO_BEANS_ONLY(rDBMSBean.getEjbName(), this.getName()));
            return false;
        }
        if (this.isFindByPrimaryKey()) {
            this.log.logWarning(this.fmt.QUERY_CACHING_UNNECESSARY_FOR_FIND_BY_PK(rDBMSBean.getEjbName()));
            return false;
        }
        if (this.isSelect()) {
            this.log.logWarning(this.fmt.QUERY_CACHING_NOT_SUPPORTED_FOR_EJBSELECTS(rDBMSBean.getEjbName(), this.getName()));
            return false;
        }
        if (this.getReturnClassType().equals(Enumeration.class)) {
            this.log.logWarning(this.fmt.QUERY_CACHING_NOT_SUPPORTED_FOR_ENUMFINDERS(rDBMSBean.getEjbName(), this.getName()));
            return false;
        }
        return true;
    }

    public boolean isEagerRefreshEnabled() {
        return this.eagerRefreshEnabled;
    }
}

