/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.logging.Loggable;
import weblogic.utils.Debug;

public class JoinNode {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private JoinNode prevNode;
    private String prevCMRField;
    private RDBMSBean thisBean;
    private String tableAlias;
    private String tableName;
    private Map otherTableNameAliasMap;
    private Map otherTableName2JoinSQL;
    private List forceOtherTableName2JoinSQL;
    private int relationshipType;
    private boolean isManyToMany;
    private boolean isRemoteInterface;
    private boolean prevNodeOwnsFK;
    private List joinColumns;
    private boolean doLeftOuterJoin;
    private boolean dbType;
    private String tableAliasMN;
    private String tableNameMN;
    private Map children;
    private QueryContext queryContext;
    public static final int PATHS_DISTINCT = -1;
    public static final int PATHS_EQUAL = 0;
    public static final int PATHS_SUBSET = 1;

    public JoinNode(JoinNode joinNode, String string, RDBMSBean rDBMSBean, String string2, String string3, int n, boolean bl, boolean bl2, String string4, QueryContext queryContext, List list) {
        this.prevNode = joinNode;
        this.prevCMRField = string;
        this.thisBean = rDBMSBean;
        this.tableName = string2;
        this.tableAlias = string3;
        this.relationshipType = n;
        this.isManyToMany = bl;
        this.isRemoteInterface = bl2;
        this.tableAliasMN = string4;
        this.queryContext = queryContext;
        this.children = new HashMap();
        this.otherTableNameAliasMap = new HashMap();
        this.otherTableName2JoinSQL = new HashMap();
        this.joinColumns = list;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    private int getDatabaseType() {
        return this.thisBean.getDatabaseType();
    }

    public void setDoLeftOuterJoin(boolean bl) throws IllegalExpressionException {
        int n = this.getDatabaseType();
        if (n == 0) {
            Loggable loggable = EJBLogger.logCannotDoOuterJoinForUnspecifiedDBLoggable();
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        if (!this.isManyToMany || this.isRemoteInterface) {
            if (!RDBMSUtils.dbSupportForSingleLeftOuterJoin(n)) {
                Loggable loggable = EJBLogger.logCannotDoOuterJoinForDBLoggable((String)this.prevNode.getRDBMSBean().getEjbName(), (String)this.thisBean.getEjbName(), (String)DDConstants.getDBNameForType(n));
                throw new IllegalExpressionException(7, loggable.getMessage());
            }
        } else if (!RDBMSUtils.dbSupportForMultiLeftOuterJoin(n)) {
            Loggable loggable = EJBLogger.logCannotDoMultiOuterJoinForDBLoggable((String)this.prevNode.getRDBMSBean().getEjbName(), (String)this.thisBean.getEjbName(), (String)DDConstants.getDBNameForType(n));
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        this.doLeftOuterJoin = bl;
    }

    public boolean getDoLeftOuterJoin() {
        return this.doLeftOuterJoin;
    }

    public int getAllDoLeftOuterJoinCount() {
        int n = 0;
        if (this.doLeftOuterJoin) {
            n = this.isManyToMany ? 2 : 1;
        }
        for (JoinNode joinNode : this.children.values()) {
            n += joinNode.getAllDoLeftOuterJoinCount();
        }
        return n;
    }

    boolean isLeftOuterJoinANSIRoot() {
        if (!this.hasChildren()) {
            return false;
        }
        if (this.isDoLeftOuterJoinANSI()) {
            return false;
        }
        Iterator iterator = this.getChildrenIterator();
        while (iterator.hasNext()) {
            JoinNode joinNode = (JoinNode)iterator.next();
            if (!joinNode.isDoLeftOuterJoinANSI()) continue;
            return true;
        }
        return false;
    }

    boolean isDoLeftOuterJoinANSI() {
        if (!this.getDoLeftOuterJoin()) {
            return false;
        }
        int n = this.getDatabaseType();
        switch (n) {
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public JoinNode getPrevNode() {
        return this.prevNode;
    }

    public String getPrevCMRField() {
        return this.prevCMRField;
    }

    public int getRelationshipType() {
        return this.relationshipType;
    }

    public boolean getIsManyToMany() {
        return this.isManyToMany;
    }

    public String getJoinTableAlias() {
        return this.tableAliasMN;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String string) {
        this.tableAlias = string;
    }

    public List getTableAlias(List list) {
        if (this.tableAlias.length() > 0) {
            list.add(this.tableAlias);
        }
        if (this.isManyToMany) {
            list.add(this.tableAliasMN);
        }
        Iterator iterator = this.otherTableNameAliasMap.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        for (JoinNode joinNode : this.children.values()) {
            joinNode.getTableAlias(list);
        }
        return list;
    }

    public boolean otherTableNameContains(String string) {
        return this.otherTableNameAliasMap.containsKey(string);
    }

    public String getAnyTableNameAlias(String string) throws IllegalExpressionException {
        if (string.equals(this.tableName)) {
            return this.tableAlias;
        }
        return this.getOtherTableNameAlias(string);
    }

    public String getOtherTableNameAlias(String string) throws IllegalExpressionException {
        if (string.equals(this.tableName)) {
            throw new IllegalExpressionException(7, " Internal Error: attempt to getOtherTableNameAlias on default table: '" + string + "', this indicates an internal problem.  Should not be attempting to getOtherTableNameAlias " + "on the default JoinNode.  contact technical support");
        }
        String string2 = (String)this.otherTableNameAliasMap.get(string);
        if (string2 != null) {
            return string2;
        }
        if (!this.thisBean.hasTable(string)) {
            throw new IllegalExpressionException(7, "Attempt to register Table '" + string + "'. for Bean: '" + this.thisBean.getEjbName() + "'  but that Table is not mapped to the Bean.");
        }
        string2 = this.registerTable(string);
        this.otherTableNameAliasMap.put(string, string2);
        return string2;
    }

    public boolean isExcluded(List list) {
        if (list == null) {
            return false;
        }
        if (list.size() == 0) {
            return false;
        }
        if (list.contains(this.getTableAlias())) {
            return true;
        }
        return list.contains(this.getJoinTableAlias());
    }

    public boolean hasChild(String string) {
        return this.children.containsKey(string);
    }

    public JoinNode getChild(String string) {
        return (JoinNode)this.children.get(string);
    }

    public void putChild(String string, JoinNode joinNode) {
        this.children.put(string, joinNode);
    }

    boolean hasChildren() {
        return this.getChildren().keySet().size() > 0;
    }

    public Map getChildren() {
        return this.children;
    }

    Iterator getChildrenIterator() {
        return this.getChildren().values().iterator();
    }

    String getFROMDeclaration(List list, int n) throws IllegalExpressionException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDatabaseType() == 1) {
            this.getOracleFROM(list, n, stringBuffer);
        } else {
            this.addANSIFROM(list, n, stringBuffer);
            this.addNonANSIFROM(list, n, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void addANSIFROM(List list, int n, StringBuffer stringBuffer) {
        Object object;
        Object object2;
        if (!this.isExcluded(list) && (this.isLeftOuterJoinANSIRoot() || this.isDoLeftOuterJoinANSI()) && (object2 = this.getTableAlias()) != null && ((String)object2).length() > 0) {
            object = this.queryContext.getTableNameForAlias((String)object2);
            if (this.isLeftOuterJoinANSIRoot()) {
                this.addTableToFROM((String)object, (String)object2, n, stringBuffer);
            } else {
                String string = this.getJoinTableAlias();
                if (string != null && string.length() > 0) {
                    String string2 = this.queryContext.getTableNameForAlias(string);
                    this.addANSIOuterJoinTableToFROM(string2, string, n, stringBuffer);
                }
                this.addANSIOuterJoinTableToFROM((String)object, (String)object2, n, stringBuffer);
            }
        }
        object2 = this.getChildrenIterator();
        while (object2.hasNext()) {
            object = (JoinNode)object2.next();
            ((JoinNode)object).addANSIFROM(list, n, stringBuffer);
        }
    }

    private void addNonANSIFROM(List list, int n, StringBuffer stringBuffer) {
        Object object3;
        Object object2;
        if (!this.isExcluded(list)) {
            String string;
            if (!this.isLeftOuterJoinANSIRoot() && !this.isDoLeftOuterJoinANSI()) {
                object2 = this.getTableAlias();
                if (object2 != null && ((String)object2).length() > 0) {
                    object3 = this.queryContext.getTableNameForAlias((String)object2);
                    this.addTableToFROM((String)object3, (String)object2, n, stringBuffer);
                }
                if ((object3 = this.getJoinTableAlias()) != null && ((String)object3).length() > 0) {
                    string = this.queryContext.getTableNameForAlias((String)object3);
                    this.addTableToFROM(string, (String)object3, n, stringBuffer);
                }
            }
            if (this.otherTableNameAliasMap.keySet().size() > 0) {
                for (Object object3 : this.otherTableNameAliasMap.keySet()) {
                    string = (String)this.otherTableNameAliasMap.get(object3);
                    this.addTableToFROM((String)object3, string, n, stringBuffer);
                }
            }
        }
        object2 = this.getChildrenIterator();
        while (object2.hasNext()) {
            object3 = (JoinNode)object2.next();
            ((JoinNode)object3).addNonANSIFROM(list, n, stringBuffer);
        }
    }

    private void getOracleFROM(List list, int n, StringBuffer stringBuffer) throws IllegalExpressionException {
        List list2;
        try {
            list2 = JoinNode.getTableAliasList(this);
        }
        catch (Exception exception) {
            throw new IllegalExpressionException(7, exception.getMessage());
        }
        for (int i = list2.size() - 1; i >= 0; --i) {
            String string = (String)list2.get(i);
            String string2 = this.queryContext.getTableNameForAlias(string);
            this.addTableToFROM(string2, string, n, stringBuffer);
        }
    }

    private void addTableToFROM(String string, String string2, int n, StringBuffer stringBuffer) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(", ");
        }
        stringBuffer.append(RDBMSUtils.escQuotedID(string));
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(this.queryContext.getFROMClauseSelectForUpdate(n));
    }

    private void addANSIOuterJoinTableToFROM(String string, String string2, int n, StringBuffer stringBuffer) {
        Object object;
        if (this.isUseInnerJoin()) {
            stringBuffer.append("INNER JOIN ");
        } else {
            stringBuffer.append("LEFT OUTER JOIN ");
        }
        stringBuffer.append(RDBMSUtils.escQuotedID(string));
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(this.queryContext.getFROMClauseSelectForUpdate(n));
        stringBuffer.append(" ON ");
        String string3 = "AND ";
        Iterator iterator = this.joinColumns.iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            Debug.assertion((object.size() == 2 ? 1 : 0) != 0, (String)("Internal Error !!  For Prev Bean: '" + this.prevNode.getRDBMSBean().getEjbName() + "' and Bean: '" + this.thisBean.getEjbName() + "', we expect all joinColumn List elements to contain 2 Columns. " + "Instead we encountered one with '" + object.size() + "' Columns !"));
            Iterator iterator2 = object.iterator();
            String string4 = (String)iterator2.next();
            String string5 = (String)iterator2.next();
            if (!string5.startsWith(string2 + ".")) continue;
            stringBuffer.append(string4).append(" = ").append(string5).append(" ");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string3);
        }
        object = stringBuffer.substring(stringBuffer.length() - string3.length());
        if (((String)object).equals(string3)) {
            stringBuffer.delete(stringBuffer.length() - string3.length(), stringBuffer.length());
        }
    }

    public void setJoinSQL(List list) {
        this.joinColumns = list;
    }

    public void addJoinSQL(List list) {
        this.joinColumns.add(list);
    }

    public String getJoinSQL() throws IllegalExpressionException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.joinColumns.iterator();
        while (iterator.hasNext()) {
            int n;
            object = (List)iterator.next();
            if (object.size() != 2) {
                throw new IllegalExpressionException(7, "Internal Error !!  For Prev Bean: '" + this.prevNode.getRDBMSBean().getEjbName() + "' and Bean: '" + this.thisBean.getEjbName() + "', we expect all joinColumn List elements to contain 2 Columns. " + "Instead we encountered one with '" + object.size() + "' Columns !");
            }
            Iterator iterator2 = object.iterator();
            String string = (String)iterator2.next();
            String string2 = (String)iterator2.next();
            if (this.getDoLeftOuterJoin()) {
                if (!this.isDoLeftOuterJoinANSI()) {
                    n = this.getDatabaseType();
                    switch (n) {
                        case 1: {
                            if (this.isUseInnerJoin()) {
                                stringBuffer.append(string2).append(" = ").append(string);
                                break;
                            }
                            stringBuffer.append(string2).append(" (+)= ").append(string);
                            break;
                        }
                        case 2: 
                        case 5: {
                            stringBuffer.append(string).append(" *= ").append(string2);
                            break;
                        }
                        default: {
                            throw new IllegalExpressionException(7, "Internal Error !!  For Prev Bean: '" + this.prevNode.getRDBMSBean().getEjbName() + "' and Bean: '" + this.thisBean.getEjbName() + "', we were asked to do a Left Outer Join in the WHERE Clause for Database: '" + n + "', but we don't know how to do this !");
                        }
                    }
                }
            } else {
                stringBuffer.append(string).append(" = ").append(string2);
            }
            if (!iterator.hasNext()) continue;
            n = this.getDatabaseType();
            if (this.getDoLeftOuterJoin() && this.isDoLeftOuterJoinANSI() && (n == 4 || n == 9 || n == 7 || n == 8 || n == 6)) continue;
            stringBuffer.append(" AND ");
        }
        if (this.prevNode != null && this.prevCMRField != null && (object = this.prevNode.getJoinSQLForCmrf(this.prevCMRField)) != null) {
            if (this.joinColumns.size() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public RDBMSBean getRDBMSBean() {
        return this.thisBean;
    }

    public void parseJoin(String string) throws IllegalExpressionException {
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug("  parse pathExpression: " + string);
        }
        if (string.length() == 0) {
            return;
        }
        String string2 = "";
        String string3 = null;
        if (string.indexOf(".") == -1) {
            String string4 = this.thisBean.getCmpColumnForField(string);
            if (string4 == null) {
                string4 = this.thisBean.getCmpColumnForVariable(string);
            }
            if (string4 != null) {
                return;
            }
            string3 = string;
        } else {
            int n = string.indexOf(".");
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Object var4_6 = null;
        Object var5_7 = null;
        if (this.children.containsKey(string3)) {
            JoinNode joinNode = (JoinNode)this.children.get(string3);
            joinNode.parseJoin(string2);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        RDBMSBean rDBMSBean = this.thisBean;
        String string5 = string3;
        if (rDBMSBean.isRemoteField(string5)) {
            Object object2;
            if (string2.length() > 0) {
                Loggable loggable = EJBLogger.logfinderTerminalCMRNotRemoteLoggable((String)string5, (String)rDBMSBean.getEjbName());
                throw new IllegalExpressionException(7, loggable.getMessage());
            }
            if (rDBMSBean.containsFkField(string5)) {
                if (debugLogger.isDebugEnabled()) {
                    JoinNode.debug(" Bean contains FK Field. NO Join Node For Bean Type: Remote Interface. ");
                }
                return;
            }
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" Doing join table JOIN for Bean: " + rDBMSBean.getEjbName() + ", cmr-field: " + string5 + " to Remote Interface ");
            }
            if (!rDBMSBean.isForeignKeyField(string5)) {
                Loggable loggable = EJBLogger.logfinderCouldNotGetFKColumnsLoggable((String)rDBMSBean.getEjbName(), (String)string5, (String)"JOIN Calculation");
                throw new IllegalExpressionException(7, loggable.getMessage());
            }
            String string6 = this.getFKTableAliasAndSQLForCmrf(string5);
            String string7 = rDBMSBean.getJoinTableName(string5);
            String string8 = this.registerTable(string7);
            Map map = rDBMSBean.getColumnMapForCmrfAndPkTable(string5, string7);
            if (map == null) {
                throw new IllegalExpressionException(7, " could not find Map of foreign keys and primary keys table for Bean: " + rDBMSBean.getEjbName() + "  Remote cmr-field: " + string5);
            }
            ArrayList<List> arrayList = new ArrayList<List>();
            for (Object object2 : map.keySet()) {
                String string9 = (String)map.get(object2);
                String string10 = string6 + "." + RDBMSUtils.escQuotedID(string9);
                String string11 = string8 + "." + RDBMSUtils.escQuotedID((String)object2);
                arrayList.add(JoinNode.createJoinListEntry(string10, string11));
            }
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" add new join table Join Node for Remote Interface with JOIN: " + stringBuffer.toString());
            }
            object2 = this.newJoinNode(this, string3, null, string7, "", 8, true, true, string8, arrayList);
            this.children.put(string3, object2);
            return;
        }
        RDBMSBean rDBMSBean2 = rDBMSBean.getRelatedRDBMSBean(string5);
        if (rDBMSBean2 == null) {
            Loggable loggable = EJBLogger.logejbqlIdNotFieldAndNotBeanLoggable((String)string5);
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        if (rDBMSBean.isManyToManyRelation(string5)) {
            Object object;
            String string12;
            String string13;
            String string142;
            Map map;
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" Doing Many-to-Many JOIN for Bean: " + rDBMSBean.getEjbName() + ", cmr-field: " + string5);
            }
            String string15 = rDBMSBean.getJoinTableName(string5);
            String string16 = this.registerTable(string15);
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" cmrfield: " + string5 + ", joinTable name: " + string15 + ", joinTableAlias: " + string16);
            }
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug("processing symmetric field: '" + string5 + "'");
            }
            String string17 = this.getTableName();
            String string18 = this.getTableAlias();
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" the LHS Table is: '" + string17 + "',  with Alias: '" + string18 + "'");
            }
            if (rDBMSBean.isSymmetricField(string5)) {
                if (debugLogger.isDebugEnabled()) {
                    JoinNode.debug("processing     symmetric field: '" + string5 + "'");
                }
                map = rDBMSBean.getSymColumnMapForCmrfAndPkTable(string5, string17);
            } else {
                if (debugLogger.isDebugEnabled()) {
                    JoinNode.debug("processing non-symmetric field: '" + string5 + "'");
                }
                if (!rDBMSBean.isForeignKeyField(string5)) {
                    Loggable loggable = EJBLogger.logfinderCMRFieldNotFKLoggable((String)rDBMSBean.getEjbName(), (String)string5, (String)"M-N Relationship JOIN Calculation");
                    throw new IllegalExpressionException(7, loggable.getMessage());
                }
                map = rDBMSBean.getColumnMapForCmrfAndPkTable(string5, this.tableName);
            }
            if (map == null) {
                throw new IllegalExpressionException(7, " could not find Map of foreign keys and primary keys table for EJB: '" + rDBMSBean.getEjbName() + "'  cmr-field: '" + string5 + "'   dest PK Table: '" + string17 + "'  Join Table Name: '" + string15 + "'.   Please check your RDBMS Deployment Descriptors for this EJB.");
            }
            ArrayList<List> arrayList = new ArrayList<List>();
            for (String string142 : map.keySet()) {
                string13 = (String)map.get(string142);
                string12 = string18 + "." + RDBMSUtils.escQuotedID(string13);
                object = string16 + "." + RDBMSUtils.escQuotedID(string142);
                arrayList.add(JoinNode.createJoinListEntry(string12, (String)object));
            }
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" joinSQL after 'from' side processed  '" + stringBuffer.toString() + "'");
            }
            string142 = RDBMSUtils.escQuotedID(rDBMSBean2.chooseTableAsJoinTarget());
            string13 = this.registerTable(string142);
            string12 = rDBMSBean.getRelatedFieldName(string5);
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" processing other side of M-N join:  for RHS Bean '" + rDBMSBean2.getEjbName() + "',  we've chosen RHS Table: '" + string142 + "'  with TableAlias: '" + string13 + "'");
            }
            if ((map = rDBMSBean2.getColumnMapForCmrfAndPkTable(string12, string142)) == null) {
                throw new IllegalExpressionException(7, " could not find Map of foreign keys and primary keys table for Bean: '" + rDBMSBean2.getEjbName() + "'   dest PK Table: '" + string15 + "'   cmr-field: '" + string12 + "'.   Please check your RDBMS Deployment Descriptors for this EJB.");
            }
            Iterator iterator = map.keySet().iterator();
            stringBuffer.append(" AND ");
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string19 = (String)map.get(object);
                String string20 = string16 + "." + RDBMSUtils.escQuotedID((String)object);
                String string21 = string13 + "." + RDBMSUtils.escQuotedID(string19);
                arrayList.add(JoinNode.createJoinListEntry(string20, string21));
            }
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" add new Many-to-Many Join Node with JOIN: " + stringBuffer.toString());
            }
            object = this.newJoinNode(this, string3, rDBMSBean2, string142, string13, 6, true, false, string16, arrayList);
            this.children.put(string3, object);
            if (string2.length() > 0) {
                ((JoinNode)object).parseJoin(string2);
            }
        } else {
            int n;
            Map map;
            String string22;
            String string23;
            Object object;
            String string24 = this.tableAlias;
            String string25 = this.tableName;
            Object var15_35 = null;
            Iterator iterator = null;
            String string26 = null;
            String string27 = null;
            Object var19_46 = null;
            String string28 = null;
            boolean bl = rDBMSBean.isForeignKeyField(string5);
            if (bl) {
                string27 = string5;
                if (debugLogger.isDebugEnabled()) {
                    JoinNode.debug("\n\n parseJoin 1-N or 1-1.  prevHasFK.  about to call getFKTableAliasAndSQLForCmrf on cmrfield: '" + string5 + "'\n\n");
                }
                object = this.getFKTableAliasAndSQLForCmrf(string5);
                string23 = RDBMSUtils.escQuotedID(rDBMSBean2.chooseTableAsJoinTarget());
                string28 = string22 = this.registerTable(string23);
                string26 = object;
                map = rDBMSBean.getColumnMapForCmrfAndPkTable(string5, string23);
                n = rDBMSBean.isOneToManyRelation(string5) ? 5 : 2;
            } else {
                string27 = rDBMSBean.getRelatedFieldName(string5);
                if (string27.length() < 1) {
                    throw new IllegalExpressionException(7, "Could not find cmr-field in Bean: " + rDBMSBean2.getEjbName() + " that points to EJBean: " + rDBMSBean.getEjbName());
                }
                string23 = rDBMSBean2.getTableForCmrField(string27);
                string22 = this.registerTable(string23);
                string28 = string24;
                string26 = string22;
                map = rDBMSBean2.getColumnMapForCmrfAndPkTable(string27, this.tableName);
                n = rDBMSBean.isOneToManyRelation(string5) ? 4 : 3;
            }
            iterator = map.keySet().iterator();
            if (iterator.hasNext() && stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            object = new ArrayList();
            while (iterator.hasNext()) {
                int n2 = rDBMSBean2.getDatabaseType();
                String string29 = (String)iterator.next();
                String string30 = (String)map.get(string29);
                String string31 = string26 + "." + RDBMSUtils.escQuotedID(string29);
                String string32 = string28 + "." + RDBMSUtils.escQuotedID(string30);
                if (bl) {
                    object.add(JoinNode.createJoinListEntry(string31, string32));
                    continue;
                }
                object.add(JoinNode.createJoinListEntry(string32, string31));
            }
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" add new Join Node with JOIN: " + stringBuffer.toString());
            }
            JoinNode joinNode = this.newJoinNode(this, string3, rDBMSBean2, string23, string22, n, false, false, "", (List)object);
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" add new JoinNode to children ");
            }
            this.children.put(string3, joinNode);
            if (this.queryContext.mainQueryContainsInSelectListForCachingElement(rDBMSBean, rDBMSBean2)) {
                joinNode.setDoLeftOuterJoin(true);
            }
            if (string2.length() > 0) {
                joinNode.parseJoin(string2);
            }
        }
    }

    public String getFKTableAliasAndSQLForCmrf(String string) throws IllegalExpressionException {
        String string2;
        String string3 = this.thisBean.getTableForCmrField(string);
        if (string3 == null) {
            throw new IllegalExpressionException(7, " could not find foreign key table for Bean: " + this.thisBean.getEjbName() + "  cmr-field: " + string);
        }
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug("  in getFKTableAliasAndSQLForCmrf  for cmrField '" + string + "',  theFKTable is '" + string3 + "',  default TableName is: '" + this.tableName + "'");
        }
        if (!string3.equals(this.tableName)) {
            string2 = this.getOtherTableNameAlias(string3);
            this.getInnerBeanJoinSQLMaybe(string3);
        } else {
            string2 = this.tableAlias;
        }
        return string2;
    }

    private String getInnerBeanJoinSQLMaybe(String string) throws IllegalExpressionException {
        if (this.tableName.equals(string)) {
            return null;
        }
        return this.getInnerBeanJoinSQL(string);
    }

    private String getInnerBeanJoinSQL(String string) throws IllegalExpressionException {
        String string2 = (String)this.otherTableName2JoinSQL.get(string);
        if (string2 != null) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.getOtherTableNameAlias(string);
        Map map = this.thisBean.getPKCmpf2ColumnForTable(this.tableName);
        if (map == null) {
            throw new IllegalExpressionException(7, "Internal Error in getInnerBeanJoinSQL, thisTablePKColMap:  Bean: '" + this.thisBean.getEjbName() + "', could not get Primary Key Field to Column Map for Table: '" + this.tableName + "'");
        }
        Map map2 = this.thisBean.getPKCmpf2ColumnForTable(string);
        if (map2 == null) {
            throw new IllegalExpressionException(7, "Internal Errorin getInnerBeanJoinSQL, destTablePKColMap:  Bean: '" + this.thisBean.getEjbName() + "', could not get Primary Key Field to Column Map for Table: '" + string + "'");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            String string5 = (String)map.get(string4);
            String string6 = (String)map2.get(string4);
            stringBuffer.append(this.tableAlias + "." + RDBMSUtils.escQuotedID(string5) + " = " + string3 + "." + RDBMSUtils.escQuotedID(string6));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        string2 = stringBuffer.toString();
        this.otherTableName2JoinSQL.put(string, string2);
        return string2;
    }

    public String getJoinSQLForCmrf(String string) {
        String string2 = this.thisBean.getTableForCmrField(string);
        if (string2 == null) {
            return null;
        }
        String string3 = (String)this.otherTableName2JoinSQL.get(string2);
        return string3;
    }

    void forceInternalMultiTableJoinMaybe(QueryNode queryNode, String string) throws IllegalExpressionException {
        if (this.tableName.equals(string)) {
            return;
        }
        this.forceInternalMultiTableJoin(queryNode, string);
    }

    void forceInternalMultiTableJoin(QueryNode queryNode, String string) throws IllegalExpressionException {
        String string2 = this.getTableAlias();
        String string3 = this.getOtherTableNameAlias(string);
        String string4 = this.getInnerBeanJoinSQLMaybe(string);
        if (string4 != null) {
            queryNode.addCmpFieldJoinSQL(string2, string3, string4);
        }
    }

    private String registerTable(String string) {
        return this.queryContext.registerTable(string);
    }

    public static String getPathWithoutTrailingCmpField(JoinNode joinNode, String string) throws IllegalExpressionException {
        if (string == null) {
            return "";
        }
        joinNode.parseJoin(string);
        if (!JoinNode.endsInField(joinNode, string)) {
            return string;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            throw new IllegalExpressionException(7, "Path Expression: '" + string + "' is a cmp-field without " + "a Range Variable or cmr-field pointing to it.  " + "cmp-fields alone are not allowed in EJB QL Queries, " + "they must be qualified.  Please re-examine your query.");
        }
        return string.substring(0, n);
    }

    public static int getRelationshipTypeForPathExpression(QueryContext queryContext, JoinNode joinNode, String string) throws IllegalExpressionException {
        String string2 = string;
        if (queryContext != null) {
            string2 = queryContext.replaceIdAliases(string);
        }
        joinNode.parseJoin(string);
        int n = JoinNode.countPathNodes(string2);
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 1;
        }
        if (JoinNode.endsInField(joinNode, string2)) {
            return 0;
        }
        JoinNode joinNode2 = JoinNode.getNode(joinNode, string2);
        return joinNode2.getRelationshipType();
    }

    public static int getRelationshipTypeForPathExpressionWithNoSQLGen(QueryContext queryContext, JoinNode joinNode, String string) throws IllegalExpressionException {
        JoinNode joinNode2 = queryContext.makeTrialJoinRoot(joinNode, string);
        return JoinNode.getRelationshipTypeForPathExpression(queryContext, joinNode2, string);
    }

    public static RDBMSBean getLastRDBMSBeanForPathExpressionWithNoSQLGen(QueryContext queryContext, JoinNode joinNode, String string) throws IllegalExpressionException {
        JoinNode joinNode2 = queryContext.makeTrialJoinRoot(joinNode, string);
        joinNode2.parseJoin(string);
        JoinNode joinNode3 = JoinNode.getNode(joinNode2, string);
        return joinNode3.getRDBMSBean();
    }

    public static boolean endsInField(JoinNode joinNode, String string) throws IllegalExpressionException {
        JoinNode joinNode2 = joinNode;
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = (String)stringTokenizer.nextElement();
            if (joinNode2.hasChild(string2)) {
                joinNode2 = joinNode2.getChild(string2);
                continue;
            }
            RDBMSBean rDBMSBean = joinNode2.getRDBMSBean();
            if (rDBMSBean.isRemoteField(string2)) {
                return false;
            }
            String string3 = rDBMSBean.getCmpColumnForField(string2);
            if (string3 == null) {
                string3 = rDBMSBean.getCmpColumnForVariable(string2);
            }
            if (string3 != null) {
                if (stringTokenizer.hasMoreTokens()) {
                    throw new IllegalExpressionException(7, "called endsInField on a pathExpression with an embedded field: " + string);
                }
                return true;
            }
            if (rDBMSBean.getCmrFieldNames().contains(string2)) {
                return false;
            }
            throw new IllegalExpressionException(7, "called endsInField on a pathExpression with field: '" + string2 + "' that's neither Field nor Bean: " + string);
        }
        return false;
    }

    public static boolean endsInLocalRelationship(JoinNode joinNode, String string) throws IllegalExpressionException {
        if (JoinNode.endsInRemoteInterface(joinNode, string)) {
            return false;
        }
        if (JoinNode.endsInField(joinNode, string)) {
            return false;
        }
        JoinNode joinNode2 = joinNode;
        String string2 = JoinNode.getLastFieldFromId(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (!joinNode2.hasChild(string3)) continue;
            if (string2.equals(string3)) {
                RDBMSBean rDBMSBean = joinNode2.getRDBMSBean();
                if (rDBMSBean.getCmrFieldNames().contains(string2)) {
                    return true;
                }
                throw new IllegalExpressionException(7, "unable to determine if  pathExpression '" + string + "' is terminated by a Remote Relationship, a cmp-field or a Local Relationship. " + "   It appears to be none of them.");
            }
            joinNode2 = joinNode2.getChild(string3);
        }
        throw new IllegalExpressionException(7, "unable to determine if  pathExpression '" + string + "' is terminated by a Remote Relationship, a cmp-field or a Local Relationship. " + "   It appears to be none of them.    Out of Tokens.");
    }

    public static boolean endsInRemoteInterface(JoinNode joinNode, String string) throws IllegalExpressionException {
        try {
            if (JoinNode.endsInField(joinNode, string)) {
                return false;
            }
        }
        catch (IllegalExpressionException illegalExpressionException) {
            // empty catch block
        }
        JoinNode joinNode2 = joinNode;
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = (String)stringTokenizer.nextElement();
            if (joinNode2.hasChild(string2) && stringTokenizer.hasMoreTokens()) {
                joinNode2 = joinNode2.getChild(string2);
                continue;
            }
            RDBMSBean rDBMSBean = joinNode2.getRDBMSBean();
            String string3 = rDBMSBean.getCmpColumnForField(string2);
            if (string3 == null) {
                string3 = rDBMSBean.getCmpColumnForVariable(string2);
            }
            if (string3 != null) {
                return false;
            }
            if (rDBMSBean.isRemoteField(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    throw new IllegalExpressionException(7, "called endsInRemoteInterface on a pathExpression.  The Remote Interface is NOT the last field in the Path as defined in the EJB 2.0 public draft  spec  section 10.2.4.6: " + string);
                }
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new IllegalExpressionException(7, "called endsInRemoteInterface on an unparsed pathExpression: " + string);
            }
            return false;
        }
        return false;
    }

    public static void getJoinSQLForPath(JoinNode joinNode, String string, List list, StringBuffer stringBuffer) throws IllegalExpressionException {
        boolean bl = false;
        JoinNode joinNode2 = joinNode;
        String string2 = "";
        if (string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        string2 = (String)stringTokenizer.nextElement();
        joinNode2 = joinNode.getChild(string2);
        if (joinNode2 == null) {
            throw new IllegalExpressionException(7, "Internal Error in JoinNode.getJoinSQLForPath, root node missing for path: '" + string + "'");
        }
        while (stringTokenizer.hasMoreTokens() && joinNode2.hasChild(string2 = (String)stringTokenizer.nextElement())) {
            joinNode2 = joinNode2.getChild(string2);
            boolean bl2 = false;
            if (list != null) {
                for (String string3 : list) {
                    if (string3.compareTo(joinNode2.getTableAlias()) != 0 && string3.compareTo(joinNode2.getJoinTableAlias()) != 0) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) break;
            String string4 = joinNode2.getJoinSQL();
            if (string4.length() <= 0) continue;
            if (bl) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(string4);
            bl = true;
        }
    }

    public static String getTableAndField(QueryNode queryNode, JoinNode joinNode, String string) throws IllegalExpressionException {
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug(" called getTableAndField on pathExpression: '" + string + "'");
        }
        if (JoinNode.endsInRemoteInterface(joinNode, string)) {
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug("  processing RemoteInterface ");
            }
            JoinNode joinNode2 = joinNode;
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = (String)stringTokenizer.nextElement();
                if (joinNode2.hasChild(string2) && stringTokenizer.hasMoreTokens()) {
                    joinNode2 = joinNode2.getChild(string2);
                    continue;
                }
                RDBMSBean rDBMSBean = joinNode2.getRDBMSBean();
                if (!rDBMSBean.isRemoteField(string2)) {
                    throw new IllegalExpressionException(7, "called getTableAndField on a pathExpression for a Remote Interface but the <cmr-field> " + string2 + " seems not to be pointing to a Remote Field. " + string);
                }
                List list = rDBMSBean.getForeignKeyColNames(string2);
                if (list == null) {
                    throw new IllegalExpressionException(7, "called getTableAndField on a pathExpression for a Remote Interface but the <cmr-field> " + string2 + " from Bean " + rDBMSBean.getEjbName() + " does not point to Foreign Key Column Information. " + string);
                }
                Iterator iterator = rDBMSBean.getForeignKeyColNames(string2).iterator();
                if (!iterator.hasNext()) {
                    Loggable loggable = EJBLogger.logfinderCouldNotGetFKColumnsLoggable((String)rDBMSBean.getEjbName(), (String)string2, (String)("JoinNode.getTableAndField on Remote Interface: " + string));
                    throw new IllegalExpressionException(7, loggable.getMessage());
                }
                if (rDBMSBean.containsFkField(string2)) {
                    String string3 = (String)iterator.next();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(joinNode2.getTableAlias());
                    stringBuffer.append(".");
                    stringBuffer.append(RDBMSUtils.escQuotedID(string3));
                    return stringBuffer.toString();
                }
                Map map = rDBMSBean.getCmpFieldToColumnMap();
                String string4 = (String)iterator.next();
                String string5 = (String)map.get(rDBMSBean.getRelatedPkFieldName(string2, string4));
                StringBuffer stringBuffer = new StringBuffer();
                if ((joinNode2 = joinNode2.getChild(string2)) == null) {
                    throw new IllegalExpressionException(7, "called getTableAndField on a pathExpression for a Remote Interface but the <cmr-field> " + string2 + " from Bean " + rDBMSBean.getEjbName() + "  did not yield an expected JoinNode which is " + "required to get the JoinTable info. " + " Path Expression: '" + string + "'");
                }
                stringBuffer.append(joinNode2.getJoinTableAlias());
                stringBuffer.append(".");
                stringBuffer.append(RDBMSUtils.escQuotedID(rDBMSBean.getRemoteColumn(string2)));
                return stringBuffer.toString();
            }
            Loggable loggable = EJBLogger.logfinderCouldNotGetTableAndFieldLoggable((String)string);
            throw new IllegalExpressionException(7, "JoinNode processing: " + loggable.getMessage());
        }
        Loggable loggable = EJBLogger.logfinderPathEndsInXNotYLoggable((String)"Bean", (String)"Field");
        if (!JoinNode.endsInField(joinNode, string)) {
            throw new IllegalExpressionException(7, "JoinNode.getTableAndField " + loggable.getMessage());
        }
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug("  processing local cmp-field ");
        }
        JoinNode joinNode3 = null;
        String string6 = "";
        JoinNode joinNode4 = joinNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string6 = (String)stringTokenizer.nextElement();
            if (joinNode4.hasChild(string6)) {
                joinNode3 = joinNode4;
                joinNode4 = joinNode4.getChild(string6);
                continue;
            }
            return JoinNode.writeTableAndFieldForLocalCmrf(queryNode, joinNode4, string6);
        }
        return JoinNode.writeTableAndFieldForLocalCmrf(queryNode, joinNode4, string6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String writeTableAndFieldForLocalCmrf(QueryNode queryNode, JoinNode joinNode, String string) throws IllegalExpressionException {
        String string2;
        RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug(" writeTableAndFieldForLocalCmrf got RDBMSBean for '" + rDBMSBean.getEjbName() + "'");
        }
        String string3 = joinNode.getTableName();
        String string4 = "";
        String string5 = null;
        if (rDBMSBean.isPrimaryKeyField(string)) {
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" processing PK field: '" + string + "'");
            }
            string2 = string3;
            string4 = joinNode.getTableAlias();
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" defaultTableName is: '" + string3 + "' tableAlias is: '" + string4 + "'");
            }
            string5 = rDBMSBean.getColumnForCmpFieldAndTable(string, string3);
        } else {
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" processing non-PK field: '" + string + "'");
            }
            string2 = rDBMSBean.getTableForCmpField(string);
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" Table Name that contains non-PK field: '" + string + "' is '" + string2 + "'");
            }
            if (string2 != null && (string5 = rDBMSBean.getColumnForCmpFieldAndTable(string, string2)) != null) {
                if (!string2.equals(string3)) {
                    string4 = joinNode.getOtherTableNameAlias(string2);
                    joinNode.forceInternalMultiTableJoin(queryNode, string2);
                } else {
                    string4 = joinNode.getTableAlias();
                }
            }
        }
        if (string5 == null) {
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" processing synthesized cmrfield variableName field: '" + string + "'");
            }
            if ((string5 = rDBMSBean.getCmpColumnForVariable(string)) == null) throw new IllegalExpressionException(7, "Error.  For Bean: '" + rDBMSBean.getEjbName() + "' could not find a Foreign Key Column Name for the field: '" + string + "' check your RDBMS Deployment Descriptors for Errors or Omissions.");
            string2 = rDBMSBean.getTableForVariable(string);
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(" column name for cmrfield variableName field: '" + string + "', is: '" + string5 + "'");
                JoinNode.debug(" table  name for cmrfield variableName field: '" + string + "', is: '" + string2 + "'");
            }
            if (string2 == null) throw new IllegalExpressionException(7, "Internal Error.  For Bean: '" + rDBMSBean.getEjbName() + "' could not get Foreign Key Table Name for variable name: '" + string5 + "'.");
            if (!string2.equals(string3)) {
                string4 = joinNode.getOtherTableNameAlias(string2);
                joinNode.forceInternalMultiTableJoin(queryNode, string2);
            } else {
                string4 = joinNode.getTableAlias();
            }
        }
        if (string5 == null) throw new IllegalExpressionException(7, "called getTableAndField on an unparsed pathExpression ending in: '" + string + "'");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string4);
        stringBuffer.append(".");
        stringBuffer.append(RDBMSUtils.escQuotedID(string5));
        return stringBuffer.toString();
    }

    private static boolean lhsBeanHasFKForLocal11or1NPath(QueryNode queryNode, String string) throws IllegalExpressionException {
        Object object;
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug(" lhsBeanHasFKForLocal11or1NPath  for path: '" + string + "'");
        }
        String string2 = JoinNode.chopLastFieldFromId(string);
        String string3 = JoinNode.getLastFieldFromId(string);
        JoinNode joinNode = queryNode.getJoinTree();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            object = (String)stringTokenizer.nextElement();
            if (joinNode.hasChild((String)object)) {
                joinNode = joinNode.getChild((String)object);
                continue;
            }
            throw new IllegalExpressionException(7, "Internal Error.  lhsBeanHasFKFor11or1NPath:  Attempt to get CMR Table and Foreign Key Columns for path: '" + string2 + ",  cmr-field: '" + string3 + "'.  Could not traverse the JoinTree for the path: '" + string2 + "'.  It's possible that this path has not been previously parsed.");
        }
        object = joinNode.getRDBMSBean();
        if (((RDBMSBean)object).isRemoteField(string3)) {
            throw new IllegalExpressionException(7, "Internal Error.  lhsBeanHasFKFor11or1NPath:  Attempt to get CMR Table and Foreign Key Columns for path: '" + string2 + ",  cmr-field: '" + string3 + "'.  This looks like a Remote Relationship.  This method should " + "only be called on 1-1 or 1-N Local Relationships.");
        }
        if (((RDBMSBean)object).isManyToManyRelation(string3)) {
            throw new IllegalExpressionException(7, "Internal Error.  lhsBeanHasFKFor11or1NPath:  Attempt to get CMR Table and Foreign Key Columns for path: '" + string2 + ",  cmr-field: '" + string3 + "'.  This looks like a Many To Many Relationship.  This method should " + "only be called on 1-1 or 1-N Local Relationships.");
        }
        return ((RDBMSBean)object).isForeignKeyField(string3);
    }

    public static List getTableAndFKColumnListForLocal11or1NPath(QueryNode queryNode, String string) throws IllegalExpressionException {
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug("  getTableAndFKColumnListForLocal11or1NPath for path: '" + string + "'");
        }
        if (JoinNode.lhsBeanHasFKForLocal11or1NPath(queryNode, string)) {
            return JoinNode.getTableAndFKColumnListForLocal11or1NPathFKonLHS(queryNode, string);
        }
        return JoinNode.getTableAndFKColumnListForLocal11or1NPathFKonRHS(queryNode, string);
    }

    private static List getTableAndFKColumnListForLocal11or1NPathFKonLHS(QueryNode queryNode, String string) throws IllegalExpressionException {
        String string2;
        Object object;
        String string3 = "JoinNode.getTableAndFKColumnListForLocal11or1NForPathFKonLHS";
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug(string3 + "  for path: '" + string + "'");
        }
        String string4 = JoinNode.chopLastFieldFromId(string);
        String string5 = JoinNode.getLastFieldFromId(string);
        JoinNode joinNode = queryNode.getJoinTree();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
        while (stringTokenizer.hasMoreTokens()) {
            object = (String)stringTokenizer.nextElement();
            if (joinNode.hasChild((String)object)) {
                joinNode = joinNode.getChild((String)object);
                continue;
            }
            throw new IllegalExpressionException(7, "Internal Error.  " + string3 + ": " + "Attempt to get CMR Table and Foreign Key Columns for " + "path: '" + string4 + ",  cmr-field: '" + string5 + "'.  Could not traverse the JoinTree for the path: '" + string4 + "'.  It's possible that this path has not been previously parsed.");
        }
        object = joinNode.getRDBMSBean();
        String string6 = ((RDBMSBean)object).getTableForCmrField(string5);
        if (string6 == null) {
            throw new IllegalExpressionException(7, "Internal Error.  " + string3 + ": " + "Could not get Table Name that contains the Foreign Keys for Bean: '" + ((RDBMSBean)object).getEjbName() + "'  and cmr-field: '" + string5 + "'");
        }
        String string7 = joinNode.getTableName();
        if (!string6.equals(string7)) {
            string2 = joinNode.getOtherTableNameAlias(string6);
            joinNode.forceInternalMultiTableJoin(queryNode, string6);
        } else {
            string2 = joinNode.getTableAlias();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string8 : ((RDBMSBean)object).getForeignKeyColNames(string5)) {
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(string3 + " adding entry: '" + string2 + "." + string8);
            }
            arrayList.add(string2 + "." + string8);
        }
        return arrayList;
    }

    private static List getTableAndFKColumnListForLocal11or1NPathFKonRHS(QueryNode queryNode, String string) throws IllegalExpressionException {
        String string2 = "JoinNode.getTableAndFKColumnListForLocal11or1NForPathFKonRHS";
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug(string2 + " for path: '" + string + "'");
        }
        if (string.indexOf(".") == -1) {
            throw new IllegalExpressionException(7, "Internal Error.  " + string2 + ": " + " the input pathExpression is required to represent at least 1 Relationship (between 2 Beans), " + "the pathExpression: '" + string + "' apparently does not.");
        }
        JoinNode joinNode = queryNode.getJoinTree();
        joinNode.parseJoin(string);
        String string3 = JoinNode.getLastFieldFromId(string);
        String string4 = JoinNode.chopLastFieldFromId(string);
        if (string4.length() < 1) {
            throw new IllegalExpressionException(7, "Internal Error.  " + string2 + ": " + " the input pathExpression is required to represent at least 1 Relationship (between 2 Beans), " + "the pathExpression: '" + string + "' apparently does not.");
        }
        JoinNode joinNode2 = JoinNode.getNode(joinNode, string4);
        RDBMSBean rDBMSBean = joinNode2.getRDBMSBean();
        JoinNode joinNode3 = JoinNode.getNode(joinNode, string);
        RDBMSBean rDBMSBean2 = joinNode3.getRDBMSBean();
        String string5 = rDBMSBean.getRelatedFieldName(string3);
        if (string5 == null) {
            throw new IllegalExpressionException(7, "Internal Error.  " + string2 + ": " + " for path: '" + string + "', for the cmr-field: '" + string3 + "', we could not get the RelatedFieldName from the Bean represented by the cmr-field: '" + string3 + "', that points back to the Previous Bean. ");
        }
        String string6 = rDBMSBean2.getTableForCmrField(string5);
        if (string6 == null) {
            throw new IllegalExpressionException(7, "Internal Error.  " + string2 + ": " + " for path: '" + string + "', for the cmr-field: '" + string3 + "', we could not get the name of the Table on Bean: '" + rDBMSBean2.getEjbName() + "' that holds the Foreign Key Columns for the Relationship.  " + "RelatedFieldName used for lookup was: '" + string5 + "'");
        }
        List list = rDBMSBean2.getForeignKeyColNames(string5);
        if (list == null) {
            throw new IllegalExpressionException(7, "Internal Error.  " + string2 + ": " + " for path: '" + string + "', for the cmr-field: '" + string3 + "', for Bean: '" + rDBMSBean2.getEjbName() + "' that holds the Foreign Key Columns for the Relationship.  " + "We could not get the Foreign Key Column Map for: RelatedFieldName '" + string5 + "'");
        }
        String string7 = joinNode3.getAnyTableNameAlias(string6);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string8 : list) {
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug(string2 + " adding entry: '" + string7 + "." + string8);
            }
            arrayList.add(string7 + "." + string8);
        }
        return arrayList;
    }

    public static int comparePaths(String string, String string2) {
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        if (string == null || string2 == null) {
            return -1;
        }
        StringTokenizer stringTokenizer3 = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer4 = new StringTokenizer(string2, ".");
        int n = stringTokenizer3.countTokens();
        int n2 = stringTokenizer4.countTokens();
        if (stringTokenizer3.countTokens() < stringTokenizer4.countTokens()) {
            stringTokenizer2 = stringTokenizer3;
            stringTokenizer = stringTokenizer4;
        } else {
            stringTokenizer2 = stringTokenizer4;
            stringTokenizer = stringTokenizer3;
        }
        while (stringTokenizer2.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer2.nextToken();
            if (string4.equals(string3 = stringTokenizer.nextToken())) continue;
            return -1;
        }
        if (stringTokenizer.hasMoreTokens()) {
            return 1;
        }
        return 0;
    }

    public static int countPathNodes(String string) {
        if (string == null) {
            return 0;
        }
        if (string.length() == 0) {
            return 0;
        }
        if (string.indexOf(".") == -1) {
            return 1;
        }
        int n = 1;
        int n2 = 0;
        while (n2 != -1) {
            if ((n2 = string.indexOf(".", n2)) == -1) continue;
            ++n;
            ++n2;
        }
        return n;
    }

    public static JoinNode getFirstNode(JoinNode joinNode, String string) throws IllegalExpressionException {
        String string2 = JoinNode.getFirstFieldFromId(string);
        return joinNode.getChild(string2);
    }

    public static JoinNode getNode(JoinNode joinNode, String string) throws IllegalExpressionException {
        if (JoinNode.endsInField(joinNode, string) || JoinNode.endsInRemoteInterface(joinNode, string)) {
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            } else {
                return joinNode;
            }
        }
        JoinNode joinNode2 = null;
        String string2 = "";
        JoinNode joinNode3 = joinNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = (String)stringTokenizer.nextElement();
            if (joinNode3.hasChild(string2)) {
                joinNode2 = joinNode3;
                joinNode3 = joinNode3.getChild(string2);
                continue;
            }
            RDBMSBean rDBMSBean = joinNode3.getRDBMSBean();
            String string3 = rDBMSBean.getCmpColumnForField(string2);
            if (string3 == null) {
                string3 = rDBMSBean.getCmpColumnForVariable(string2);
            }
            if (string3 != null) {
                throw new IllegalExpressionException(7, "called getNode on an pathExpression that ends with a Field: " + string);
            }
            throw new IllegalExpressionException(7, "called getNode on an unparsed pathExpression: " + string);
        }
        return joinNode3;
    }

    public static List createJoinListEntry(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    public static void markDoLeftOuterJoins(JoinNode joinNode, String string, String string2) throws IllegalExpressionException {
        if (JoinNode.countPathNodes(string) > JoinNode.countPathNodes(string2)) {
            throw new IllegalExpressionException(7, "Internal Error !  in doLeftOuterJoins.  The number of path elements in Start Path: '" + string + "', is greater than the number of path elements in the End Path '" + string2 + "'.");
        }
        JoinNode joinNode2 = JoinNode.getFirstNode(joinNode, string);
        if (joinNode2 == null) {
            throw new IllegalExpressionException(7, "Internal Error !  in doLeftOuterJoins.  Start Path: '" + string + "', does not start with the Alias of an Abstract Schema Name defined in the Query.");
        }
        String string3 = JoinNode.getFirstFieldFromId(string);
        JoinNode joinNode3 = JoinNode.getFirstNode(joinNode, string2);
        if (joinNode3 == null) {
            throw new IllegalExpressionException(7, "Internal Error !  in doLeftOuterJoins.  End Path: '" + string2 + "', does not start with the Alias of an Abstract Schema Name defined in the Query.");
        }
        String string4 = JoinNode.getFirstFieldFromId(string2);
        if (!string4.equals(string3)) {
            throw new IllegalExpressionException(7, "Internal Error !  in doLeftOuterJoins.  The Start Path: '" + string + "', begins with: '" + string3 + "'.  The End Path: '" + string2 + "', begins with: '" + string4 + "'.   The Start Path and End Path must begin with the same Root PathElement, " + "but they do not.");
        }
        int n = 0;
        int n2 = JoinNode.countPathNodes(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        JoinNode joinNode4 = joinNode;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            ++n;
            if ((joinNode4 = joinNode4.getChild(string5)) == null) {
                throw new IllegalExpressionException(7, "Internal Error !  in doLeftOuterJoins.   Start Path: '" + string + ", End Path: '" + string2 + ", at element number: '" + n + "', we could not get a JoinNode for path element: '" + string5 + "'");
            }
            if (n <= n2) continue;
            if (debugLogger.isDebugEnabled()) {
                JoinNode.debug("in path: '" + string2 + "', element " + n + ": '" + n + "', setting WHERE Clause Left Outer Join to 'True'.");
            }
            joinNode4.setDoLeftOuterJoin(true);
        }
        JoinNode.checkLeftOuterJoinCountSupported(joinNode);
    }

    public static boolean checkLeftOuterJoinCountSupported(JoinNode joinNode) throws IllegalExpressionException {
        int n = joinNode.getAllDoLeftOuterJoinCount();
        if (n <= 0) {
            return true;
        }
        Map map = joinNode.getChildren();
        Iterator iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            boolean bl;
            String string = (String)iterator.next();
            JoinNode joinNode2 = (JoinNode)map.get(string);
            int n2 = joinNode2.getRDBMSBean().getDatabaseType();
            boolean bl2 = bl = n > 1 ? RDBMSUtils.dbSupportForMultiLeftOuterJoin(n2) : RDBMSUtils.dbSupportForSingleLeftOuterJoin(n2);
            if (!bl) {
                Loggable loggable = EJBLogger.logCannotDoNOuterJoinForDBLoggable((int)n, (String)DDConstants.getDBNameForType(n2));
                throw new IllegalExpressionException(7, loggable.getMessage());
            }
        }
        return true;
    }

    public static List getTableAliasList(JoinNode joinNode) throws RDBMSException {
        ArrayList arrayList = new ArrayList();
        return joinNode.getTableAlias(arrayList);
    }

    public static List getTableAliasListFromChildren(JoinNode joinNode) throws RDBMSException {
        ArrayList arrayList = new ArrayList();
        Map map = joinNode.getChildren();
        for (JoinNode joinNode2 : map.values()) {
            joinNode2.getTableAlias(arrayList);
        }
        return arrayList;
    }

    public static RDBMSBean getTerminalBean(JoinNode joinNode, String string) throws IllegalExpressionException {
        JoinNode joinNode2 = JoinNode.getNode(joinNode, string);
        return joinNode2.getRDBMSBean();
    }

    public static String getFirstFieldFromId(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        int n = string.indexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getLastFieldFromId(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String chopLastFieldFromId(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static String getFirstNFieldsFromId(String string, int n) {
        if (string == null) {
            return "";
        }
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if ((n2 = string.indexOf(".", n2 + 1)) != -1) continue;
            return string;
        }
        if (n2 > string.length()) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static JoinNode makeJoinRoot(RDBMSBean rDBMSBean, QueryContext queryContext) {
        JoinNode joinNode = new JoinNode(null, "", rDBMSBean, "", "", -1, false, false, "", queryContext, new ArrayList());
        return joinNode;
    }

    private JoinNode newJoinNode(JoinNode joinNode, String string, RDBMSBean rDBMSBean, String string2, String string3, int n, boolean bl, boolean bl2, String string4, List list) {
        if (debugLogger.isDebugEnabled()) {
            JoinNode.debug(" new JoinNode: using QueryContext ");
        }
        return new JoinNode(joinNode, string, rDBMSBean, string2, string3, n, bl, bl2, string4, this.queryContext, list);
    }

    private static void debug(String string) {
        debugLogger.debug("[JoinNode] " + string);
    }

    private boolean isUseInnerJoin() {
        if (this.queryContext.getRDBMSBean() == null) {
            return false;
        }
        if (!this.queryContext.getRDBMSBean().isUseInnerJoin()) {
            return this.thisBean.isUseInnerJoin();
        }
        return true;
    }
}

