/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;

public final class ParamNode {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private RDBMSBean rbean;
    private String paramName;
    private int variableNumber;
    private Class classType;
    private String id;
    private String remoteHomeName;
    private boolean isBeanParam;
    private boolean isSelectInEntity;
    private Class primaryKeyClass;
    private boolean hasCompoundKey;
    private List paramSubList;
    private boolean isOracleNLSDataType;

    public ParamNode(RDBMSBean rDBMSBean, String string, int n, Class clazz, String string2, String string3, boolean bl, boolean bl2, Class clazz2, boolean bl3, boolean bl4) {
        this.rbean = rDBMSBean;
        this.paramName = string;
        this.variableNumber = n;
        this.classType = clazz;
        this.id = string2;
        this.remoteHomeName = string3;
        this.isBeanParam = bl;
        this.isSelectInEntity = bl2;
        this.primaryKeyClass = clazz2;
        this.hasCompoundKey = bl3;
        this.isOracleNLSDataType = bl4;
        if (debugLogger.isDebugEnabled()) {
            ParamNode.debug(" Created new Param Node for: " + string2 + ", variableNumber: " + n);
            ParamNode.debug(this.toString());
        }
    }

    public boolean isBeanParam() {
        return this.isBeanParam;
    }

    public boolean hasCompoundKey() {
        return this.hasCompoundKey;
    }

    public String getRemoteHomeName() {
        return this.remoteHomeName;
    }

    public String getId() {
        return this.id;
    }

    public Class getParamClass() {
        return this.classType;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void addParamSubList(ParamNode paramNode) {
        if (this.paramSubList == null) {
            this.paramSubList = new ArrayList();
        }
        this.paramSubList.add(paramNode);
    }

    public List getParamSubList() {
        if (this.paramSubList == null) {
            this.paramSubList = new ArrayList();
        }
        return this.paramSubList;
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public void setPrimaryKeyClass(Class clazz) {
        this.primaryKeyClass = clazz;
    }

    public RDBMSBean getRDBMSBean() {
        return this.rbean;
    }

    public boolean isSelectInEntity() {
        return this.isSelectInEntity;
    }

    public int getVariableNumber() {
        return this.variableNumber;
    }

    public boolean isOracleNLSDataType() {
        return this.isOracleNLSDataType;
    }

    public void setOracleNLSDataType(boolean bl) {
        this.isOracleNLSDataType = bl;
    }

    public String toString() {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n------------------------");
        stringBuffer.append("\n  ParamNode     name: " + this.paramName);
        stringBuffer.append("\n               class: " + this.classType.getName());
        stringBuffer.append("\n      variableNumber: " + this.variableNumber);
        stringBuffer.append("\n                  id: " + this.id);
        stringBuffer.append("\n      remoteHomeName: " + this.remoteHomeName);
        stringBuffer.append("\n         isBeanParam: " + (this.isBeanParam ? "true" : "false"));
        stringBuffer.append("\n    isSelectInEntity: " + (this.isSelectInEntity ? "true" : "false"));
        stringBuffer.append("\n     primaryKeyClass: " + this.primaryKeyClass);
        stringBuffer.append("\n      hasCompoundKey: " + (this.hasCompoundKey ? "true" : "false"));
        stringBuffer.append("\n");
        if (this.paramSubList != null && (iterator = this.paramSubList.iterator()).hasNext()) {
            stringBuffer.append("  ----------- subList ------");
            while (iterator.hasNext()) {
                ParamNode paramNode = (ParamNode)iterator.next();
                stringBuffer.append(paramNode.toString());
            }
        }
        return stringBuffer.toString();
    }

    public static void addInVariableOrder(List list, ParamNode paramNode) {
        Iterator iterator = list.iterator();
        int n = list.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ParamNode paramNode2 = (ParamNode)list.get(i);
            if (paramNode.getVariableNumber() < paramNode2.getVariableNumber()) {
                list.add(i, paramNode);
                bl = true;
            }
            if (bl) break;
        }
        if (!bl) {
            list.add(paramNode);
        }
    }

    public static List listInVariableOrder(List list) {
        Iterator iterator = list.iterator();
        ArrayList<ParamNode> arrayList = new ArrayList<ParamNode>();
        boolean bl = false;
        while (iterator.hasNext()) {
            ParamNode paramNode = (ParamNode)iterator.next();
            int n = arrayList.size();
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < n; ++i) {
                ParamNode paramNode2 = (ParamNode)arrayList.get(i);
                if (paramNode.getVariableNumber() < paramNode2.getVariableNumber()) {
                    arrayList.add(i, paramNode);
                    bl3 = true;
                }
                if (bl3) break;
            }
            if (bl3) continue;
            arrayList.add(paramNode);
        }
        return arrayList;
    }

    private static void debug(String string) {
        debugLogger.debug("[ParamNode] " + string);
    }
}

