/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.finders.BaseExpr;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.ExprAND;
import weblogic.ejb.container.cmp.rdbms.finders.ExprID;
import weblogic.ejb.container.cmp.rdbms.finders.ExprNOT;
import weblogic.ejb.container.cmp.rdbms.finders.ExprOR;
import weblogic.ejb.container.cmp.rdbms.finders.ExprROOT;
import weblogic.ejb.container.cmp.rdbms.finders.ExprWHERE;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.cmp.rdbms.finders.QueryNode;
import weblogic.ejb.container.cmp.rdbms.finders.RewriteEjbqlNOT;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb20.cmp.rdbms.finders.EJBQLCompilerException;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public class QueryContext {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private static RewriteEjbqlNOT notRewriter = new RewriteEjbqlNOT();
    private RDBMSBean bean;
    private EjbqlFinder finder;
    private Expr exprTree;
    private QueryNode queryTree;
    private Map tableAliasMap;
    private int tableAliasCount;
    private List tableAliasExclusionList;
    private String ejbqlErrorString;
    private String ejbqlErrorStar;
    private Map idAliasMap;
    private String originalEjbql;
    private boolean ejbqlRewritten = false;
    private int ejbqlRewrittenReasons = 0;
    private ErrorCollectionException warnings;

    public QueryContext(RDBMSBean rDBMSBean, EjbqlFinder ejbqlFinder, Expr expr) {
        this.bean = rDBMSBean;
        this.finder = ejbqlFinder;
        this.exprTree = expr;
        this.tableAliasMap = new HashMap();
        this.tableAliasExclusionList = new ArrayList();
        JoinNode joinNode = JoinNode.makeJoinRoot(this.bean, this);
        this.queryTree = new QueryNode(this.finder, this, null, joinNode);
    }

    public void generateQuery() throws EJBQLCompilerException {
        try {
            this.originalEjbql = ((ExprROOT)this.exprTree).getEJBQLText();
            this.factorOutNOT();
            this.setupForORCrossProducts();
            this.exprTree.init(this, this.getMainQueryTree());
            this.exprTree.calculate();
        }
        catch (ErrorCollectionException errorCollectionException) {
            EJBQLCompilerException eJBQLCompilerException = this.newEJBQLCompilerException((Exception)((Object)errorCollectionException));
            if (debugLogger.isDebugEnabled()) {
                QueryContext.debug("\n\n\n\n");
                QueryContext.debug(" generateQuery() encountered Exception, process Exceptions !");
                String string = eJBQLCompilerException.getMessage();
                QueryContext.debug(string + "\n\n");
                QueryContext.debug("\n\n\n\n");
            }
            throw eJBQLCompilerException;
        }
    }

    private void factorOutNOT() throws ErrorCollectionException {
        if (!RewriteEjbqlNOT.hasNOTExpr((BaseExpr)this.exprTree)) {
            return;
        }
        this.ejbqlRewritten = true;
        this.ejbqlRewrittenReasons |= 1;
        if (debugLogger.isDebugEnabled()) {
            QueryContext.debug("\n\n -----------  finder: '" + this.finder.getName() + "'");
            QueryContext.debug("\n\n------------------------------------------QueryContext finder method '" + this.finder.getName() + "' before rewriteNOT \n");
            QueryContext.debug(this.exprTree.dumpString());
            QueryContext.debug("\n");
        }
        this.exprTree = RewriteEjbqlNOT.rewriteEjbqlNOT((ExprROOT)this.exprTree, debugLogger.isDebugEnabled());
        if (debugLogger.isDebugEnabled()) {
            QueryContext.debug("\n\n QueryContext finder method '" + this.finder.getName() + "' after rewriteNOT \n");
            QueryContext.debug(this.exprTree.dumpString());
            QueryContext.debug("\n");
            QueryContext.debug("--------------------------------------------");
        }
    }

    public String getWhereSql() throws IllegalExpressionException {
        try {
            return ((ExprROOT)this.exprTree).getWhereSql();
        }
        catch (ErrorCollectionException errorCollectionException) {
            EJBQLCompilerException eJBQLCompilerException = this.newEJBQLCompilerException((Exception)((Object)errorCollectionException));
            if (debugLogger.isDebugEnabled()) {
                QueryContext.debug("\n\n\n\n");
                QueryContext.debug(" getWhereSql() encountered Exception !, process Exceptions !");
                String string = eJBQLCompilerException.getMessage();
                QueryContext.debug(string + "\n\n");
                QueryContext.debug("\n\n\n");
            }
            throw new IllegalExpressionException(7, eJBQLCompilerException.getMessage());
        }
    }

    boolean getEjbqlRewritten() {
        return this.ejbqlRewritten;
    }

    int getEjbqlRewrittenReasons() {
        return this.ejbqlRewrittenReasons;
    }

    String getOriginalEjbql() {
        return this.originalEjbql;
    }

    public List getSQLGenEJBQLTokenList() {
        return ((ExprROOT)this.exprTree).getEJBQLTokenList();
    }

    public void addWarning(Exception exception) {
        if (this.warnings == null) {
            this.warnings = new ErrorCollectionException((Throwable)exception);
            return;
        }
        this.warnings.add((Throwable)exception);
    }

    public ErrorCollectionException getWarnings() {
        return this.warnings;
    }

    private EJBQLCompilerException newEJBQLCompilerException(Exception exception) {
        return this.finder.newEJBQLCompilerException(exception, this);
    }

    public QueryNode getMainQueryTree() {
        return this.queryTree;
    }

    private void setupForORCrossProducts() {
        List list = ((ExprROOT)this.exprTree).getWHEREList();
        for (ExprWHERE exprWHERE : list) {
            Expr expr = exprWHERE.getTerm1();
            if (expr == null) continue;
            if (debugLogger.isDebugEnabled()) {
                QueryContext.debug("  setup FirstOR for WHERE " + exprWHERE.printEJBQLTree());
            }
            this.findAndSetupFirstOR(expr);
        }
    }

    private void findAndSetupFirstOR(Expr expr) {
        if (expr instanceof ExprNOT) {
            expr = expr.getTerm1();
        }
        if (!(expr instanceof ExprOR) && !(expr instanceof ExprAND)) {
            return;
        }
        if (expr instanceof ExprOR) {
            if (debugLogger.isDebugEnabled()) {
                QueryContext.debug("findAndSetupFirstOR GOT TOPMOST OR for subtree.  setting ORJoinDataList for OR " + expr.printEJBQLTree());
            }
            ArrayList arrayList = new ArrayList();
            ((ExprOR)expr).setOrJoinDataList(arrayList);
            Expr expr2 = expr.getTerm1();
            this.markORSubTree(arrayList, expr2);
            expr2 = expr.getTerm2();
            this.markORSubTree(arrayList, expr2);
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            QueryContext.debug(" findAndSetupFirstOR  term not OR, descend Left and Right ");
        }
        Expr expr3 = expr.getTerm1();
        this.findAndSetupFirstOR(expr3);
        expr3 = expr.getTerm2();
        this.findAndSetupFirstOR(expr3);
    }

    private void markORSubTree(List list, Expr expr) {
        if (!(expr instanceof ExprOR) && !(expr instanceof ExprAND)) {
            return;
        }
        if (expr instanceof ExprOR) {
            if (debugLogger.isDebugEnabled()) {
                QueryContext.debug("markORSubTree    OR found setOrJoinDataList on " + expr.printEJBQLTree());
            }
            ((ExprOR)expr).setOrJoinDataList(list);
        }
        Expr expr2 = expr.getTerm1();
        this.markORSubTree(list, expr2);
        expr2 = expr.getTerm2();
        this.markORSubTree(list, expr2);
    }

    public QueryNode newQueryNode(QueryNode queryNode, int n) {
        return QueryNode.newQueryNode(this.getFinder(), this, queryNode, n);
    }

    public List getMainQuerySelectList() {
        return this.queryTree.getSelectList();
    }

    public List getMainQuerySelectListForCachingElement() {
        return this.queryTree.getSelectListForCachingElement();
    }

    public boolean mainQueryContainsInSelectListForCachingElement(RDBMSBean rDBMSBean, RDBMSBean rDBMSBean2) {
        return this.queryTree.containsInSelectListForCachingElement(rDBMSBean, rDBMSBean2);
    }

    public JoinNode getRootJoinNodeForMainQuery(String string) throws IllegalExpressionException {
        return this.queryTree.getJoinNodeForFirstId(string);
    }

    public JoinNode getJoinTreeForMainQuery() {
        return this.queryTree.getJoinTree();
    }

    public List getTableAliasExclusionListForMainQuery() {
        return this.queryTree.getTableAliasExclusionList();
    }

    public List getTableAndFKColumnListForLocal11or1NPath(QueryNode queryNode, String string) throws IllegalExpressionException {
        return JoinNode.getTableAndFKColumnListForLocal11or1NPath(queryNode, string);
    }

    public List getTableAndFKColumnListForLocal11or1NPathForMainQuery(String string) throws IllegalExpressionException {
        return JoinNode.getTableAndFKColumnListForLocal11or1NPath(this.queryTree, string);
    }

    public String getMainQueryJoinBuffer() throws IllegalExpressionException {
        return this.queryTree.getMainORJoinBuffer();
    }

    public RDBMSBean getRDBMSBean() {
        return this.bean;
    }

    public EjbqlFinder getFinder() {
        return this.finder;
    }

    public String getEjbName() {
        return this.bean.getEjbName();
    }

    public int getDatabaseType() {
        return this.bean.getDatabaseType();
    }

    public Map getGlobalTableAliasMap() {
        return this.tableAliasMap;
    }

    String getTableNameForAlias(String string) {
        return (String)this.getGlobalTableAliasMap().get(string);
    }

    String getAliasForTableName(String string) {
        String string2 = null;
        String string3 = null;
        Iterator iterator = this.tableAliasMap.keySet().iterator();
        while (iterator.hasNext() && !(string3 = (String)this.tableAliasMap.get(string2 = (String)iterator.next())).equals(string)) {
        }
        return string2;
    }

    public String getFinderMethodName() {
        return this.finder.getName();
    }

    public Class getFinderParameterTypeAt(int n) {
        return this.finder.getParameterTypeAt(n);
    }

    public boolean queryIsSelect() {
        return this.finder.isSelect();
    }

    public boolean queryIsSelectInEntity() {
        return this.finder.isSelectInEntity();
    }

    public boolean isKeyFinder() {
        return this.finder.isKeyFinder();
    }

    public void setQueryIsSelectThisBean() {
        this.finder.setQueryType(2);
    }

    public boolean getQueryIsSelectThisBean() {
        return this.finder.getQueryType() == 2;
    }

    public void setQueryIsSelectLocalBean() {
        this.finder.setQueryType(4);
    }

    public boolean getQueryIsSelectLocalBean() {
        return this.finder.getQueryType() == 4;
    }

    public void setQueryIsSelectThisBeanField() {
        this.finder.setQueryType(3);
    }

    public void setQueryIsSelectLocalBeanField() {
        this.finder.setQueryType(5);
    }

    public void setQueryIsFinderLocalBean() {
        this.finder.setQueryType(0);
    }

    public boolean getQueryIsFinderLocalBean() {
        return this.finder.getQueryType() == 0;
    }

    public void setQuerySelectBeanTarget(RDBMSBean rDBMSBean) {
        this.finder.setSelectBeanTarget(rDBMSBean);
    }

    public void setQuerySelectFieldTableAndColumn(String string) {
        this.finder.setSelectFieldColumn(string);
    }

    public void setQuerySelectFieldClass(Class clazz) {
        this.finder.setSelectFieldClass(clazz);
    }

    public String registerTable(String string) {
        String string2 = "WL" + this.tableAliasCount++;
        this.tableAliasMap.put(string2, string);
        return string2;
    }

    public void addFinderInternalQueryParmList(ParamNode paramNode) {
        this.finder.addInternalQueryParmList(paramNode);
    }

    public void addFinderRemoteBeanParamList(ParamNode paramNode) {
        this.finder.addRemoteBeanParamList(paramNode);
    }

    public void setFinderRemoteBeanCommandEQ(boolean bl) {
        if (bl) {
            this.finder.setRemoteBeanCommand(2);
        } else {
            this.finder.setRemoteBeanCommand(3);
        }
    }

    public String replaceIdAliases(String string) {
        if (string == null) {
            return null;
        }
        if (this.idAliasMap == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            String string4 = (String)this.idAliasMap.get(string2);
            if (string4 != null) {
                string3 = string4;
            }
            stringBuffer.append(string3);
            stringBuffer.append(".");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void addIdAlias(String string, String string2) throws IllegalExpressionException {
        if (this.idAliasMap == null) {
            this.idAliasMap = new HashMap();
        }
        if (this.idAliasMap.get(string) != null) {
            throw new IllegalExpressionException(7, " Correlation variable '" + string2 + "' is defined more than once ", new DescriptorErrorInfo("<ejb-ql>", (Object)this.bean.getEjbName(), (Object)this.finder.getName()));
        }
        this.idAliasMap.put(string, string2);
    }

    public void addGlobalRangeVariable(String string, String string2) throws IllegalExpressionException {
        this.finder.addGlobalRangeVariable(string, string2);
    }

    public int globalRangeVariableMapSize() {
        return this.finder.globalRangeVariableMapSize();
    }

    public String getGlobalRangeVariableMap(String string) throws IllegalExpressionException {
        return this.finder.getGlobalRangeVariableMap(string);
    }

    public List getGlobalRangeVariableMapIdList() {
        return this.finder.getGlobalRangeVariableMapIdList();
    }

    public List getIDsFromGlobalRangeVariableMapForSchema(String string) {
        return this.finder.getIDsFromGlobalRangeVariableMapForSchema(string);
    }

    public boolean identifierIsRangeVariable(String string) {
        String string2 = null;
        try {
            string2 = this.finder.getGlobalRangeVariableMap(string);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            return false;
        }
        return string2 != null;
    }

    public boolean pathExpressionEndsInField(QueryNode queryNode, String string) throws IllegalExpressionException {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        JoinNode joinNode = queryNode.getJoinTreeForId(string);
        if (joinNode == null) {
            String string2 = JoinNode.getFirstFieldFromId(string);
            throw new IllegalExpressionException(7, "The pathExpression/Identifier '" + string + "', contains a root: '" + string2 + "' that is not defined in an AS declaration " + "in the FROM clause.");
        }
        String string3 = this.replaceIdAliases(string);
        return JoinNode.endsInField(joinNode, string3);
    }

    public boolean pathExpressionEndsInRemoteInterface(QueryNode queryNode, String string) throws IllegalExpressionException {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        JoinNode joinNode = queryNode.getJoinTreeForId(string);
        if (joinNode == null) {
            String string2 = JoinNode.getFirstFieldFromId(string);
            throw new IllegalExpressionException(7, "The pathExpression/Identifier '" + string + "', contains a root: '" + string2 + "' that is not defined in an AS declaration " + "in the FROM clause.");
        }
        String string3 = this.replaceIdAliases(string);
        return JoinNode.endsInRemoteInterface(joinNode, string3);
    }

    public String getTableAndColumnFromMainQuery(String string) throws IllegalExpressionException {
        String string2 = null;
        try {
            string2 = ExprID.calcTableAndColumn(this, this.getMainQueryTree(), string);
        }
        catch (Exception exception) {
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(7, exception.getMessage());
            throw illegalExpressionException;
        }
        return string2;
    }

    String getFROMClauseSelectForUpdate(int n) {
        return RDBMSUtils.getFROMClauseSelectForUpdate(this.bean.getDatabaseType(), n);
    }

    public String getMainJoinBuffer() throws IllegalExpressionException {
        return this.queryTree.getMainORJoinBuffer();
    }

    public void setMainQuerySelectDistinct() {
        this.finder.setSelectDistinct(true);
    }

    public void setOrderbyColBuf(String string) {
        this.finder.setOrderbyColBuf(string);
    }

    public void setOrderbySql(String string) {
        this.finder.setOrderbySql(string);
    }

    public void setGroupbySql(String string) {
        this.finder.setGroupbySql(string);
    }

    public void setSelectHint(String string) {
        this.finder.setSelectHint(string);
    }

    public boolean isResultSetFinder() {
        return this.finder.isResultSetFinder();
    }

    public void setMainQueryResultSetFinder() {
        this.queryTree.setQueryType(6);
    }

    public String getRelationshipCachingName() {
        return this.finder.getCachingName();
    }

    JoinNode makeTrialJoinRoot(JoinNode joinNode, String string) throws IllegalExpressionException {
        if (string == null) {
            throw new IllegalExpressionException(7, " <cmr-field> " + string + " could not get RDBMSBean ! ");
        }
        QueryContext queryContext = new QueryContext(this.bean, this.finder, this.exprTree);
        JoinNode joinNode2 = new JoinNode(null, "", this.bean, "", "", -1, false, false, "", queryContext, new ArrayList());
        String string2 = JoinNode.getFirstFieldFromId(string);
        JoinNode joinNode3 = JoinNode.getFirstNode(joinNode, string);
        String string3 = joinNode3.getTableName();
        String string4 = queryContext.registerTable(string3);
        if (debugLogger.isDebugEnabled()) {
            QueryContext.debug(" makeTrialJoinRoot:  added 1st child JoinNode to trialRoot.  id: '" + string + "', the child JoinNode cmr-field was: '" + joinNode3.getPrevCMRField() + "', the child tableName is: '" + string3 + "', the child tableNameAlias is: '" + string4 + "'");
        }
        JoinNode joinNode4 = new JoinNode(joinNode2, string2, joinNode3.getRDBMSBean(), string3, string4, -1, false, false, "", queryContext, new ArrayList());
        joinNode2.putChild(string2, joinNode4);
        return joinNode2;
    }

    public void addFinderBeanInputParameter(int n, RDBMSBean rDBMSBean) throws IllegalExpressionException {
        Class clazz = this.finder.getParameterTypeAt(n - 1);
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        List list = rDBMSBean.getPrimaryKeyFields();
        boolean bl = cMPBeanDescriptor.hasComplexPrimaryKey();
        Class clazz2 = null;
        if (bl) {
            clazz2 = cMPBeanDescriptor.getPrimaryKeyClass();
        }
        String string = "param" + (n - 1);
        ParamNode paramNode = new ParamNode(rDBMSBean, string, n, clazz, "", "", true, false, clazz2, bl, false);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)list.get(i);
            clazz2 = cMPBeanDescriptor.getFieldClass(string2);
            if (clazz2 == null) {
                if (debugLogger.isDebugEnabled()) {
                    QueryContext.debug("  PK CLASS: " + string2 + " is NULL !!!!");
                }
                Loggable loggable = EJBLogger.logfinderNoPKClassForFieldLoggable((String)string2);
                throw new IllegalExpressionException(7, "Bean: " + rDBMSBean.getEjbName() + " " + loggable.getMessage());
            }
            boolean bl2 = this.isOracleNLSDataType(string2);
            if (i == 0 && !bl) {
                paramNode.setPrimaryKeyClass(clazz2);
                paramNode.setOracleNLSDataType(bl2);
            }
            ParamNode paramNode2 = new ParamNode(rDBMSBean, "N_A", n, clazz2, string2, "", false, false, clazz2, false, bl2);
            paramNode.addParamSubList(paramNode2);
        }
        this.finder.addInternalQueryParmList(paramNode);
    }

    public ExprID setupForLHSForeignKeysWithNoReferenceToRHS(ExprID exprID) throws ErrorCollectionException {
        int n;
        QueryNode queryNode = exprID.getQueryTree();
        if (queryNode == null) {
            throw new ErrorCollectionException("Internal Error, setupForLHSForeignKeysWithNoReferenceToRHS called with ExprID before ExprID.init() has been called.  queryTree is NULL.");
        }
        try {
            n = queryNode.getRelationshipTypeForPathExpressionWithNoSQLGen(exprID.getDealiasedEjbqlID());
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
        if (n != 2 && n != 5) {
            throw new ErrorCollectionException("Internal Error, setupForLHSForeignKeysWithNoReferenceToRHS called with ExprID  which is not a relationship of type: 'RDBMSUtils.ONE_TO_ONE_RELATION_FK_ON_LHS' or 'RDBMSUtils.MANY_TO_ONE_RELATION', type is: '" + RDBMSUtils.relationshipTypeToString(n));
        }
        String string = QueryContext.getLastFieldFromId(exprID.getDealiasedEjbqlID());
        ExprID exprID2 = this.prepareTruncatedPathExpression(queryNode, exprID.getDealiasedEjbqlID());
        JoinNode joinNode = null;
        try {
            joinNode = queryNode.getJoinNodeForLastId(exprID2.getDealiasedEjbqlID());
            RDBMSBean rDBMSBean = joinNode.getRDBMSBean();
            String string2 = rDBMSBean.getTableForCmrField(string);
            joinNode.forceInternalMultiTableJoinMaybe(queryNode, string2);
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
        return exprID2;
    }

    public ExprID setupForLHSPrimaryKeysWithNoReferenceToRHS(ExprID exprID) throws ErrorCollectionException {
        int n;
        QueryNode queryNode = exprID.getQueryTree();
        if (queryNode == null) {
            throw new ErrorCollectionException("Internal Error, setupForLHSPrimaryKeysWithNoReferenceToRHS called with ExprID before ExprID.init() has been called.  queryTree is NULL.");
        }
        try {
            n = queryNode.getRelationshipTypeForPathExpressionWithNoSQLGen(exprID.getDealiasedEjbqlID());
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
        if (n != 4 && n != 6 && n != 8) {
            throw new ErrorCollectionException("Internal Error, setupForLHSPrimaryKeysWithNoReferenceToRHS called with ExprID  which is not a relationship of type: 'RDBMSUtils.ONE_TO_MANY_RELATION' or 'RDBMSUtils.MANY_TO_MANY_RELATION' or 'RDBMSUtils.REMOTE_RELATION_W_JOIN_TABLE', type is: '" + RDBMSUtils.relationshipTypeToString(n));
        }
        String string = QueryContext.getLastFieldFromId(exprID.getDealiasedEjbqlID());
        ExprID exprID2 = this.prepareTruncatedPathExpression(queryNode, exprID.getDealiasedEjbqlID());
        return exprID2;
    }

    private ExprID prepareTruncatedPathExpression(QueryNode queryNode, String string) throws ErrorCollectionException {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            Loggable loggable = EJBLogger.logFinderNotNullOnBadPathLoggable((String)string);
            throw new ErrorCollectionException(loggable.getMessage());
        }
        String string2 = string.substring(0, n);
        ExprID exprID = ExprID.newInitExprID(this, queryNode, string2);
        exprID.prepareIdentifierForSQLGen();
        return exprID;
    }

    public boolean isOracleNLSDataType(String string) {
        return RDBMSUtils.isOracleNLSDataType(this.bean, this.replaceIdAliases(string), this.finder.getGlobalRangeVariableMap());
    }

    public static String getFirstFieldFromId(String string) {
        return JoinNode.getFirstFieldFromId(string);
    }

    public static String getLastFieldFromId(String string) {
        return JoinNode.getLastFieldFromId(string);
    }

    public static Class getInterfaceClass(RDBMSBean rDBMSBean) {
        CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
        if (cMPBeanDescriptor.hasLocalClientView()) {
            return cMPBeanDescriptor.getLocalInterfaceClass();
        }
        return cMPBeanDescriptor.getRemoteInterfaceClass();
    }

    private static void debug(String string) {
        debugLogger.debug("[QueryContext] " + string);
    }
}

