/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.finders.EjbqlFinder;
import weblogic.ejb.container.cmp.rdbms.finders.Expr;
import weblogic.ejb.container.cmp.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp.rdbms.finders.JoinNode;
import weblogic.ejb.container.cmp.rdbms.finders.ORJoinData;
import weblogic.ejb.container.cmp.rdbms.finders.QueryContext;
import weblogic.ejb.container.cmp.rdbms.finders.SelectNode;
import weblogic.logging.Loggable;
import weblogic.utils.Debug;

public class QueryNode {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    static EJBTextTextFormatter fmt = new EJBTextTextFormatter();
    private EjbqlFinder finder = null;
    private QueryContext queryContext = null;
    private int queryId;
    private QueryNode parent = null;
    private List children = null;
    private int queryType;
    private Map rangeVariableMap = null;
    private Set collectionMemberSet = null;
    private JoinNode joinTree = null;
    private List selectList = null;
    private List selectListForCachingElement = null;
    private List tableAliasExclusionList = null;
    private int ORcount = 0;
    private Stack orJoinDataStack;
    private ORJoinData mainOrJoinData;
    private List orJoinDataListList;

    public QueryNode(EjbqlFinder ejbqlFinder, QueryContext queryContext, QueryNode queryNode, JoinNode joinNode, int n) {
        this.finder = ejbqlFinder;
        this.queryContext = queryContext;
        this.parent = queryNode;
        this.children = new ArrayList();
        this.rangeVariableMap = new HashMap();
        this.collectionMemberSet = new HashSet();
        this.joinTree = joinNode;
        this.selectList = new ArrayList();
        this.selectListForCachingElement = new ArrayList();
        this.tableAliasExclusionList = new ArrayList();
        this.queryId = n;
        this.orJoinDataStack = new Stack();
        this.mainOrJoinData = new ORJoinData();
        this.orJoinDataStack.push(this.mainOrJoinData);
        if (queryNode != null) {
            queryNode.addChild(this);
        }
    }

    public QueryNode(EjbqlFinder ejbqlFinder, QueryContext queryContext, QueryNode queryNode, JoinNode joinNode) {
        this(ejbqlFinder, queryContext, queryNode, joinNode, 0);
    }

    public boolean isMainQuery() {
        return this.parent == null;
    }

    public QueryNode getParent() {
        Debug.assertion((this.parent != null ? 1 : 0) != 0);
        return this.parent;
    }

    public void addChild(QueryNode queryNode) {
        this.children.add(queryNode);
    }

    public Iterator getChildrenIterator() {
        return this.children.iterator();
    }

    public void setQueryType(int n) {
        this.queryType = n;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void addRangeVariable(String string, String string2) throws IllegalExpressionException {
        if (this.rangeVariableMap == null) {
            this.rangeVariableMap = new HashMap();
        }
        if (this.rangeVariableMap.containsKey(string)) {
            Loggable loggable = EJBLogger.logduplicateAsDefinitionLoggable((String)string);
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        this.rangeVariableMap.put(string, string2);
    }

    public int rangeVariableMapSize() {
        if (this.rangeVariableMap == null) {
            this.rangeVariableMap = new HashMap();
        }
        return this.rangeVariableMap.size();
    }

    public String getRangeVariableMap(String string) {
        if (this.rangeVariableMap == null) {
            return null;
        }
        return (String)this.rangeVariableMap.get(string);
    }

    public List getRangeVariableMapIdList() {
        ArrayList arrayList = new ArrayList();
        if (this.rangeVariableMap == null) {
            return arrayList;
        }
        Iterator iterator = this.rangeVariableMap.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public List getIDsFromRangeVariableMapForSchema(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.rangeVariableMap == null) {
            return arrayList;
        }
        for (String string2 : this.rangeVariableMap.keySet()) {
            String string3 = (String)this.rangeVariableMap.get(string2);
            if (!string3.equals(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void addCollectionMember(String string) throws IllegalExpressionException {
        if (this.collectionMemberSet.contains(string)) {
            Loggable loggable = EJBLogger.logduplicateCollectionMemberDefinitionLoggable((String)string);
            throw new IllegalExpressionException(7, loggable.getMessage());
        }
        this.collectionMemberSet.add(string);
    }

    public boolean containsCollectionMember(String string) {
        if (string == null) {
            return false;
        }
        if (JoinNode.countPathNodes(string) != 1) {
            return false;
        }
        return this.collectionMemberSet.contains(string);
    }

    public boolean isCollectionMemberInScope(String string) {
        QueryNode queryNode = null;
        try {
            queryNode = this.getQueryNodeForCollectionMember(string);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            return false;
        }
        return queryNode != null;
    }

    public QueryNode getQueryNodeForCollectionMember(String string) throws IllegalExpressionException {
        if (this.containsCollectionMember(string)) {
            return this;
        }
        if (this.parent == null) {
            throw new IllegalExpressionException(5, "Error, attempt to reference a Collection Member Identifier, '" + string + "' that is outside of the scope of it's query or subquery.");
        }
        return this.parent.getQueryNodeForCollectionMember(string);
    }

    public boolean isRangeVariableInScope(String string) {
        if (string == null) {
            return false;
        }
        if (JoinNode.countPathNodes(string) != 1) {
            return false;
        }
        QueryNode queryNode = null;
        try {
            queryNode = this.getQueryNodeForId(string);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            return false;
        }
        return queryNode != null;
    }

    public boolean thisQueryNodeOwnsId(String string) {
        String string2 = JoinNode.getFirstFieldFromId(string);
        return this.getRangeVariableMap(string2) != null;
    }

    public QueryNode getQueryNodeForId(String string) throws IllegalExpressionException {
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug("\n About to search for joinTree that owns: " + string);
        }
        String string2 = this.queryContext.replaceIdAliases(string);
        String string3 = JoinNode.getFirstFieldFromId(string2);
        QueryNode queryNode = null;
        try {
            queryNode = this.getQueryNodeForRangeVariableID(string3);
        }
        catch (IllegalExpressionException illegalExpressionException) {
            if (illegalExpressionException.getErrorCode() == 5) {
                Loggable loggable = EJBLogger.logpathExpressionNotInContextOfQueryTreeLoggable((String)string2, (String)string3);
                IllegalExpressionException illegalExpressionException2 = new IllegalExpressionException(5, loggable.getMessage());
                throw illegalExpressionException2;
            }
            throw illegalExpressionException;
        }
        return queryNode;
    }

    public QueryNode getQueryNodeForRangeVariableID(String string) throws IllegalExpressionException {
        if (this.getRangeVariableMap(string) != null) {
            return this;
        }
        if (this.parent == null) {
            throw new IllegalExpressionException(5, "Error, attempt to reference a path expression, '" + string + "' that is outside of the scope of it's query or subquery.");
        }
        return this.parent.getQueryNodeForRangeVariableID(string);
    }

    public JoinNode getJoinTreeForId(String string) throws IllegalExpressionException {
        QueryNode queryNode = this.getQueryNodeForId(string);
        if (queryNode == null) {
            return null;
        }
        return queryNode.getJoinTree();
    }

    public JoinNode getJoinNodeForFirstId(String string) throws IllegalExpressionException {
        JoinNode joinNode = this.getJoinTreeForId(string);
        return JoinNode.getFirstNode(joinNode, string);
    }

    public JoinNode getJoinNodeForLastId(String string) throws IllegalExpressionException {
        this.prepareIdentifierForSQLGen(string);
        JoinNode joinNode = this.getJoinTreeForId(string);
        return JoinNode.getNode(joinNode, string);
    }

    public JoinNode getJoinTree() {
        return this.joinTree;
    }

    public void prepareIdentifierForSQLGen(String string) throws IllegalExpressionException {
        String string2 = this.queryContext.replaceIdAliases(string);
        String string3 = JoinNode.getFirstFieldFromId(string);
        QueryNode queryNode = this.getQueryNodeForId(string2);
        if (queryNode == null) {
            Loggable loggable = EJBLogger.logpathExpressionNotInContextOfQueryTreeLoggable((String)string, (String)string3);
            IllegalExpressionException illegalExpressionException = new IllegalExpressionException(5, loggable.getMessage());
        }
        this.parseJoin(string2);
        queryNode.replaceORPathMaybe(string2);
    }

    private void parseJoin(String string) throws IllegalExpressionException {
        JoinNode joinNode = this.getJoinTreeForId(string);
        if (joinNode == null) {
            String string2 = JoinNode.getFirstFieldFromId(string);
            Loggable loggable = EJBLogger.logidNotDefinedInAsDeclarationLoggable((String)string, (String)string2);
            throw new IllegalExpressionException(5, loggable.getMessage());
        }
        joinNode.parseJoin(string);
    }

    public void addSelectList(SelectNode selectNode) {
        this.selectList.add(selectNode);
    }

    public List getSelectList() {
        return this.selectList;
    }

    public SelectNode selectListRootMatch(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 0) {
            return null;
        }
        String string2 = this.finder.replaceCorrVars(string);
        String string3 = JoinNode.getFirstFieldFromId(string2);
        List list = this.getSelectList();
        for (SelectNode selectNode : list) {
            String string4 = selectNode.getSelectTarget();
            String string5 = this.finder.replaceCorrVars(string4);
            String string6 = JoinNode.getFirstFieldFromId(string5);
            if (!string6.equals(string3)) continue;
            return selectNode;
        }
        return null;
    }

    public void addSelectListForCachingElement(SelectNode selectNode) {
        this.selectListForCachingElement.add(selectNode);
    }

    public List getSelectListForCachingElement() {
        return this.selectListForCachingElement;
    }

    public boolean containsInSelectListForCachingElement(SelectNode selectNode) {
        return this.selectListForCachingElement.contains(selectNode);
    }

    public boolean containsInSelectListForCachingElement(RDBMSBean rDBMSBean, RDBMSBean rDBMSBean2) {
        for (SelectNode selectNode : this.selectListForCachingElement) {
            RDBMSBean rDBMSBean3 = selectNode.getSelectBean();
            if (rDBMSBean != rDBMSBean3 && rDBMSBean2 != rDBMSBean3) continue;
            return true;
        }
        return false;
    }

    public void addTableAliasExclusionList(String string) {
        if (this.tableAliasExclusionList == null) {
            this.tableAliasExclusionList = new ArrayList();
        }
        this.tableAliasExclusionList.add(string);
    }

    public List getTableAliasExclusionList() {
        return this.tableAliasExclusionList;
    }

    public Set getTableNameSetMinusExcluded() throws IllegalExpressionException {
        return this.getTableInfoSetMinusExcluded(0);
    }

    private Set getTableInfoSetMinusExcluded(int n) throws IllegalExpressionException {
        List list;
        try {
            list = JoinNode.getTableAliasList(this.getJoinTree());
        }
        catch (Exception exception) {
            throw new IllegalExpressionException(7, exception.getMessage());
        }
        List list2 = this.getTableAliasExclusionList();
        Map map = this.queryContext.getGlobalTableAliasMap();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (String string : list) {
            boolean bl = false;
            if (list2 != null) {
                for (String string2 : list2) {
                    if (string2.compareTo(string) != 0) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            if (n == 1) {
                hashSet.add(string);
                continue;
            }
            String string3 = (String)map.get(string);
            hashSet.add(string3);
        }
        return hashSet;
    }

    String getFROMDeclaration(int n) throws IllegalExpressionException {
        return this.joinTree.getFROMDeclaration(this.getTableAliasExclusionList(), n);
    }

    public void setQueryId(int n) {
        this.queryId = n;
    }

    public int getQueryId() {
        return this.queryId;
    }

    public QueryNode getQueryNodeForQueryId(int n) {
        if (this.queryId == n) {
            return this;
        }
        QueryNode queryNode = null;
        for (QueryNode queryNode2 : this.children) {
            queryNode = queryNode2.getQueryNodeForQueryId(n);
            if (queryNode == null) continue;
            return queryNode;
        }
        return null;
    }

    public void pushOR(Expr expr) {
        this.pushOR(this.newORJoinData(expr));
        ++this.ORcount;
    }

    public void pushOR(ORJoinData oRJoinData) {
        this.orJoinDataStack.push(oRJoinData);
    }

    public ORJoinData popOR() {
        return (ORJoinData)this.orJoinDataStack.pop();
    }

    public ORJoinData currentOR() {
        return (ORJoinData)this.orJoinDataStack.peek();
    }

    public void addORJoinDataListList(List list) {
        if (this.orJoinDataListList == null) {
            this.orJoinDataListList = new ArrayList();
        }
        if (!this.orJoinDataListList.contains(list)) {
            this.orJoinDataListList.add(list);
        }
    }

    public List getORJoinDataListList() {
        return this.orJoinDataListList;
    }

    public void replaceORPathMaybe(String string) throws IllegalExpressionException {
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug(" Entered replaceORPathMaybe for id: '" + string + "'");
        }
        if (!this.thisQueryNodeOwnsId(string)) {
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug(" queryNode does not own id.  exiting.");
            }
            return;
        }
        this.checkORPath(string);
        this.addSQLTableGenSymbolMap(string);
    }

    private void checkORPath(String string) throws IllegalExpressionException {
        ORJoinData oRJoinData = this.currentOR();
        Vector vector = oRJoinData.getOrVector();
        int n = vector.size();
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug("Entered checkORPath. With input: '" + string + "',  current OR Vector has: " + n + " entries");
        }
        string = JoinNode.getPathWithoutTrailingCmpField(this.joinTree, string);
        block5: for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug(" checking input '" + string + "' against OR path: '" + string2 + "'");
            }
            int n2 = JoinNode.comparePaths(string, string2);
            switch (n2) {
                case -1: {
                    if (!debugLogger.isDebugEnabled()) continue block5;
                    QueryNode.debug(" JoinNode.PATHS_DISTINCT  try again.");
                    continue block5;
                }
                case 0: {
                    if (debugLogger.isDebugEnabled()) {
                        QueryNode.debug(" JoinNode.PATHS_EQUAL  we're done.");
                    }
                    return;
                }
                case 1: {
                    if (debugLogger.isDebugEnabled()) {
                        QueryNode.debug(" JoinNode.PATHS_SUBSET  replace shorter path if needed.");
                    }
                    if (string.length() > string2.length()) {
                        vector.setElementAt(string, i);
                        if (debugLogger.isDebugEnabled()) {
                            QueryNode.debug(" JoinNode.PATHS_SUBSET  replaced shorter path in OR Vector with '" + string + "'");
                        }
                    }
                    return;
                }
                default: {
                    throw new IllegalExpressionException(7, " UNKNOWN JoinNode.comparePaths return code: " + n2);
                }
            }
        }
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug(" Adding path '" + string + "' to current OR Vector.");
        }
        vector.add(string);
    }

    private void addSQLTableGenSymbolMap(String string) throws IllegalExpressionException {
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug(" addSQLTableGenSymbols on '" + string + "'");
        }
        ORJoinData oRJoinData = this.currentOR();
        string = JoinNode.getPathWithoutTrailingCmpField(this.joinTree, string);
        int n = JoinNode.countPathNodes(string);
        block4: for (int i = 0; i < n; ++i) {
            String string2 = JoinNode.getFirstNFieldsFromId(string, i + 1);
            if (oRJoinData.getOrSQLTableGenSymbolMap().containsKey(string)) {
                if (!debugLogger.isDebugEnabled()) continue;
                QueryNode.debug(" addSQLTableGenSymbolMap: skipping, already processed '" + string + "'");
                continue;
            }
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug(" addSQLTableGenSymbolMap: checking pathExpression '" + string2 + "'");
            }
            int n2 = this.getRelationshipTypeForPathExpressionWithNoSQLGen(string2);
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    JoinNode joinNode = JoinNode.getNode(this.joinTree, string2);
                    String string3 = joinNode.getTableName();
                    if (debugLogger.isDebugEnabled()) {
                        QueryNode.debug(" addSQLTableGenSymbolMap:  adding key value pair: '" + string2 + "', tableName: '" + string3 + "'");
                    }
                    oRJoinData.addOrSQLTableGenInfo(string2, string3);
                    continue block4;
                }
                case -1: 
                case 0: {
                    continue block4;
                }
            }
        }
    }

    public void checkAllORCrossProducts() {
        HashMap hashMap = new HashMap();
        this.checkAllORCrossProducts(hashMap);
        if (hashMap.size() > 0) {
            Object object;
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = hashMap.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object = ((Set)hashMap.get(string)).iterator();
                if (!object.hasNext()) continue;
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                stringBuffer.append(string);
            }
            string = stringBuffer.toString();
            object = EJBLogger.logOrMayYieldEmptyCrossProductLoggable((String)string);
            this.queryContext.addWarning(new IllegalExpressionException(6, object.getMessage()));
        }
    }

    public void checkAllORCrossProducts(Map map) {
        this.checkORCrossProducts(map);
        Iterator iterator = this.getChildrenIterator();
        while (iterator.hasNext()) {
            QueryNode queryNode = (QueryNode)iterator.next();
            queryNode.checkAllORCrossProducts(map);
        }
    }

    public void checkORCrossProducts(Map map) {
        List list;
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug("checkORCrossProducts()");
        }
        if ((list = this.getORJoinDataListList()) == null) {
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug("checkORCrossProducts() NO OR CLAUSES exit.  \n\n");
            }
            return;
        }
        int n = list.size();
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug(" checkORCrossProducts()  ORListList size " + n);
        }
        if (n <= 0) {
            return;
        }
        for (List list2 : list) {
            n = list2.size();
            if (list2.size() == 0) continue;
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug("\n check next orJoinDataList");
            }
            for (int i = 0; i < n - 1; ++i) {
                ORJoinData oRJoinData = (ORJoinData)list2.get(i);
                for (int j = i + 1; j < n; ++j) {
                    ORJoinData oRJoinData2 = (ORJoinData)list2.get(j);
                    this.checkORCrossProductPair(oRJoinData, oRJoinData2, map);
                }
            }
        }
    }

    private void checkORCrossProductPair(ORJoinData oRJoinData, ORJoinData oRJoinData2, Map map) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Expr expr = oRJoinData.getOrTerm();
        Expr expr2 = oRJoinData2.getOrTerm();
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug("\n\n\nchecking OR pair: clause 1: '" + expr.printEJBQLTree() + "', \n                  clause 2: '" + expr2.printEJBQLTree() + "'\n");
        }
        Set set = (Set)((HashSet)oRJoinData.getOrSQLTableGenTableSet()).clone();
        Set set2 = (Set)((HashSet)oRJoinData2.getOrSQLTableGenTableSet()).clone();
        if (set.size() == 0 || set2.size() == 0) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug(" set1 table: '" + object3 + "'");
            }
            if (set2.contains(object3)) {
                iterator.remove();
                set2.remove(object3);
                if (!debugLogger.isDebugEnabled()) continue;
                QueryNode.debug("      table: '" + object3 + "' is in Set2, removing");
                continue;
            }
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug(" table '" + object3 + "' in set1 but not set2. ");
            }
            hashSet.add(object3);
        }
        if (set.size() == 0 && set2.size() == 0) {
            if (debugLogger.isDebugEnabled()) {
                QueryNode.debug(" both sets have identical table lists. ");
            }
            return;
        }
        object3 = new HashSet();
        if (set2.size() > 0) {
            object3 = new HashSet();
            object2 = set2.iterator();
            while (object2.hasNext()) {
                string = object2.next();
                if (debugLogger.isDebugEnabled()) {
                    QueryNode.debug(" set2 table: '" + string + "'");
                }
                if (set.contains(string)) {
                    object2.remove();
                    set.remove(string);
                    if (!debugLogger.isDebugEnabled()) continue;
                    QueryNode.debug("      table: '" + string + "' is in Set1, removing");
                    continue;
                }
                if (debugLogger.isDebugEnabled()) {
                    QueryNode.debug(" table '" + string + "' in set2 but not set1. ");
                }
                object3.add(string);
            }
        }
        object2 = new StringBuffer();
        if (hashSet.size() > 0) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                ((StringBuffer)object2).append(string);
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object2).append(" ");
            }
        }
        string = ((StringBuffer)object2).toString();
        String string2 = "";
        ((StringBuffer)object2).setLength(0);
        if (object3 != null) {
            object = object3.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                ((StringBuffer)object2).append(string3);
                if (!object.hasNext()) continue;
                ((StringBuffer)object2).append(" ");
            }
            string2 = ((StringBuffer)object2).toString();
        }
        if (debugLogger.isDebugEnabled()) {
            QueryNode.debug("  tables in OR clause 1 but not in OR clause 2 '" + string + "'");
            QueryNode.debug("  tables in OR clause 2 but not in OR clause 1 '" + string2 + "'");
        }
        object = null;
        try {
            object = this.getTableNameSetMinusExcluded();
        }
        catch (Exception exception) {
            return;
        }
        ((StringBuffer)object2).setLength(0);
        this.listORCrossProductPairDiff(hashSet, oRJoinData.getOrSQLTableGenSymbolMap(), (Set)object, map, expr);
        this.listORCrossProductPairDiff((Set)object3, oRJoinData2.getOrSQLTableGenSymbolMap(), (Set)object, map, expr2);
    }

    private void listORCrossProductPairDiff(Set set, Map map, Set set2, Map map2, Expr expr) {
        if (set.size() > 0) {
            for (String string : set) {
                if (set2.contains(string)) {
                    for (String string2 : map.keySet()) {
                        String string3 = (String)map.get(string2);
                        if (!string.equals(string3)) continue;
                        HashSet<String> hashSet = (HashSet<String>)map2.get(string);
                        if (hashSet == null) {
                            hashSet = new HashSet<String>();
                            map2.put(string, hashSet);
                        }
                        hashSet.add(string2);
                    }
                    continue;
                }
                if (!debugLogger.isDebugEnabled()) continue;
                QueryNode.debug(" table '" + string + "' not in query's FROM clause, ignoring.");
            }
        }
    }

    private static void get_line(String string) {
        System.out.print(string);
        System.out.flush();
        try {
            int n;
            while ((n = System.in.read()) != 10) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMainJoinBuffer() throws IllegalExpressionException {
        return this.getMainORJoinBuffer();
    }

    public String getMainORJoinBuffer() throws IllegalExpressionException {
        return this.getORJoinBuffer(this.mainOrJoinData);
    }

    public String getCurrentORJoinBuffer() throws IllegalExpressionException {
        ORJoinData oRJoinData = (ORJoinData)this.orJoinDataStack.peek();
        return this.getORJoinBuffer(oRJoinData);
    }

    private String getORJoinBuffer(ORJoinData oRJoinData) throws IllegalExpressionException {
        CharSequence charSequence;
        Object object2;
        Vector vector = oRJoinData.getOrVector();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (vector.size() > 0) {
            for (Object object2 : vector) {
                charSequence = new StringBuffer();
                JoinNode.getJoinSQLForPath(this.joinTree, (String)object2, this.tableAliasExclusionList, (StringBuffer)charSequence);
                String string = ((StringBuffer)charSequence).toString();
                if (string.length() <= 0) continue;
                if (bl) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string);
                bl = true;
            }
        }
        Map map = oRJoinData.getOrCmpFieldJoinMap();
        object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            charSequence = (String)map.get(object2.next());
            if (((String)charSequence).length() <= 0) continue;
            if (bl) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append((String)charSequence);
            bl = true;
        }
        return stringBuffer.toString();
    }

    public void addCmpFieldJoinSQL(String string, String string2, String string3) {
        String string4 = string + "." + string2;
        ORJoinData oRJoinData = this.currentOR();
        Map map = oRJoinData.getOrCmpFieldJoinMap();
        map.put(string4, string3);
    }

    void checkOracleORJoin(String string) throws IllegalExpressionException {
        int n = this.getDbType();
        if (n == 1) {
            if (this.ORcount <= 0) {
                return;
            }
            int n2 = this.joinTree.getAllDoLeftOuterJoinCount();
            if (n2 > 0) {
                Loggable loggable = EJBLogger.logOracleCannotDoOuterJoinAndORLoggable((String)string);
                throw new IllegalExpressionException(7, loggable.getMessage());
            }
        }
    }

    int getRelationshipTypeForPathExpressionWithNoSQLGen(String string) throws IllegalExpressionException {
        JoinNode joinNode = this.getJoinTreeForId(string);
        return JoinNode.getRelationshipTypeForPathExpressionWithNoSQLGen(this.queryContext, joinNode, string);
    }

    public RDBMSBean getLastRDBMSBeanForPathExpressionWithNoSQLGen(String string) throws IllegalExpressionException {
        JoinNode joinNode = this.getJoinTreeForId(string);
        return JoinNode.getLastRDBMSBeanForPathExpressionWithNoSQLGen(this.queryContext, joinNode, string);
    }

    public RDBMSBean getLastRDBMSBeanForPathExpression(String string) throws IllegalExpressionException {
        JoinNode joinNode = this.getJoinTreeForId(string);
        return JoinNode.getTerminalBean(joinNode, string);
    }

    private int getDbType() {
        return this.queryContext.getRDBMSBean().getDatabaseType();
    }

    private ORJoinData newORJoinData() {
        return new ORJoinData();
    }

    private ORJoinData newORJoinData(Expr expr) {
        return new ORJoinData(expr);
    }

    public static QueryNode newQueryNode(EjbqlFinder ejbqlFinder, QueryContext queryContext, QueryNode queryNode, int n) {
        JoinNode joinNode = JoinNode.makeJoinRoot(ejbqlFinder.getRDBMSBean(), queryContext);
        return new QueryNode(ejbqlFinder, queryContext, queryNode, joinNode, n);
    }

    private static void debug(String string) {
        debugLogger.debug("[QueryNode] " + string);
    }
}

