/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.lang.reflect.Method;
import java.util.Map;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.j2ee.descriptor.wl.MethodParamsBean;
import weblogic.j2ee.descriptor.wl.QueryMethodBean;
import weblogic.j2ee.descriptor.wl.WeblogicQueryBean;

public final class RDBMSFinder {
    private String finderName;
    private String[] finderParams;
    private String ejbQlQuery;
    private String groupName;
    private String cachingName;
    private String sqlShapeName;
    private Map sqlQueries;
    private int maxElements = 0;
    private boolean includeUpdates = true;
    private boolean sqlSelectDistinct = false;
    private boolean queryCachingEnabled = false;
    private boolean enableEagerRefresh = false;
    private boolean includeResultCacheHint = false;

    public void setFinderName(String string) {
        this.finderName = string;
    }

    public String getFinderName() {
        return this.finderName;
    }

    public void setFinderParams(String[] stringArray) {
        this.finderParams = stringArray;
    }

    public String[] getFinderParams() {
        return this.finderParams;
    }

    public void setEjbQlQuery(String string) {
        this.ejbQlQuery = string;
    }

    public String getEjbQlQuery() {
        return this.ejbQlQuery;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setCachingName(String string) {
        this.cachingName = string;
    }

    public String getCachingName() {
        return this.cachingName;
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public void setMaxElements(int n) {
        this.maxElements = n;
    }

    public void setIncludeUpdates(boolean bl) {
        this.includeUpdates = bl;
    }

    public boolean getIncludeUpdates() {
        return this.includeUpdates;
    }

    public void setSqlSelectDistinct(boolean bl) {
        this.sqlSelectDistinct = bl;
    }

    public boolean getSqlSelectDistinct() {
        return this.sqlSelectDistinct;
    }

    public void setQueryCachingEnabled(boolean bl) {
        this.queryCachingEnabled = bl;
    }

    public boolean isQueryCachingEnabled() {
        return this.queryCachingEnabled;
    }

    public void setEnableEagerRefresh(boolean bl) {
        this.enableEagerRefresh = bl;
    }

    public boolean isEnableEagerRefresh() {
        return this.enableEagerRefresh;
    }

    public void setIncludeResultCacheHint(boolean bl) {
        this.includeResultCacheHint = bl;
    }

    public boolean isIncludeResultCacheHint() {
        return this.includeResultCacheHint;
    }

    public String toString() {
        return DDUtils.getMethodSignature(this.finderName, this.finderParams);
    }

    public String getSqlShapeName() {
        return this.sqlShapeName;
    }

    public void setSqlShapeName(String string) {
        this.sqlShapeName = string;
    }

    public Map getSqlQueries() {
        return this.sqlQueries;
    }

    public void setSqlQueries(Map map) {
        this.sqlQueries = map;
    }

    public boolean usesSql() {
        return this.sqlQueries != null;
    }

    public static class FinderKey {
        private String finderName;
        private String[] finderParams;

        public FinderKey(String string, String[] stringArray) {
            this.finderName = string;
            this.finderParams = stringArray;
            if (string == null) {
                string = "";
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
        }

        public FinderKey(RDBMSFinder rDBMSFinder) {
            this.finderName = rDBMSFinder.getFinderName();
            String[] stringArray = rDBMSFinder.getFinderParams();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.finderParams = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.finderParams[i] = MethodUtils.decodePrimitiveTypeArrayMaybe(stringArray[i]);
            }
        }

        public FinderKey(Finder finder) {
            this.finderName = finder.getName();
            String[] stringArray = finder.getParameterClassNames();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.finderParams = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.finderParams[i] = MethodUtils.decodePrimitiveTypeArrayMaybe(stringArray[i]);
            }
        }

        public FinderKey(Method method) {
            String string = method.getName();
            this.finderName = string.startsWith("ejbFind") ? MethodUtils.convertToDDFinderName(string) : string;
            Class[] classArray = method.getParameterTypes();
            this.finderParams = MethodUtils.classesToJavaSourceTypes(classArray);
        }

        public FinderKey(WeblogicQueryBean weblogicQueryBean) {
            QueryMethodBean queryMethodBean = weblogicQueryBean.getQueryMethod();
            if (queryMethodBean == null) {
                this.finderName = "";
                this.finderParams = new String[0];
            } else {
                MethodParamsBean methodParamsBean;
                this.finderName = queryMethodBean.getMethodName();
                if (this.finderName == null) {
                    this.finderName = "";
                }
                if ((methodParamsBean = queryMethodBean.getMethodParams()) == null) {
                    this.finderParams = new String[0];
                } else {
                    this.finderParams = methodParamsBean.getMethodParams();
                    if (this.finderParams == null) {
                        this.finderParams = new String[0];
                    }
                }
            }
        }

        public void setFinderName(String string) {
            this.finderName = string;
        }

        public String getFinderName() {
            return this.finderName;
        }

        public void setFinderParams(String[] stringArray) {
            this.finderParams = stringArray;
        }

        public String[] getFinderParams() {
            return this.finderParams;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FinderKey)) {
                return false;
            }
            FinderKey finderKey = (FinderKey)object;
            if (!this.finderName.equals(finderKey.getFinderName())) {
                return false;
            }
            String[] stringArray = finderKey.getFinderParams();
            if (this.finderParams.length != stringArray.length) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.finderParams[i].equals(stringArray[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.finderName.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[FinderKey: " + this.getFinderName() + "(");
            if (this.finderParams != null) {
                for (int i = 0; i < this.finderParams.length; ++i) {
                    stringBuffer.append(this.finderParams[i]);
                    if (i >= this.finderParams.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
            stringBuffer.append(")]");
            return stringBuffer.toString();
        }
    }
}

