/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp.rdbms.finders;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.dbeans.ConversationImpl;
import weblogic.dbeans.DataBeansException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp.rdbms.SqlShape;
import weblogic.ejb.container.cmp.rdbms.codegen.CodeGenUtils;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.ParamNode;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.internal.QueryCachingHandler;
import weblogic.ejb.container.internal.TxManager;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cmp.rdbms.finders.InvalidFinderException;
import weblogic.jdbc.rowset.WLCachedRowSet;
import weblogic.logging.Loggable;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.AssertionError;

public class SqlFinder
extends Finder {
    private Method method;
    private Method secondMethod;
    private Map sqlQueries;
    private String sqlShapeName;
    private String query;
    private RDBMSBean rdbmsBean;
    private ConversationImpl conversation;
    private int[] query2method;
    private boolean initialized = false;
    private int columnCount = 0;
    private Field[] columnFields;
    private Method[] columnMethods;
    private int[] columnIndices;
    private boolean[] columnSetsPrimaryKey;
    private Field[] columnPrimaryKeyFields;
    private Field[] columnOptimisticFields;
    private Method[] columnOptimisticMethods;
    private String[] columnTypes;
    private Class[] columnClasses;
    private int[] columnIsLoadedIndices;
    private BaseEntityManager[] resultManagers;
    private RDBMSBean[] resultBeans;
    private int[] relationIndex1;
    private int[] relationIndex2;
    private Method[] relationMethod1;
    private Method[] relationMethod2;
    private TransactionHelper txHelper = TransactionHelper.getTransactionHelper();
    private List externalMethodParmList = null;
    private boolean queryTypeInitialized = false;
    private boolean usesStoredProcedure = false;
    private boolean usesStoredFunction = false;
    private boolean usesRelationshipCaching = false;
    private boolean isDynamicFinder = false;
    private String[] cmrFieldFinderMethodNames1;
    private String[] cmrFieldFinderMethodNames2;
    private int[] cmrFieldFinderReturnTypes1;
    private int[] cmrFieldFinderReturnTypes2;
    private static final Pattern FROM_PATTERN = Pattern.compile("(?i)\\bfrom\\s+([a-zA-Z_0-9.]+)");
    private static int NO_MAPPING = -1;

    public SqlFinder(String string, Map map, String string2, RDBMSBean rDBMSBean) throws InvalidFinderException {
        super(string, true);
        this.sqlShapeName = string2;
        this.sqlQueries = map;
        this.rdbmsBean = rDBMSBean;
        this.conversation = null;
    }

    public SqlFinder(String string, Map map, String string2, RDBMSBean rDBMSBean, ConversationImpl conversationImpl) throws InvalidFinderException {
        super(string, true);
        this.sqlShapeName = string2;
        this.sqlQueries = map;
        this.rdbmsBean = rDBMSBean;
        this.conversation = conversationImpl;
    }

    public void setMethods(Method[] methodArray) throws Exception {
        assert (methodArray[0] != null);
        super.setMethod(methodArray[0]);
        this.setParameterClassTypes(methodArray[0].getParameterTypes());
        this.method = methodArray[0];
        this.secondMethod = methodArray[1];
    }

    public void setup(int n) throws WLDeploymentException {
        String[] stringArray;
        this.query = (String)this.sqlQueries.get(new Integer(n));
        if (this.query == null) {
            this.query = (String)this.sqlQueries.get(new Integer(0));
            if (this.query == null) {
                throw new WLDeploymentException("Error: no SQL query specified for " + DDConstants.getDBNameForType(n) + "database type in finder method " + this.getName() + "of EJB " + this.rdbmsBean.getEjbName());
            }
        }
        if (Pattern.matches("\\{\\s*call.*\\}", this.query)) {
            this.usesStoredProcedure = true;
        } else if (Pattern.matches("\\{\\s*\\?\\s*=\\s*call.*\\}", this.query)) {
            this.usesStoredFunction = true;
        }
        if ((this.usesStoredProcedure || this.usesStoredFunction) && !this.hasSqlShape()) {
            Loggable loggable = EJBLogger.logNoSqlShapeSpecifiedLoggable((String)this.getName());
            throw new EJBException(loggable.getMessage());
        }
        this.sqlQuery = this.query;
        this.sqlQueryForUpdate = this.query;
        this.sqlQueryForUpdateNoWait = this.query;
        Pattern pattern = Pattern.compile("\\?\\d+");
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(this.query);
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("starting query- " + this.query);
        }
        while (matcher.find(n2)) {
            String string = matcher.group();
            if (debugLogger.isDebugEnabled()) {
                SqlFinder.debug("parameter- " + string);
            }
            n2 = matcher.end();
            stringArray = string.substring(1);
            Integer n3 = new Integer(Integer.parseInt((String)stringArray) - 1);
            arrayList.add(n3);
        }
        this.query2method = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.query2method[i] = (Integer)arrayList.get(i);
            if (!debugLogger.isDebugEnabled()) continue;
            SqlFinder.debug("query indghostlyex- " + i + "method index- " + this.query2method[i]);
        }
        this.query = matcher.replaceAll(" ? ");
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("ending query- " + this.query);
        }
        if (this.sqlShapeName != null) {
            SqlShape sqlShape = this.rdbmsBean.getSqlShape(this.sqlShapeName);
            stringArray = sqlShape.getEjbRelationNames();
            this.usesRelationshipCaching = stringArray != null;
        }
    }

    public void setupDynamic(String string) throws WLDeploymentException {
        this.query = string;
        Pattern pattern = Pattern.compile("\\?");
        int n = 0;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(this.query);
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("starting query- " + this.query);
        }
        while (matcher.find(n)) {
            String string2 = matcher.group();
            if (debugLogger.isDebugEnabled()) {
                SqlFinder.debug("parameter- " + string2);
            }
            n = matcher.end();
            arrayList.add(new Integer(n2++));
        }
        this.query2method = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.query2method[i] = (Integer)arrayList.get(i);
            if (!debugLogger.isDebugEnabled()) continue;
            SqlFinder.debug("query indghostlyex- " + i + "method index- " + this.query2method[i]);
        }
        this.isDynamicFinder = true;
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("ending query- " + this.query);
        }
    }

    private boolean alreadyMapped(List list, int n, String string, String string2) {
        if (n == NO_MAPPING) {
            return false;
        }
        Map map = (Map)list.get(n);
        List list2 = (List)map.get(string);
        if (list2 == null) {
            return false;
        }
        return list2.contains(string2);
    }

    private void updateMapped(List list, int n, String string, String string2) {
        Map map = (Map)list.get(n);
        assert (map != null);
        ArrayList<String> arrayList = (ArrayList<String>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            map.put(string, arrayList);
        }
        if (!arrayList.contains(string2)) {
            arrayList.add(string2);
        }
    }

    private boolean hasSqlShape() {
        return this.sqlShapeName != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSqlMetadata(ResultSet resultSet, List list, List list2, List list3) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        if (this.hasSqlShape()) {
            SqlShape sqlShape = this.rdbmsBean.getSqlShape(this.sqlShapeName);
            for (SqlShape.Table table : sqlShape.getTables()) {
                if (table == null) {
                    list.add(null);
                    list2.add(null);
                    list3.add(null);
                    continue;
                }
                for (String string : table.getColumns()) {
                    list.add(string);
                    list2.add(table.getName());
                    list3.add(table.getEjbRelationshipRoleNames());
                }
            }
            for (int i = 0; i < sqlShape.getPassThroughColumns(); ++i) {
                list.add(null);
                list2.add(null);
                list3.add(null);
            }
            if (list.size() == n) return;
            Loggable loggable = EJBLogger.logErrorExecuteFinderLoggable((String)this.getName(), (String)sqlShape.getSqlShapeName(), (String)(list.size() + ""), (String)(n + ""));
            throw new EJBException(loggable.getMessage());
        }
        String string = null;
        if (this.isSingletonSelect()) {
            if (n != 1) throw new EJBException("Too many columns (" + n + ") selected by query '" + this.query + "'.  " + this.getName() + " returns a value of type " + this.getReturnClassType().getName() + " and requires and SQL query that selects a single value.");
            list.add(null);
            list2.add(null);
            return;
        }
        for (int i = 1; i <= n; ++i) {
            String string2 = null;
            String string3 = null;
            try {
                string2 = resultSetMetaData.getColumnName(i);
                string3 = resultSetMetaData.getTableName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || string2.length() == 0) {
                throw new EJBException("Unknown column name for column- " + string2 + "of query- " + this.query + ".  Use a SqlShape element to specify the column name.");
            }
            if (string3 == null || string3.length() == 0) {
                if (string == null) {
                    string = this.guessTableName();
                    if (string == null || string.length() == 0) {
                        throw new EJBException("Unknown table name for column- " + string2 + "of query- " + this.query + ".  Use a SqlShape element to specifying the table name.");
                    }
                    string = string.trim();
                }
                string3 = string;
            }
            list.add(string2);
            list2.add(string3);
            list3.add(null);
        }
    }

    private String guessTableName() {
        Matcher matcher = FROM_PATTERN.matcher(this.query);
        if (!matcher.find()) {
            return null;
        }
        String string = matcher.group(1);
        return string;
    }

    public synchronized void initializeMapping(ResultSet resultSet) throws FinderException, SQLException {
        if (!this.initialized) {
            int n;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            this.getSqlMetadata(resultSet, arrayList, arrayList2, arrayList3);
            this.columnCount = arrayList.size();
            if (debugLogger.isDebugEnabled()) {
                SqlFinder.debug("column count-" + this.columnCount);
            }
            ArrayList arrayList4 = new ArrayList();
            ArrayList arrayList5 = new ArrayList();
            ArrayList arrayList6 = new ArrayList();
            ArrayList<Object> arrayList7 = new ArrayList<Object>();
            ArrayList<Object> arrayList8 = new ArrayList<Object>();
            this.columnFields = new Field[this.columnCount];
            this.columnMethods = new Method[this.columnCount];
            this.columnIndices = new int[this.columnCount];
            this.columnSetsPrimaryKey = new boolean[this.columnCount];
            this.columnPrimaryKeyFields = new Field[this.columnCount];
            this.columnIsLoadedIndices = new int[this.columnCount];
            this.columnOptimisticFields = new Field[this.columnCount];
            this.columnOptimisticMethods = new Method[this.columnCount];
            this.columnTypes = new String[this.columnCount];
            this.columnClasses = new Class[this.columnCount];
            for (n = 0; n < this.columnCount; ++n) {
                Object object;
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("current column- " + n);
                }
                String string = (String)arrayList.get(n);
                String string2 = (String)arrayList2.get(n);
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("column name-" + string);
                    SqlFinder.debug("table name-" + string2);
                }
                List list = null;
                boolean bl = false;
                if (string2 == null && string == null) {
                    this.columnIndices[n] = arrayList6.size();
                    arrayList4.add(null);
                    arrayList5.add(null);
                    arrayList6.add(null);
                    arrayList7.add(null);
                    arrayList8.add(null);
                    this.columnClasses[n] = this.isSingletonSelect() ? this.getReturnClassType() : Object.class;
                    bl = true;
                }
                if (!bl) {
                    list = (List)arrayList3.get(n);
                    int n2 = 0;
                    object = arrayList5.iterator();
                    while (object.hasNext() && !bl) {
                        bl = this.mapTableAndColumn((RDBMSBean)object.next(), string2, string, list, n, arrayList4, arrayList5, arrayList6, arrayList7, arrayList8, n2++, hashMap, hashMap2);
                    }
                }
                if (!bl) {
                    bl = this.mapTableAndColumn(this.rdbmsBean, string2, string, list, n, arrayList4, arrayList5, arrayList6, arrayList7, arrayList8, NO_MAPPING, hashMap, hashMap2);
                }
                if (!bl) {
                    Iterator iterator = this.rdbmsBean.getRdbmsBeanMap().values().iterator();
                    while (iterator.hasNext() && !bl) {
                        object = (RDBMSBean)iterator.next();
                        bl = this.mapTableAndColumn((RDBMSBean)object, string2, string, list, n, arrayList4, arrayList5, arrayList6, arrayList7, arrayList8, NO_MAPPING, hashMap, hashMap2);
                    }
                }
                if (bl) continue;
                Loggable loggable = EJBLogger.logErrorMapColumnLoggable((String)string2, (String)string, (String)this.query);
                throw new FinderException(loggable.getMessage());
            }
            this.resultManagers = arrayList4.toArray(new BaseEntityManager[0]);
            this.resultBeans = arrayList5.toArray(new RDBMSBean[0]);
            this.validateMapping(this.resultBeans, arrayList6);
            this.initializeRelationshipCaching(arrayList5, arrayList8);
            if (this.isQueryCachingEnabled()) {
                for (n = 0; n < this.resultManagers.length; ++n) {
                    if (this.resultManagers[n] == null || this.resultManagers[n].isReadOnly()) continue;
                    this.log.logWarning(this.fmt.QUERY_CACHING_SQLFINDER_RETURNS_RW_BEAN(this.rdbmsBean.getEjbName(), this.getName(), this.resultManagers[n].getBeanInfo().getEJBName()));
                    this.setQueryCachingEnabled(false);
                }
            }
            this.initialized = true;
        }
        this.initializeTxListeners();
    }

    private void initializeRelationshipCaching(List list, List list2) {
        SqlShape sqlShape;
        String[] stringArray;
        if (this.sqlShapeName == null) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("------------------initializeRelationshipCaching");
        }
        if ((stringArray = (sqlShape = this.rdbmsBean.getSqlShape(this.sqlShapeName)).getEjbRelationNames()) != null) {
            this.relationIndex1 = new int[stringArray.length];
            this.relationIndex2 = new int[stringArray.length];
            this.relationMethod1 = new Method[stringArray.length];
            this.relationMethod2 = new Method[stringArray.length];
            this.cmrFieldFinderMethodNames1 = new String[stringArray.length];
            this.cmrFieldFinderMethodNames2 = new String[stringArray.length];
            this.cmrFieldFinderReturnTypes1 = new int[stringArray.length];
            this.cmrFieldFinderReturnTypes2 = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Class clazz;
                EjbRelation ejbRelation = this.rdbmsBean.getEjbRelation(stringArray[i]);
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("------------------relation name" + ejbRelation.getEjbRelationName());
                }
                Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
                EjbRelationshipRole ejbRelationshipRole = (EjbRelationshipRole)iterator.next();
                EjbRelationshipRole ejbRelationshipRole2 = (EjbRelationshipRole)iterator.next();
                RoleSource roleSource = ejbRelationshipRole.getRoleSource();
                RoleSource roleSource2 = ejbRelationshipRole2.getRoleSource();
                String string = roleSource.getEjbName();
                String string2 = roleSource2.getEjbName();
                int n = this.getIndex(string, ejbRelationshipRole.getName(), list, list2, NO_MAPPING, string.equals(string2), ejbRelation.getEjbRelationName());
                int n2 = this.getIndex(string2, ejbRelationshipRole2.getName(), list, list2, n, string.equals(string2), ejbRelation.getEjbRelationName());
                assert (n != n2);
                this.relationIndex1[i] = n;
                this.relationIndex2[i] = n2;
                String string3 = RDBMSUtils.getCmrFieldName(ejbRelationshipRole, ejbRelationshipRole2);
                String string4 = RDBMSUtils.getCmrFieldName(ejbRelationshipRole2, ejbRelationshipRole);
                String string5 = CodeGenUtils.cacheRelationshipMethodName(string3);
                String string6 = CodeGenUtils.cacheRelationshipMethodName(string4);
                this.setRelationMethod(this.relationMethod1, i, n, string5);
                this.setRelationMethod(this.relationMethod2, i, n2, string6);
                if (this.isQueryCachingEnabled() || this.getRDBMSBean(n).isQueryCachingEnabledForCMRField(string3)) {
                    this.cmrFieldFinderMethodNames1[i] = CodeGenUtils.getCMRFieldFinderMethodName(this.getRDBMSBean(n), string3);
                    clazz = this.getRDBMSBean(n).getCmrFieldClass(string3);
                    this.cmrFieldFinderReturnTypes1[i] = Set.class.isAssignableFrom(clazz) ? 1 : 3;
                    if (debugLogger.isDebugEnabled()) {
                        SqlFinder.debug("CMRField1: " + string3);
                        SqlFinder.debug("CMRFieldFinderMethod: " + this.cmrFieldFinderMethodNames1[i]);
                        SqlFinder.debug("CMRFieldFinderReturnType: " + this.cmrFieldFinderReturnTypes1[i]);
                        SqlFinder.debug("MGR: " + this.resultManagers[this.relationIndex2[i]].getBeanInfo().getEJBName());
                    }
                }
                if (!this.isQueryCachingEnabled() && !this.getRDBMSBean(n2).isQueryCachingEnabledForCMRField(string4)) continue;
                this.cmrFieldFinderMethodNames2[i] = CodeGenUtils.getCMRFieldFinderMethodName(this.getRDBMSBean(n2), string4);
                clazz = this.getRDBMSBean(n2).getCmrFieldClass(string4);
                this.cmrFieldFinderReturnTypes2[i] = Set.class.isAssignableFrom(clazz) ? 1 : 3;
                if (!debugLogger.isDebugEnabled()) continue;
                SqlFinder.debug("CMRField: " + string4);
                SqlFinder.debug("CMRFieldFinderMethod: " + this.cmrFieldFinderMethodNames2[i]);
                SqlFinder.debug("CMRFieldFinderReturnType: " + this.cmrFieldFinderReturnTypes2[i]);
                SqlFinder.debug("MGR: " + this.resultManagers[this.relationIndex1[i]].getBeanInfo().getEJBName());
            }
        }
    }

    private void setRelationMethod(Method[] methodArray, int n, int n2, String string) {
        ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)this.resultManagers[n2].getBeanInfo();
        Class clazz = clientDrivenBeanInfo.getGeneratedBeanInterface();
        try {
            methodArray[n] = clazz.getMethod(string, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("the legal relationship setting method: name-" + string);
        }
    }

    private int getIndex(String string, String string2, List list, List list2, int n, boolean bl, String string3) {
        Object object;
        RDBMSBean rDBMSBean;
        int n2;
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("ejbName-" + string);
            SqlFinder.debug("role-" + string2);
            SqlFinder.debug("taken-" + n);
            SqlFinder.debug("requiresRole-" + bl);
            SqlFinder.debug("relationship-" + string3);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            rDBMSBean = (RDBMSBean)list.get(n2);
            object = (Set)list2.get(n2);
            if (!string.equals(rDBMSBean.getEjbName()) || !object.contains(string2) || n != NO_MAPPING && n == n2) continue;
            return n2;
        }
        if (!bl) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                rDBMSBean = (RDBMSBean)list.get(n2);
                if (!string.equals(rDBMSBean.getEjbName()) || n != NO_MAPPING && n == n2) continue;
                return n2;
            }
        }
        String string4 = "";
        for (int i = 0; i < list.size(); ++i) {
            object = (RDBMSBean)list.get(i);
            Set set = (Set)list2.get(i);
            if (i > 0) {
                string4 = string4 + ", ";
            }
            string4 = string4 + ((RDBMSBean)object).getEjbName();
        }
        Loggable loggable = EJBLogger.logErrorMapRelatioshipLoggable((String)this.getName(), (String)string3, (String)string2, (String)this.query, (String)string4);
        throw new EJBException(loggable.getMessage());
    }

    public void initializeTxListeners() {
        if (this.conversation != null) {
            Transaction transaction = this.txHelper.getTransaction();
            for (int i = 0; i < this.resultManagers.length; ++i) {
                TxManager txManager = this.resultManagers[i].getTxManager();
                try {
                    txManager.setConversation(transaction, this.conversation);
                    continue;
                }
                catch (RollbackException rollbackException) {
                    throw new DataBeansException(rollbackException);
                }
                catch (SystemException systemException) {
                    throw new DataBeansException(systemException);
                }
            }
        }
    }

    private void validateMapping(RDBMSBean[] rDBMSBeanArray, List list) {
        for (int i = 0; i < rDBMSBeanArray.length; ++i) {
            String string3;
            String string22;
            RDBMSBean rDBMSBean = rDBMSBeanArray[i];
            if (rDBMSBean == null) continue;
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            HashSet hashSet = new HashSet(cMPBeanDescriptor.getPrimaryKeyFieldNames());
            Map map = (Map)list.get(i);
            for (String string22 : map.keySet()) {
                for (String string3 : (List)map.get(string22)) {
                    String string4 = rDBMSBean.getCmpField(string22, string3);
                    hashSet.remove(string4);
                }
            }
            if (hashSet.isEmpty()) continue;
            string22 = "";
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                string22 = string22 + iterator.next();
                if (!iterator.hasNext()) continue;
                string22 = string22 + ", ";
            }
            string3 = EJBLogger.logNotSelectForAllPrimaryKeyLoggable((String)this.getName(), (String)this.query, (String)rDBMSBean.getEjbName(), (String)string22);
            throw new EJBException(string3.getMessage());
        }
    }

    private String getTable(RDBMSBean rDBMSBean, String string, Map map) {
        TreeMap<String, String> treeMap = (TreeMap<String, String>)map.get(rDBMSBean.getEjbName());
        if (treeMap == null) {
            treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (String string2 : rDBMSBean.getTables()) {
                treeMap.put(string2, string2);
            }
            map.put(rDBMSBean.getEjbName(), treeMap);
        }
        return (String)treeMap.get(string);
    }

    private String getColumn(RDBMSBean rDBMSBean, String string, String string2, Map map) {
        Map map2;
        TreeMap treeMap = (TreeMap)map.get(rDBMSBean.getEjbName());
        if (treeMap == null) {
            treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            rDBMSBean.computeAllTableColumns(treeMap);
            map.put(rDBMSBean.getEjbName(), treeMap);
        }
        if ((map2 = (Map)treeMap.get(string)) == null) {
            return null;
        }
        return (String)map2.get(string2);
    }

    private boolean mapTableAndColumn(RDBMSBean rDBMSBean, String string, String string2, List list, int n, List list2, List list3, List list4, List list5, List list6, int n2, Map map, Map map2) {
        if (debugLogger.isDebugEnabled()) {
            SqlFinder.debug("checking bean- " + rDBMSBean.getEjbName());
        }
        boolean bl = false;
        String string3 = this.getTable(rDBMSBean, string, map);
        if (string3 != null && (string3 = this.getColumn(rDBMSBean, string = string3, string2, map2)) != null && !this.alreadyMapped(list4, n2, string, string2 = string3)) {
            bl = true;
        }
        if (bl) {
            Class clazz;
            Object object;
            if (debugLogger.isDebugEnabled()) {
                SqlFinder.debug("bean as field for column-" + string2);
            }
            CMPBeanDescriptor cMPBeanDescriptor = rDBMSBean.getCMPBeanDescriptor();
            BaseEntityManager baseEntityManager = rDBMSBean.getRDBMSPersistenceManager().getBeanManager();
            if (n2 == NO_MAPPING) {
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("beginning bean: EJB-" + rDBMSBean.getEjbName());
                }
                this.columnIndices[n] = list4.size();
                list2.add(baseEntityManager);
                list3.add(rDBMSBean);
                list4.add(new HashMap());
                list5.add(new HashSet());
                list6.add(new HashSet());
            } else {
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("found column for bean- " + rDBMSBean.getEjbName());
                }
                this.columnIndices[n] = n2;
            }
            this.updateMapped(list4, this.columnIndices[n], string, string2);
            ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)baseEntityManager.getBeanInfo();
            Class clazz2 = clientDrivenBeanInfo.getGeneratedBeanClass();
            boolean bl2 = rDBMSBean.isOptimistic() && (rDBMSBean.hasOptimisticColumn(string) && string2.equalsIgnoreCase(rDBMSBean.getOptimisticColumn(string)) || !rDBMSBean.hasOptimisticColumn(string) && (!rDBMSBean.hasCmpField(string, string2) || !rDBMSBean.isPrimaryKeyField(rDBMSBean.getCmpField(string, string2))));
            String string4 = null;
            if (cMPBeanDescriptor.isBeanClassAbstract() || !rDBMSBean.hasCmpField(string, string2)) {
                string4 = rDBMSBean.getVariable(string, string2);
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("variable-" + string4);
                }
                try {
                    this.columnFields[n] = clazz2.getField(string4);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new AssertionError("illegal field value- " + string4);
                }
                this.columnClasses[n] = this.columnFields[n].getType();
            } else {
                object = null;
                clazz = null;
                String string5 = null;
                object = rDBMSBean.getCmpField(string, string2);
                clazz = cMPBeanDescriptor.getFieldClass((String)object);
                string5 = "__WL_super_" + MethodUtils.setMethodName((String)object);
                string4 = object;
                try {
                    this.columnMethods[n] = clazz2.getMethod(string5, clazz);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError("illegal setter method: name-" + string5 + " argument type-" + clazz.getName());
                }
                this.columnClasses[n] = clazz;
            }
            if (bl2) {
                object = CodeGenUtils.snapshotNameForVar(string4);
                if (debugLogger.isDebugEnabled()) {
                    SqlFinder.debug("-------------------------optimistic Field" + (String)object);
                }
                try {
                    this.columnOptimisticFields[n] = clazz2.getField((String)object);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new AssertionError("illegal optimistic field value- " + (String)object);
                }
            }
            if (rDBMSBean.hasCmpField(string4)) {
                if (rDBMSBean.hasCmpColumnType(string4)) {
                    this.columnTypes[n] = rDBMSBean.getCmpColumnTypeForField(string4);
                }
                if (rDBMSBean.isPrimaryKeyField(string4)) {
                    object = (Set)list5.get(this.columnIndices[n]);
                    if (!object.contains(string4)) {
                        this.columnSetsPrimaryKey[n] = true;
                        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
                            clazz = cMPBeanDescriptor.getPrimaryKeyClass();
                            try {
                                this.columnPrimaryKeyFields[n] = clazz.getField(string4);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                throw new AssertionError("illegal primary key field value- " + string4);
                            }
                        }
                    } else {
                        this.columnSetsPrimaryKey[n] = false;
                    }
                }
            }
            if (list != null) {
                ((List)list6.get(this.columnIndices[n])).addAll(list);
            }
            object = rDBMSBean.getField(string4);
            this.columnIsLoadedIndices[n] = rDBMSBean.getIsModifiedIndex((String)object);
        }
        return bl;
    }

    public String getQuery(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.query;
                break;
            }
            case 1: {
                string = this.query;
                break;
            }
            case 2: {
                string = this.query;
                break;
            }
            default: {
                throw new AssertionError("Unknown selectForUpdate type: '" + n + "'");
            }
        }
        return string;
    }

    public Object[] getBeans() throws InternalException {
        Object[] objectArray = new Object[this.resultManagers.length];
        for (int i = 0; i < this.resultManagers.length; ++i) {
            if (this.resultManagers[i] == null) continue;
            objectArray[i] = this.resultManagers[i].getBeanFromPool();
            ((CMPBean)objectArray[i]).__WL_initialize();
        }
        return objectArray;
    }

    public void releaseBeans(Object[] objectArray, int n) {
        for (int i = n; i < this.resultManagers.length; ++i) {
            if (this.resultManagers[i] == null) continue;
            this.resultManagers[i].releaseBeanToPool((EntityBean)objectArray[i]);
        }
    }

    public Object[] getPrimaryKey() throws InstantiationException, IllegalAccessException {
        Object[] objectArray = new Object[this.resultManagers.length];
        for (int i = 0; i < this.resultManagers.length; ++i) {
            if (this.resultBeans[i] == null || !this.resultBeans[i].getCMPBeanDescriptor().hasComplexPrimaryKey()) continue;
            objectArray[i] = this.resultBeans[i].getCMPBeanDescriptor().getPrimaryKeyClass().newInstance();
        }
        return objectArray;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getSecondMethod() {
        return this.secondMethod;
    }

    public Field getField(int n) {
        return this.columnFields[n];
    }

    public boolean hasField(int n) {
        return this.columnFields[n] != null;
    }

    public Method getMethod(int n) {
        return this.columnMethods[n];
    }

    public int getNumQueryParams() {
        return this.query2method.length;
    }

    public int getMethodIndex(int n) {
        assert (n < this.query2method.length);
        return this.query2method[n];
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Class getColumnClass(int n) {
        return this.columnClasses[n];
    }

    public int getResultIndex(int n) {
        return this.columnIndices[n];
    }

    public boolean setsPrimaryKey(int n) {
        return this.columnSetsPrimaryKey[n];
    }

    public Field getPrimaryKeyField(int n) {
        return this.columnPrimaryKeyFields[n];
    }

    public int getIsLoadedIndex(int n) {
        return this.columnIsLoadedIndices[n];
    }

    public BaseEntityManager getManager(int n) {
        return this.resultManagers[n];
    }

    public RDBMSBean getRDBMSBean(int n) {
        return this.resultBeans[n];
    }

    public boolean isOptimistic(int n) {
        return this.columnOptimisticFields[n] != null;
    }

    public Field getOptimisticField(int n) {
        return this.columnOptimisticFields[n];
    }

    public boolean isCharArrayMappedToString(Class clazz) {
        return this.rdbmsBean.isCharArrayMappedToString(clazz);
    }

    private static void debug(String string) {
        debugLogger.debug("[SqlFinder] " + string);
    }

    public RDBMSBean getSelectBeanTarget() {
        return this.rdbmsBean;
    }

    public List getExternalMethodParmList() {
        if (this.externalMethodParmList == null) {
            Class<?>[] classArray = this.method.getParameterTypes();
            this.externalMethodParmList = new ArrayList();
            for (int i = 0; i < classArray.length; ++i) {
                this.externalMethodParmList.add(new ParamNode(null, "param" + i, 0, classArray[i], null, null, false, false, null, false, false));
            }
        }
        return this.externalMethodParmList;
    }

    public List getExternalMethodAndInEntityParmList() {
        return this.getExternalMethodParmList();
    }

    public boolean isSingletonSelect() {
        return this.isSelect() && !Collection.class.isAssignableFrom(this.getReturnClassType()) && !ResultSet.class.isAssignableFrom(this.getReturnClassType()) && !EJBObject.class.isAssignableFrom(this.getReturnClassType()) && !EJBLocalObject.class.isAssignableFrom(this.getReturnClassType());
    }

    public boolean maxElementsReached(Collection collection, WLCachedRowSet wLCachedRowSet) {
        if (this.maxElements == 0) {
            return false;
        }
        if (collection == null && wLCachedRowSet == null) {
            return false;
        }
        if (collection != null && collection.size() < this.maxElements) {
            return false;
        }
        return wLCachedRowSet == null || wLCachedRowSet.size() >= this.maxElements;
    }

    public int getResultColumnCount() {
        return this.resultManagers.length;
    }

    public boolean usesStoredProcedure() {
        return this.usesStoredProcedure;
    }

    public boolean usesStoredFunction() {
        return this.usesStoredFunction;
    }

    public boolean usesRelationshipCaching() {
        return this.usesRelationshipCaching;
    }

    public int getRelationCount() {
        return this.relationIndex1.length;
    }

    public String getCmrFieldFinderMethodName1(int n) {
        return this.cmrFieldFinderMethodNames1[n];
    }

    public String getCmrFieldFinderMethodName2(int n) {
        return this.cmrFieldFinderMethodNames2[n];
    }

    public int getCmrFieldFinderReturnType1(int n) {
        return this.cmrFieldFinderReturnTypes1[n];
    }

    public int getCmrFieldFinderReturnType2(int n) {
        return this.cmrFieldFinderReturnTypes2[n];
    }

    public int[] getRelationIndex1() {
        return this.relationIndex1;
    }

    public int[] getRelationIndex2() {
        return this.relationIndex2;
    }

    public Method[] getRelationMethod1() {
        return this.relationMethod1;
    }

    public Method[] getRelationMethod2() {
        return this.relationMethod2;
    }

    public boolean isBlobColumn(int n) {
        return "blob".equalsIgnoreCase(this.columnTypes[n]);
    }

    public boolean isClobColumn(int n) {
        return "clob".equalsIgnoreCase(this.columnTypes[n]);
    }

    public QueryCachingHandler getQueryCachingHandler(Object[] objectArray, TTLManager tTLManager) {
        if (!this.isQueryCachingEnabled()) {
            return new QueryCachingHandler(this);
        }
        if (this.isDynamicFinder) {
            return new QueryCachingHandler(this.query, this.getMaxElements(), (Finder)this, tTLManager);
        }
        return new QueryCachingHandler(this.getFinderIndex(), objectArray, (Finder)this, tTLManager);
    }

    protected boolean checkIfQueryCachingLegal(RDBMSBean rDBMSBean) {
        if (!super.checkIfQueryCachingLegal(rDBMSBean)) {
            return false;
        }
        SqlShape sqlShape = this.rdbmsBean.getSqlShape(this.sqlShapeName);
        if (sqlShape == null) {
            return true;
        }
        String[] stringArray = sqlShape.getEjbRelationNames();
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            EjbRelation ejbRelation = this.rdbmsBean.getEjbRelation(stringArray[i]);
            Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
            String string = null;
            while (iterator.hasNext()) {
                object = (EjbRelationshipRole)iterator.next();
                RoleSource roleSource = object.getRoleSource();
                String string2 = roleSource.getEjbName();
                if (!string2.equals(this.rdbmsBean.getEjbName())) continue;
                string = object.getCmrField().getName();
                break;
            }
            if ((object = this.rdbmsBean.getRelatedRDBMSBean(string)) == null) {
                throw new AssertionError("Related RDBMS bean not found for cmr-field " + string + " from " + this.rdbmsBean.getEjbName());
            }
            if (((RDBMSBean)object).isReadOnly()) continue;
            this.log.logWarning(this.fmt.QUERY_CACHING_SQLFINDER_HAS_RW_RELATED_BEAN(rDBMSBean.getEjbName(), this.getName(), sqlShape.getSqlShapeName(), ejbRelation.getEjbRelationName()));
            return false;
        }
        return true;
    }
}

