/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import weblogic.ejb.container.cmp11.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp11.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp11.rdbms.finders.Finder;

public final class BeanWriter {
    public static final boolean debug = false;
    public static final boolean verbose = false;
    private PrintWriter writer = null;
    private int indent = 0;

    public void putRDBMSBean(RDBMSBean rDBMSBean, OutputStream outputStream) {
        Object object;
        this.writer = new PrintWriter(outputStream, true);
        this.docType("weblogic-rdbms-bean", "-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB RDBMS Persistence//EN", "http://www.bea.com/servers/wls510/dtd/weblogic-rdbms-persistence.dtd");
        this.openTag("weblogic-rdbms-bean");
        this.stringValue("pool-name", rDBMSBean.getPoolName(), true);
        this.stringValue("schema-name", rDBMSBean.getSchemaName(), false);
        this.stringValue("table-name", rDBMSBean.getTableName(), true);
        this.openTag("attribute-map");
        Iterator iterator = rDBMSBean.getObjectLinks();
        while (iterator.hasNext()) {
            object = (RDBMSBean.ObjectLink)iterator.next();
            this.openTag("object-link");
            this.stringValue("bean-field", ((RDBMSBean.ObjectLink)object).getBeanField(), true);
            this.stringValue("dbms-column", ((RDBMSBean.ObjectLink)object).getDBMSColumn(), true);
            this.closeTag("object-link");
        }
        this.closeTag("attribute-map");
        this.openTag("finder-list");
        object = rDBMSBean.getFinders();
        while (object.hasNext()) {
            Object object2;
            Object object3;
            Finder finder = (Finder)object.next();
            this.openTag("finder");
            this.stringValue("method-name", finder.getName(), true);
            this.openTag("method-params");
            Iterator iterator2 = finder.getParameterTypes();
            while (iterator2.hasNext()) {
                object3 = (String)iterator2.next();
                this.stringValue("method-param", (String)object3, false);
            }
            this.closeTag("method-params");
            this.cDataValue("finder-query", finder.getWeblogicQuery(), true);
            object3 = finder.getFinderExpressions();
            while (object3.hasNext()) {
                object2 = (Finder.FinderExpression)object3.next();
                this.openTag("finder-expression");
                this.intValue("expression-number", ((Finder.FinderExpression)object2).getNumber());
                this.cDataValue("expression-text", ((Finder.FinderExpression)object2).getExpressionText(), false);
                this.stringValue("expression-type", ((Finder.FinderExpression)object2).getExpressionType(), true);
                this.closeTag("finder-expression");
            }
            if (finder.getFinderOptions() != null) {
                this.openTag("finder-options");
                object2 = finder.getFinderOptions();
                this.booleanValue("find-for-update", ((Finder.FinderOptions)object2).getFindForUpdate());
                this.closeTag("finder-options");
            }
            this.closeTag("finder");
        }
        this.closeTag("finder-list");
        this.openTag("options");
        this.booleanValue("use-quoted-names", rDBMSBean.getUseQuotedNames());
        if (rDBMSBean.getTransactionIsolation() != null) {
            this.stringValue("transaction-isolation", RDBMSUtils.isolationLevelToString(rDBMSBean.getTransactionIsolation()), false);
        }
        this.closeTag("options");
        this.closeTag("weblogic-rdbms-bean");
    }

    private void openTag(String string) {
        this.indentCurrentLevel();
        this.printOpenTag(string);
        this.writer.println();
        ++this.indent;
    }

    private void closeTag(String string) {
        --this.indent;
        this.indentCurrentLevel();
        this.printCloseTag(string);
        this.writer.println();
    }

    private void stringValue(String string, String string2, boolean bl) {
        if (bl || string2 != null) {
            this.indentCurrentLevel();
            this.printOpenTag(string);
            if (string2 != null) {
                this.writer.print(string2);
            }
            this.printCloseTag(string);
            this.writer.println();
        }
    }

    private void cDataValue(String string, String string2, boolean bl) {
        this.stringValue(string, "<![CDATA[" + string2 + "]]>", bl);
    }

    private void booleanValue(String string, boolean bl) {
        this.indentCurrentLevel();
        this.printOpenTag(string);
        this.writer.print(new Boolean(bl).toString());
        this.printCloseTag(string);
        this.writer.println();
    }

    private void intValue(String string, int n) {
        this.indentCurrentLevel();
        this.printOpenTag(string);
        this.writer.print(n);
        this.printCloseTag(string);
        this.writer.println();
    }

    private void indentCurrentLevel() {
        for (int i = 0; i < this.indent * 2; ++i) {
            this.writer.print(' ');
        }
    }

    private void printOpenTag(String string) {
        this.writer.print("<");
        this.writer.print(string);
        this.writer.print(">");
    }

    private void printCloseTag(String string) {
        this.writer.print("</");
        this.writer.print(string);
        this.writer.print(">");
    }

    private void docType(String string, String string2, String string3) {
        this.writer.print("<!DOCTYPE ");
        this.writer.print(string);
        this.writer.println(" PUBLIC ");
        this.writer.print(" \"");
        this.writer.print(string2);
        this.writer.println("\"");
        this.writer.print(" \"");
        this.writer.print(string3);
        this.writer.print("\">");
        this.writer.println();
    }
}

