/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public abstract class CMPDDParser {
    private WeblogicRdbmsJarBean cmpDescriptor;
    private String currentEJBName;
    private String fileName = null;
    protected String encoding = null;
    private CompatibilitySettings compat;
    protected EjbDescriptorBean ejbDescriptor;
    protected static EJBComplianceTextFormatter fmt;

    public CMPDDParser() {
        fmt = new EJBComplianceTextFormatter();
    }

    public void setEJBDescriptor(EjbDescriptorBean ejbDescriptorBean) {
        this.ejbDescriptor = ejbDescriptorBean;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    protected String getFileName() {
        return this.fileName;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setCurrentEJBName(String string) {
        this.currentEJBName = string;
    }

    protected String getCurrentEJBName() {
        return this.currentEJBName;
    }

    public void setDescriptorMBean(WeblogicRdbmsJarBean weblogicRdbmsJarBean) {
        this.cmpDescriptor = weblogicRdbmsJarBean;
    }

    public WeblogicRdbmsJarBean getDescriptorMBean() {
        return this.cmpDescriptor;
    }

    public CompatibilitySettings getCompatibilitySettings() {
        return this.compat;
    }

    private static void p(String string) {
        System.out.println("***<CMPDDParser> " + string);
    }

    public abstract void process(Reader var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(InputStream var1) throws IOException, XMLParsingException, XMLProcessingException;

    public void setUseQuotedNames(boolean bl) {
        if (this.compat == null) {
            this.compat = new CompatibilitySettings();
        }
        this.compat.useQuotedNames = bl;
    }

    public void setIsolationLevel(Integer n) {
        if (this.compat == null) {
            this.compat = new CompatibilitySettings();
        }
        this.compat.isolationLevel = n;
    }

    protected void addFinderExpression(String string, FinderExpression finderExpression) {
        ArrayList<FinderExpression> arrayList;
        if (this.compat == null) {
            this.compat = new CompatibilitySettings();
        }
        if ((arrayList = (ArrayList<FinderExpression>)this.compat.finderExpressionMap.get(string)) == null) {
            arrayList = new ArrayList<FinderExpression>();
            this.compat.finderExpressionMap.put(string, arrayList);
        }
        arrayList.add(finderExpression);
    }

    public static class CompatibilitySettings {
        public boolean useQuotedNames = false;
        public Integer isolationLevel = null;
        public Map finderExpressionMap = new HashMap();
    }

    public static class FinderExpression {
        public int expressionNumber;
        public String expressionText;
        public String expressionType;
    }
}

