/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSDescriptor;
import weblogic.ejb.container.cmp11.rdbms.AttributeMapException;
import weblogic.ejb.container.cmp11.rdbms.BeanWriter;
import weblogic.ejb.container.cmp11.rdbms.CMPDDParser;
import weblogic.ejb.container.cmp11.rdbms.InvalidBeanException;
import weblogic.ejb.container.cmp11.rdbms.PersistenceManagerImpl;
import weblogic.ejb.container.cmp11.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp11.rdbms.RDBMSDeployment;
import weblogic.ejb.container.cmp11.rdbms.RDBMSDeploymentInfo;
import weblogic.ejb.container.cmp11.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp11.rdbms.codegen.RDBMSCodeGenerator;
import weblogic.ejb.container.cmp11.rdbms.codegen.TypeUtils;
import weblogic.ejb.container.cmp11.rdbms.compliance.RDBMSComplianceChecker;
import weblogic.ejb.container.cmp11.rdbms.finders.Finder;
import weblogic.ejb.container.cmp11.rdbms.finders.FinderNotFoundException;
import weblogic.ejb.container.cmp11.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp11.rdbms.finders.InvalidFinderException;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.persistence.spi.CMPDeployer;
import weblogic.ejb.container.persistence.spi.JarDeployment;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLProcessor;

public final class Deployer
implements CMPDeployer {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private RDBMSBean currBean = null;
    private List fieldList = null;
    private List finderList = null;
    private List primaryKeyList = null;
    private Map parameterMap = null;
    private Class ejbClass = null;
    private Class homeInterfaceClass = null;
    private Class remoteInterfaceClass = null;
    private Class primaryKeyClass = null;
    private boolean isCompoundPK = true;
    private CMPBeanDescriptor bd = null;
    private RDBMSDeployment rdbmsDeployment = null;

    public void setup(JarDeployment jarDeployment) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.setup()");
        }
        this.currBean = new RDBMSBean();
        this.rdbmsDeployment = (RDBMSDeployment)jarDeployment;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        assert (cMPBeanDescriptor != null);
        this.bd = cMPBeanDescriptor;
        this.ejbClass = this.bd.getBeanClass();
        this.homeInterfaceClass = this.bd.getHomeInterfaceClass();
        this.remoteInterfaceClass = this.bd.getRemoteInterfaceClass();
        this.primaryKeyClass = this.bd.getPrimaryKeyClass();
        this.finderList = ClassUtils.getFinderMethodList(this.homeInterfaceClass);
        this.primaryKeyList = new ArrayList(this.bd.getPrimaryKeyFieldNames());
        this.isCompoundPK = this.bd.hasComplexPrimaryKey();
        this.fieldList = new ArrayList(this.bd.getCMFieldNames());
    }

    public void setBeanMap(Map map) {
        throw new AssertionError("Deployer.setBeanMap called for a 1.1 CMP bean.");
    }

    public void setRelationships(Relationships relationships) {
        throw new AssertionError("Deployer.setRelationships called for a 1.1 CMP bean.");
    }

    public void setDependentMap(Map map) {
        throw new AssertionError("Deployer.setDependentMap called for a 1.1 CMP bean.");
    }

    public void setParameters(Map map) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.setParameters()");
        }
        this.parameterMap = new HashMap(map);
    }

    public void initializePersistenceManager(PersistenceManager persistenceManager) throws WLDeploymentException {
        assert (this.bd != null);
        PersistenceManagerImpl persistenceManagerImpl = (PersistenceManagerImpl)persistenceManager;
        persistenceManagerImpl.setBeanInfo(this.currBean);
        persistenceManagerImpl.bd = this.bd;
    }

    private boolean fieldListContainsField(String string) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.fieldListContainsField()");
        }
        for (String string2 : this.fieldList) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean currBeanContainsField(String string) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.currBeanContainsField()");
        }
        Iterator iterator = this.currBean.getObjectLinks();
        while (iterator.hasNext()) {
            RDBMSBean.ObjectLink objectLink = (RDBMSBean.ObjectLink)iterator.next();
            if (!objectLink.getBeanField().equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized RDBMSBean getTypeSpecificData() {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.getTypeSpecificData()");
        }
        return this.currBean;
    }

    public synchronized void setTypeSpecificData(RDBMSBean rDBMSBean) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.setTypeSpecificData()");
        }
        this.currBean = rDBMSBean;
    }

    /*
     * Loose catch block
     */
    public RDBMSDeploymentInfo parseXMLFile(VirtualJarFile virtualJarFile, String string, String string2, ProcessorFactory processorFactory, EjbDescriptorBean ejbDescriptorBean) throws Exception {
        CMPDDParser.CompatibilitySettings compatibilitySettings;
        WeblogicRdbmsJarBean weblogicRdbmsJarBean;
        block24: {
            BufferedInputStream bufferedInputStream = null;
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("getRDBMSBean(" + virtualJarFile + ")");
            }
            weblogicRdbmsJarBean = null;
            compatibilitySettings = null;
            ZipEntry zipEntry = virtualJarFile.getEntry(string);
            if (zipEntry == null) {
                weblogicRdbmsJarBean = this.parseXMLFileWithSchema(null, string, ejbDescriptorBean);
                if (weblogicRdbmsJarBean == null) {
                    Loggable loggable = EJBLogger.logRdbmsDescriptorNotFoundInJarLoggable((String)string);
                    throw new RDBMSException(loggable.getMessage());
                }
            } else {
                InputStream inputStream = virtualJarFile.getInputStream(zipEntry);
                bufferedInputStream = new BufferedInputStream(inputStream);
                String string3 = DDUtils.getXMLEncoding(bufferedInputStream, string);
                bufferedInputStream.mark(0x100000);
                CMPDDParser cMPDDParser = null;
                XMLProcessor xMLProcessor = processorFactory.getProcessor(bufferedInputStream, RDBMSUtils.validRdbmsCmp11JarPublicIds);
                bufferedInputStream.reset();
                if (xMLProcessor != null) {
                    if (!(xMLProcessor instanceof CMPDDParser)) {
                        Loggable loggable = EJBLogger.logincorrectXMLFileVersionLoggable((String)string, (String)string2, (String)xMLProcessor.getClass().getName());
                        throw new RDBMSException(loggable.getMessage());
                    }
                    cMPDDParser = (CMPDDParser)((Object)xMLProcessor);
                }
                if (null != cMPDDParser) {
                    cMPDDParser.setCurrentEJBName(string2);
                    cMPDDParser.setFileName(string);
                    cMPDDParser.setEJBDescriptor(ejbDescriptorBean);
                    cMPDDParser.setEncoding(string3);
                    cMPDDParser.process(bufferedInputStream);
                    weblogicRdbmsJarBean = cMPDDParser.getDescriptorMBean();
                    compatibilitySettings = cMPDDParser.getCompatibilitySettings();
                } else {
                    throw new AssertionError("Couldn't find a loader for weblogic-cmp-ejb-jar.xml. The document probably references an unknown dtd.");
                }
            }
            Object var16_21 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                break block24;
            }
            catch (IOException iOException) {}
            break block24;
            {
                catch (ProcessorFactoryException processorFactoryException) {
                    try {
                        bufferedInputStream.reset();
                        weblogicRdbmsJarBean = this.parseXMLFileWithSchema(virtualJarFile, string, ejbDescriptorBean);
                        if (weblogicRdbmsJarBean == null) {
                            Loggable loggable = EJBLogger.logRdbmsDescriptorNotFoundInJarLoggable((String)string);
                            throw new RDBMSException(loggable.getMessage());
                        }
                    }
                    catch (RDBMSException rDBMSException) {
                        throw rDBMSException;
                    }
                    catch (Exception exception) {
                        throw new RDBMSException(StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                    ejbDescriptorBean.addWeblogicRdbms11JarBean(weblogicRdbmsJarBean);
                    Object var16_22 = null;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                        break block24;
                    }
                    catch (IOException iOException) {}
                    break block24;
                }
                catch (IOException iOException) {
                    throw new RDBMSException(StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                }
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return new RDBMSDeploymentInfo(weblogicRdbmsJarBean, compatibilitySettings, string);
    }

    private WeblogicRdbmsJarBean parseXMLFileWithSchema(VirtualJarFile virtualJarFile, String string, EjbDescriptorBean ejbDescriptorBean) throws Exception {
        try {
            WeblogicRdbmsJarBean weblogicRdbmsJarBean = null;
            RDBMSDescriptor rDBMSDescriptor = new RDBMSDescriptor(virtualJarFile, string, ejbDescriptorBean.getAppName(), ejbDescriptorBean.getUri(), ejbDescriptorBean.getDeploymentPlan(), ejbDescriptorBean.getConfigDirectory());
            weblogicRdbmsJarBean = ejbDescriptorBean.isReadOnly() ? (WeblogicRdbmsJarBean)rDBMSDescriptor.getDescriptorBean() : (WeblogicRdbmsJarBean)rDBMSDescriptor.getEditableDescriptorBean();
            return weblogicRdbmsJarBean;
        }
        catch (Exception exception) {
            throw new RDBMSException(StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    public synchronized void readTypeSpecificData(VirtualJarFile virtualJarFile, String string) throws Exception {
        Object object;
        Object object2;
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("readTypeSpecificData called.");
        }
        if (this.rdbmsDeployment.needToReadFile(string)) {
            if (debugLogger.isDebugEnabled()) {
                Deployer.debug("processing XML for bean: " + this.bd.getEJBName());
            }
            try {
                object2 = new ProcessorFactory();
                object = this.parseXMLFile(virtualJarFile, string, this.bd.getEJBName(), (ProcessorFactory)object2, this.bd.getEjbDescriptorBean());
                this.rdbmsDeployment.addRdbmsBeans(((RDBMSDeploymentInfo)object).getRDBMSBeanMap());
                this.rdbmsDeployment.addDescriptorMBean(((RDBMSDeploymentInfo)object).getWeblogicRdbmsJarBean());
                this.rdbmsDeployment.addFileName(string);
            }
            catch (Exception exception) {
                if (debugLogger.isDebugEnabled()) {
                    Deployer.debug("parseXMLFile exception: " + exception);
                }
                throw exception;
            }
        }
        this.currBean = this.rdbmsDeployment.getRDBMSBean(this.bd.getEJBName());
        this.currBean.setCMPBeanDescriptor(this.bd);
        if (this.currBean == null) {
            object2 = EJBLogger.logUnableToFindBeanInRDBMSDescriptorLoggable((String)this.bd.getEJBName(), (String)string);
            throw new RDBMSException(object2.getMessage());
        }
        object2 = new RDBMSComplianceChecker(this.bd, this.ejbClass, this.fieldList);
        ((RDBMSComplianceChecker)object2).checkCompliance();
        object = this.currBean.getFinders();
        Finder finder = null;
        while (object.hasNext()) {
            finder = (Finder)object.next();
            Iterator iterator = finder.getFinderExpressions();
            if (!iterator.hasNext()) continue;
            Loggable loggable = EJBLogger.logPersistenceUsesFinderExpressionsLoggable();
            throw new WLDeploymentException(loggable.getMessage());
        }
        boolean bl = false;
        object = this.currBean.getFinders();
        finder = null;
        while (object.hasNext()) {
            finder = (Finder)object.next();
            if (!finder.getName().equals("findByPrimaryKey")) continue;
            bl = true;
            object.remove();
            break;
        }
        Finder finder2 = this.generateFindByPrimaryKeyFinder();
        if (bl) {
            finder2.setFinderOptions(finder.getFinderOptions());
        }
        this.currBean.addFinder(finder2);
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("currBean=" + this.currBean);
        }
        String string2 = "False";
        String string3 = "";
        int n = 0;
        WeblogicRdbmsJarBean weblogicRdbmsJarBean = this.rdbmsDeployment.getDescriptorMBean(this.currBean.getEjbName());
        if (weblogicRdbmsJarBean != null) {
            string2 = weblogicRdbmsJarBean.isCreateDefaultDbmsTables() ? "CreateOnly" : "Disabled";
            string3 = weblogicRdbmsJarBean.getValidateDbSchemaWith();
            n = MethodUtils.dbmsType2int(weblogicRdbmsJarBean.getDatabaseType());
        }
        if (string3 == null) {
            string3 = "";
        }
        this.currBean.setCreateDefaultDBMSTables(string2);
        this.currBean.setValidateDbSchemaWith(string3);
        this.currBean.setDatabaseType(n);
        this.currBean.setPrimaryKeyFields(this.primaryKeyList);
    }

    public void saveTypeSpecificData(OutputStream outputStream) {
        assert (outputStream != null);
        assert (this.currBean != null);
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.saveTypeSpecificData()");
            Deployer.debug("   Deployer is " + this);
        }
        BeanWriter beanWriter = new BeanWriter();
        beanWriter.putRDBMSBean(this.currBean, outputStream);
    }

    public void preCodeGeneration(CMPCodeGenerator cMPCodeGenerator) throws ErrorCollectionException {
        assert (cMPCodeGenerator instanceof RDBMSCodeGenerator);
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.preCodeGeneration()");
        }
        RDBMSCodeGenerator rDBMSCodeGenerator = (RDBMSCodeGenerator)cMPCodeGenerator;
        this.validateBeanSettings();
        this.currBean.generateFinderSQLStatements();
        rDBMSCodeGenerator.setCMPBeanDescriptor(this.bd);
        rDBMSCodeGenerator.setRDBMSBean(this.currBean);
        rDBMSCodeGenerator.setFinderList(this.finderList);
        rDBMSCodeGenerator.setPrimaryKeyFields(this.primaryKeyList);
        rDBMSCodeGenerator.setParameterMap(this.parameterMap);
        rDBMSCodeGenerator.setCMFields(this.currBean.getFieldNamesList());
    }

    public void postCodeGeneration(CMPCodeGenerator cMPCodeGenerator) {
        assert (cMPCodeGenerator instanceof RDBMSCodeGenerator);
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.postCodeGeneration()");
        }
        RDBMSCodeGenerator rDBMSCodeGenerator = (RDBMSCodeGenerator)cMPCodeGenerator;
    }

    private void validateBeanSettings() throws InvalidBeanException {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.validateBeanSettings()");
        }
        InvalidBeanException invalidBeanException = new InvalidBeanException();
        this.validateAttributeMapAndFieldList(invalidBeanException);
        this.validateAttributeFieldsInBean(invalidBeanException);
        this.validateFinderMethodsHaveDescriptors(invalidBeanException);
        this.validateFinderExpressionsHaveAppropriateTypes(invalidBeanException);
        this.validateFinderQueries(invalidBeanException);
        if (invalidBeanException.getExceptions().size() > 0) {
            throw invalidBeanException;
        }
    }

    private boolean validateFinderMethodsHaveDescriptors(InvalidBeanException invalidBeanException) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.validateFinderMethodsHaveDescriptors()");
        }
        for (Method method : this.finderList) {
            Finder finder = this.currBean.getFinderForMethod(method);
            if (finder != null) continue;
            invalidBeanException.add(new FinderNotFoundException(method, this.currBean.getEjbName(), this.currBean.getFileName()));
        }
        return true;
    }

    private void validateFinderExpressionsHaveAppropriateTypes(InvalidBeanException invalidBeanException) {
        IllegalExpressionException illegalExpressionException = null;
        Iterator iterator = this.currBean.getFinders();
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            Iterator iterator2 = finder.getFinderExpressions();
            while (iterator2.hasNext()) {
                Finder.FinderExpression finderExpression = (Finder.FinderExpression)iterator2.next();
                String string = finderExpression.getExpressionType();
                Class clazz = null;
                try {
                    clazz = ClassUtils.nameToClass(string, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    illegalExpressionException = new IllegalExpressionException(3, string, finderExpression);
                    illegalExpressionException.setFinder(finder);
                    invalidBeanException.add(illegalExpressionException);
                }
                if (TypeUtils.isValidSQLType(clazz)) continue;
                illegalExpressionException = new IllegalExpressionException(3, string, finderExpression);
                illegalExpressionException.setFinder(finder);
                invalidBeanException.add(illegalExpressionException);
            }
        }
    }

    private void validateAttributeFieldsInBean(InvalidBeanException invalidBeanException) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.validateAttributeFieldsInBean()");
        }
        Iterator iterator = this.currBean.getObjectLinks();
        while (iterator.hasNext()) {
            RDBMSBean.ObjectLink objectLink = (RDBMSBean.ObjectLink)iterator.next();
            String string = objectLink.getBeanField();
            try {
                Field field = this.ejbClass.getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                invalidBeanException.add(new AttributeMapException(2, string));
            }
        }
    }

    private void validateAttributeMapAndFieldList(InvalidBeanException invalidBeanException) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.validateAttributeMapAndFieldList()");
        }
        Iterator iterator = this.currBean.getObjectLinks();
        while (iterator.hasNext()) {
            RDBMSBean.ObjectLink objectLink = (RDBMSBean.ObjectLink)iterator.next();
            String string = objectLink.getBeanField();
            if (this.fieldListContainsField(string)) continue;
            invalidBeanException.add(new AttributeMapException(3, string));
        }
        for (String string : this.fieldList) {
            if (this.currBeanContainsField(string)) continue;
            invalidBeanException.add(new AttributeMapException(4, string));
        }
    }

    private void validateFinderQueries(InvalidBeanException invalidBeanException) {
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("ejb20.cmp11.rdbms.Deployer.validateFinderQueries(()");
        }
        Iterator iterator = this.currBean.getFinders();
        while (iterator.hasNext()) {
            IllegalExpressionException illegalExpressionException;
            Finder finder = (Finder)iterator.next();
            try {
                finder.parseExpression();
            }
            catch (EJBCException eJBCException) {
                illegalExpressionException = new IllegalExpressionException(4, finder.getWeblogicQuery());
                illegalExpressionException.setFinder(finder);
                invalidBeanException.add(illegalExpressionException);
            }
            catch (InvalidFinderException invalidFinderException) {
                illegalExpressionException = new IllegalExpressionException(4, finder.getWeblogicQuery());
                illegalExpressionException.setFinder(finder);
                invalidBeanException.add(illegalExpressionException);
            }
        }
    }

    private Finder generateFindByPrimaryKeyFinder() {
        assert (this.primaryKeyClass != null) : "PrimaryKeyClass is null";
        assert (this.ejbClass != null) : "ejbClass is null";
        assert (this.currBean != null) : "currBean is null";
        String string = "findByPrimaryKey";
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.bd.getPrimaryKeyFieldNames();
        assert (set != null) : "No primaryKeyList set in Deployer.";
        String[] stringArray = set.toArray(new String[0]);
        if (stringArray.length > 1) {
            stringBuffer.append("(& ");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            assert (string2 != null) : "Field " + i + " in pkArray is null.";
            String string3 = " (= $" + i + " " + string2 + " ) ";
            stringBuffer.append(string3);
        }
        if (stringArray.length > 1) {
            stringBuffer.append(")");
        }
        if (debugLogger.isDebugEnabled()) {
            Deployer.debug("Created findByPrimaryKey query of " + stringBuffer);
        }
        Finder finder = null;
        try {
            finder = new Finder(string, stringBuffer.toString());
        }
        catch (InvalidFinderException invalidFinderException) {
            throw new AssertionError("Caught an InvalidFinderException in generated finder: " + invalidFinderException);
        }
        finder.addParameterType(this.primaryKeyClass.getName());
        return finder;
    }

    public String toString() {
        Object object;
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("[weblogic.cmp11.rdbms.Deployer =\n");
        stringBuffer.append("\tremote interface = " + (this.remoteInterfaceClass != null ? this.remoteInterfaceClass.getName() : "null"));
        stringBuffer.append("\n");
        stringBuffer.append("\thome interface = " + (this.homeInterfaceClass != null ? this.homeInterfaceClass.getName() : "null"));
        stringBuffer.append("\n");
        stringBuffer.append("\tbean class = " + (this.ejbClass != null ? this.ejbClass.getName() : "null"));
        stringBuffer.append("\n");
        stringBuffer.append("\tprimary key class = " + (this.primaryKeyClass != null ? this.primaryKeyClass.getName() : "null"));
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\tparameterMap = {");
        if (this.parameterMap == null || this.parameterMap.keySet() == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.parameterMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append("(" + (String)object + "," + "value" + ")");
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("\tfieldList = {");
        if (this.fieldList == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.fieldList.iterator();
            while (iterator.hasNext()) {
                object = (Field)iterator.next();
                stringBuffer.append(((Field)object).getName());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("\tfinderList = {");
        if (this.finderList == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.finderList.iterator();
            while (iterator.hasNext()) {
                object = (Method)iterator.next();
                stringBuffer.append(((Method)object).getName());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("\tprimaryKeyList = {");
        if (this.primaryKeyList == null) {
            stringBuffer.append("null}\n");
        } else {
            iterator = this.primaryKeyList.iterator();
            while (iterator.hasNext()) {
                object = (Field)iterator.next();
                stringBuffer.append(((Field)object).getName());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append("}\n");
            }
        }
        if (this.currBean == null) {
            stringBuffer.append("\tcurrBean = null\n");
        } else {
            stringBuffer.append("\t" + this.currBean.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public RDBMSDeployment getJarDeployment() {
        return this.rdbmsDeployment;
    }

    public Object getEntityManager() {
        return null;
    }

    private static void debug(String string) {
        debugLogger.debug("[Deployer] " + string);
    }
}

