/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EntityBean;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.cmp11.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp11.rdbms.RDBMSUtils;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.WLCMPPersistenceManager;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.persistence.spi.CMPBean;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.persistence.spi.RSInfo;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb.container.utils.TableVerifier;
import weblogic.ejb.container.utils.TableVerifierMetaData;
import weblogic.ejb.container.utils.TableVerifierSqlQuery;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.persistence.spi.PersistenceRuntimeException;
import weblogic.logging.Loggable;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.AssertionError;

public final class PersistenceManagerImpl
implements PersistenceManager,
WLCMPPersistenceManager {
    private static final DebugLogger deploymentLogger = EJBDebugService.cmpDeploymentLogger;
    private static final DebugLogger runtimeLogger = EJBDebugService.cmpRuntimeLogger;
    private static final int GET_FIELD_INFO = 0;
    private static final int GET_COLUMN_INFO = 1;
    private BaseEntityManager beanManager = null;
    CMPBeanDescriptor bd = null;
    private RDBMSBean bean = null;
    private Driver jtsDriver = null;
    private Context ctx = null;
    private DataSource ds = null;
    private ClassLoader classLoader = null;
    private boolean usingJtsDriver = false;
    private TableVerifier verifier;
    private int databaseType = 0;
    private Map variable2SQLType = new HashMap();
    private Map variable2nullable = new HashMap();
    private TransactionManager tm = null;
    private String[] indexColumnMap = null;

    public void setup(BeanManager beanManager) throws Exception {
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("PersistenceManagerImpl.setup");
        }
        assert (this.bd != null) : "bd != null failed ";
        assert (this.bean != null) : "bean != null failed";
        this.beanManager = (BaseEntityManager)beanManager;
        this.classLoader = this.beanManager.getEJBHome().getBeanInfo().getClassLoader();
        this.verifier = "MetaData".equalsIgnoreCase(this.getValidateDbSchemaWith()) ? new TableVerifierMetaData() : new TableVerifierSqlQuery();
        if (this.bean.getPoolName() != null) {
            try {
                this.jtsDriver = (Driver)Class.forName("weblogic.jdbc.jts.Driver").newInstance();
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logUnableToLoadJTSDriverLoggable((Exception)exception);
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            assert (this.jtsDriver != null);
            this.usingJtsDriver = true;
        } else {
            assert (this.bean.getDataSourceName() != null);
            try {
                this.ctx = new InitialContext();
            }
            catch (NamingException namingException) {
                throw new AssertionError((Throwable)namingException);
            }
            try {
                this.ds = (DataSource)this.ctx.lookup(this.bean.getDataSourceName());
            }
            catch (NamingException namingException) {
                Loggable loggable = EJBLogger.logDataSourceNotFoundLoggable((String)this.bean.getDataSourceName());
                throw new WLDeploymentException(loggable.getMessage(), namingException);
            }
        }
        this.databaseType = this.bean.getDatabaseType();
        this.tm = TxHelper.getTransactionManager();
        this.verifyDatabaseType();
        this.verifyTablesExist();
        this.populateIndexColumnMap();
        this.populateFieldSQLTypeMap();
    }

    public String getCreateDefaultDBMSTables() {
        return this.bean.getCreateDefaultDBMSTables();
    }

    public String getValidateDbSchemaWith() {
        return this.bean.getValidateDbSchemaWith();
    }

    public String getEjbName() {
        return this.bean.getEjbName();
    }

    public EntityBean getBeanFromPool() throws InternalException {
        return this.beanManager.getBeanFromPool();
    }

    public EntityBean getBeanFromRS(Object object, RSInfo rSInfo) throws InternalException {
        return this.beanManager.getBeanFromRS(object, rSInfo);
    }

    public Object finderGetEoFromBeanOrPk(EntityBean entityBean, Object object, boolean bl) throws InternalException {
        return this.beanManager.finderGetEoFromBeanOrPk(entityBean, object, bl);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Object findByPrimaryKey(EntityBean entityBean, Method method, Object object) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.findByPrimaryKey");
        }
        assert (entityBean != null);
        assert (method != null);
        assert (object != null);
        Object[] objectArray = new Object[]{object};
        try {
            return method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public int getSelectForUpdateValue() {
        try {
            Transaction transaction = this.tm.getTransaction();
            TransactionImpl transactionImpl = (TransactionImpl)transaction;
            Integer n = null;
            if (transactionImpl != null) {
                n = (Integer)transactionImpl.getProperty("SELECT_FOR_UPDATE");
            }
            if (n == null) {
                return 0;
            }
            return n;
        }
        catch (Exception exception) {
            throw new PersistenceRuntimeException(exception);
        }
    }

    public String selectForUpdate() {
        return RDBMSUtils.selectForUpdateToString(this.getSelectForUpdateValue());
    }

    private void verifyDatabaseType() throws WLDeploymentException {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.databaseType = this.verifier.verifyDatabaseType(connection, this.databaseType);
            }
            catch (Exception exception) {
                throw new WLDeploymentException(exception.getMessage(), exception);
            }
            Object var4_2 = null;
            this.releaseResources(connection, null, null);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    private void verifyTablesExist() throws WLDeploymentException {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.verifier.verifyOrCreateOrAlterTable(this, connection, this.bean.getQualifiedTableName(), this.getPersistentFieldsOrColumns(1), true, this.getPersistentFieldsOrColumns(0), this.variable2SQLType, this.variable2nullable, this.bean.getCreateDefaultDBMSTables(), false);
            }
            catch (Exception exception) {
                throw new WLDeploymentException(exception.getMessage(), exception);
            }
            Object var4_2 = null;
            this.releaseResources(connection, null, null);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    public EntityBean findByPrimaryKeyLoadBean(EntityBean entityBean, Method method, Object object) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.findByPrimaryKeyLoadBean");
        }
        try {
            Object[] objectArray = new Object[]{object};
            return (EntityBean)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Object scalarFinder(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.scalarFinder");
        }
        try {
            return method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Map scalarFinderLoadBean(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.scalarFinderLoadBean");
        }
        try {
            return (Map)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Enumeration enumFinder(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.enumFinder");
        }
        try {
            return (Enumeration)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Collection collectionFinder(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.collectionFinder");
        }
        try {
            return (Collection)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public Map collectionFinderLoadBean(EntityBean entityBean, Method method, Object[] objectArray) throws Throwable {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.collectionFinderLoadBean");
        }
        try {
            return (Map)method.invoke((Object)entityBean, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", throwable);
            }
            throw throwable;
        }
        catch (Exception exception) {
            if (runtimeLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugRuntime("Error invoking finder: ", exception);
            }
            throw exception;
        }
    }

    public void loadBeanFromRS(EntityBean entityBean, RSInfo rSInfo) throws InternalException {
        try {
            ((CMPBean)entityBean).__WL_loadGroupByIndex(rSInfo.getGroupIndex(), rSInfo.getRS(), rSInfo.getOffset(), rSInfo.getPK(), entityBean);
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("Error load bean states from ResultSet", exception);
        }
    }

    public Connection getConnection() throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.getConnection");
        }
        Connection connection = null;
        if (this.usingJtsDriver) {
            assert (this.getDriver() != null);
            assert (this.bean.getPoolName() != null);
            assert (this.getDriver().acceptsURL("jdbc:weblogic:jts:" + this.bean.getPoolName()));
            connection = this.getDriver().connect("jdbc:weblogic:jts:" + this.bean.getPoolName(), null);
        } else {
            connection = this.ds.getConnection();
        }
        if (connection == null) {
            Loggable loggable = EJBLogger.logCouldNotGetConnectionFromLoggable((String)(this.connectionProducerType() + " '" + this.connectionProducerName() + "'"));
            throw new SQLException(loggable.getMessage());
        }
        return connection;
    }

    public void setBeanInfo(RDBMSBean rDBMSBean) {
        assert (rDBMSBean != null);
        assert (rDBMSBean.getPoolName() != null || rDBMSBean.getDataSourceName() != null) : "No pool or data source set for this bean.";
        assert (rDBMSBean.getTableName() != null) : "No table name set for this bean.";
        this.bean = rDBMSBean;
    }

    public RDBMSBean getBeanInfo() {
        return this.bean;
    }

    private Driver getDriver() {
        return this.jtsDriver;
    }

    private String connectionProducerType() {
        if (this.usingJtsDriver) {
            return "connection pool";
        }
        return "data source";
    }

    private String connectionProducerName() {
        if (this.usingJtsDriver) {
            return this.bean.getPoolName();
        }
        return this.bean.getDataSourceName();
    }

    private void populateIndexColumnMap() {
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("PersistenceManagerImpl.populateIndexColumnMap(");
        }
        Map map = this.getBeanInfo().getFieldToColumnMap();
        String[] stringArray = this.bean.getFieldNamesList().toArray(new String[0]);
        this.indexColumnMap = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.indexColumnMap[i] = (String)map.get(stringArray[i]);
        }
    }

    public String getColumnName(int n) {
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("PersistenceManagerImpl.getColumnName");
        }
        assert (this.indexColumnMap != null);
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("modifiedIndex: " + n + " indexColumnMap.length: " + this.indexColumnMap.length);
        }
        assert (n < this.indexColumnMap.length);
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("returning: " + this.indexColumnMap[n]);
        }
        return this.indexColumnMap[n];
    }

    private List getPersistentFieldsOrColumns(int n) {
        List list = this.getBeanInfo().getFieldNamesList();
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.getBeanInfo().getFieldToColumnMap();
        for (String string : list) {
            String string2 = (String)map.get(string);
            assert (string2 != null);
            arrayList.add(string2);
        }
        switch (n) {
            case 0: {
                return list;
            }
            case 1: {
                return arrayList;
            }
        }
        throw new AssertionError("Unknown returnType: " + n + " encountered in " + "RDBMSersistenceManager." + "getPersistentFieldsOrColumns(int returnType)");
    }

    private void populateFieldSQLTypeMap() throws WLDeploymentException {
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("PersistenceManagerImpl.populateFieldSQLTypeMap");
        }
        if (this.variable2SQLType.size() > 0) {
            return;
        }
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.verifier.verifyOrCreateOrAlterTable(this, connection, this.getBeanInfo().getQualifiedTableName(), this.getPersistentFieldsOrColumns(1), true, this.getPersistentFieldsOrColumns(0), this.variable2SQLType, this.variable2nullable, null, false);
                if (this.variable2SQLType.size() <= 0) {
                    Loggable loggable = EJBLogger.logCouldNotInitializeFieldSQLTypeMapWithoutExceptionLoggable();
                    throw new WLDeploymentException(loggable.getMessage());
                }
                Object var5_4 = null;
                this.releaseResources(connection, null, null);
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logCouldNotInitializeFieldSQLTypeMapLoggable((Exception)exception);
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseResources(connection, null, null);
            throw throwable;
        }
    }

    public boolean setParamNull(PreparedStatement preparedStatement, int n, Object object, String string) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.setParamNull");
        }
        if (object == null) {
            assert (this.variable2SQLType != null);
            assert (this.variable2SQLType.get(string) != null) : "No field->SQLType mapping for field " + string;
            Integer n2 = (Integer)this.variable2SQLType.get(string);
            int n3 = n2;
            preparedStatement.setNull(n, n3);
            return true;
        }
        return false;
    }

    public void releaseResources(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        this.releaseResources(connection, (Statement)preparedStatement, resultSet);
    }

    public void releaseResources(Connection connection, Statement statement, ResultSet resultSet) {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.releaseResources");
        }
        try {
            this.releaseResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.releaseStatement(statement);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.releaseConnection(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void releaseConnection(Connection connection) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.releaseConnection");
        }
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }

    public void releaseStatement(Statement statement) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.releaseStatement");
        }
        if (statement != null) {
            statement.close();
        }
    }

    public void releaseResultSet(ResultSet resultSet) throws SQLException {
        if (runtimeLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugRuntime("PersistenceManagerImpl.releaseResultSet");
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAndCreateDefaultDBMSTable(String string) throws WLDeploymentException {
        StringBuffer stringBuffer = new StringBuffer("DROP TABLE " + string);
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorDroppingDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                loggable.log();
                Object var8_6 = null;
                this.releaseResources(connection, statement, null);
            }
            Object var8_5 = null;
            this.releaseResources(connection, statement, null);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
        this.createDefaultDBMSTable(string);
    }

    public void alterDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        if (set.isEmpty() && set2.isEmpty()) {
            if (deploymentLogger.isDebugEnabled()) {
                PersistenceManagerImpl.debugDeployment("Table not changed so no alter table");
            }
            return;
        }
        this.alterOracleDefaultDBMSTable(string, set, set2);
    }

    private void alterOracleDefaultDBMSTable(String string, Set set, Set set2) throws WLDeploymentException {
        this.addColumns(string, set);
        this.removeColumns(string, set2);
    }

    private void removeColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            stringBuffer.append("drop ( ");
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object);
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        stringBuffer.append(" ) ");
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private void addColumns(String string, Set set) throws WLDeploymentException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("alter table " + string + " ");
        if (!set.isEmpty()) {
            stringBuffer.append("add ( ");
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object + " " + this.getSqltypeForCol((String)object));
                if (!object2.hasNext()) continue;
                stringBuffer.append(",");
            }
        } else {
            return;
        }
        stringBuffer.append(" ) ");
        if (deploymentLogger.isDebugEnabled()) {
            PersistenceManagerImpl.debugDeployment("The alter table command is ..." + stringBuffer);
        }
        object2 = null;
        object = null;
        try {
            try {
                object2 = this.getConnection();
                object = object2.createStatement();
                object.executeUpdate(stringBuffer.toString());
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorAlteringDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var9_6 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseResources((Connection)object2, (Statement)object, null);
            throw throwable;
        }
    }

    private String getSqltypeForCol(String string) throws WLDeploymentException {
        Class clazz = this.bean.getCmpFieldClass(string);
        if (null == clazz) {
            throw new WLDeploymentException(" Bean: " + this.bean.getEjbName() + ", could not get Column To Field Map for column ");
        }
        try {
            return MethodUtils.getDefaultDBMSColType(clazz, this.databaseType);
        }
        catch (Exception exception) {
            throw new WLDeploymentException("No Field class found for " + string);
        }
    }

    public boolean createDefaultDBMSTable(String string) throws WLDeploymentException {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + string + " (");
        Connection connection = null;
        Statement statement = null;
        List list = this.bean.getPrimaryKeyFields();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            try {
                String string2;
                if (deploymentLogger.isDebugEnabled()) {
                    PersistenceManagerImpl.debugDeployment(" createDefaultDBMSTable: processing Bean Table: " + string);
                }
                Iterator iterator = this.bean.getFieldNames();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    String string3 = this.bean.getColumnForField(string2);
                    stringBuffer.append(string3 + " ");
                    if (list.contains(string2)) {
                        hashSet.add(string3);
                    }
                    Class clazz = this.bd.getFieldClass(string2);
                    stringBuffer.append(MethodUtils.getDefaultDBMSColType(clazz, this.databaseType));
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                if (hashSet.size() > 0) {
                    stringBuffer.append(", PRIMARY KEY (");
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        stringBuffer.append(string2);
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(")");
                }
                stringBuffer.append(")");
                string2 = stringBuffer.toString();
                if (deploymentLogger.isDebugEnabled()) {
                    PersistenceManagerImpl.debugDeployment(" full CREATE TABLE QUERY: '" + string2 + "'");
                }
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(string2);
            }
            catch (Exception exception) {
                Loggable loggable = EJBLogger.logerrorCreatingDefaultDBMSTableLoggable((String)string, (String)exception.getMessage());
                loggable.log();
                throw new WLDeploymentException(loggable.getMessage(), exception);
            }
            Object var12_13 = null;
            this.releaseResources(connection, statement, null);
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.releaseResources(connection, statement, null);
            throw throwable;
        }
        return true;
    }

    public void updateClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static void debugDeployment(String string) {
        deploymentLogger.debug("[PersistenceManagerImpl] " + string);
    }

    private static void debugRuntime(String string) {
        runtimeLogger.debug("[PersistenceManagerImpl] " + string);
    }

    private static void debugRuntime(String string, Throwable throwable) {
        runtimeLogger.debug("[PersistenceManagerImpl] " + string, throwable);
    }
}

