/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.cmp11.rdbms.RDBMSUtils;
import weblogic.ejb.container.cmp11.rdbms.finders.Finder;
import weblogic.ejb.container.cmp11.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.utils.ErrorCollectionException;

public final class RDBMSBean
implements Cloneable {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private String ejbName = null;
    private String fileName = null;
    private List cmpFieldNames = null;
    private List primaryKeyFieldList = null;
    private List cmpColumnNames = null;
    private String dataSourceName = null;
    private String poolName = null;
    private Integer isolationLevel = null;
    private String schemaName = null;
    private String tableName = null;
    private boolean dbIsShared = true;
    private List attributeMap = null;
    private List finderList = null;
    private boolean useQuotedNames = false;
    private String createDefaultDBMSTable = "false";
    private String validateDbSchemaWith = "";
    private boolean useTunedUpdates = true;
    private int databaseType = 0;
    private CMPBeanDescriptor bd = null;

    public RDBMSBean() {
        this(null, "");
    }

    public RDBMSBean(String string, String string2) {
        this.setSchemaName(string);
        this.setTableName(string2);
        this.attributeMap = new ArrayList();
        this.finderList = new LinkedList();
        this.cmpFieldNames = new ArrayList();
        this.cmpColumnNames = new ArrayList();
    }

    public void setEjbName(String string) {
        this.ejbName = string;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPoolName(String string) {
        this.poolName = string;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean useTunedUpdates() {
        return this.useTunedUpdates;
    }

    public void setEnableTunedUpdates(boolean bl) {
        this.useTunedUpdates = bl;
    }

    public int getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(int n) {
        this.databaseType = n;
    }

    public void setTransactionIsolation(Integer n) {
        this.isolationLevel = n;
    }

    public Integer getTransactionIsolation() {
        return this.isolationLevel;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQualifiedTableName() {
        if (this.getSchemaName() != null && !this.getSchemaName().equals("")) {
            return this.getSchemaName() + "." + this.getTableName();
        }
        return this.getTableName();
    }

    public void setPrimaryKeyFields(List list) {
        this.primaryKeyFieldList = list;
    }

    public List getPrimaryKeyFields() {
        return this.primaryKeyFieldList;
    }

    public void setUseQuotedNames(boolean bl) {
        this.useQuotedNames = bl;
    }

    public boolean getUseQuotedNames() {
        return this.useQuotedNames;
    }

    public void addObjectLink(ObjectLink objectLink) {
        this.attributeMap.add(objectLink);
        String string = objectLink.getBeanField();
        String string2 = objectLink.getDBMSColumn();
        this.cmpFieldNames.add(string);
        this.cmpColumnNames.add(string2);
    }

    public void addObjectLink(String string, String string2) {
        ObjectLink objectLink = new ObjectLink(string, string2);
        this.addObjectLink(objectLink);
    }

    public Iterator getObjectLinks() {
        return this.attributeMap.iterator();
    }

    public List getCmpFieldNames() {
        return this.cmpFieldNames;
    }

    public List getCmpColumnNames() {
        return this.cmpColumnNames;
    }

    public String getColumnForField(String string) {
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            if (!objectLink.getBeanField().equals(string)) continue;
            return objectLink.getDBMSColumn();
        }
        return null;
    }

    public String getFieldForColumn(String string) {
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            if (!objectLink.getDBMSColumn().equals(string)) continue;
            return objectLink.getBeanField();
        }
        return null;
    }

    public Map getFieldToColumnMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            hashMap.put(objectLink.getBeanField(), objectLink.getDBMSColumn());
        }
        return hashMap;
    }

    public Map getColumnToFieldMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            hashMap.put(objectLink.getDBMSColumn(), objectLink.getBeanField());
        }
        return hashMap;
    }

    public List getFieldNamesList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            linkedList.add(objectLink.getBeanField());
        }
        return linkedList;
    }

    public Iterator getFieldNames() {
        List list = this.getFieldNamesList();
        return list.iterator();
    }

    public String getCreateDefaultDBMSTables() {
        return this.createDefaultDBMSTable;
    }

    public void setCreateDefaultDBMSTables(String string) {
        this.createDefaultDBMSTable = string;
    }

    public String getValidateDbSchemaWith() {
        return this.validateDbSchemaWith;
    }

    public void setValidateDbSchemaWith(String string) {
        this.validateDbSchemaWith = string;
    }

    public void addFinder(Finder finder) {
        this.finderList.add(finder);
    }

    public void replaceFinder(Finder finder, Finder finder2) throws IllegalArgumentException {
        int n = this.finderList.indexOf(finder);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.finderList.set(n, finder2);
    }

    public Iterator getFinders() {
        return this.finderList.iterator();
    }

    public List getFinderList() {
        return this.finderList;
    }

    public void generateFinderSQLStatements() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Iterator iterator = this.getFinders();
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            try {
                finder.computeSQLQuery(this.getMapTable());
                if (!debugLogger.isDebugEnabled()) continue;
                String string = finder.getSQLQuery();
                if (string == null) {
                    RDBMSBean.debug("finder.computSQLQuery: None generated.  NULL !");
                    continue;
                }
                RDBMSBean.debug("finder.computSQLQuery: " + string);
            }
            catch (IllegalExpressionException illegalExpressionException) {
                errorCollectionException.add((Throwable)illegalExpressionException);
            }
        }
        if (errorCollectionException.getExceptions().size() > 0) {
            throw errorCollectionException;
        }
    }

    public Finder getFinderForMethod(Method method) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSBean.debug("RDBMSBean.getFinderForMethod(" + method + ")");
        }
        Iterator iterator = this.getFinders();
        while (iterator.hasNext()) {
            Finder finder = (Finder)iterator.next();
            if (!finder.methodIsEquivalent(method)) continue;
            return finder;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RDBMSBean)) {
            return false;
        }
        RDBMSBean rDBMSBean = (RDBMSBean)object;
        return this.ejbName.equals(rDBMSBean.getEjbName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("[weblogic.cmp.rdbms.RDBMSBean {");
        stringBuffer.append("\n\tejbName = " + this.ejbName);
        stringBuffer.append("\n\tpoolName = " + this.poolName);
        stringBuffer.append("\n\tschemaName = " + this.schemaName);
        stringBuffer.append("\n\ttableName = " + this.tableName);
        stringBuffer.append("\n\tisolationLevel = " + RDBMSUtils.isolationLevelToString(this.isolationLevel));
        stringBuffer.append("\n\tattributeMap = " + this.attributeMap);
        stringBuffer.append("\n\tfinderList = " + this.finderList);
        stringBuffer.append("\n\tuseQuotedNames = " + this.useQuotedNames);
        stringBuffer.append("\n\tdbIsShared = " + this.dbIsShared);
        stringBuffer.append("\n} end RDBMSBean ]\n");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.ejbName.hashCode();
    }

    private Hashtable getMapTable() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            hashtable.put(objectLink.getBeanField(), objectLink.getDBMSColumn());
        }
        return hashtable;
    }

    public void setCMPBeanDescriptor(CMPBeanDescriptor cMPBeanDescriptor) {
        this.bd = cMPBeanDescriptor;
    }

    public Class getCmpFieldClass(String string) {
        Iterator iterator = this.getObjectLinks();
        while (iterator.hasNext()) {
            ObjectLink objectLink = (ObjectLink)iterator.next();
            if (!string.equalsIgnoreCase(objectLink.getDBMSColumn())) continue;
            return this.bd.getFieldClass(objectLink.getBeanField());
        }
        return null;
    }

    private static void debug(String string) {
        debugLogger.debug("[RDBMSBean] " + string);
    }

    public static class ObjectLink {
        public static final boolean verbose = false;
        public static final boolean debug = false;
        private String beanField = null;
        private String dbmsColumn = null;

        public ObjectLink(String string, String string2) {
            this.setBeanField(string);
            this.setDBMSColumn(string2);
        }

        private void setBeanField(String string) {
            this.beanField = string;
        }

        public String getBeanField() {
            return this.beanField;
        }

        public void setDBMSColumn(String string) {
            this.dbmsColumn = string;
        }

        public String getDBMSColumn() {
            return this.dbmsColumn;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ObjectLink)) {
                return false;
            }
            ObjectLink objectLink = (ObjectLink)object;
            if (!this.beanField.equals(objectLink.getBeanField())) {
                return false;
            }
            return this.dbmsColumn.equals(objectLink.getDBMSColumn());
        }

        public int hashCode() {
            return this.beanField.hashCode() | this.dbmsColumn.hashCode();
        }

        public String toString() {
            return "[ObjectLink: field<" + this.beanField + "> to column <" + this.dbmsColumn + ">]";
        }
    }
}

