/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import weblogic.ejb.container.cmp11.rdbms.CMPDDParser;
import weblogic.ejb.container.cmp11.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp11.rdbms.finders.Finder;
import weblogic.ejb.container.cmp11.rdbms.finders.InvalidFinderException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb20.cmp.rdbms.RDBMSException;
import weblogic.j2ee.descriptor.wl60.FieldMapBean;
import weblogic.j2ee.descriptor.wl60.FinderBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;

public final class RDBMSDeploymentInfo {
    protected EJBComplianceTextFormatter fmt;
    private WeblogicRdbmsJarBean wlJar;
    private Map rdbmsBeanMap = new HashMap();

    public RDBMSDeploymentInfo(WeblogicRdbmsJarBean weblogicRdbmsJarBean, CMPDDParser.CompatibilitySettings compatibilitySettings, String string) throws RDBMSException, InvalidFinderException {
        this.wlJar = weblogicRdbmsJarBean;
        this.fmt = new EJBComplianceTextFormatter();
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
        for (int i = 0; i < weblogicRdbmsBeanBeanArray.length; ++i) {
            RDBMSBean rDBMSBean = new RDBMSBean();
            rDBMSBean.setEjbName(weblogicRdbmsBeanBeanArray[i].getEjbName());
            rDBMSBean.setFileName(string);
            rDBMSBean.setPoolName(weblogicRdbmsBeanBeanArray[i].getPoolName());
            rDBMSBean.setDataSourceName(weblogicRdbmsBeanBeanArray[i].getDataSourceJndiName());
            rDBMSBean.setTableName(weblogicRdbmsBeanBeanArray[i].getTableName());
            rDBMSBean.setEnableTunedUpdates(weblogicRdbmsBeanBeanArray[i].isEnableTunedUpdates());
            if (compatibilitySettings != null) {
                rDBMSBean.setUseQuotedNames(compatibilitySettings.useQuotedNames);
                rDBMSBean.setTransactionIsolation(compatibilitySettings.isolationLevel);
            }
            this.initFieldMaps(weblogicRdbmsBeanBeanArray[i], rDBMSBean);
            this.initFinders(weblogicRdbmsBeanBeanArray[i], rDBMSBean, compatibilitySettings);
            this.rdbmsBeanMap.put(rDBMSBean.getEjbName(), rDBMSBean);
        }
    }

    public RDBMSBean getRDBMSBean(String string) {
        return (RDBMSBean)this.rdbmsBeanMap.get(string);
    }

    public Map getRDBMSBeanMap() {
        return this.rdbmsBeanMap;
    }

    public WeblogicRdbmsJarBean getWeblogicRdbmsJarBean() {
        return this.wlJar;
    }

    private void initFieldMaps(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean) throws RDBMSException {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        FieldMapBean[] fieldMapBeanArray = weblogicRdbmsBeanBean.getFieldMaps();
        for (int i = 0; i < fieldMapBeanArray.length; ++i) {
            if (!hashSet.add(fieldMapBeanArray[i].getCmpField())) {
                throw new RDBMSException(this.fmt.DUPLICATE_MAPPING_FOR_CMP_FIELD(rDBMSBean.getFileName(), rDBMSBean.getEjbName(), fieldMapBeanArray[i].getCmpField()));
            }
            if (!hashSet2.add(fieldMapBeanArray[i].getDbmsColumn())) {
                throw new RDBMSException(this.fmt.DUPLICATE_MAPPING_FOR_DBMS_COLUMN(rDBMSBean.getFileName(), rDBMSBean.getEjbName(), fieldMapBeanArray[i].getDbmsColumn()));
            }
            RDBMSBean.ObjectLink objectLink = new RDBMSBean.ObjectLink(fieldMapBeanArray[i].getCmpField(), fieldMapBeanArray[i].getDbmsColumn());
            rDBMSBean.addObjectLink(objectLink);
        }
    }

    private void initFinders(WeblogicRdbmsBeanBean weblogicRdbmsBeanBean, RDBMSBean rDBMSBean, CMPDDParser.CompatibilitySettings compatibilitySettings) throws InvalidFinderException {
        FinderBean[] finderBeanArray = weblogicRdbmsBeanBean.getFinders();
        for (int i = 0; i < finderBeanArray.length; ++i) {
            Object object;
            boolean bl = true;
            String string = finderBeanArray[i].getFinderSql();
            if (string == null) {
                string = finderBeanArray[i].getFinderQuery();
                if ("empty-finder".equals(string)) {
                    string = "";
                }
                bl = false;
            }
            if (string == null) continue;
            Finder finder = new Finder(finderBeanArray[i].getFinderName(), string);
            finder.setUsingSQL(bl);
            String[] stringArray = finderBeanArray[i].getFinderParams();
            for (int j = 0; j < stringArray.length; ++j) {
                finder.addParameterType(stringArray[j]);
            }
            List list = null;
            if (compatibilitySettings != null) {
                object = DDUtils.getMethodSignature(finderBeanArray[i].getFinderName(), finderBeanArray[i].getFinderParams());
                list = (List)compatibilitySettings.finderExpressionMap.get(object);
            }
            if (list != null) {
                for (CMPDDParser.FinderExpression finderExpression : list) {
                    Finder.FinderExpression finderExpression2 = new Finder.FinderExpression(finderExpression.expressionNumber, finderExpression.expressionText, finderExpression.expressionType);
                    finder.addFinderExpression(finderExpression2);
                }
            }
            if (finderBeanArray[i].isFindForUpdate()) {
                object = new Finder.FinderOptions();
                ((Finder.FinderOptions)object).setFindForUpdate(true);
                finder.setFinderOptions((Finder.FinderOptions)object);
            }
            rDBMSBean.addFinder(finder);
        }
    }
}

