/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import weblogic.ejb.container.cmp11.rdbms.BeanEntityResolver;
import weblogic.utils.AssertionError;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

public final class RDBMSUtils
extends weblogic.ejb.spi.RDBMSUtils {
    public static final String PARSER_NAME = "com.sun.xml.parser.ValidatingParser";
    public static final String WEBLOGIC_RDBMS_BEAN = "weblogic-rdbms-bean";
    public static final String POOL_NAME = "pool-name";
    public static final String SCHEMA_NAME = "schema-name";
    public static final String TABLE_NAME = "table-name";
    public static final String ATTRIBUTE_MAP = "attribute-map";
    public static final String FINDER_LIST = "finder-list";
    public static final String OBJECT_LINK = "object-link";
    public static final String BEAN_FIELD = "bean-field";
    public static final String DBMS_COLUMN = "dbms-column";
    public static final String FINDER = "finder";
    public static final String METHOD_NAME = "method-name";
    public static final String METHOD_PARAMS = "method-params";
    public static final String METHOD_PARAM = "method-param";
    public static final String FINDER_QUERY = "finder-query";
    public static final String FINDER_EXPRESSION = "finder-expression";
    public static final String EXPRESSION_NUMBER = "expression-number";
    public static final String EXPRESSION_TEXT = "expression-text";
    public static final String EXPRESSION_TYPE = "expression-type";
    public static final String FINDER_OPTIONS = "finder-options";
    public static final String FIND_FOR_UPDATE = "find-for-update";
    public static final String OPTIONS = "options";
    public static final String USE_QUOTED_NAMES = "use-quoted-names";
    public static final String TRANSACTION_ISOLATION = "transaction-isolation";
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    public static final String TRANSACTION_ISOLATION_UNKNOWN = "TRANSACTION_ISOLATION_UNKNOWN";
    public static final String[] validRdbmsCmp11JarPublicIds = new String[]{"-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB RDBMS Persistence//EN", "-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB 1.1 RDBMS Persistence//EN"};

    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = new WebLogicDocumentBuilderFactory().newDocumentBuilder();
            documentBuilder.setEntityResolver(new BeanEntityResolver());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Throwable)parserConfigurationException);
        }
    }

    public static String isolationLevelToString(Integer n) {
        if (n == null) {
            return "(default)";
        }
        switch (n) {
            case 0: {
                return TRANSACTION_NONE;
            }
            case 2: {
                return TRANSACTION_READ_COMMITTED;
            }
            case 1: {
                return TRANSACTION_READ_UNCOMMITTED;
            }
            case 4: {
                return TRANSACTION_REPEATABLE_READ;
            }
            case 8: {
                return TRANSACTION_SERIALIZABLE;
            }
        }
        return TRANSACTION_ISOLATION_UNKNOWN;
    }

    public static String selectForUpdateToString(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return " FOR UPDATE ";
            }
            case 2: {
                return " FOR UPDATE NOWAIT ";
            }
        }
        throw new AssertionError("Unknown selectForUpdate type: '" + n + "'");
    }

    public static String throwable2StackTrace(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }

    public static String setterMethodName(String string) {
        return "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String getterMethodName(String string) {
        return "get" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }
}

