/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms.codegen;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EntityContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp11.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp11.rdbms.codegen.StatementBinder;
import weblogic.ejb.container.cmp11.rdbms.codegen.TypeUtils;
import weblogic.ejb.container.cmp11.rdbms.finders.Finder;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.utils.string.Sprintf;

public final class RDBMSCodeGenerator
extends CMPCodeGenerator {
    private static final DebugLogger debugLogger = EJBDebugService.cmpDeploymentLogger;
    private RDBMSBean beanData = null;
    private Map variableToClass = null;
    private List finderList = null;
    private List primaryKeyFieldList = null;
    private FinderMethodInfo finderMethodInfo = null;
    private int preparedStatementParamIndex = -1;
    private Map parameterMap = null;
    private List fieldList = null;
    private List nonPrimaryKeyFieldList = null;
    private SnapshotFieldInfo[] snapshotFieldInfo;
    private boolean useTunedUpdates;
    private int level = 0;
    private Class[] immutableClasses = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, BigDecimal.class, BigInteger.class};
    private int current_index;
    private SnapshotFieldInfo current;

    public RDBMSCodeGenerator(Getopt2 getopt2) {
        super(getopt2);
    }

    public void setRDBMSBean(RDBMSBean rDBMSBean) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("RDBMSCodeGenerator.setRDBMSBean(" + rDBMSBean + ")");
        }
        assert (rDBMSBean != null);
        this.beanData = rDBMSBean;
        this.variableToClass = new HashMap();
        List list = rDBMSBean.getCmpFieldNames();
        for (String string : list) {
            this.variableToClass.put(string, this.bd.getFieldClass(string));
        }
    }

    public void setFinderList(List list) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("RDBMSCodeGenerator.setFinderList(" + list + ")");
        }
        this.finderList = list;
    }

    public void setCMFields(List list) {
        this.nonPrimaryKeyFieldList = this.deriveNonPrimaryKeyFields(list);
        this.fieldList = new ArrayList();
        this.fieldList.addAll(this.primaryKeyFieldList);
        this.fieldList.addAll(this.nonPrimaryKeyFieldList);
    }

    public void setPrimaryKeyFields(List list) {
        this.primaryKeyFieldList = list;
    }

    protected List typeSpecificTemplates() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("weblogic/ejb/container/cmp11/rdbms/codegen/template.j");
        return arrayList;
    }

    public void setParameterMap(Map map) {
        this.parameterMap = map;
    }

    private List deriveNonPrimaryKeyFields(List list) {
        Debug.assertion((this.primaryKeyFieldList != null ? 1 : 0) != 0);
        Debug.assertion((list != null ? 1 : 0) != 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (this.primaryKeyFieldList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    protected void prepare(CodeGenerator.Output output) throws EJBCException, ClassNotFoundException {
        super.prepare(output);
        assert (this.beanData != null);
        assert (this.finderList != null);
        assert (this.primaryKeyFieldList != null);
        assert (this.fieldList != null);
        assert (this.parameterMap != null);
        assert (this.nonPrimaryKeyFieldList != null);
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("cmp11.rdbms.codegen.RDBMSCodeGenerator.prepare() called");
        }
    }

    public static String varPrefix() {
        return "__WL_";
    }

    public String debugVar() {
        return RDBMSCodeGenerator.varPrefix() + "debugLogger";
    }

    public String debugEnabled() {
        return this.debugVar() + ".isDebugEnabled()";
    }

    public String debugSay() {
        return RDBMSCodeGenerator.varPrefix() + "debug";
    }

    public String beanVar() {
        return RDBMSCodeGenerator.varPrefix() + "bean";
    }

    public String pkVar() {
        return RDBMSCodeGenerator.varPrefix() + "pk";
    }

    public String eoVar() {
        return RDBMSCodeGenerator.varPrefix() + "eo";
    }

    public String ctxVar() {
        return RDBMSCodeGenerator.varPrefix() + "ctx";
    }

    public String conVar() {
        return RDBMSCodeGenerator.varPrefix() + "con";
    }

    public String rsVar() {
        return RDBMSCodeGenerator.varPrefix() + "rs";
    }

    public String rsInfoVar() {
        return RDBMSCodeGenerator.varPrefix() + "rsInfo";
    }

    public String stmtVar() {
        return RDBMSCodeGenerator.varPrefix() + "stmt";
    }

    public String pmVar() {
        return RDBMSCodeGenerator.varPrefix() + "pm";
    }

    public String keyVar() {
        return RDBMSCodeGenerator.varPrefix() + "key";
    }

    public String numVar() {
        return RDBMSCodeGenerator.varPrefix() + "num";
    }

    public String queryVar() {
        return RDBMSCodeGenerator.varPrefix() + "query";
    }

    public String iVar() {
        return RDBMSCodeGenerator.varPrefix() + "i";
    }

    public String countVar() {
        return RDBMSCodeGenerator.varPrefix() + "count";
    }

    public String stringVar() {
        return RDBMSCodeGenerator.varPrefix() + "stringVar";
    }

    public String stringVar(String string) {
        return RDBMSCodeGenerator.varPrefix() + "stringVar" + "_" + string;
    }

    public String sqlTimestampVar() {
        return RDBMSCodeGenerator.varPrefix() + "sqlTimestampVar";
    }

    public String sqlTimestampVar(String string) {
        return RDBMSCodeGenerator.varPrefix() + "sqlTimestampVar" + "_" + string;
    }

    public String byteArrayVar() {
        return RDBMSCodeGenerator.varPrefix() + "byteArrayVar";
    }

    public String byteArrayVar(String string) {
        return RDBMSCodeGenerator.varPrefix() + "byteArrayVar" + "_" + string;
    }

    public String isModifiedVar() {
        return "isModified";
    }

    public String createMethodName() {
        return RDBMSCodeGenerator.varPrefix() + "create";
    }

    public String existsMethodName() {
        return RDBMSCodeGenerator.varPrefix() + "exists";
    }

    public String standardCatch() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lvl(2) + "} catch (RuntimeException e) {" + EOL);
        stringBuffer.append(this.upLvl() + "if (" + this.debugEnabled() + ") " + this.debugSay() + "(\"throwing runtime exception\");" + EOL);
        stringBuffer.append(this.lvl() + "throw e;" + EOL);
        stringBuffer.append(this.dnLvl() + "}" + EOL);
        stringBuffer.append(this.lvl() + "catch (Exception ex) {" + EOL);
        stringBuffer.append(this.upLvl() + "if (" + this.debugEnabled() + ") " + this.debugSay() + "(\"throwing ejbeception\");" + EOL);
        stringBuffer.append(this.lvl() + "throw new PersistenceRuntimeException(ex);" + EOL);
        stringBuffer.append(this.dnLvl() + "}" + EOL);
        return stringBuffer.toString();
    }

    public String declareEntityContextVar() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lvl(0) + "private EntityContext " + this.ctxVar() + ";");
        return stringBuffer.toString();
    }

    public String declareIsModified() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tprivate boolean[] ");
        stringBuffer.append(this.isModifiedVar());
        stringBuffer.append(" = new boolean[");
        stringBuffer.append(this.fieldList.size());
        stringBuffer.append("];");
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public String tableName() {
        String string = "";
        if (this.beanData.getUseQuotedNames()) {
            if (this.beanData.getSchemaName() != null && !this.beanData.getSchemaName().equals("")) {
                string = string + '\"' + this.beanData.getSchemaName() + '\"' + ".";
            }
            string = string + '\"' + this.beanData.getTableName() + '\"';
        } else {
            if (this.beanData.getSchemaName() != null && !this.beanData.getSchemaName().equals("")) {
                string = string + this.beanData.getSchemaName() + ".";
            }
            string = string + this.beanData.getTableName();
        }
        return string;
    }

    public String getSimpleBeanClassName() {
        return MethodUtils.tail(this.bd.getGeneratedBeanClassName());
    }

    public String declareNoArgsConstructor() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getBeanClass();
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            assert (constructor != null);
            stringBuffer.append(this.lvl(1) + "public " + MethodUtils.tail(cMPBeanDescriptor.getGeneratedBeanClassName()));
            stringBuffer.append("()");
            Class<?>[] classArray = constructor.getExceptionTypes();
            if (classArray.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray.length; ++i) {
                    stringBuffer.append(this.javaCodeForType(classArray[i]));
                    if (i >= classArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Unable to find constructor on class '" + clazz.getName() + "'.");
        }
        return stringBuffer.toString();
    }

    public String declareBeanMethod(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getBeanClass();
        try {
            Method method = clazz.getMethod(string, classArray);
            assert (method != null);
            MethodSignature methodSignature = new MethodSignature(method);
            stringBuffer.append(this.lvl(1) + methodSignature.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Unable to find '" + string + "' method on class '" + clazz.getName() + "'.");
        }
        return stringBuffer.toString();
    }

    public String initializePersistentVars() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.variableToClass.keySet()) {
            Class clazz = (Class)this.variableToClass.get(string);
            stringBuffer.append(this.lvl(2) + string + " = " + ClassUtils.getDefaultValue(clazz) + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String copyFromMethodBody() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        stringBuffer.append(this.lvl(2) + cMPBeanDescriptor.getGeneratedBeanClassName() + " " + this.beanVar() + " = null;" + EOL);
        stringBuffer.append(this.lvl() + "try {" + EOL);
        stringBuffer.append(this.upLvl() + this.beanVar() + " = (" + cMPBeanDescriptor.getGeneratedBeanClassName() + ")otherBean;" + EOL);
        stringBuffer.append(this.standardCatch());
        for (String string : cMPBeanDescriptor.getCMFieldNames()) {
            stringBuffer.append(string + " = " + this.beanVar() + "." + string + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String initializePersistentVarsForBeanVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.finderMethodInfo.loadBean) {
            for (String string : this.variableToClass.keySet()) {
                Class clazz = (Class)this.variableToClass.get(string);
                stringBuffer.append(this.lvl(2) + this.beanVar() + "." + string + " = " + ClassUtils.getDefaultValue(clazz) + ";" + EOL);
            }
        }
        return stringBuffer.toString();
    }

    public String declareSetEntityContextMethod() {
        return this.declareBeanMethod("setEntityContext", new Class[]{EntityContext.class});
    }

    public String declareEjbLoadMethod() {
        return this.declareBeanMethod("ejbLoad", new Class[0]);
    }

    private boolean throwsCreateException(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(CreateException.class)) continue;
            return true;
        }
        return false;
    }

    public String ejbLoadExceptionList() {
        return this.ejbCallbackMethodExceptionList("ejbLoad");
    }

    public String ejbStoreExceptionList() {
        return this.ejbCallbackMethodExceptionList("ejbStore");
    }

    public String ejbCallbackMethodExceptionList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getBeanClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            assert (method != null);
            Class<?>[] classArray = method.getExceptionTypes();
            if (classArray.length > 0) {
                stringBuffer.append(" throws ");
                for (int i = 0; i < classArray.length; ++i) {
                    stringBuffer.append(this.javaCodeForType(classArray[i]));
                    if (i >= classArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Unable to find ejbLoad on class '" + clazz.getName() + "'.");
        }
        return stringBuffer.toString();
    }

    public String implementEjbCreateMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getBeanClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals("ejbCreate")) continue;
            MethodSignature methodSignature = new MethodSignature(method);
            stringBuffer.append(this.lvl(1) + methodSignature.toString() + " {" + EOL);
            stringBuffer.append("int oldState = __WL_method_state;" + EOL + "try {" + EOL);
            stringBuffer.append("__WL_method_state = STATE_EJB_CREATE;" + EOL);
            stringBuffer.append("__WL_initialize();" + EOL);
            stringBuffer.append(this.upLvl() + "super.ejbCreate(");
            stringBuffer.append(methodSignature.getParametersAsArgs());
            stringBuffer.append(");" + EOL + EOL);
            Class clazz2 = methodSignature.getReturnType();
            stringBuffer.append(this.lvl() + "try {" + EOL);
            stringBuffer.append(this.upLvl() + "return (" + ClassUtils.classToJavaSourceType(clazz2) + ")" + this.createMethodName() + "();" + EOL);
            if (this.throwsCreateException(method)) {
                stringBuffer.append(this.dnLvl() + "} catch (javax.ejb.CreateException ce) {" + EOL);
                stringBuffer.append("System.out.println(\"throwing create exception.\");" + EOL);
                stringBuffer.append(this.upLvl() + "throw ce;" + EOL);
            }
            stringBuffer.append(this.standardCatch());
            stringBuffer.append("} finally { __WL_method_state = oldState; }" + EOL);
            stringBuffer.append(this.dnLvl() + "}" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementEjbRemoveMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lvl(1) + this.declareBeanMethod("ejbRemove", new Class[0]) + " {" + EOL);
        stringBuffer.append(this.parse(this.getProductionRule("implementEjbRemoveMethodBody")));
        stringBuffer.append(this.lvl(1) + "}");
        return stringBuffer.toString();
    }

    public String implementEjbStoreMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lvl(1) + this.declareBeanMethod("ejbStore", new Class[0]) + " {" + EOL);
        stringBuffer.append(this.parse(this.getProductionRule("implementEjbStoreMethodBody")));
        stringBuffer.append(this.lvl(1) + "}");
        return stringBuffer.toString();
    }

    public String implementFinderMethods() throws EJBCException {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("ejb20.cmp11.rdbms.codegen.RDBMSCodeGenerator.implementFinderMethods() called.");
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        for (Method method : this.finderList) {
            try {
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("generating finder: " + method);
                }
                stringBuffer.append(this.implementFinderMethod(method));
            }
            catch (CodeGenerationException codeGenerationException) {
                throw new EJBCException("Could not generate finder method code for finder " + method + " due to CodeGenerationException: " + codeGenerationException.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    private String implementFinderMethod(Method method) throws EJBCException, CodeGenerationException {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("implementFinderMethod(" + method + ") called.");
        }
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        assert (cMPBeanDescriptor != null);
        this.finderMethodInfo = new FinderMethodInfo();
        this.finderMethodInfo.method = method;
        this.finderMethodInfo.finder = this.beanData.getFinderForMethod(method);
        this.finderMethodInfo.loadBean = cMPBeanDescriptor.getFindersLoadBean();
        assert (this.finderMethodInfo.method != null);
        if (this.finderMethodInfo.finder == null) {
            throw new EJBCException("Could not find finder descriptor for method with signature " + method);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = MethodUtils.getFinderMethodDeclaration(method, cMPBeanDescriptor.getPrimaryKeyClass(), true);
        stringBuffer.append(string);
        stringBuffer.append("{" + EOL);
        try {
            if (this.isMultiFinder(method)) {
                stringBuffer.append(this.parse(this.getProductionRule("finderMethodBodyMulti")));
            } else {
                stringBuffer.append(this.parse(this.getProductionRule("finderMethodBodyScalar")));
            }
        }
        catch (CodeGenerationException codeGenerationException) {
            if (debugLogger.isDebugEnabled()) {
                RDBMSCodeGenerator.debug("finderMethod cought CodeGenerationException : " + (Object)((Object)codeGenerationException));
            }
            if (debugLogger.isDebugEnabled()) {
                codeGenerationException.printStackTrace();
            }
            String string2 = "Could not produce production rule for this finder.";
            EJBLogger.logStackTraceAndMessage((String)string2, (Throwable)codeGenerationException);
            throw new EJBCException(string2);
        }
        stringBuffer.append("" + EOL + "}" + EOL);
        this.finderMethodInfo = null;
        return stringBuffer.toString();
    }

    private boolean isMultiFinder(Method method) {
        return Collection.class.isAssignableFrom(method.getReturnType()) || Enumeration.class.isAssignableFrom(method.getReturnType());
    }

    public String finderMethodName() {
        assert (this.finderMethodInfo != null);
        return this.finderMethodInfo.method.getName();
    }

    public String finderQuery() {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("finderQuery() called for method " + this.finderMethodInfo.method);
        }
        assert (this.finderMethodInfo != null);
        assert (this.finderMethodInfo.finder != null);
        assert (this.finderMethodInfo.finder.getSQLQuery() != null);
        String string = this.finderMethodInfo.finder.getSQLQuery();
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("finder query is: " + string);
        }
        return string;
    }

    public String declareResultVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.finderMethodInfo.loadBean) {
            stringBuffer.append(this.declareBeanVar());
            stringBuffer.append(this.declareEoVar());
        } else {
            stringBuffer.append(this.lvl(2) + "Object " + this.pkVar() + " = null;");
        }
        return stringBuffer.toString();
    }

    public String allocateResultVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.finderMethodInfo.loadBean) {
            stringBuffer.append(this.getBeanFromRS());
        }
        return stringBuffer.toString();
    }

    public String finderGetEo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.finderMethodInfo.loadBean) {
            stringBuffer.append(this.eoVar() + " = " + this.pmVar() + ".finderGetEoFromBeanOrPk(" + this.beanVar() + ", " + this.pkVar() + ", __WL_getIsLocal());");
        }
        return stringBuffer.toString();
    }

    public String resultVar() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.finderMethodInfo.loadBean) {
            stringBuffer.append(this.eoVar());
        } else {
            stringBuffer.append(this.pkVar());
        }
        return stringBuffer.toString();
    }

    public String declareEoVar() {
        return "Object " + this.eoVar() + " = null;" + EOL;
    }

    public String getGeneratedBeanClassName() {
        return this.bd.getGeneratedBeanClassName();
    }

    public String declareBeanVar() {
        return this.lvl(2) + this.bd.getGeneratedBeanClassName() + " " + this.beanVar() + " = null;" + EOL;
    }

    public String declarePkVar() {
        return this.lvl(2) + this.pk_class() + " " + this.pkVar() + " = null;";
    }

    public String allocatePkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
            stringBuffer.append(this.lvl(2) + this.pkVar() + " = ");
            stringBuffer.append("new " + this.pk_class() + "();");
        }
        return stringBuffer.toString();
    }

    public String allocateBeanVar() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        return this.lvl(2) + this.beanVar() + " = (" + cMPBeanDescriptor.getGeneratedBeanClassName() + ")" + this.pmVar() + ".getBeanFromPool();" + EOL;
    }

    public String getBeanFromRS() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RSInfo " + this.rsInfoVar() + " = new RSInfoImpl(" + this.rsVar() + ", 0, 0, " + this.pkVar() + ");" + EOL);
        stringBuffer.append(this.beanVar() + " = (" + cMPBeanDescriptor.getGeneratedBeanClassName() + ")" + this.pmVar() + ".getBeanFromRS(" + this.pkVar() + ", " + this.rsInfoVar() + ");" + EOL);
        return stringBuffer.toString();
    }

    public String getPkVarFromRS() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.finderMethodInfo.loadBean) {
            stringBuffer.append("Object ");
        }
        stringBuffer.append(this.pkVar() + " = " + this.getPKFromRSMethodName() + this.getPKFromRSMethodParams() + EOL);
        return stringBuffer.toString();
    }

    public String implementGetPKFromRSStaticMethod() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EOL);
        stringBuffer.append("public static Object " + this.getPKFromRSMethodName() + "(java.sql.ResultSet " + this.rsVar() + ") " + EOL);
        stringBuffer.append("throws java.sql.SQLException, java.lang.Exception" + EOL);
        stringBuffer.append("{" + EOL);
        stringBuffer.append(this.declarePkVar() + EOL);
        stringBuffer.append(this.allocatePkVar() + EOL + EOL);
        this.assignToFields(this.primaryKeyFieldList, stringBuffer, 1, this.pkVar(), this.bd.hasComplexPrimaryKey());
        stringBuffer.append("return " + this.pkVar() + ";" + EOL);
        stringBuffer.append("}" + EOL);
        return stringBuffer.toString();
    }

    public String getPKFromRSMethodName() {
        return RDBMSCodeGenerator.varPrefix() + "getPKFromRS";
    }

    private String getPKFromRSMethodParams() {
        return "(" + this.rsVar() + ");";
    }

    public String finderColumnsSql() throws EJBCException {
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        list = this.finderMethodInfo.loadBean ? this.fieldList : this.primaryKeyFieldList;
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.beanData.getColumnForField(string);
            assert (string2 != null);
            stringBuffer.append(string2);
            if (n < list.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String implementGetPrimaryKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lvl(2) + this.declarePkVar() + EOL);
        stringBuffer.append(this.lvl() + this.allocatePkVar() + EOL);
        stringBuffer.append(this.lvl() + this.assignPkFieldsToPkVar() + EOL);
        stringBuffer.append(this.lvl() + "return " + this.pkVar() + ";" + EOL);
        return stringBuffer.toString();
    }

    public String implementSetPrimaryKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.assignPkVarToPkFields() + EOL);
        return stringBuffer.toString();
    }

    public String assignPkFieldsToPkVar() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.primaryKeyFieldList.iterator();
        if (this.bd.hasComplexPrimaryKey()) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(this.lvl(3) + this.pkVar() + "." + string + " = " + "this." + string + ";");
            }
        } else {
            stringBuffer.append(this.lvl(3) + this.pkVar() + " = " + "this." + (String)iterator.next() + ";");
        }
        return stringBuffer.toString();
    }

    public String assignPkVarToPkFields() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.bd.getPrimaryKeyFieldNames().iterator();
        if (this.bd.hasComplexPrimaryKey()) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("this." + string + " = " + this.pkVar() + "." + string + ";" + EOL);
            }
        } else {
            stringBuffer.append("this." + (String)iterator.next() + " = " + this.pkVar() + ";");
        }
        return stringBuffer.toString();
    }

    public boolean isFindByPrimaryKey(Finder finder) {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        if (!finder.getName().equals("findByPrimaryKey")) {
            return false;
        }
        Iterator iterator = finder.getParameterTypes();
        if (!iterator.hasNext()) {
            return false;
        }
        String string = (String)iterator.next();
        if (!string.equals(cMPBeanDescriptor.getPrimaryKeyClass().getName())) {
            return false;
        }
        return !iterator.hasNext();
    }

    public String setFinderQueryParams() throws EJBCException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Method method = this.finderMethodInfo.method;
        Finder finder = this.beanData.getFinderForMethod(method);
        assert (finder != null);
        assert (finder.getSQLQuery() != null);
        Class<?>[] classArray = null;
        String[] stringArray = null;
        boolean bl = this.isFindByPrimaryKey(finder);
        if (bl && cMPBeanDescriptor.hasComplexPrimaryKey()) {
            String[] stringArray2 = this.primaryKeyFieldList.toArray(new String[0]);
            classArray = new Class[stringArray2.length];
            stringArray = new String[stringArray2.length];
            for (n = 0; n < classArray.length; ++n) {
                classArray[n] = cMPBeanDescriptor.getFieldClass(stringArray2[n]);
                stringArray[n] = MethodUtils.getParameterName(0) + "." + stringArray2[n];
            }
        } else {
            classArray = method.getParameterTypes();
            stringArray = new String[classArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = MethodUtils.getParameterName(i);
            }
        }
        for (int i = 1; i <= finder.getVariableCount(); ++i) {
            n = finder.getParameterIndex(i);
            if (!classArray[n].isPrimitive()) {
                this.addNullCheck("", stringBuffer, stringArray[n], TypeUtils.getSQLTypeForClass(classArray[n]), i);
            }
            Object[] objectArray = new Object[]{TypeUtils.getPreparedStatementMethodPostfix(classArray[n]), new Integer(i), this.getParameterSetterName(classArray[n], stringArray[n])};
            Sprintf.sprintf((String)(this.stmtVar() + ".set%s(%d, %s);" + EOL), (Object[])objectArray, (StringBuffer)stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void addNullCheck(String string, StringBuffer stringBuffer, String string2, String string3, String string4) {
        stringBuffer.append(string + "if(!" + this.pmVar() + ".setParamNull(" + this.stmtVar() + ", " + string4 + ", " + string2 + ", " + "\"" + string3 + "\"" + ")) {" + EOL);
    }

    private void addNullCheck(String string, StringBuffer stringBuffer, String string2, int n, int n2) {
        stringBuffer.append("");
        stringBuffer.append("if (" + string2 + " == null) {" + EOL);
        stringBuffer.append("  " + this.stmtVar() + ".setNull(" + n2 + "," + n + ");" + EOL);
        stringBuffer.append("} else " + EOL);
    }

    public String assignResultVar() {
        StringBuffer stringBuffer = new StringBuffer();
        this.assignToFields(this.fieldList, stringBuffer, 1, this.beanVar(), true, true);
        return stringBuffer.toString();
    }

    private void assignToFields(List list, StringBuffer stringBuffer, int n, String string, boolean bl) {
        this.assignToFields(list, stringBuffer, n, string, bl, false);
    }

    private void assignToFields(List list, StringBuffer stringBuffer, int n, String string, boolean bl, boolean bl2) {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Iterator iterator = list.iterator();
        int n2 = list.size();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = this.convertToField(string2, n++);
            Class clazz = cMPBeanDescriptor.getFieldClass(string2);
            String string4 = null;
            if (bl2 && this.primaryKeyFieldList.contains(string2)) {
                stringBuffer.append("if (" + this.pkVar() + " == null) {" + EOL);
            }
            string4 = bl ? string + "." + string2 : string;
            if (clazz == Character.class || clazz == Character.TYPE) {
                stringBuffer.append("String " + this.stringVar(string2) + " = " + string3 + ";" + EOL);
                stringBuffer.append("  if (" + this.rsVar() + ".wasNull() || " + this.stringVar(string2) + "==null || " + this.stringVar(string2) + ".length()==0) { " + EOL);
                stringBuffer.append("    " + string4 + " = ");
                if (clazz == Character.class) {
                    stringBuffer.append("null");
                } else {
                    stringBuffer.append("'\\u0000'");
                }
                stringBuffer.append(";" + EOL);
                stringBuffer.append("  }" + EOL);
                stringBuffer.append("  else { " + EOL);
                stringBuffer.append("    " + string4 + " = ");
                if (clazz == Character.class) {
                    stringBuffer.append("new Character(" + this.stringVar(string2) + ".charAt(0));" + EOL);
                } else {
                    stringBuffer.append(this.stringVar(string2) + ".charAt(0);" + EOL);
                }
                stringBuffer.append("  }" + EOL);
            } else if (clazz == Date.class) {
                stringBuffer.append("java.sql.Timestamp " + this.sqlTimestampVar(string2) + " = " + string3 + ";" + EOL);
                stringBuffer.append("  if (" + this.rsVar() + ".wasNull() || " + this.sqlTimestampVar(string2) + "==null) { " + EOL);
                stringBuffer.append("    " + string4 + " = null");
                stringBuffer.append(";" + EOL);
                stringBuffer.append("  }" + EOL);
                stringBuffer.append("  else { " + EOL);
                stringBuffer.append("    " + string4 + " = ");
                stringBuffer.append("new java.util.Date(" + this.sqlTimestampVar(string2) + ".getTime());" + EOL);
                stringBuffer.append("  }" + EOL);
            } else if (!ClassUtils.isValidSQLType(clazz)) {
                stringBuffer.append(this.lvl() + "byte[] " + this.byteArrayVar(string2) + " = " + string3 + ";" + EOL);
                stringBuffer.append(this.lvl() + "if (" + this.debugEnabled() + ") {" + EOL);
                stringBuffer.append(this.upLvl() + this.debugSay() + "(\"returned bytes\" + " + this.byteArrayVar(string2) + ");" + EOL);
                stringBuffer.append(this.lvl() + "if (" + this.byteArrayVar(string2) + "!=null) {" + EOL);
                stringBuffer.append(this.upLvl() + this.debugSay() + "(\"length- \" + " + this.byteArrayVar(string2) + ".length);" + EOL);
                stringBuffer.append(this.dnLvl() + "}" + EOL);
                stringBuffer.append(this.dnLvl() + "}" + EOL);
                stringBuffer.append(this.lvl() + "if (" + this.rsVar() + ".wasNull() || " + this.byteArrayVar(string2) + " ==null || " + this.byteArrayVar(string2) + ".length==0) { " + EOL);
                stringBuffer.append(this.upLvl() + string4 + " = null;" + EOL);
                stringBuffer.append(this.dnLvl() + "}" + EOL);
                String string5 = "(" + this.javaCodeForType(clazz) + ")";
                stringBuffer.append(this.lvl() + "else { " + EOL);
                stringBuffer.append(this.upLvl() + "ByteArrayInputStream bstr = " + "new java.io.ByteArrayInputStream(" + this.byteArrayVar(string2) + ");" + EOL);
                stringBuffer.append(this.lvl() + "RDBMSObjectInputStream ostr = " + "new RDBMSObjectInputStream(bstr, " + this.pmVar() + ".getClassLoader()" + ");" + EOL);
                stringBuffer.append(this.lvl() + string4 + " = " + string5 + "ostr.readObject();" + EOL);
                stringBuffer.append(this.dnLvl() + "}" + EOL);
            } else {
                stringBuffer.append(string4 + " = " + string3 + ";" + EOL);
            }
            if (!clazz.isPrimitive() && clazz != Character.class && clazz != Date.class && ClassUtils.isValidSQLType(clazz)) {
                stringBuffer.append("  if (").append(this.rsVar()).append(".wasNull()) { ");
                stringBuffer.append(string4 + " = null; }").append(EOL);
            }
            if (!bl2 || !this.primaryKeyFieldList.contains(string2)) continue;
            stringBuffer.append("} else {" + EOL);
            stringBuffer.append(this.beanVar() + ".__WL_setPrimaryKey((" + this.pk_class() + ") " + this.pkVar() + ");" + EOL);
            stringBuffer.append("}" + EOL);
        }
    }

    private String convertToField(String string, int n) {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz = cMPBeanDescriptor.getFieldClass(string);
        String string2 = "(" + this.javaCodeForType(clazz) + ")";
        String string3 = this.getFromResultSet(n, clazz);
        if (clazz == Boolean.class) {
            return "new Boolean(" + string3 + ")";
        }
        if (clazz == Byte.class) {
            return "new Byte(" + string3 + ")";
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return "(java.lang.String)" + string3;
        }
        if (clazz == Double.class) {
            return "new Double(" + string3 + ")";
        }
        if (clazz == Float.class) {
            return "new Float(" + string3 + ")";
        }
        if (clazz == Integer.class) {
            return "new Integer(" + string3 + ")";
        }
        if (clazz == Long.class) {
            return "new Long(" + string3 + ")";
        }
        if (clazz == Short.class) {
            return "new Short(" + string3 + ")";
        }
        if (clazz == Date.class) {
            string2 = "(java.sql.Timestamp)";
            return string2 + string3;
        }
        if (!ClassUtils.isValidSQLType(clazz)) {
            return string3;
        }
        return string2 + string3;
    }

    private String getFromResultSet(int n, Class clazz) {
        String string = null;
        string = clazz.equals(BigDecimal.class) ? this.rsVar() + ".get" + TypeUtils.getResultSetMethodPostfix(clazz) + "(" + n + ")" : this.rsVar() + ".get" + TypeUtils.getResultSetMethodPostfix(clazz) + "(" + n + ")";
        return string;
    }

    public String result_set_to_collection_class() {
        assert (this.finderMethodInfo != null);
        assert (this.finderMethodInfo.method != null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("resultSetToCollection(" + this.rsVar() + ", " + "\"" + this.finderMethodInfo.method.getName() + "\");");
        return stringBuffer.toString();
    }

    public String beanIsUpdateable() {
        if (this.fieldList.size() > this.primaryKeyFieldList.size()) {
            return "true";
        }
        return "false";
    }

    public String updateBeanColumnsSql() {
        String[] stringArray = this.nonPrimaryKeyFieldList.toArray(new String[0]);
        return this.attrsAsColumnsAsParams(stringArray, ", ");
    }

    public String idParamsSql() {
        String[] stringArray = this.primaryKeyFieldList.toArray(new String[0]);
        assert (stringArray != null);
        return this.attrsAsColumnsAsParams(stringArray, " AND ");
    }

    public String idColumnsSql() {
        String[] stringArray = this.primaryKeyFieldList.toArray(new String[0]);
        assert (stringArray != null);
        return StringUtils.join((String[])stringArray, (String)", ");
    }

    public String allColumnsSql() {
        String[] stringArray = this.fieldList.toArray(new String[0]);
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String string2 = this.beanData.getColumnForField(string);
            assert (string2 != null);
            stringBuffer.append(string2);
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String allColumnsQMs() {
        String[] stringArray = this.fieldList.toArray(new String[0]);
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("?");
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String copyKeyValuesToPkVar() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        String[] stringArray = this.primaryKeyFieldList.toArray(new String[0]);
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (ClassUtils.isObjectPrimitive(cMPBeanDescriptor.getPrimaryKeyClass())) {
                assert (i == 0) : "Too many fields for an object primitive PK class";
                Class clazz = cMPBeanDescriptor.getFieldClass(stringArray[i]);
                stringBuffer.append(this.pkVar());
                if (clazz.getName().equals(cMPBeanDescriptor.getPrimaryKeyClass().getName())) {
                    stringBuffer.append(" = ");
                    stringBuffer.append("this").append(".").append(stringArray[i]).append(";");
                } else {
                    stringBuffer.append(" = new ");
                    stringBuffer.append(this.primaryKeyClass.getName());
                    stringBuffer.append("(");
                    stringBuffer.append(");");
                }
            } else {
                if (cMPBeanDescriptor.hasComplexPrimaryKey()) {
                    stringBuffer.append(this.pkVar()).append(".").append(string);
                } else {
                    stringBuffer.append(this.pkVar());
                }
                stringBuffer.append(" = ").append("this").append(".").append(string).append(";");
            }
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    public String perhaps_include_result_set_to_collection() throws CodeGenerationException {
        Serializable serializable;
        boolean bl = true;
        try {
            serializable = Class.forName("java.util.Collection");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        serializable = new StringBuffer();
        if (bl) {
            ((StringBuffer)serializable).append(this.parse(this.getProductionRule("resultSetToCollection")));
        }
        return ((StringBuffer)serializable).toString();
    }

    public String cm_bean_field_copy() {
        return this.cm_field_to_field_assign(this.ejbClass, "src.", "dest.");
    }

    public String cm_field_to_field_assign(Class clazz, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        Field[] fieldArray = this.fieldList.toArray(new Field[0]);
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            stringBuffer.append(string2 + field.getName() + " = " + string + field.getName() + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String implementStoreUtilities() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        String[] stringArray = this.fieldList.toArray(new String[0]);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("private void setParam" + stringArray[i]);
            stringBuffer.append("(PreparedStatement " + this.stmtVar() + ", ");
            stringBuffer.append("int " + this.numVar() + ", ");
            stringBuffer.append(cMPBeanDescriptor.getFieldClass(stringArray[i]).getName() + " ");
            stringBuffer.append(stringArray[i] + ") {" + EOL);
            this.addPreparedStatementBinding("", stringBuffer, stringArray[i], stringArray[i], this.numVar(), false, cMPBeanDescriptor.getFieldClass(stringArray[i]));
            stringBuffer.append(EOL);
            stringBuffer.append("}" + EOL + EOL);
        }
        return stringBuffer.toString();
    }

    private String lvl() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.level; ++i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    private String lvl(int n) {
        this.level = n;
        return this.lvl();
    }

    private String upLvl() {
        ++this.level;
        return this.lvl();
    }

    private String dnLvl() {
        --this.level;
        return this.lvl();
    }

    private String attrsAsColumnsAsParams(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = this.beanData.getColumnForField(stringArray[i]);
            stringBuffer.append(string2).append(" = ?");
            if (i >= n - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private Field nameToField(String string) throws NoSuchFieldException {
        return this.ejbClass.getField(string);
    }

    public String resetParams() {
        this.preparedStatementParamIndex = 1;
        return "// preparedStatementParamIndex reset.";
    }

    public String setBeanParams() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        String[] stringArray = this.fieldList.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray, "this", true, cMPBeanDescriptor.getBeanClass(), false);
    }

    public String setPrimaryKeyParams() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        String[] stringArray = this.primaryKeyFieldList.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray, this.pkVar(), cMPBeanDescriptor.hasComplexPrimaryKey(), cMPBeanDescriptor.getPrimaryKeyClass(), false);
    }

    public String setPrimaryKeyParamsUsingNum() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        String[] stringArray = this.primaryKeyFieldList.toArray(new String[0]);
        return this.preparedStatementBindings(stringArray, this.pkVar(), cMPBeanDescriptor.hasComplexPrimaryKey(), cMPBeanDescriptor.getPrimaryKeyClass(), true);
    }

    private String preparedStatementBindings(String[] stringArray, String string, boolean bl, Class clazz, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            String string3 = bl2 ? this.numVar() : String.valueOf(this.preparedStatementParamIndex);
            this.addPreparedStatementBinding("", stringBuffer, string2, string, string3, bl, clazz);
            if (bl2) {
                stringBuffer.append(this.numVar() + "++;" + EOL);
            }
            ++this.preparedStatementParamIndex;
            if (i >= n - 1) continue;
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private void addPreparedStatementBinding(String string, StringBuffer stringBuffer, String string2, String string3, String string4, boolean bl, Class clazz) {
        if (debugLogger.isDebugEnabled()) {
            RDBMSCodeGenerator.debug("Adding a prepared statement binding: ");
            RDBMSCodeGenerator.debug("\t\tfield = " + string2);
            RDBMSCodeGenerator.debug("\t\tobj = " + string3);
            RDBMSCodeGenerator.debug("\t\tparamIdx = " + string4);
            RDBMSCodeGenerator.debug("\t\tobjIsCompound = " + bl);
            RDBMSCodeGenerator.debug("\t\tobjectType = " + clazz);
        }
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        Class clazz2 = cMPBeanDescriptor.getFieldClass(string2);
        String string5 = StatementBinder.getStatementTypeNameForClass(clazz2);
        String string6 = string3;
        if (!clazz2.isPrimitive()) {
            if (bl) {
                string6 = string6 + "." + string2;
            }
            this.addNullCheck(string, stringBuffer, string6, string2, string4);
        }
        if (!ClassUtils.isValidSQLType(clazz2)) {
            stringBuffer.append(this.upLvl() + "ByteArrayOutputStream bstr = new ByteArrayOutputStream();" + EOL);
            stringBuffer.append(this.lvl() + "ObjectOutputStream ostr = new ObjectOutputStream(bstr);" + EOL);
            stringBuffer.append(this.lvl() + "ostr.writeObject(" + string6 + ");" + EOL);
            stringBuffer.append(this.lvl() + "byte[] byteArray = bstr.toByteArray();" + EOL);
            stringBuffer.append(this.lvl() + "if (" + this.debugEnabled() + ") {" + EOL);
            stringBuffer.append(this.upLvl() + this.debugSay() + "(\"writing bytes: \" + byteArray);" + EOL);
            stringBuffer.append(this.lvl() + "if (byteArray!=null) {" + EOL);
            stringBuffer.append(this.upLvl() + this.debugSay() + "(\"bytes length: \" + byteArray.length);" + EOL);
            stringBuffer.append(this.dnLvl() + "}" + EOL);
            stringBuffer.append(this.dnLvl() + "}" + EOL);
            stringBuffer.append(this.lvl() + "InputStream inputStream " + " = new ByteArrayInputStream(byteArray);" + EOL);
            stringBuffer.append(this.lvl() + this.stmtVar() + ".setBinaryStream(" + string4 + ", inputStream, byteArray.length);" + EOL);
        } else if (ClassUtils.isByteArray(clazz2)) {
            stringBuffer.append(this.lvl() + "InputStream inputStream " + " = new ByteArrayInputStream(" + string6 + ");" + EOL);
            stringBuffer.append(this.lvl() + this.stmtVar() + ".setBinaryStream(" + string4 + ", inputStream, " + string6 + ".length);" + EOL);
        } else {
            stringBuffer.append(string + "\t" + this.stmtVar());
            stringBuffer.append(".set" + string5 + "(");
            stringBuffer.append(string4).append(", ");
            if (bl) {
                if (clazz2 == Character.TYPE) {
                    stringBuffer.append("String.valueOf(" + string3 + "." + string2 + ")");
                } else if (clazz2 == Character.class) {
                    stringBuffer.append("String.valueOf(" + string3 + "." + string2 + ".charValue())");
                } else if (clazz2 == Date.class) {
                    stringBuffer.append("new java.sql.Timestamp(");
                    stringBuffer.append(string3).append(".").append(this.getParameterSetterName(clazz2, string2));
                    stringBuffer.append(".getTime())");
                } else {
                    stringBuffer.append(string3).append(".").append(this.getParameterSetterName(clazz2, string2));
                }
            } else if (ClassUtils.isObjectPrimitive(clazz)) {
                if (clazz == Character.class) {
                    stringBuffer.append("String.valueOf(" + string3 + ".charValue())");
                } else {
                    stringBuffer.append(this.getParameterSetterName(clazz, string3));
                }
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("\tThis type IS an object primitive.");
                }
            } else {
                if (clazz == Character.TYPE) {
                    stringBuffer.append("String.valueOf(" + string3 + ")");
                } else if (clazz2 == Date.class) {
                    stringBuffer.append("new java.sql.Timestamp(");
                    stringBuffer.append(string3);
                    stringBuffer.append(".getTime())");
                } else {
                    stringBuffer.append(string3);
                }
                if (debugLogger.isDebugEnabled()) {
                    RDBMSCodeGenerator.debug("\tThis type is not an object primitive.");
                }
            }
            stringBuffer.append(");" + EOL);
        }
        stringBuffer.append(this.lvl() + "if (" + this.debugEnabled() + ") {" + EOL);
        stringBuffer.append(this.upLvl() + this.debugSay() + "(\"paramIdx :\"+" + string4 + "+\" binded with value :\"+" + string6 + ");" + EOL);
        stringBuffer.append(this.dnLvl() + "}" + EOL);
        if (!clazz2.isPrimitive()) {
            stringBuffer.append(string + "}" + EOL);
        }
    }

    private String getParameterSetterName(Class clazz, String string) {
        if (clazz == Boolean.class) {
            return string + ".booleanValue()";
        }
        if (clazz == Byte.class) {
            return string + ".byteValue()";
        }
        if (clazz == Character.class) {
            return string + ".charValue()";
        }
        if (clazz == Double.class) {
            return string + ".doubleValue()";
        }
        if (clazz == Float.class) {
            return string + ".floatValue()";
        }
        if (clazz == Integer.class) {
            return string + ".intValue()";
        }
        if (clazz == Long.class) {
            return string + ".longValue()";
        }
        if (clazz == Short.class) {
            return string + ".shortValue()";
        }
        if (clazz == Character.TYPE) {
            return "String.valueOf(" + string + ")";
        }
        return string;
    }

    public String setUpdateBeanParams() {
        CMPCodeGenerator.Output output = (CMPCodeGenerator.Output)this.currentOutput;
        CMPBeanDescriptor cMPBeanDescriptor = output.getCMPBeanDescriptor();
        String[] stringArray = this.nonPrimaryKeyFieldList.toArray(new String[0]);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\t\tif((! __WL_snapshots_enabled) || __WL_modified[" + i + "]) {" + EOL);
            this.addPreparedStatementBinding("", stringBuffer, stringArray[i], stringArray[i], this.numVar(), false, cMPBeanDescriptor.getFieldClass(stringArray[i]));
            stringBuffer.append("\t\t" + this.numVar() + "++;" + EOL);
            stringBuffer.append("__WL_modified[" + i + "] = false;" + EOL);
            stringBuffer.append("}" + EOL);
        }
        return stringBuffer.toString();
    }

    public String assignAllColumnsToBean() {
        StringBuffer stringBuffer = new StringBuffer();
        this.assignToFields(this.fieldList, stringBuffer, 1, "this", true);
        return stringBuffer.toString();
    }

    public String refresh_bean_from_key() {
        if (this.isContainerManagedBean) {
            return "loadByPrimaryKey(ctx);";
        }
        return "((" + this.ejbClass.getName() + ")(ctx.getBean())).ejbFindByPrimaryKey(pk);";
    }

    public String snapshots_enabled() {
        this.useTunedUpdates = this.beanData.useTunedUpdates();
        for (String string : this.fieldList) {
            Class<?> clazz = this.getBeanField(string).getType();
            if (ClassUtils.isValidSQLType(clazz)) continue;
            this.useTunedUpdates = false;
            break;
        }
        this.initializeSnapshotArray();
        return "" + this.useTunedUpdates;
    }

    private Field getBeanField(String string) {
        try {
            return this.ejbClass.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            EJBLogger.logStackTrace((Throwable)noSuchFieldException);
            throw new AssertionError((Throwable)noSuchFieldException);
        }
    }

    private void initializeSnapshotArray() {
        int n = this.nonPrimaryKeyFieldList.size();
        String[] stringArray = new String[this.nonPrimaryKeyFieldList.size()];
        stringArray = this.nonPrimaryKeyFieldList.toArray(stringArray);
        this.snapshotFieldInfo = new SnapshotFieldInfo[n];
        for (int i = 0; i < n; ++i) {
            Class<?> clazz = this.getBeanField(stringArray[i]).getType();
            this.snapshotFieldInfo[i] = new SnapshotFieldInfo(clazz, stringArray[i], this.getSnapFieldTypeForClass(clazz), "__WL_snap_" + stringArray[i]);
        }
    }

    public String modified_array_count() {
        return "" + this.nonPrimaryKeyFieldList.size();
    }

    private boolean isImmutableType(Class clazz) {
        for (int i = 0; i < this.immutableClasses.length; ++i) {
            if (!clazz.equals(this.immutableClasses[i])) continue;
            return true;
        }
        return false;
    }

    private Class getSnapFieldTypeForClass(Class clazz) {
        if (clazz.isPrimitive() || this.isImmutableType(clazz)) {
            return clazz;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return Long.class;
        }
        if (byte[].class.equals((Object)clazz)) {
            return clazz;
        }
        return clazz;
    }

    private String getSnapAssignmentCode(String string, Class clazz) {
        if (Date.class.isAssignableFrom(clazz)) {
            return "((" + string + "==null)?null:new Long(" + string + ".getTime()))";
        }
        return string;
    }

    public String declare_snapshot_variables() {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < this.snapshotFieldInfo.length; ++i) {
            SnapshotFieldInfo snapshotFieldInfo = this.snapshotFieldInfo[i];
            String string = byte[].class.equals((Object)snapshotFieldInfo.snapFieldType) ? "byte []" : (String[].class.equals((Object)snapshotFieldInfo.snapFieldType) ? "String []" : (char[].class.equals((Object)snapshotFieldInfo.snapFieldType) ? "char []" : snapshotFieldInfo.snapFieldType.getName()));
            stringBuffer.append("private " + string + " " + snapshotFieldInfo.snapFieldName + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String clear_snapshot_variables() {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < this.snapshotFieldInfo.length; ++i) {
            SnapshotFieldInfo snapshotFieldInfo = this.snapshotFieldInfo[i];
            if (snapshotFieldInfo.snapFieldType.isPrimitive()) continue;
            stringBuffer.append("\t\t" + snapshotFieldInfo.snapFieldName + " = null;" + EOL);
        }
        return stringBuffer.toString();
    }

    public String take_snapshot_variables() {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < this.snapshotFieldInfo.length; ++i) {
            SnapshotFieldInfo snapshotFieldInfo = this.snapshotFieldInfo[i];
            if (byte[].class.equals((Object)snapshotFieldInfo.beanFieldType)) {
                stringBuffer.append(snapshotFieldInfo.snapFieldName + " = " + "__WL_snapshot_byte_array(" + snapshotFieldInfo.beanFieldName + ");" + EOL);
                continue;
            }
            stringBuffer.append(snapshotFieldInfo.snapFieldName + " = " + this.getSnapAssignmentCode(snapshotFieldInfo.beanFieldName, snapshotFieldInfo.beanFieldType) + ";" + EOL);
        }
        return stringBuffer.toString();
    }

    public String modified_field_index() {
        return "" + this.current_index;
    }

    public String snapshot_field() {
        return this.current.snapFieldName;
    }

    public String modified_field() {
        return this.current.beanFieldName;
    }

    public String modified_column_name() {
        return this.beanData.getColumnForField(this.current.beanFieldName);
    }

    public String determineSetString() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < this.snapshotFieldInfo.length; ++i) {
            this.current_index = i;
            this.current = this.snapshotFieldInfo[i];
            if (Date.class.isAssignableFrom(this.current.beanFieldType)) {
                stringBuffer.append(this.parse(this.getProductionRule("check_for_date_modified_field")));
                continue;
            }
            if (byte[].class.isAssignableFrom(this.current.beanFieldType)) {
                stringBuffer.append(this.parse(this.getProductionRule("check_for_bytea_modified_field")));
                continue;
            }
            stringBuffer.append(this.parse(this.getProductionRule("check_for_simple_modified_field")));
        }
        return stringBuffer.toString();
    }

    public String home_methods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.homeMethods != null) {
            for (int i = 0; i < this.homeMethods.length; ++i) {
                try {
                    String string = null;
                    string = this.homeToBeanName("ejbHome", this.homeMethods[i].getName());
                    Method method = this.ejbClass.getMethod(string, this.homeMethods[i].getParameterTypes());
                    this.setMethod(method, (short)0);
                    stringBuffer.append(this.parse(this.getProductionRule("business_method")));
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Throwable)noSuchMethodException);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String declare_bean_interface_methods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.declare_bean_interface_methods());
        for (Method method : this.finderList) {
            String string = MethodUtils.getFinderMethodDeclaration(method, this.bd.getPrimaryKeyClass(), true);
            stringBuffer.append(string);
            stringBuffer.append(";");
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }

    private String homeToBeanName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string + string2);
        stringBuffer.setCharAt(string.length(), Character.toUpperCase(stringBuffer.charAt(string.length())));
        return stringBuffer.toString();
    }

    private static void debug(String string) {
        debugLogger.debug("[RDBMSCodeGenerator] " + string);
    }

    private class FinderMethodInfo {
        public Method method;
        public Finder finder;
        public boolean loadBean;

        private FinderMethodInfo() {
        }
    }

    private static class SnapshotFieldInfo {
        private Class beanFieldType;
        private String beanFieldName;
        private Class snapFieldType;
        private String snapFieldName;

        public SnapshotFieldInfo(Class clazz, String string, Class clazz2, String string2) {
            this.beanFieldType = clazz;
            this.beanFieldName = string;
            this.snapFieldType = clazz2;
            this.snapFieldName = string2;
        }
    }
}

