/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms.compliance;

import java.lang.reflect.Field;
import java.util.List;
import weblogic.ejb.container.cmp11.rdbms.codegen.TypeUtils;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.EJBComplianceChecker;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.j2ee.validation.ComplianceException;
import weblogic.utils.ErrorCollectionException;

public final class RDBMSComplianceChecker
extends BaseComplianceChecker {
    private CMPBeanDescriptor bd = null;
    private Class ejbClass = null;
    private String ejbName = null;
    private List fieldList = null;
    private ErrorCollectionException errors = null;

    public RDBMSComplianceChecker(CMPBeanDescriptor cMPBeanDescriptor, Class clazz, List list) {
        if (EJBComplianceChecker.isNeedCheck) {
            return;
        }
        this.bd = cMPBeanDescriptor;
        this.ejbClass = clazz;
        this.fieldList = list;
        this.ejbName = cMPBeanDescriptor.getEJBName();
        this.errors = new ErrorCollectionException();
    }

    public void checkCompliance() throws ErrorCollectionException {
        this.checkCMPFields();
        if (!this.errors.isEmpty()) {
            throw this.errors;
        }
    }

    private void checkCMPFields() {
        for (String string : this.fieldList) {
            Field field = null;
            try {
                field = this.ejbClass.getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.CMP_FIELDS_MUST_BE_BEAN_FIELDS(this.ejbName, string)));
            }
            Class<?> clazz = field.getType();
            try {
                int n = TypeUtils.getSQLTypeForClass(clazz);
            }
            catch (EJBCException eJBCException) {
                this.errors.add((Throwable)new ComplianceException(this.fmt.CMP_FIELD_CLASS_NOT_SUPPORTED_IN_CMP11(this.ejbName, field.getName(), clazz.getName())));
            }
        }
    }
}

