/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms.finders;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp11.rdbms.codegen.TypeUtils;
import weblogic.ejb.container.cmp11.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp11.rdbms.finders.InvalidFinderException;
import weblogic.ejb.container.cmp11.rdbms.finders.SQLQueryExpander;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLExpression;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLParser;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public final class Finder {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private String methodName = null;
    private List parameterTypes = null;
    private String ejbQuery = null;
    private String sqlQuery = null;
    private WLQLExpression wlqlExpression = null;
    private List finderExpressions = null;
    private FinderOptions finderOptions = null;
    private SQLQueryExpander sqlExpander = null;
    private boolean isSQL;
    private int[] sqlVariableMap;

    public Finder(String string, String string2) throws InvalidFinderException {
        this.setName(string);
        this.setWeblogicQuery(string2);
        this.parameterTypes = new ArrayList();
        this.finderExpressions = new ArrayList();
    }

    public void setUsingSQL(boolean bl) {
        this.isSQL = bl;
    }

    private void setName(String string) throws InvalidFinderException {
        if (string == null) {
            throw new InvalidFinderException(1, string);
        }
        if (string.equals("")) {
            throw new InvalidFinderException(2, string);
        }
        if (!string.startsWith("find")) {
            throw new InvalidFinderException(3, string);
        }
        this.methodName = string;
    }

    public String getName() {
        return this.methodName;
    }

    public void addParameterType(String string) {
        if (string.length() > 0) {
            this.parameterTypes.add(string);
        }
    }

    public Iterator getParameterTypes() {
        return this.parameterTypes.iterator();
    }

    public void setWeblogicQuery(String string) {
        this.ejbQuery = string;
        this.sqlQuery = null;
    }

    public String getWeblogicQuery() {
        return this.ejbQuery;
    }

    public String getSQLQuery(Hashtable hashtable) throws IllegalExpressionException {
        Collection collection;
        this.computeSQLQuery(hashtable);
        if (this.sqlExpander.hasWarnings() && (collection = this.sqlExpander.getWarnings()) != null) {
            EJBLogger eJBLogger = new EJBLogger();
            for (Exception exception : collection) {
                EJBLogger.logWarningFromEJBQLCompiler((String)exception.getMessage());
            }
        }
        return this.getSQLQuery();
    }

    public String getSQLQuery() {
        return this.sqlQuery;
    }

    public WLQLExpression getWLQLExpression() {
        return this.wlqlExpression;
    }

    public void addFinderExpression(int n, String string, String string2) throws InvalidFinderException {
        this.finderExpressions.add(new FinderExpression(n, string, string2));
    }

    public void addFinderExpression(FinderExpression finderExpression) {
        this.finderExpressions.add(finderExpression);
    }

    public Iterator getFinderExpressions() {
        return this.finderExpressions.iterator();
    }

    public FinderExpression getFinderExpression(int n) {
        Iterator iterator = this.getFinderExpressions();
        while (iterator.hasNext()) {
            FinderExpression finderExpression = (FinderExpression)iterator.next();
            if (finderExpression.getNumber() != n) continue;
            return finderExpression;
        }
        return null;
    }

    public FinderOptions getFinderOptions() {
        return this.finderOptions;
    }

    public void setFinderOptions(FinderOptions finderOptions) {
        this.finderOptions = finderOptions;
    }

    public int getParameterIndex(int n) {
        if (this.isSQL) {
            return this.sqlVariableMap[n - 1];
        }
        int[] nArray = this.sqlExpander.getVariableMap();
        return nArray[n - 1];
    }

    public int getVariableCount() {
        if (this.isSQL) {
            return this.sqlVariableMap.length;
        }
        int[] nArray = this.sqlExpander.getVariableMap();
        Debug.assertion((nArray != null ? 1 : 0) != 0);
        return nArray.length;
    }

    public FinderExpression getExpressionForVariable(int n, Class[] classArray) {
        FinderExpression finderExpression = this.getFinderExpression(this.getParameterIndex(n));
        if (finderExpression == null) {
            try {
                finderExpression = new FinderExpression(this.getParameterIndex(n), "@" + this.getParameterIndex(n), classArray[this.getParameterIndex(n)].getName());
            }
            catch (InvalidFinderException invalidFinderException) {
                throw new AssertionError("Internal logic produced invalid  FinderExpression " + StackTraceUtils.throwable2StackTrace((Throwable)invalidFinderException));
            }
        }
        return finderExpression;
    }

    public boolean methodIsEquivalent(Method method) {
        if (!method.getName().equals(this.getName())) {
            return false;
        }
        String[] stringArray = MethodUtils.classesToJavaSourceTypes(method.getParameterTypes());
        if (this.parameterTypes.size() != stringArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(this.parameterTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Finder)) {
            return false;
        }
        Finder finder = (Finder)object;
        if (!this.getName().equals(finder.getName())) {
            return false;
        }
        if (this.getWLQLExpression() == null ? finder.getWLQLExpression() != null : !this.getWLQLExpression().equals(finder.getWLQLExpression())) {
            return false;
        }
        if (!((Object)this.finderExpressions).equals(finder.finderExpressions)) {
            return false;
        }
        return ((Object)this.parameterTypes).equals(finder.parameterTypes);
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getWLQLExpression().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Finder ");
        stringBuffer.append("methodName = " + this.methodName + "; ");
        stringBuffer.append("wlqlQuery = " + this.ejbQuery + "; ");
        stringBuffer.append("wlqlExpression = " + this.wlqlExpression + "; ");
        stringBuffer.append("sqlQuery = " + this.sqlQuery + " ");
        stringBuffer.append("Finder Expressions = " + this.finderExpressions + ";");
        stringBuffer.append("Parameter types = " + this.parameterTypes + ";");
        stringBuffer.append(" End-Finder]");
        return stringBuffer.toString();
    }

    public void parseExpression() throws EJBCException, InvalidFinderException {
        if (this.isSQL) {
            return;
        }
        WLQLParser wLQLParser = new WLQLParser();
        if (this.ejbQuery == null) {
            throw new InvalidFinderException(4, this.ejbQuery);
        }
        if (this.ejbQuery.equals("")) {
            this.wlqlExpression = new WLQLExpression(17);
        } else {
            this.wlqlExpression = wLQLParser.parse(this.ejbQuery);
        }
    }

    public void computeSQLQuery(Hashtable hashtable) throws IllegalExpressionException {
        if (this.isSQL) {
            this.computeLiteralSQLQuery();
        } else {
            try {
                this.sqlExpander = new SQLQueryExpander(this.wlqlExpression, hashtable);
                this.sqlQuery = this.sqlExpander.toSQL();
                if (!this.sqlQuery.trim().equals("")) {
                    this.sqlQuery = " WHERE " + this.sqlQuery;
                }
                if (this.getFinderOptions() != null && this.getFinderOptions().getFindForUpdate()) {
                    this.sqlQuery = this.sqlQuery + " FOR UPDATE";
                }
            }
            catch (IllegalExpressionException illegalExpressionException) {
                illegalExpressionException.setFinder(this);
                throw illegalExpressionException;
            }
        }
    }

    public String toUserLevelString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Finder");
        if (bl) {
            stringBuffer.append("\n\t");
        } else {
            stringBuffer.append(", ");
        }
        stringBuffer.append("Method Name: " + this.methodName);
        if (bl) {
            stringBuffer.append("\n\t");
        } else {
            stringBuffer.append(", ");
        }
        stringBuffer.append("Parameter Types: (");
        Iterator iterator = this.getParameterTypes();
        while (iterator.hasNext()) {
            stringBuffer.append("" + iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        if (bl) {
            stringBuffer.append("\n\t");
        } else {
            stringBuffer.append(", ");
        }
        stringBuffer.append("WebLogic Query: " + this.ejbQuery);
        if (bl) {
            stringBuffer.append("\n\t");
        } else {
            stringBuffer.append(", ");
        }
        stringBuffer.append("Finder Expressions: (");
        Iterator iterator2 = this.getFinderExpressions();
        while (iterator2.hasNext()) {
            stringBuffer.append("" + iterator2.next());
            if (!iterator2.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean isContentValid() {
        this.sqlQuery = null;
        try {
            this.parseExpression();
        }
        catch (EJBCException eJBCException) {
            return false;
        }
        catch (InvalidFinderException invalidFinderException) {
            return false;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = this.getFinderExpressions();
        while (iterator.hasNext()) {
            FinderExpression finderExpression = (FinderExpression)iterator.next();
            int n = finderExpression.getNumber();
            if (hashSet.contains(new Integer(n))) {
                return false;
            }
            hashSet.add(new Integer(n));
            if (finderExpression.getExpressionText() == null || finderExpression.getExpressionText().trim().equals("")) {
                return false;
            }
            String string = finderExpression.getExpressionType();
            if (string == null || string.trim().equals("")) {
                return false;
            }
            Class clazz = null;
            try {
                clazz = ClassUtils.nameToClass(string, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            if (TypeUtils.isValidSQLType(clazz)) continue;
            return false;
        }
        return true;
    }

    public static boolean isQueryValid(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            WLQLParser wLQLParser = new WLQLParser();
            wLQLParser.parse(string);
            return true;
        }
        catch (EJBCException eJBCException) {
            return false;
        }
    }

    private void computeLiteralSQLQuery() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ");
        int n2 = this.ejbQuery.length();
        for (n = 0; n < n2; ++n) {
            char c = this.ejbQuery.charAt(n);
            if (c == '$') {
                int n3 = n;
                while (n + 1 < n2 && Character.isDigit(this.ejbQuery.charAt(n + 1))) {
                    ++n;
                }
                int n4 = n;
                if (n3 == n4) {
                    stringBuffer.append('$');
                    continue;
                }
                int n5 = 1;
                int n6 = 0;
                for (int i = n4; i != n3; --i) {
                    n6 += (this.ejbQuery.charAt(i) - 48) * n5;
                    n5 *= 10;
                }
                stringBuffer.append('?');
                arrayList.add(new Integer(n6));
                continue;
            }
            stringBuffer.append(c);
        }
        this.sqlQuery = stringBuffer.toString();
        this.sqlVariableMap = new int[arrayList.size()];
        n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.sqlVariableMap[n++] = (Integer)iterator.next();
        }
    }

    public static class FinderOptions {
        private boolean findForUpdate = false;

        public boolean getFindForUpdate() {
            return this.findForUpdate;
        }

        public void setFindForUpdate(boolean bl) {
            this.findForUpdate = bl;
        }
    }

    public static class FinderExpression {
        private static final boolean debug = false;
        private static final boolean verbose = false;
        private int number;
        private String expressionText;
        private String expressionType;

        public FinderExpression(int n) {
            this.number = n;
        }

        public FinderExpression(int n, String string, String string2) throws InvalidFinderException {
            if (n < 0) {
                throw new InvalidFinderException(5, null);
            }
            this.number = n;
            if (string == null) {
                throw new InvalidFinderException(6, null);
            }
            this.expressionText = string;
            if (string2 == null) {
                throw new InvalidFinderException(7, null);
            }
            this.expressionType = string2;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int n) {
            this.number = n;
        }

        public String getExpressionText() {
            return this.expressionText;
        }

        public String getExpressionType() {
            return this.expressionType;
        }

        public void setExpressionText(String string) {
            this.expressionText = string;
        }

        public void setExpressionType(String string) {
            this.expressionType = string;
        }

        public String getExpressionWithParams(String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            String string = this.expressionText;
            while (string.length() > 0) {
                if (string.charAt(0) == '@') {
                    string = string.substring(1);
                    stringBuffer2 = new StringBuffer();
                    while (Character.isDigit(string.charAt(0))) {
                        stringBuffer2.append(string.charAt(0));
                        if ((string = string.substring(1)).length() > 0) continue;
                    }
                    int n = -1;
                    try {
                        n = Integer.parseInt(stringBuffer2.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AssertionError("Internal logic error reading a finder expression:" + StackTraceUtils.throwable2StackTrace((Throwable)numberFormatException));
                    }
                    stringBuffer.append(stringArray[n]);
                    continue;
                }
                stringBuffer.append(string.charAt(0));
                string = string.substring(1);
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FinderExpression)) {
                return false;
            }
            FinderExpression finderExpression = (FinderExpression)object;
            if (finderExpression.getNumber() != this.getNumber()) {
                return false;
            }
            if (!finderExpression.getExpressionText().equals(this.getExpressionText())) {
                return false;
            }
            return finderExpression.getExpressionType().equals(this.getExpressionType());
        }

        public int hashCode() {
            return this.number ^ this.expressionText.hashCode() ^ this.expressionType.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[Finder.FinderExpression: ");
            stringBuffer.append(" number: " + this.number + "; ");
            stringBuffer.append(" expressionText: " + this.expressionText + "; ");
            stringBuffer.append(" expressionType: " + this.expressionType + "; ");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

