/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms.finders;

import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.ejb.container.cmp11.rdbms.finders.Finder;
import weblogic.utils.PlatformConstants;

public final class IllegalExpressionException
extends Exception
implements PlatformConstants {
    private static final long serialVersionUID = -3707529156302719304L;
    public static final int INVALID_IDENTIFIER = 1;
    public static final int INVALID_OPERATION = 2;
    public static final int INVALID_EXPRESSION_TYPE = 3;
    public static final int COULD_NOT_PARSE = 4;
    private int errorCode = 0;
    private String identifier = null;
    private Finder finder = null;
    private Finder.FinderExpression expression = null;
    private String message = null;

    public IllegalExpressionException(int n, String string, Finder.FinderExpression finderExpression) {
        this.errorCode = n;
        this.identifier = string;
        this.expression = finderExpression;
    }

    public IllegalExpressionException(int n, String string) {
        this(n, string, (Finder.FinderExpression)null);
    }

    public IllegalExpressionException(int n, String string, String string2) {
        this(n, string);
        this.message = string2;
    }

    public void setFinder(Finder finder) {
        this.finder = finder;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
        stringBuffer.append(this.getClass().getName() + ":" + EOL);
        stringBuffer.append(eJBTextTextFormatter.whileTryingToProcess(this.finder == null ? null : this.finder.toUserLevelString(true)) + EOL);
        String string = "WLQL";
        switch (this.errorCode) {
            case 1: {
                stringBuffer.append(eJBTextTextFormatter.invalidIdInExpression(string, this.identifier));
                break;
            }
            case 2: {
                stringBuffer.append(eJBTextTextFormatter.invalidOp(string, this.identifier));
                break;
            }
            case 3: {
                stringBuffer.append("Finder Expression: " + this.expression + " is invalid." + EOL);
                stringBuffer.append("It has type " + this.identifier + ", which is not a valid Finder Expression type.");
                break;
            }
            case 4: {
                stringBuffer.append(eJBTextTextFormatter.couldNotParse(string, this.identifier));
            }
        }
        stringBuffer.append("  ").append(this.message);
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }
}

