/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms.finders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp11.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLExpression;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLExpressionTypes;
import weblogic.ejb.container.utils.ToStringUtils;
import weblogic.logging.Loggable;

public class SQLQueryExpander
implements WLQLExpressionTypes {
    private static final boolean verbose = false;
    private static final char DOT = '.';
    private int variableCount = 0;
    protected WLQLExpression queryExpression = null;
    private Hashtable parameterMap = null;
    private List variableMap = null;
    private Collection warnings = null;

    public SQLQueryExpander(WLQLExpression wLQLExpression, Hashtable hashtable) {
        this.queryExpression = wLQLExpression;
        this.parameterMap = hashtable;
        this.variableMap = new LinkedList();
    }

    public String toSQL() throws IllegalExpressionException {
        return this.toSQL(this.queryExpression);
    }

    public String toSQL(WLQLExpression wLQLExpression) throws IllegalExpressionException {
        switch (wLQLExpression.type()) {
            case 0: {
                return this.join(wLQLExpression, "AND");
            }
            case 1: {
                return this.join(wLQLExpression, "OR");
            }
            case 2: {
                return "NOT " + this.toSQL(wLQLExpression.term(0));
            }
            case 3: {
                return this.twoTerm(wLQLExpression, "=");
            }
            case 4: {
                return this.twoTerm(wLQLExpression, "<");
            }
            case 5: {
                return this.twoTerm(wLQLExpression, ">");
            }
            case 6: {
                return this.twoTerm(wLQLExpression, "<=");
            }
            case 7: {
                return this.twoTerm(wLQLExpression, ">=");
            }
            case 8: {
                return this.twoTerm(wLQLExpression, "LIKE");
            }
            case 9: {
                return this.getIdentifier(wLQLExpression.getSval());
            }
            case 10: {
                return "'" + ToStringUtils.escapedQuotesToString(wLQLExpression.getSval()) + "'";
            }
            case 11: {
                return wLQLExpression.getSval();
            }
            case 12: {
                return wLQLExpression.getSpecialName() + " " + this.join(wLQLExpression, ",");
            }
            case 13: {
                return this.getVariable(wLQLExpression);
            }
            case 14: {
                return this.toSQL(wLQLExpression.term(0)) + " IS NULL";
            }
            case 15: {
                return this.toSQL(wLQLExpression.term(0)) + " IS NOT NULL";
            }
            case 16: {
                return this.toSQL(wLQLExpression.term(1)) + " ORDER BY " + wLQLExpression.term(0).getSval();
            }
            case 17: {
                return "";
            }
        }
        throw new IllegalExpressionException(2, WLQLExpressionTypes.TYPE_NAMES[wLQLExpression.getType()]);
    }

    public String[] getParameterNames(WLQLExpression wLQLExpression) {
        Vector vector = new Vector();
        this.getParameterNames(wLQLExpression, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void getParameterNames(WLQLExpression wLQLExpression, Vector vector) {
        if (wLQLExpression.type() == 13) {
            vector.addElement(wLQLExpression.getSval());
        } else {
            int n = wLQLExpression.numTerms();
            for (int i = 0; i < n; ++i) {
                this.getParameterNames(wLQLExpression.term(i), vector);
            }
        }
    }

    public int[] getVariableMap() {
        int[] nArray = new int[this.variableMap.size()];
        Iterator iterator = this.variableMap.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            nArray[n++] = n2;
        }
        return nArray;
    }

    boolean hasWarnings() {
        if (this.warnings == null) {
            return false;
        }
        return this.warnings.size() != 0;
    }

    Collection getWarnings() {
        if (this.warnings == null) {
            return new ArrayList();
        }
        return this.warnings;
    }

    private void addWarning(Exception exception) {
        Collection collection = this.getWarnings();
        collection.add(exception);
    }

    protected String join(WLQLExpression wLQLExpression, String string) throws IllegalExpressionException {
        int n = wLQLExpression.numTerms();
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.toSQL(wLQLExpression.term(i)));
            if (i >= n - 1) continue;
            stringBuffer.append(" ").append(string).append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String twoTerm(WLQLExpression wLQLExpression, String string) throws IllegalExpressionException {
        String string2 = this.toSQL(wLQLExpression.term(0));
        String string3 = this.toSQL(wLQLExpression.term(1));
        String string4 = "(" + string2 + " " + string + " " + string3 + ")";
        return string4;
    }

    private String getIdentifier(String string) throws IllegalExpressionException {
        IllegalExpressionException illegalExpressionException;
        String string2 = (String)this.parameterMap.get(string);
        if (null == string2) {
            throw new IllegalExpressionException(1, string);
        }
        char[] cArray = string2.toCharArray();
        if (cArray.length > 0 && cArray[0] != '.' && !Character.isJavaIdentifierStart(cArray[0])) {
            Loggable loggable = EJBLogger.logInvalidStartCharacterForEJBQLIdentifierLoggable((char)cArray[0], (String)string2);
            illegalExpressionException = new IllegalExpressionException(1, loggable.getMessage());
            this.addWarning(illegalExpressionException);
        }
        if (cArray.length > 1) {
            for (int i = 1; i < cArray.length; ++i) {
                if (cArray[i] == '.' || Character.isJavaIdentifierPart(cArray[i])) continue;
                illegalExpressionException = EJBLogger.logInvalidPartCharacterForEJBQLIdentifierLoggable((char)cArray[i], (String)string2);
                IllegalExpressionException illegalExpressionException2 = new IllegalExpressionException(1, illegalExpressionException.getMessage());
                this.addWarning(illegalExpressionException2);
            }
        }
        return string2;
    }

    private String getVariable(WLQLExpression wLQLExpression) {
        this.variableMap.add(new Integer(wLQLExpression.getSval()));
        ++this.variableCount;
        return "?";
    }
}

