/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.cmp11.rdbms.finders;

import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.ejb.container.cmp11.rdbms.finders.IllegalExpressionException;
import weblogic.ejb.container.cmp11.rdbms.finders.SQLQueryExpander;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLExpression;
import weblogic.ejb.container.cmp11.rdbms.finders.WLQLExpressionTypes;
import weblogic.logging.Loggable;

public final class WLQLtoEJBQLExpander
extends SQLQueryExpander {
    EJBTextTextFormatter fmt = null;

    public WLQLtoEJBQLExpander(WLQLExpression wLQLExpression) {
        super(wLQLExpression, null);
    }

    public String toEJBQL() throws IllegalExpressionException {
        return this.toSQL(this.queryExpression);
    }

    public String toSQL(WLQLExpression wLQLExpression) throws IllegalExpressionException {
        switch (wLQLExpression.type()) {
            case 9: {
                return this.perhapsAppendAbstractSchemaAlias(wLQLExpression.getSval());
            }
            case 12: {
                Loggable loggable = EJBLogger.logejbqlNoTokenSpecialLoggable((String)wLQLExpression.getSpecialName());
                throw new IllegalExpressionException(2, WLQLExpressionTypes.TYPE_NAMES[wLQLExpression.getType()], loggable.getMessage());
            }
            case 13: {
                return this.getVariable(wLQLExpression);
            }
            case 16: {
                Loggable loggable = EJBLogger.logejbqlOrderByIsDifferentLoggable();
                throw new IllegalExpressionException(2, WLQLExpressionTypes.TYPE_NAMES[wLQLExpression.getType()], loggable.getMessage());
            }
            case 3: {
                if (!wLQLExpression.term(0).equals(wLQLExpression.term(1))) break;
                return null;
            }
        }
        return super.toSQL(wLQLExpression);
    }

    private String getVariable(WLQLExpression wLQLExpression) {
        Integer n = new Integer(wLQLExpression.getSval());
        int n2 = n;
        return "?" + ++n2;
    }

    private String perhapsAppendAbstractSchemaAlias(String string) {
        String string2 = string;
        if (string2 != null && !string2.startsWith("o.")) {
            string2 = "o." + string2;
        }
        return string2;
    }
}

