/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionSynchronization;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.TimeoutCheckHelper;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.utils.ErrorCollectionException;

abstract class BeanClassChecker
extends BaseComplianceChecker {
    protected Class beanClass;
    protected int beanClassMod;
    private Class remoteClass;
    private Class localClass;
    protected ClientDrivenBeanInfo beanInfo;
    protected String ejbName;

    BeanClassChecker(ClientDrivenBeanInfo clientDrivenBeanInfo) throws ClassNotFoundException {
        this.beanClass = clientDrivenBeanInfo.getBeanClass();
        this.beanClassMod = this.beanClass.getModifiers();
        this.beanInfo = clientDrivenBeanInfo;
        this.remoteClass = this.beanInfo.getRemoteInterfaceClass();
        this.localClass = this.beanInfo.getLocalInterfaceClass();
        this.ejbName = this.beanInfo.getEJBName();
    }

    protected String section(String string, String string2) {
        if (this.beanInfo instanceof EntityBeanInfo) {
            return string2;
        }
        return string;
    }

    protected List getCreateMethods() {
        Method[] methodArray = this.beanClass.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("ejbCreate")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    protected List getBusMethods() {
        int n;
        Method[] methodArray;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (this.remoteClass != null) {
            methodArray = this.remoteClass.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (this.isEJBObjectMethod(methodArray[n])) continue;
                arrayList.add(methodArray[n]);
            }
        }
        if (this.localClass != null) {
            methodArray = this.localClass.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (this.isEJBObjectMethod(methodArray[n])) continue;
                arrayList.add(methodArray[n]);
            }
        }
        return arrayList;
    }

    private boolean isEJBObjectMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return EJBObject.class.equals(clazz) || EJBLocalObject.class.equals(clazz);
    }

    abstract void validateCreateReturnType(Method var1) throws ComplianceException;

    protected void validateEjbCreates(List list) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : list) {
            int n = method.getModifiers();
            if (!Modifier.isPublic(n)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.PUBLIC_EJBCREATE(this.ejbName)));
            }
            if (Modifier.isFinal(n)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINAL_EJBCREATE(this.ejbName)));
            }
            if (Modifier.isStatic(n)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.STATIC_EJBCREATE(this.ejbName)));
            }
            try {
                this.validateCreateReturnType(method);
            }
            catch (ComplianceException complianceException) {
                errorCollectionException.add((Throwable)complianceException);
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkRemoteView() throws ComplianceException {
        if (this.beanInfo.getHomeInterfaceName() != null && this.beanInfo.getRemoteInterfaceName() == null || this.beanInfo.getHomeInterfaceName() == null && this.beanInfo.getRemoteInterfaceName() != null) {
            throw new ComplianceException(this.fmt.INCONSISTENT_REMOTE_VIEW(this.ejbName));
        }
    }

    public void checkLocalView() throws ComplianceException {
        if (this.beanInfo.getLocalHomeInterfaceName() != null && this.beanInfo.getLocalInterfaceName() == null || this.beanInfo.getLocalHomeInterfaceName() == null && this.beanInfo.getLocalInterfaceName() != null) {
            throw new ComplianceException(this.fmt.INCONSISTENT_LOCAL_VIEW(this.ejbName));
        }
    }

    public void checkClientView() throws ComplianceException {
        if (this.beanInfo.isEJB30()) {
            return;
        }
        if (this.beanInfo.hasRemoteClientView()) {
            return;
        }
        if (this.beanInfo.hasLocalClientView()) {
            return;
        }
        if (this.beanInfo.hasWebserviceClientView()) {
            return;
        }
        throw new ComplianceException(this.fmt.NO_CLIENT_VIEW(this.ejbName));
    }

    public void checkSessionSynchronization() throws ComplianceException {
        if (SessionSynchronization.class.isAssignableFrom(this.beanClass)) {
            if (this.beanInfo instanceof EntityBeanInfo) {
                throw new ComplianceException(this.fmt.ENTITY_IMPLEMENT_SESSIONSYNCHRONIZATION(this.ejbName));
            }
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.beanInfo;
            if (!sessionBeanInfo.isStateful()) {
                throw new ComplianceException(this.fmt.STATELESS_IMPLEMENT_SESSIONSYNCHRONIZATION(this.ejbName));
            }
            if (sessionBeanInfo.usesBeanManagedTx()) {
                throw new ComplianceException(this.fmt.BEAN_MANAGED_IMPLEMENT_SESSIONSYNCHRONIZATION(this.ejbName));
            }
        }
    }

    public void checkTransactionAttribute() throws ComplianceException {
        MethodInfo methodInfo;
        short s;
        if (this.beanInfo.isTimerDriven() && 1 != (s = (methodInfo = this.beanInfo.getBeanMethodInfo(DDUtils.getMethodSignature(this.beanInfo.getTimeoutMethod()))).getTransactionAttribute()) && 3 != s && 0 != s) {
            throw new ComplianceException(this.fmt.EJB_TIMEOUT_BAD_TX_ATTRIBUTE(this.beanInfo.getDisplayName()));
        }
    }

    public void checkBeanClassIsPublic() throws ComplianceException {
        if (!Modifier.isPublic(this.beanClassMod)) {
            throw new ComplianceException(this.fmt.PUBLIC_BEAN_CLASS(this.ejbName));
        }
    }

    public void checkBeanClassIsNotFinal() throws ComplianceException {
        if (Modifier.isFinal(this.beanClassMod)) {
            throw new ComplianceException(this.fmt.FINAL_BEAN_CLASS(this.ejbName));
        }
    }

    public void checkBeanClassHasPublicNoArgCtor() throws ComplianceException {
        if (!ComplianceUtils.classHasPublicNoArgCtor(this.beanClass)) {
            throw new ComplianceException(this.fmt.PUBLIC_NOARG_BEAN_CTOR(this.ejbName));
        }
    }

    public void checkBeanClassDoesNotDefineFinalize() throws ComplianceException {
        try {
            Method method = this.beanClass.getMethod("finalize", null);
            throw new ComplianceException(this.fmt.NO_FINALIZE_IN_BEAN(this.ejbName));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
    }

    public void checkBeanMethodsAreSynchronized() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = this.beanClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n = methodArray[i].getModifiers();
            if (!Modifier.isSynchronized(n)) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NO_SYNCHRONIZED_METHODS(this.ejbName, this.methodSig(methodArray[i]))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkLocalReferences() throws ErrorCollectionException {
        if (this.beanInfo.isEJB30()) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Map map = this.beanInfo.getAllEJBLocalReferenceJNDINames();
        for (EjbLocalRefBean ejbLocalRefBean : this.beanInfo.getAllEJBLocalReferences()) {
            String string;
            String string2 = ejbLocalRefBean.getEjbLink();
            if (string2 != null && string2.length() > 0 || (string = (String)map.get(ejbLocalRefBean.getEjbRefName())) != null && string.length() != 0) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BEAN_MISSING_LREF_JNDI_NAME(this.ejbName, ejbLocalRefBean.getEjbRefName()), new DescriptorErrorInfo("<jndi-name>", (Object)this.ejbName, (Object)string)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkReferences() throws ErrorCollectionException {
        if (this.beanInfo.isEJB30()) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Map map = this.beanInfo.getAllEJBReferenceJNDINames();
        for (EjbRefBean ejbRefBean : this.beanInfo.getAllEJBReferences()) {
            String string;
            String string2 = ejbRefBean.getEjbLink();
            if (string2 != null && string2.length() > 0 || (string = (String)map.get(ejbRefBean.getEjbRefName())) != null && string.length() != 0) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BEAN_MISSING_REF_JNDI_NAME(this.ejbName, ejbRefBean.getEjbRefName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkCallByReference() {
        if (this.beanInfo.hasRemoteClientView() && !this.beanInfo.useCallByReference() && !this.beanInfo.isWarningDisabled("BEA-010202")) {
            EJBLogger.logCallByReferenceNotEnabled((String)this.ejbName);
        }
    }

    public void checkBusinessMethods() throws ErrorCollectionException {
        List list = this.getBusMethods();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : list) {
            Method method2 = null;
            try {
                method2 = ClassUtils.getDeclaredMethod(this.beanClass, method.getName(), method.getParameterTypes());
                String string = method2.getName();
                int n = method2.getModifiers();
                if (!Modifier.isPublic(n)) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BUS_METHOD_NOT_PUBLIC(this.ejbName, string)));
                }
                if (Modifier.isFinal(n)) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BUS_METHOD_MUST_NOT_FINAL(this.ejbName, string)));
                }
                if (!Modifier.isStatic(n)) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BUS_METHOD_MUST_NOT_STATIC(this.ejbName, string)));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (EJBObject.class.isAssignableFrom(method.getDeclaringClass())) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EO_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, DDUtils.getMethodSignature(method))));
                    continue;
                }
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ELO_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, DDUtils.getMethodSignature(method))));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkTimeoutMethods() throws ErrorCollectionException, ComplianceException {
        TimeoutCheckHelper.validateTimeoutMethod(this.beanInfo);
    }

    public void checkAppExceptions() throws ErrorCollectionException {
        if (!this.beanInfo.isEJB30()) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Map map = this.beanInfo.getDeploymentInfo().getApplicationExceptions();
        if (map == null) {
            return;
        }
        Set set = map.keySet();
        ClassLoader classLoader = this.beanInfo.getClassLoader();
        Iterator iterator = set.iterator();
        Class<?> clazz = null;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            try {
                clazz = classLoader == null ? Class.forName((String)k) : classLoader.loadClass((String)k);
            }
            catch (ClassNotFoundException classNotFoundException) {
                errorCollectionException.add((Throwable)classNotFoundException);
                continue;
            }
            if (!RemoteException.class.isAssignableFrom(clazz)) continue;
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().EXCEPTION_CANNOT_EXTEND_REMOTEEXCEPTION(this.ejbName)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }
}

