/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBLocalObject;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.utils.MethodUtils;

public final class BusinessLocalInterfaceChecker
extends BaseComplianceChecker {
    private final Ejb3SessionBeanInfo sbi;
    private final Set lbi;

    public BusinessLocalInterfaceChecker(Ejb3SessionBeanInfo ejb3SessionBeanInfo) {
        this.sbi = ejb3SessionBeanInfo;
        this.lbi = ejb3SessionBeanInfo.getBusinessLocals();
    }

    public void checkLBIIsNotRBI() throws ComplianceException {
        Set set = this.sbi.getBusinessRemotes();
        for (Class clazz : this.lbi) {
            if (!set.contains(clazz)) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().LOCAL_INTERFACE_CANNOT_REMOTE(clazz.getName()));
        }
    }

    public void checkBIMethodsMatchBeanMethods() throws ComplianceException {
        Method[] methodArray = this.sbi.getBeanClass().getMethods();
        HashSet<String> hashSet = new HashSet<String>(methodArray.length);
        for (Method method : methodArray) {
            hashSet.add(DDUtils.getMethodSignature(method));
        }
        for (Class clazz : this.lbi) {
            for (Method method : clazz.getMethods()) {
                String string = DDUtils.getMethodSignature(method);
                if (hashSet.contains(string)) continue;
                for (Method method2 : methodArray) {
                    if (!MethodUtils.potentialBridgeCandidate(method, method2)) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().EJB_MAY_BE_MISSING_BRIDGE_METHOD(string, clazz.getName()));
                }
                throw new ComplianceException(EJBComplianceTextFormatter.getInstance().LOCAL_INTERFACE_NOT_FOUND_IN_BEAN(string, clazz.getName(), this.sbi.getBeanClass().toString()));
            }
        }
    }

    public void checkBIExtendsEJBLocalObject() throws ComplianceException {
        for (Class clazz : this.lbi) {
            if (!EJBLocalObject.class.isAssignableFrom(clazz)) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().LOCAL_INTERFACE_CANNOT_EXTEND_EJBLocalObject(clazz.toString()));
        }
    }

    public void checkBIHasMethods() throws ComplianceException {
        for (Class clazz : this.lbi) {
            if (clazz.getMethods().length != 0) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().BUSINESS_INTERFACE_WITHOUT_METHOD(clazz.getName()));
        }
    }
}

