/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.InterceptorHelper;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.AroundInvokeBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.utils.ErrorCollectionException;

public class BusinessMethodInterceptorChecker {
    private DeploymentInfo deploymentInfo;
    private EjbDescriptorBean ejbDescriptor;
    private EjbJarBean ejbJarBean;
    private InterceptorsBean interceptorsBean;
    private Collection beanInfos;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public BusinessMethodInterceptorChecker(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
        this.ejbDescriptor = this.deploymentInfo.getEjbDescriptorBean();
        this.ejbJarBean = this.ejbDescriptor.getEjbJarBean();
        this.interceptorsBean = this.ejbJarBean.getInterceptors();
        this.beanInfos = deploymentInfo.getBeanInfos();
    }

    public void checkOnlyOneAroundInvokeMethodperClass() throws ComplianceException {
        SessionBeanBean sessionBeanBean;
        BeanInfo beanInfo;
        int n;
        AroundInvokeBean[] aroundInvokeBeanArray = null;
        SessionBeanBean[] sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getSessions();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            sessionBeanBean = sessionBeanBeanArray[n];
            aroundInvokeBeanArray = sessionBeanBean.getAroundInvokes();
            this.validateNotTwoAroundInvokeInOneClass(aroundInvokeBeanArray);
        }
        sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getMessageDrivens();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            sessionBeanBean = (MessageDrivenBeanBean)sessionBeanBeanArray[n];
            aroundInvokeBeanArray = sessionBeanBean.getAroundInvokes();
            this.validateNotTwoAroundInvokeInOneClass(aroundInvokeBeanArray);
        }
        if (this.interceptorsBean != null) {
            InterceptorBean[] interceptorBeanArray = this.interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                aroundInvokeBeanArray = interceptorBeanArray[i].getAroundInvokes();
                this.validateNotTwoAroundInvokeInOneClass(aroundInvokeBeanArray);
            }
        }
    }

    public void checkAroundInvokeMethods() throws ErrorCollectionException, ComplianceException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Set set = this.getAllAroundInvokeMethods();
        Set set2 = InterceptorHelper.getAllBusinessMethods(this.beanInfos);
        for (Method method : set) {
            try {
                this.validateAroundInvokeMethod(method, set2);
            }
            catch (ErrorCollectionException errorCollectionException2) {
                errorCollectionException.add((Throwable)errorCollectionException2);
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateNotTwoAroundInvokeInOneClass(AroundInvokeBean[] aroundInvokeBeanArray) throws ComplianceException {
        if (aroundInvokeBeanArray != null && aroundInvokeBeanArray.length > 1) {
            for (int i = 0; i < aroundInvokeBeanArray.length; ++i) {
                String string = aroundInvokeBeanArray[i].getClassName();
                for (int j = i + 1; j < aroundInvokeBeanArray.length; ++j) {
                    if (!string.equals(aroundInvokeBeanArray[j].getClassName())) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().TWO_ARROUNDINVOKE_METHOD(string.toString()));
                }
            }
        }
    }

    private void validateAroundInvokeMethod(Method method, Set set) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = method.getModifiers();
        if (set.contains(method)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().ARROUNDINVOKE_METHOD_CANNOT_BUSINESS_METHOD(method.getName(), method.getDeclaringClass().getName())));
        }
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().ARROUNDINVOKE_METHOD_CANNOT_BE_FINAL(method.getName(), method.getDeclaringClass().getName())));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().ARROUNDINVOKE_METHOD_CANNOT_BE_STATIC(method.getName(), method.getDeclaringClass().getName())));
        }
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getExceptionTypes();
        if (!clazz.equals(Object.class)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().ARROUNDINVOKE_METHOD_IS_INVALID(method.getName(), method.getDeclaringClass().getName())));
        } else if (classArray == null || classArray.length == 0 || classArray.length > 1 || !classArray[0].equals(Exception.class)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().ARROUNDINVOKE_METHOD_IS_INVALID(method.getName(), method.getDeclaringClass().getName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private Set getAllAroundInvokeMethods() throws ComplianceException {
        Set set;
        Object object;
        BeanInfo beanInfo;
        int n;
        HashSet hashSet = new HashSet();
        Object var2_2 = null;
        SessionBeanBean[] sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getSessions();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            object = sessionBeanBeanArray[n];
            set = InterceptorHelper.getAroundInvokeMethodinBean(this.classLoader, object);
            hashSet.addAll(set);
        }
        sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getMessageDrivens();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            object = (MessageDrivenBeanBean)sessionBeanBeanArray[n];
            set = InterceptorHelper.getAroundInvokeMethodinBean(this.classLoader, (MessageDrivenBeanBean)object);
            hashSet.addAll(set);
        }
        if (this.interceptorsBean != null) {
            InterceptorBean[] interceptorBeanArray = this.interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                object = InterceptorHelper.getAroundInvokeMethodinInterceptor(this.classLoader, interceptorBeanArray[i]);
                hashSet.addAll(object);
            }
        }
        return hashSet;
    }
}

