/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBObject;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.utils.MethodUtils;

public final class BusinessRemoteInterfaceChecker
extends BaseComplianceChecker {
    private final Ejb3SessionBeanInfo sbi;
    private final Set rbi;
    private final DeploymentInfo di;

    public BusinessRemoteInterfaceChecker(Ejb3SessionBeanInfo ejb3SessionBeanInfo) {
        this.sbi = ejb3SessionBeanInfo;
        this.rbi = ejb3SessionBeanInfo.getBusinessRemotes();
        this.di = ejb3SessionBeanInfo.getDeploymentInfo();
    }

    public void checkRBIIsNotLBI() throws ComplianceException {
        Set set = this.sbi.getBusinessLocals();
        for (Class clazz : set) {
        }
        for (Class clazz : this.rbi) {
            if (!set.contains(clazz)) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOTE_INTERFACE_IS_LOCAL(clazz.toString()));
        }
    }

    public void checkBIMethodsMatchBeanMethods() throws ComplianceException {
        Method[] methodArray = this.sbi.getBeanClass().getMethods();
        HashSet<String> hashSet = new HashSet<String>(methodArray.length);
        for (Method method : methodArray) {
            hashSet.add(DDUtils.getMethodSignature(method));
        }
        for (Class clazz : this.rbi) {
            for (Method method : clazz.getMethods()) {
                String string = DDUtils.getMethodSignature(method);
                if (hashSet.contains(string)) continue;
                for (Method method2 : methodArray) {
                    if (!MethodUtils.potentialBridgeCandidate(method, method2)) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().EJB_MAY_BE_MISSING_BRIDGE_METHOD(string, clazz.getName()));
                }
                throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOTE_METHOD_NOT_FOUND_IN_BEAN(string, clazz.getName(), this.sbi.getBeanClass().toString()));
            }
        }
    }

    public void checkBIExtendsEJBObject() throws ComplianceException {
        for (Class clazz : this.rbi) {
            if (!EJBObject.class.isAssignableFrom(clazz)) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOTE_INTERFACE_EXTEND_EJBOBJECT(clazz.toString()));
        }
    }

    public void checkBIHasMethods() throws ComplianceException {
        for (Class clazz : this.rbi) {
            if (clazz.getMethods().length != 0) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOTE_BUSINESS_INTERFACE_NO_METHOD(clazz.getName()));
        }
    }

    public void checkBIMethodsThrowRemoteException() throws ComplianceException {
        for (Class clazz : this.rbi) {
            int n;
            Method[] methodArray;
            if (!Remote.class.isAssignableFrom(clazz)) {
                methodArray = clazz.getMethods();
                for (n = 0; n < methodArray.length; ++n) {
                    Class<?>[] classArray = methodArray[n].getExceptionTypes();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (RemoteException.class != classArray[i]) continue;
                        throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOTE_BUSINESS_INTERFACE_THROW_REMOTEEXCEPTION(methodArray[n].toString(), clazz.toString()));
                    }
                }
                continue;
            }
            methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                boolean bl = false;
                Class<?>[] classArray = methodArray[n].getExceptionTypes();
                if (classArray != null && classArray.length != 0) {
                    for (int i = 0; i < classArray.length; ++i) {
                        if (RemoteException.class != classArray[i]) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOTE_INTERFACE_NOT_THROW_REMOTEEXCEPTION(methodArray[n].toString(), clazz.toString()));
            }
        }
    }
}

