/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.HashSet;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

public final class CmpJarChecker
extends BaseComplianceChecker {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    private DeploymentInfo di;

    public CmpJarChecker(DeploymentInfo deploymentInfo) {
        this.di = deploymentInfo;
        if (debug) {
            Debug.assertion((deploymentInfo != null ? 1 : 0) != 0);
        }
    }

    public void checkCmpJar() throws ErrorCollectionException {
        PersistenceType persistenceType = null;
        boolean bl = true;
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (BeanInfo beanInfo : this.di.getBeanInfos()) {
            CMPInfo cMPInfo;
            EntityBeanInfo entityBeanInfo;
            if (!(beanInfo instanceof EntityBeanInfo) || (entityBeanInfo = (EntityBeanInfo)beanInfo).getIsBeanManagedPersistence() || !(cMPInfo = entityBeanInfo.getCMPInfo()).uses20CMP()) continue;
            PersistenceType persistenceType2 = cMPInfo.getPersistenceType();
            if (bl) {
                persistenceType = persistenceType2;
                bl = false;
                continue;
            }
            if (persistenceType != persistenceType2) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NOT_ALL_BEANS_USE_SAME_PERSISTENCE(entityBeanInfo.getEJBName()), new DescriptorErrorInfo("<persistence-type>", (Object)entityBeanInfo.getEJBName(), (Object)persistenceType2)));
            }
            if (errorCollectionException.isEmpty()) continue;
            throw errorCollectionException;
        }
    }

    public void checkUniqueAbstractSchemaNames() throws ErrorCollectionException {
        HashSet<String> hashSet = new HashSet<String>();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (BeanInfo beanInfo : this.di.getBeanInfos()) {
            CMPInfo cMPInfo;
            EntityBeanInfo entityBeanInfo;
            if (!(beanInfo instanceof EntityBeanInfo) || (entityBeanInfo = (EntityBeanInfo)beanInfo).getIsBeanManagedPersistence() || !(cMPInfo = entityBeanInfo.getCMPInfo()).uses20CMP() || cMPInfo.getAbstractSchemaName() == null || cMPInfo.getAbstractSchemaName().equals("")) continue;
            if (hashSet.contains(cMPInfo.getAbstractSchemaName())) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ABSTRACT_SCHEMA_NAME_NOT_UNIQUE(entityBeanInfo.getEJBName()), new DescriptorErrorInfo("<abstract-schema-name>", (Object)entityBeanInfo.getEJBName(), (Object)cMPInfo.getAbstractSchemaName())));
            }
            hashSet.add(cMPInfo.getAbstractSchemaName());
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }
}

