/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.Map;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import weblogic.ejb.container.compliance.ExceptionTypeMismatchException;
import weblogic.ejb.container.interfaces.BeanInfo;

final class ComplianceUtils {
    private static final boolean debug = false;

    ComplianceUtils() {
    }

    static boolean methodThrowsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static boolean methodThrowsException_correct(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static boolean checkApplicationException(Class clazz, Class clazz2) {
        boolean bl = true;
        if (!clazz2.isAssignableFrom(clazz) && !Exception.class.isAssignableFrom(clazz)) {
            bl = false;
        }
        return bl;
    }

    static boolean methodThrowsExceptionAssignableFrom(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!clazz.isAssignableFrom(classArray[i])) continue;
            return true;
        }
        return false;
    }

    static boolean methodThrowsExactlyException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].equals(clazz)) continue;
            return true;
        }
        return false;
    }

    static boolean localExposeThroughRemote(Method method) {
        Class<?> clazz = method.getReturnType();
        if (EJBLocalObject.class.isAssignableFrom(clazz) || EJBLocalHome.class.isAssignableFrom(clazz)) {
            return true;
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!EJBLocalObject.class.isAssignableFrom(classArray[i]) && !EJBLocalHome.class.isAssignableFrom(classArray[i])) continue;
            return true;
        }
        return false;
    }

    static boolean methodTakesNoArgs(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        return classArray.length == 0;
    }

    static boolean returnTypesMatch(Method method, Method method2) {
        Class<?> clazz = method.getReturnType();
        Class<?> clazz2 = method2.getReturnType();
        return clazz.equals(clazz2);
    }

    static void exceptionTypesMatch(Method method, Method method2) throws ExceptionTypeMismatchException {
        Class<?>[] classArray = method2.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (RuntimeException.class.isAssignableFrom(clazz) || ComplianceUtils.methodThrowsException(method, clazz)) continue;
            throw new ExceptionTypeMismatchException(method2, clazz);
        }
    }

    static boolean classHasPublicNoArgCtor(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            int n;
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 0 || !Modifier.isPublic(n = constructorArray[i].getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegalRMIIIOPType(Class clazz) {
        boolean bl = true;
        return bl;
    }

    static boolean isApplicationException(Class clazz) {
        return false;
    }

    static boolean isApplicationException(BeanInfo beanInfo, Method method, Class clazz) {
        if (RemoteException.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (beanInfo.isEJB30()) {
            if (Error.class.isAssignableFrom(clazz)) {
                return false;
            }
            if (!RuntimeException.class.isAssignableFrom(clazz)) {
                return true;
            }
            Map map = beanInfo.getDeploymentInfo().getApplicationExceptions();
            while (!clazz.equals(Object.class)) {
                String string = clazz.getName();
                if (map.containsKey(string)) {
                    return true;
                }
                clazz = clazz.getSuperclass();
            }
        } else {
            if (RuntimeException.class.isAssignableFrom(clazz)) {
                return false;
            }
            Class<?>[] classArray = method.getExceptionTypes();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }
}

