/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.ContainerTransactionBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.MethodBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.logging.Loggable;

public final class ContainerTransactionChecker
extends BaseComplianceChecker {
    private DeploymentInfo di;
    private Set ejbNamesWithValidatedCTs = new HashSet();

    public ContainerTransactionChecker(DeploymentInfo deploymentInfo) {
        this.di = deploymentInfo;
    }

    public void checkContainerTransaction() {
        EjbDescriptorBean ejbDescriptorBean = this.di.getEjbDescriptorBean();
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor();
        if (null != assemblyDescriptorBean) {
            ContainerTransactionBean[] containerTransactionBeanArray = assemblyDescriptorBean.getContainerTransactions();
            for (int i = 0; i < containerTransactionBeanArray.length; ++i) {
                MethodBean[] methodBeanArray = containerTransactionBeanArray[i].getMethods();
                for (int j = 0; j < methodBeanArray.length; ++j) {
                    this.validateContainerTransaction(ejbJarBean, methodBeanArray[j].getEjbName());
                }
            }
        }
    }

    private void validateContainerTransaction(EjbJarBean ejbJarBean, String string) {
        Loggable loggable;
        if (this.ejbNamesWithValidatedCTs.contains(string)) {
            return;
        }
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            if (!sessionBeanBeanArray[i].getEjbName().equals(string) || !sessionBeanBeanArray[i].getTransactionType().equals("Bean")) continue;
            loggable = EJBLogger.logContainerTransactionSetForBeanManagedEJBLoggable((String)string);
            loggable.log();
        }
        if (enterpriseBeansBean instanceof EnterpriseBeansBean) {
            EnterpriseBeansBean enterpriseBeansBean2 = enterpriseBeansBean;
            loggable = enterpriseBeansBean2.getMessageDrivens();
            for (int i = 0; i < ((MessageDrivenBeanBean[])loggable).length; ++i) {
                if (!loggable[i].getEjbName().equals(string) || !loggable[i].getTransactionType().equals("Bean")) continue;
                Loggable loggable2 = EJBLogger.logContainerTransactionSetForBeanManagedEJBLoggable((String)string);
                loggable2.log();
            }
        }
        this.ejbNamesWithValidatedCTs.add(string);
    }
}

