/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EntityBeanClassChecker;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

final class EJB11EntityBeanClassChecker
extends EntityBeanClassChecker {
    EJB11EntityBeanClassChecker(ClientDrivenBeanInfo clientDrivenBeanInfo) throws ClassNotFoundException {
        super(clientDrivenBeanInfo);
    }

    public void checkCreatesMatchPostCreates() throws ErrorCollectionException {
        super.doCheckCreatesMatchPostCreates("9.1.5.1");
    }

    public void checkBeanClassImplementsEntityBean() throws ComplianceException {
        super.doCheckBeanClassImplementsEntityBean("9.2.2");
    }

    protected void validateCreateReturnType(Method method) throws ComplianceException {
        super.validateCreateReturnType(method, "9.2.3");
    }

    public void checkPostCreates() throws ErrorCollectionException {
        super.doCheckPostCreates("9.2.4");
    }

    public void checkCMPBeanDoesntDefineFinders() throws ErrorCollectionException {
        super.doCheckCMPBeanDoesntDefineFinders("9.4.6", false);
    }

    public void checkBeanClassIsNotAbstract() throws ComplianceException {
        if (Modifier.isAbstract(this.beanClassMod)) {
            throw new ComplianceException(this.fmt.ABSTRACT_BEAN_CLASS(this.ejbName));
        }
    }

    public void checkIsModifiedMethod() throws ComplianceException {
        String string = this.ebi.getIsModifiedMethodName();
        if (string != null) {
            Method method = null;
            try {
                method = this.beanClass.getMethod(string, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ComplianceException(this.fmt.ISMODIFIED_NOT_EXIST(this.ejbName, string));
            }
            if (!Boolean.TYPE.isAssignableFrom(method.getReturnType())) {
                throw new ComplianceException(this.fmt.ISMODIFIED_RETURNS_BOOL(this.ejbName, this.methodSig(method)));
            }
        }
    }

    public void checkCMPFields() throws ComplianceException {
        if (!this.isBMP) {
            Field field;
            String string2;
            Class clazz = this.ebi.getBeanClass();
            Debug.assertion((clazz != null ? 1 : 0) != 0, (String)"Could not find bean class in ComplianceChecker.");
            CMPInfo cMPInfo = this.ebi.getCMPInfo();
            Collection collection = cMPInfo.getAllContainerManagedFieldNames();
            for (String string2 : collection) {
                field = null;
                try {
                    field = clazz.getField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new ComplianceException(this.fmt.CMP_FIELDS_MUST_BE_BEAN_FIELDS(this.ejbName, string2));
                }
                int n = field.getModifiers();
                if (!Modifier.isPublic(n)) {
                    throw new ComplianceException(this.fmt.CMP_FIELDS_MUST_BE_PUBLIC(this.ejbName, field.getName()));
                }
                if (!Modifier.isStatic(n)) continue;
                throw new ComplianceException(this.fmt.CMP_FIELDS_MUST_NOT_BE_STATIC(this.ejbName, field.getName()));
            }
            string2 = cMPInfo.getCMPrimaryKeyFieldName();
            if (string2 == null) {
                this.doCheckPrimaryKeyClassFieldsAreCMPFields("9.4.7.2");
            } else {
                this.doCheckPrimkeyFieldIsCMPField("9.4.7.1");
                field = null;
                try {
                    field = clazz.getField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new ComplianceException(this.fmt.PK_FIELD_MUST_EXIST(this.ejbName, string2), new DescriptorErrorInfo("<primkey-field>", (Object)this.ejbName, (Object)string2));
                }
                Class<?> clazz2 = field.getType();
                if (!clazz2.getName().equals(this.pkClass.getName())) {
                    throw new ComplianceException(this.fmt.PK_FIELD_WRONG_TYPE(this.ejbName, string2, clazz2.getName()), new DescriptorErrorInfo("<primkey-field>", (Object)this.ejbName, (Object)clazz2.getName()));
                }
            }
        }
    }

    public void checkCMP11UsingOptimisticConcurrency() throws ComplianceException {
        if (this.ebi.getConcurrencyStrategy() == 6) {
            throw new ComplianceException(this.fmt.CMP11_CANNOT_USE_OPTIMISTIC_CONCURRENCY(this.ejbName));
        }
    }
}

