/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EntityBeanClassChecker;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.persistence.PersistenceUtils;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.ErrorCollectionException;

final class EJB20EntityBeanClassChecker
extends EntityBeanClassChecker {
    private Map methodMap = PersistenceUtils.getAccessorMethodMap(this.beanClass);

    EJB20EntityBeanClassChecker(ClientDrivenBeanInfo clientDrivenBeanInfo) throws ClassNotFoundException {
        super(clientDrivenBeanInfo);
    }

    private Object[] getEjbSelectMethods() {
        Method[] methodArray = this.beanClass.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            String string = methodArray[i].getName();
            if (!string.startsWith("ejbSelect") || !Modifier.isAbstract(n = methodArray[i].getModifiers()) || !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList.toArray();
    }

    public void checkCreatesMatchPostCreates() throws ErrorCollectionException {
        super.doCheckCreatesMatchPostCreates("9.6.2");
    }

    public void checkBeanClassImplementsEntityBean() throws ComplianceException {
        if (this.ebi.isEJB30()) {
            return;
        }
        super.doCheckBeanClassImplementsEntityBean("9.7.2");
    }

    protected void validateCreateReturnType(Method method) throws ComplianceException {
        super.validateCreateReturnType(method, "9.7.5");
    }

    public void checkPostCreates() throws ErrorCollectionException {
        super.doCheckPostCreates("9.7.6");
    }

    public void checkCMPBeanDoesntDefineFinders() throws ErrorCollectionException {
        super.doCheckCMPBeanDoesntDefineFinders("9.7.2", true);
    }

    public void checkIsModifiedMethod() throws ComplianceException {
        String string;
        if (this.isBMP && (string = this.ebi.getIsModifiedMethodName()) != null) {
            Method method = null;
            try {
                method = this.beanClass.getMethod(string, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ComplianceException(this.fmt.ISMODIFIED_NOT_EXIST(this.ejbName, string));
            }
            if (!Boolean.TYPE.isAssignableFrom(method.getReturnType())) {
                throw new ComplianceException(this.fmt.ISMODIFIED_RETURNS_BOOL(this.ejbName, this.methodSig(method)));
            }
        }
    }

    public void checkCMPFields() throws ComplianceException {
        if (this.ebi.isEJB30()) {
            return;
        }
        if (!this.isBMP) {
            Class clazz = null;
            clazz = this.ebi.getBeanClass();
            CMPInfo cMPInfo = this.ebi.getCMPInfo();
            Collection collection = cMPInfo.getAllContainerManagedFieldNames();
            for (String string : collection) {
                if (Character.isUpperCase(string.charAt(0)) || !Character.isLetter(string.charAt(0))) {
                    throw new ComplianceException(this.fmt.CM_FIELD_MUST_START_WITH_LOWERCASE(this.ejbName, string), new DescriptorErrorInfo("<cmp-field>", (Object)this.ejbName, (Object)string));
                }
                String string2 = RDBMSUtils.getterMethodName(string);
                if (!this.methodMap.containsKey(string2)) {
                    throw new ComplianceException(this.fmt.DEFINE_CMP_ACCESSOR_METHOD_20(this.ejbName, string2));
                }
                String string3 = RDBMSUtils.setterMethodName(string);
                if (!this.methodMap.containsKey(string3)) {
                    throw new ComplianceException(this.fmt.DEFINE_CMP_ACCESSOR_METHOD_20(this.ejbName, string3));
                }
                Method method = (Method)this.methodMap.get(string3);
                Class<?> clazz2 = method.getReturnType();
                if (!clazz2.getName().equals("void")) {
                    throw new ComplianceException(this.fmt.SETTER_DOES_NOT_RETURN_VOID(this.ejbName));
                }
                int n = method.getModifiers();
                if (!Modifier.isPublic(n)) {
                    throw new ComplianceException(this.fmt.CMP_ACCESSOR_NOT_PUBLIC(this.ejbName, string3));
                }
                Method method2 = (Method)this.methodMap.get(string2);
                Class<?> clazz3 = method2.getReturnType();
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new ComplianceException(this.fmt.SETTER_DOES_NOT_HAVE_SINGLE_PARAM(this.ejbName, string3));
                }
                if (!clazz3.equals(classArray[0])) {
                    throw new ComplianceException(this.fmt.SETTER_PARAM_DOES_NOT_MATCH_GETTER_RETURN(this.ejbName, string3));
                }
                n = method2.getModifiers();
                if (!Modifier.isPublic(n)) {
                    throw new ComplianceException(this.fmt.CMP_ACCESSOR_NOT_PUBLIC(this.ejbName, string3));
                }
                boolean bl = true;
                try {
                    Field field = clazz.getField(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    bl = false;
                }
                if (!bl) continue;
                throw new ComplianceException(this.fmt.DO_NOT_DEFINE_CMFIELD_20(this.ejbName));
            }
        }
    }

    public void checkBeanClassIsNotAbstract() throws ComplianceException {
        if (this.isBMP && Modifier.isAbstract(this.beanClassMod)) {
            throw new ComplianceException(this.fmt.ABSTRACT_BEAN_CLASS(this.ejbName));
        }
    }

    public void checkEjbSelectReturnType() throws ComplianceException {
        if (!this.isBMP) {
            Object[] objectArray = this.getEjbSelectMethods();
            for (int i = 0; i < objectArray.length; ++i) {
                Class<?> clazz = ((Method)objectArray[i]).getReturnType();
                if (!clazz.getName().equals("java.util.Enumeration")) continue;
                throw new ComplianceException(this.fmt.EJB_SELECT_CANNOT_RETURN_ENUMERATION(this.ejbName, ((Method)objectArray[i]).getName()));
            }
        }
    }

    public void checkEjbSelectThrowsClause() throws ComplianceException {
        if (!this.isBMP) {
            Object[] objectArray = this.getEjbSelectMethods();
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl = false;
                Class<?>[] classArray = ((Method)objectArray[i]).getExceptionTypes();
                for (int j = 0; j < classArray.length; ++j) {
                    if (!classArray[j].equals(FinderException.class)) continue;
                    bl = true;
                }
                if (bl) continue;
                throw new ComplianceException(this.fmt.EJB_SELECT_MUST_THROW(this.ejbName, ((Method)objectArray[i]).getName()));
            }
        }
    }

    public void checkPrimaryKeyFieldClass() throws ComplianceException {
        CMPInfo cMPInfo;
        String string;
        if (!this.isBMP && (string = (cMPInfo = this.ebi.getCMPInfo()).getCMPrimaryKeyFieldName()) != null && string.length() > 0) {
            Class<?>[] classArray;
            Object object;
            Class clazz = this.ebi.getPrimaryKeyClass();
            String string2 = clazz.getName();
            String string3 = RDBMSUtils.getterMethodName(string);
            Method method = (Method)this.methodMap.get(string3);
            if (method != null && (object = method.getReturnType()) != null && !object.equals(clazz)) {
                throw new ComplianceException(this.fmt.PRIMKEY_CLASS_DOES_NOT_MATCH_ACCESSOR_FOR_GETTER(this.ejbName, string, string2), new DescriptorErrorInfo("<prim-key-class>", (Object)this.ejbName, (Object)string2));
            }
            object = RDBMSUtils.setterMethodName(string);
            Method method2 = (Method)this.methodMap.get(object);
            if (method2 != null && (classArray = method2.getParameterTypes()) != null && classArray.length > 0 && classArray[0] != null && !classArray[0].equals(clazz)) {
                throw new ComplianceException(this.fmt.PRIMKEY_CLASS_DOES_NOT_MATCH_ACCESSOR_FOR_SETTER(this.ejbName, string, string2), new DescriptorErrorInfo("<prim-key-class>", (Object)this.ejbName, (Object)string2));
            }
        }
    }

    public void checkBeanAndPKClassDeclareSamePKFieldType() throws ErrorCollectionException {
        boolean bl;
        if (this.isBMP) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        boolean bl2 = bl = this.ebi.getCMPInfo().getCMPrimaryKeyFieldName() == null;
        if (bl) {
            Field[] fieldArray = this.ebi.getPrimaryKeyClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Class<?>[] classArray;
                Method method;
                Object object;
                Field field = fieldArray[i];
                if (field.getName().equals("serialVersionUID")) continue;
                String string = RDBMSUtils.getterMethodName(field.getName());
                Method method2 = (Method)this.methodMap.get(string);
                if (method2 != null && (object = method2.getReturnType()) != null && !object.equals(field.getType())) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BEAN_PK_CLASS_DOES_NOT_MATCH_PKFIELD_FOR_GETTER(this.ejbName, field.getName(), ((Class)object).getName(), field.getType().getName())));
                }
                if ((method = (Method)this.methodMap.get(object = RDBMSUtils.setterMethodName(field.getName()))) == null || (classArray = method.getParameterTypes()) == null || classArray[0] == null || classArray[0].equals(field.getType())) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BEAN_PK_CLASS_DOES_NOT_MATCH_PKFIELD_FOR_SETTER(this.ejbName, field.getName(), classArray[0].getName(), field.getType().getName())));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkPrimaryKeyFieldIsCMPField() throws ComplianceException {
        super.doCheckPrimkeyFieldIsCMPField("9.10.1.1");
    }

    public void checkPrimaryKeyClassFieldsAreCMPFields() throws ComplianceException {
        super.doCheckPrimaryKeyClassFieldsAreCMPFields("9.10.1.2");
    }

    public void checkAbstractBeanClassImplementsEntityBean() throws ErrorCollectionException {
        if (this.ebi.isEJB30()) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = EntityBean.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            try {
                Method method2 = this.beanClass.getMethod(method.getName(), method.getParameterTypes());
                if (!Modifier.isAbstract(method2.getModifiers())) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MISSING_ENTITY_BEAN_METHOD(this.ejbName, this.methodSig(method))));
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MISSING_ENTITY_BEAN_METHOD(this.ejbName, this.methodSig(method))));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkBMPUsingOptimisticConcurrency() throws ComplianceException {
        if (this.isBMP && this.ebi.getConcurrencyStrategy() == 6) {
            throw new ComplianceException(this.fmt.BMP_CANNOT_USE_OPTIMISTIC_CONCURRENCY(this.ejbName));
        }
    }

    public void checkOptimisticReadTimeoutSecondsNoCacheBetweenTransactions() {
        if (this.ebi.getConcurrencyStrategy() == 6 && this.ebi.getCachingDescriptor().getReadTimeoutSeconds() > 0 && !this.ebi.getCacheBetweenTransactions()) {
            log.logWarning(this.fmt.OptimisticWithReadTimeoutSecondsNoCacheBetweenTx(this.ejbName));
        }
    }
}

