/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.jar.JarFile;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.xml.stream.XMLStreamException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.BusinessLocalInterfaceChecker;
import weblogic.ejb.container.compliance.BusinessRemoteInterfaceChecker;
import weblogic.ejb.container.compliance.ClientJarChecker;
import weblogic.ejb.container.compliance.CmpJarChecker;
import weblogic.ejb.container.compliance.ComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceCheckerFactory;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ContainerTransactionChecker;
import weblogic.ejb.container.compliance.DependentChecker;
import weblogic.ejb.container.compliance.EJB11EntityBeanClassChecker;
import weblogic.ejb.container.compliance.EJB20EntityBeanClassChecker;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.EJBObjectClassChecker;
import weblogic.ejb.container.compliance.EntityHomeInterfaceChecker;
import weblogic.ejb.container.compliance.EnvironmentValuesChecker;
import weblogic.ejb.container.compliance.GlobalRelationsChecker;
import weblogic.ejb.container.compliance.MessageDrivenBeanClassChecker;
import weblogic.ejb.container.compliance.PKClassChecker;
import weblogic.ejb.container.compliance.RelationChecker;
import weblogic.ejb.container.compliance.SecurityRoleChecker;
import weblogic.ejb.container.compliance.SessionBeanClassChecker;
import weblogic.ejb.container.compliance.SessionHomeInterfaceChecker;
import weblogic.ejb.container.compliance.WeblogicJarChecker;
import weblogic.ejb.container.deployer.DeploymentDescriptorException;
import weblogic.ejb.container.deployer.MBeanDeploymentInfoImpl;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
import weblogic.utils.AssertionError;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public final class EJBComplianceChecker
extends BaseComplianceChecker
implements ComplianceChecker,
PlatformConstants {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    public static final boolean isNeedCheck = Boolean.getBoolean("ignoreEJBChecker");

    EJBComplianceChecker() {
    }

    private Object[] getDeploymentInfoCheckers(DeploymentInfo deploymentInfo) {
        return new Object[]{new CmpJarChecker(deploymentInfo), new WeblogicJarChecker(deploymentInfo), new ClientJarChecker(deploymentInfo), new SecurityRoleChecker(deploymentInfo), new EnvironmentValuesChecker(deploymentInfo), new ContainerTransactionChecker(deploymentInfo)};
    }

    private Object[] getInterceptorCheckers(DeploymentInfo deploymentInfo) {
        Object obj;
        try {
            Class<?> clazz = Class.forName("weblogic.ejb.container.compliance.InterceptorChecker");
            Constructor<?> constructor = clazz.getConstructor(DeploymentInfo.class);
            obj = constructor.newInstance(deploymentInfo);
        }
        catch (Exception exception) {
            throw new AssertionError("Couldn't load InterceptorChecker: " + exception);
        }
        return new Object[]{obj};
    }

    private Object[] getGlobalRelationsCheckers(DeploymentInfo deploymentInfo) throws ClassNotFoundException {
        return new Object[]{new GlobalRelationsChecker(deploymentInfo)};
    }

    private Object[] getRelationCheckers(EjbRelation ejbRelation, DeploymentInfo deploymentInfo) throws ClassNotFoundException {
        return new Object[]{new RelationChecker(ejbRelation, deploymentInfo)};
    }

    private Object[] getDependentCheckers(DeploymentInfo deploymentInfo) throws ClassNotFoundException {
        return new Object[]{new DependentChecker(deploymentInfo)};
    }

    private Object[] getEjb30SessionCheckers(BeanInfo beanInfo) throws ClassNotFoundException {
        return this.getSessionCheckers(beanInfo);
    }

    private Object[] getEjb30MessageDrivenCheckers(BeanInfo beanInfo) throws ClassNotFoundException {
        Object obj;
        try {
            Class<?> clazz = Class.forName("weblogic.ejb.container.compliance.Ejb30MessageDrivenBeanClassChecker");
            Constructor<?> constructor = clazz.getConstructor(BeanInfo.class);
            obj = constructor.newInstance(beanInfo);
        }
        catch (Exception exception) {
            throw new AssertionError("Couldn't load Ejb30MessageDrivenBeanClassChecker: " + exception);
        }
        return new Object[]{obj};
    }

    private Object[] getSessionCheckers(BeanInfo beanInfo) throws ClassNotFoundException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo;
        ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (clientDrivenBeanInfo instanceof Ejb3SessionBeanInfo) {
            try {
                Class<?> clazz = Class.forName("weblogic.ejb.container.compliance.Ejb30SessionBeanClassChecker");
                Constructor<?> constructor = clazz.getConstructor(ClientDrivenBeanInfo.class);
                ejb3SessionBeanInfo = constructor.newInstance(clientDrivenBeanInfo);
            }
            catch (Exception exception) {
                throw new AssertionError("Couldn't load Ejb30SessionBeanClassChecker: " + exception);
            }
            arrayList.add(ejb3SessionBeanInfo);
        } else {
            arrayList.add(new SessionBeanClassChecker(clientDrivenBeanInfo));
        }
        if (clientDrivenBeanInfo.hasDeclaredRemoteHome()) {
            arrayList.add(new SessionHomeInterfaceChecker(clientDrivenBeanInfo.getHomeInterfaceClass(), clientDrivenBeanInfo.getRemoteInterfaceClass(), clientDrivenBeanInfo.getBeanClass(), clientDrivenBeanInfo, EJBHome.class));
            arrayList.add(new EJBObjectClassChecker(clientDrivenBeanInfo.getRemoteInterfaceClass(), clientDrivenBeanInfo, EJBObject.class));
        }
        if (clientDrivenBeanInfo.hasDeclaredLocalHome()) {
            arrayList.add(new SessionHomeInterfaceChecker(clientDrivenBeanInfo.getLocalHomeInterfaceClass(), clientDrivenBeanInfo.getLocalInterfaceClass(), clientDrivenBeanInfo.getBeanClass(), clientDrivenBeanInfo, EJBLocalHome.class));
            arrayList.add(new EJBObjectClassChecker(clientDrivenBeanInfo.getLocalInterfaceClass(), clientDrivenBeanInfo, EJBLocalObject.class));
        }
        if (clientDrivenBeanInfo instanceof Ejb3SessionBeanInfo) {
            ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)clientDrivenBeanInfo;
            if (ejb3SessionBeanInfo.hasBusinessRemotes()) {
                arrayList.add(new BusinessRemoteInterfaceChecker(ejb3SessionBeanInfo));
            }
            if (ejb3SessionBeanInfo.hasBusinessLocals()) {
                arrayList.add(new BusinessLocalInterfaceChecker(ejb3SessionBeanInfo));
            }
        }
        return arrayList.toArray();
    }

    private Object[] getMessageDrivenCheckers(BeanInfo beanInfo) throws ClassNotFoundException {
        return new Object[]{new MessageDrivenBeanClassChecker(beanInfo)};
    }

    private Object[] getEntityCheckers(BeanInfo beanInfo) throws ClassNotFoundException {
        ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
        ArrayList<BaseComplianceChecker> arrayList = new ArrayList<BaseComplianceChecker>();
        if (clientDrivenBeanInfo.hasRemoteClientView()) {
            arrayList.add(new EntityHomeInterfaceChecker(clientDrivenBeanInfo.getHomeInterfaceClass(), clientDrivenBeanInfo.getRemoteInterfaceClass(), clientDrivenBeanInfo.getBeanClass(), clientDrivenBeanInfo, EJBHome.class));
            arrayList.add(new EJBObjectClassChecker(clientDrivenBeanInfo.getRemoteInterfaceClass(), clientDrivenBeanInfo, EJBObject.class));
        }
        if (clientDrivenBeanInfo.hasLocalClientView()) {
            arrayList.add(new EntityHomeInterfaceChecker(clientDrivenBeanInfo.getLocalHomeInterfaceClass(), clientDrivenBeanInfo.getLocalInterfaceClass(), clientDrivenBeanInfo.getBeanClass(), clientDrivenBeanInfo, EJBLocalHome.class));
            arrayList.add(new EJBObjectClassChecker(clientDrivenBeanInfo.getLocalInterfaceClass(), clientDrivenBeanInfo, EJBLocalObject.class));
        }
        arrayList.add(new PKClassChecker((EntityBeanInfo)beanInfo));
        if (entityBeanInfo.getIsBeanManagedPersistence() || entityBeanInfo.getCMPInfo().uses20CMP()) {
            arrayList.add(new EJB20EntityBeanClassChecker(entityBeanInfo));
        } else {
            arrayList.add(new EJB11EntityBeanClassChecker(entityBeanInfo));
        }
        return arrayList.toArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkDeploymentInfo(DeploymentInfo deploymentInfo) throws ErrorCollectionException, ClassNotFoundException {
        Object object2;
        if (isNeedCheck) {
            return;
        }
        Object[] objectArray = this.getDeploymentInfoCheckers(deploymentInfo);
        this.check(objectArray);
        Collection collection = deploymentInfo.getBeanInfos();
        for (Object object2 : collection) {
            if (deploymentInfo.getEjbDescriptorBean().isEjb30()) {
                if (object2 instanceof SessionBeanInfo) {
                    objectArray = this.getEjb30SessionCheckers((BeanInfo)object2);
                } else if (object2 instanceof EntityBeanInfo) {
                    objectArray = this.getEntityCheckers((BeanInfo)object2);
                } else {
                    if (!(object2 instanceof MessageDrivenBeanInfo)) throw new AssertionError("Unexpected BeanInfo type: " + object2);
                    objectArray = this.getEjb30MessageDrivenCheckers((BeanInfo)object2);
                }
            } else if (object2 instanceof SessionBeanInfo) {
                objectArray = this.getSessionCheckers((BeanInfo)object2);
            } else if (object2 instanceof EntityBeanInfo) {
                objectArray = this.getEntityCheckers((BeanInfo)object2);
            } else {
                if (!(object2 instanceof MessageDrivenBeanInfo)) throw new AssertionError("Unexpected BeanInfo type: " + object2);
                objectArray = this.getMessageDrivenCheckers((BeanInfo)object2);
            }
            this.check(objectArray);
        }
        if (deploymentInfo.getEjbDescriptorBean().isEjb30()) {
            objectArray = this.getInterceptorCheckers(deploymentInfo);
            this.check(objectArray);
        }
        if ((object2 = deploymentInfo.getRelationships()) != null) {
            objectArray = this.getGlobalRelationsCheckers(deploymentInfo);
            this.check(objectArray);
            for (EjbRelation ejbRelation : object2.getAllEjbRelations().values()) {
                objectArray = this.getRelationCheckers(ejbRelation, deploymentInfo);
                this.check(objectArray);
            }
        }
        if (deploymentInfo.getDependents() == null) return;
        objectArray = this.getDependentCheckers(deploymentInfo);
        this.check(objectArray);
    }

    private void check(Object[] objectArray) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Method[] methodArray = object.getClass().getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                if (!methodArray[j].getName().startsWith("check")) continue;
                try {
                    methodArray[j].invoke(object, (Object[])null);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof NoClassDefFoundError) {
                        throwable = new NoClassDefFoundError("Class not found: " + throwable.getMessage());
                    }
                    errorCollectionException.add(throwable);
                }
            }
            if (errorCollectionException.isEmpty()) continue;
            throw errorCollectionException;
        }
    }

    private static boolean checkFile(File file) {
        EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
        if (!file.exists()) {
            System.err.println(eJBComplianceTextFormatter.jarFileMissing(file.getAbsolutePath()));
            return false;
        }
        if (file.isDirectory()) {
            System.err.println(eJBComplianceTextFormatter.jarFileIsDirectory(file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static void complianceCheckEJB(DeploymentInfo deploymentInfo, ClassLoader classLoader) throws ErrorCollectionException {
        try {
            ComplianceChecker complianceChecker = ComplianceCheckerFactory.getComplianceChecker();
            complianceChecker.checkDeploymentInfo(deploymentInfo);
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw errorCollectionException;
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
    }

    private static void initParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void complianceCheckEJBJar(File file) throws IOException, XMLParsingException, XMLProcessingException, ErrorCollectionException {
        ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(file.getPath());
        GenericClassLoader genericClassLoader = new GenericClassLoader((ClassFinder)classpathClassFinder2);
        try {
            block16: {
                JarFile jarFile = new JarFile(file);
                EjbDescriptorBean ejbDescriptorBean = EjbDescriptorFactory.createDescriptorFromJarFile(jarFile);
                MBeanDeploymentInfoImpl mBeanDeploymentInfoImpl = new MBeanDeploymentInfoImpl(ejbDescriptorBean, genericClassLoader, "", "", VirtualJarFactory.createVirtualJar((File)file), null);
                EJBComplianceChecker.complianceCheckEJB(mBeanDeploymentInfoImpl, (ClassLoader)genericClassLoader);
                classpathClassFinder2.close();
                Object var7_10 = null;
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
                break block16;
                {
                    catch (ClassNotFoundException classNotFoundException) {
                        EJBLogger.logStackTrace((Throwable)classNotFoundException);
                        Object var7_11 = null;
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                        break block16;
                    }
                    catch (DeploymentDescriptorException deploymentDescriptorException) {
                        EJBLogger.logStackTrace((Throwable)((Object)deploymentDescriptorException));
                        Object var7_12 = null;
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                        break block16;
                    }
                    catch (WLDeploymentException wLDeploymentException) {
                        EJBLogger.logStackTrace((Throwable)wLDeploymentException);
                        Object var7_13 = null;
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                        break block16;
                    }
                    catch (XMLStreamException xMLStreamException) {
                        EJBLogger.logStackTrace((Throwable)xMLStreamException);
                        Object var7_14 = null;
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Object var10_23 = null;
        }
        catch (Throwable throwable) {
            Object var10_24 = null;
            genericClassLoader.close();
            throw throwable;
        }
        genericClassLoader.close();
    }

    public static void checkJar(File file) throws IOException, XMLParsingException, XMLProcessingException, ErrorCollectionException {
        EJBComplianceChecker.initParser();
        EJBComplianceChecker.complianceCheckEJBJar(file);
    }

    public static void main(String[] stringArray) {
        EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
        EJBComplianceChecker.initParser();
        if (stringArray.length == 0) {
            Localizer localizer = L10nLookup.getLocalizer((Locale)Locale.getDefault(), (String)"weblogic.ejb.container.EJBComplianceTextLocalizer");
            System.err.println(localizer.get("usage"));
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            System.out.println(eJBComplianceTextFormatter.checkingJarFile(string));
            System.out.println("");
            File file = new File(string);
            if (!EJBComplianceChecker.checkFile(file)) continue;
            try {
                EJBComplianceChecker.complianceCheckEJBJar(file);
                System.out.println(eJBComplianceTextFormatter.compliant(string));
                System.out.println("");
                continue;
            }
            catch (IOException iOException) {
                System.err.println(eJBComplianceTextFormatter.notValid(file.getName(), iOException));
                continue;
            }
            catch (XMLParsingException xMLParsingException) {
                System.err.println(eJBComplianceTextFormatter.failedToParse(file.getName(), (Exception)((Object)xMLParsingException)));
                continue;
            }
            catch (XMLProcessingException xMLProcessingException) {
                System.err.println(eJBComplianceTextFormatter.failedToLoad(file.getName(), (Exception)((Object)xMLProcessingException)));
                continue;
            }
            catch (ErrorCollectionException errorCollectionException) {
                for (Throwable throwable : errorCollectionException.getExceptions()) {
                    if (throwable instanceof ComplianceException) {
                        System.err.println(eJBComplianceTextFormatter.complianceError(throwable.getMessage()));
                        continue;
                    }
                    if (throwable instanceof ClassNotFoundException) {
                        System.err.println(eJBComplianceTextFormatter.loadFailure(throwable.getMessage()));
                        continue;
                    }
                    System.err.println(eJBComplianceTextFormatter.complianceError(StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
                }
            }
        }
    }
}

