/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp.rdbms.RDBMSUtils;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.ExceptionTypeMismatchException;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceUtils;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.utils.ErrorCollectionException;

final class EJBObjectClassChecker
extends BaseComplianceChecker {
    private final Class eoClass;
    private final Class beanClass;
    private final Class ejbObjectInterface;
    private final String ejbName;
    private final boolean isEntityBean;
    private final List businessMethods;
    private CMPInfo cmpInfo;
    private boolean uses20CMP = false;
    private Relationships relationships;
    private Class remoteInterfaceClass;

    EJBObjectClassChecker(Class clazz, ClientDrivenBeanInfo clientDrivenBeanInfo, Class clazz2) throws ClassNotFoundException {
        this.eoClass = clazz;
        this.beanClass = clientDrivenBeanInfo.getBeanClass();
        this.isEntityBean = clientDrivenBeanInfo instanceof EntityBeanInfo;
        this.ejbName = clientDrivenBeanInfo.getEJBName();
        this.ejbObjectInterface = clazz2;
        this.businessMethods = this.getBusinessMethods();
        if (this.isEntityBean) {
            this.cmpInfo = ((EntityBeanInfo)clientDrivenBeanInfo).getCMPInfo();
            if (this.cmpInfo != null && this.cmpInfo.uses20CMP()) {
                this.uses20CMP = true;
                this.relationships = this.cmpInfo.getRelationships();
                if (this.checkingRemoteClientView()) {
                    try {
                        this.remoteInterfaceClass = clientDrivenBeanInfo.getRemoteInterfaceClass();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected boolean checkingRemoteClientView() {
        return this.ejbObjectInterface.equals(EJBObject.class);
    }

    private List getBusinessMethods() {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        Method[] methodArray = this.eoClass.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            try {
                this.ejbObjectInterface.getMethod(string, method.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string2 = method.getName();
                String string3 = DDUtils.getMethodSignature(method);
                Method method2 = (Method)hashMap.get(string3);
                if (method2 != null) {
                    Class<?> clazz;
                    Class<?> clazz2 = method2.getDeclaringClass();
                    if (clazz2.isAssignableFrom(clazz = method.getDeclaringClass())) {
                        try {
                            clazz2.getMethod(string2, method.getParameterTypes());
                            arrayList.remove(method2);
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {}
                    } else if (clazz.isAssignableFrom(clazz2)) {
                        try {
                            clazz2.getMethod(string2, method.getParameterTypes());
                            if (clazz2 == clazz) {
                                continue;
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            // empty catch block
                        }
                    }
                }
                if (string2.equals("<clinit>")) continue;
                arrayList.add(method);
                hashMap.put(string3, method);
            }
        }
        return arrayList;
    }

    public void checkEoExtendsEJBObject() throws ComplianceException {
        if (!this.ejbObjectInterface.isAssignableFrom(this.eoClass)) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.EO_IMPLEMENTS_EJBOBJECT(this.ejbName));
            }
            throw new ComplianceException(this.fmt.ELO_IMPLEMENTS_EJB_LOCAL_OBJECT(this.ejbName));
        }
    }

    public void checkMethodsThrowRemoteException() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : this.businessMethods) {
            boolean bl;
            if (this.checkingRemoteClientView()) {
                bl = ComplianceUtils.methodThrowsException(method, RemoteException.class);
                if (bl) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EO_THROWS_REMOTE_EXCEPTION(this.ejbName, this.methodSig(method))));
                continue;
            }
            bl = ComplianceUtils.methodThrowsExactlyException(method, RemoteException.class);
            if (!bl) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ELO_THROWS_REMOTE_EXCEPTION(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkApplicationExceptions() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : this.businessMethods) {
            Class<?>[] classArray = method.getExceptionTypes();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                boolean bl = false;
                bl = this.checkingRemoteClientView() ? ComplianceUtils.checkApplicationException(clazz, RemoteException.class) : ComplianceUtils.checkApplicationException(clazz, EJBException.class);
                if (bl) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.INVALID_APPLICATION_EXCEPTION(this.ejbName, this.methodSig(method), method.getDeclaringClass().getName(), clazz.getName())));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private List getMatchingBeanMethodsWithName(String string) {
        Method[] methodArray = this.beanClass.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = method.getName();
            if (!string2.equals(string)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public void checkInterfaceBusinessMethodsMatchBeanMethods() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : this.businessMethods) {
            Object object;
            String string = method.getName();
            Method method2 = null;
            try {
                boolean bl = true;
                boolean bl2 = false;
                object = this.getMatchingBeanMethodsWithName(method.getName());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Class<?>[] classArray;
                    bl2 = true;
                    boolean bl3 = true;
                    method2 = (Method)iterator.next();
                    Class<?>[] classArray2 = method2.getParameterTypes();
                    if (classArray2.length != (classArray = method.getParameterTypes()).length) {
                        bl3 = false;
                    } else {
                        for (int i = 0; i < classArray.length; ++i) {
                            if (classArray2[i].equals(classArray[i])) continue;
                            bl3 = false;
                            break;
                        }
                    }
                    if (!bl3) continue;
                    bl = false;
                    break;
                }
                if (!bl2) {
                    method2 = this.beanClass.getMethod(string, method.getParameterTypes());
                }
                if (bl2 && bl) {
                    if (this.checkingRemoteClientView()) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EO_METHOD_SIGNATURE_DOES_NOT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
                    } else {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ELO_METHOD_SIGNATURE_DOES_NOT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
                    }
                }
                if (!ComplianceUtils.returnTypesMatch(method, method2)) {
                    if (this.checkingRemoteClientView()) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EO_RETURN_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
                    } else {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ELO_RETURN_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
                    }
                }
                ComplianceUtils.exceptionTypesMatch(method, method2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.checkingRemoteClientView()) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EO_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, this.methodSig(method))));
                    continue;
                }
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ELO_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, this.methodSig(method))));
            }
            catch (ExceptionTypeMismatchException exceptionTypeMismatchException) {
                String string2 = this.methodSig(method);
                object = this.checkingRemoteClientView() ? this.fmt.EO_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, string2) : this.fmt.ELO_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, string2);
                EJBLogger.logComplianceWarning((String)this.ejbName, (String)string2, (String)(this.checkingRemoteClientView() ? "remote" : "local"), (Throwable)new ComplianceException((String)object));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkLocalExposeThroughRemote() throws ErrorCollectionException {
        if (!this.checkingRemoteClientView()) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = this.eoClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!ComplianceUtils.localExposeThroughRemote(method)) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_INTERFACE_TYPES_EXPOSE_THROUGH_REMOTE_INTERFACE(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkRelationExposedThroughRemote() throws ErrorCollectionException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        if (!this.checkingRemoteClientView()) {
            return;
        }
        if (!this.uses20CMP) {
            return;
        }
        if (this.relationships == null) {
            return;
        }
        Map map = this.relationships.getAllEjbRelations();
        if (map.size() <= 0) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object52 : map.keySet()) {
            object4 = (EjbRelation)map.get(object52);
            for (Object object6 : object4.getAllEjbRelationshipRoles()) {
                object3 = object6.getRoleSource();
                if (!object3.getEjbName().equals(this.ejbName) || (object2 = object6.getCmrField()) == null) continue;
                object = object2.getName();
                string = object2.getType();
                String string2 = RDBMSUtils.getterMethodName((String)object);
                String string3 = RDBMSUtils.setterMethodName((String)object);
                hashMap.put(string2, string);
                hashMap.put(string3, string);
            }
        }
        Object object7 = new ErrorCollectionException();
        object52 = PersistenceUtils.getAccessorMethodMap(this.beanClass);
        object4 = PersistenceUtils.getAccessorMethodMap(this.remoteInterfaceClass);
        for (Object object6 : object4.keySet()) {
            if (hashMap.get(object6) == null) continue;
            object3 = (Method)object52.get(object6);
            object2 = DDUtils.getMethodSignature((Method)object3);
            object = (Method)object4.get(object6);
            string = DDUtils.getMethodSignature((Method)object);
            if (!string.equals(object2)) continue;
            object7.add(new ComplianceException(this.fmt.CANNOT_EXPOSE_RELATIONSHIP_ACCESSOR_IN_REMOTE(this.ejbName, this.remoteInterfaceClass.getName(), (String)object6)));
        }
        if (!object7.isEmpty()) {
            throw object7;
        }
    }
}

