/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.Set;
import javax.ejb.MessageDrivenBean;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.MessageDrivenBeanClassChecker;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.wl.MessageDrivenDescriptorBean;

public final class Ejb30MessageDrivenBeanClassChecker
extends MessageDrivenBeanClassChecker {
    private DeploymentInfo di;
    private EjbJarBean ejbJarBean;
    private BeanInfo bi;

    public Ejb30MessageDrivenBeanClassChecker(BeanInfo beanInfo) {
        super(beanInfo);
        this.bi = beanInfo;
        this.di = beanInfo.getDeploymentInfo();
        EjbDescriptorBean ejbDescriptorBean = this.di.getEjbDescriptorBean();
        this.ejbJarBean = ejbDescriptorBean.getEjbJarBean();
    }

    public void checkMDBInterfaceConstraints() throws ComplianceException {
        String string;
        Object object;
        String string2 = this.bi.getBeanClassName();
        String string3 = this.bi.getEJBName();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = null;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray2 = null;
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getMessageDrivens();
        for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
            MessageDrivenBeanBean messageDrivenBeanBean;
            object = this.di.getBeanInfo(messageDrivenBeanBeanArray[i].getEjbName());
            if (!object.isEJB30() || !(string = (messageDrivenBeanBean = messageDrivenBeanBeanArray[i]).getEjbClass()).equals(string2)) continue;
            lifecycleCallbackBeanArray = messageDrivenBeanBean.getPreDestroys();
            lifecycleCallbackBeanArray2 = messageDrivenBeanBean.getPostConstructs();
            break;
        }
        Class clazz = this.bi.getBeanClass();
        try {
            object = clazz.getMethod("ejbCreate", null);
            if (lifecycleCallbackBeanArray2 != null && lifecycleCallbackBeanArray2.length > 0) {
                for (int i = 0; i < lifecycleCallbackBeanArray2.length; ++i) {
                    string = lifecycleCallbackBeanArray2[i].getLifecycleCallbackMethod();
                    String string4 = lifecycleCallbackBeanArray2[i].getLifecycleCallbackClass();
                    if (!string4.equals(clazz.getName()) || string.equals("ejbCreate")) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().MDB_POSTCONSTRUCT_NOT_APPLY_EJBCREATE(string3));
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (MessageDrivenBean.class.isAssignableFrom(clazz) && lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length > 0) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string5 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                if (!string.equals(clazz.getName()) || string5.equals("ejbRemove")) continue;
                throw new ComplianceException(EJBComplianceTextFormatter.getInstance().MDB_PREDESTROY_NOT_APPLY_EJBREMOVE(string3));
            }
        }
    }

    public static boolean validateForConflictingConfiguration(CompositeMBeanDescriptor compositeMBeanDescriptor, Set set, String string) throws ComplianceException {
        boolean bl;
        boolean bl2;
        MessageDrivenDescriptorBean messageDrivenDescriptorBean = compositeMBeanDescriptor.getWl60Bean().getMessageDrivenDescriptor();
        boolean bl3 = set.contains("CONNECTIONFACTORYRESOURCELINK") || messageDrivenDescriptorBean.getConnectionFactoryResourceLink() != null || set.contains("DESTINATIONRESOURCELINK") || messageDrivenDescriptorBean.getDestinationResourceLink() != null;
        boolean bl4 = bl2 = set.contains("DESTINATIONJNDINAME") || compositeMBeanDescriptor.getDestinationJNDIName() != null || set.contains("INITIALCONTEXTFACTORY") || Ejb30MessageDrivenBeanClassChecker.isSet("InitialContextFactory", messageDrivenDescriptorBean) || set.contains("PROVIDERURL") || messageDrivenDescriptorBean.getProviderUrl() != null || set.contains("CONNECTIONFACTORYJNDINAME") || Ejb30MessageDrivenBeanClassChecker.isSet("ConnectionFactoryJNDIName", messageDrivenDescriptorBean);
        if (bl3 && bl2) {
            throw new ComplianceException("The ConnectionFactoryResourceLink and DestinationResourceLink configuration attributes cannot be mixed with any of the following settings: DestinationJNDIName, InitialContextFactory, ProviderUrl, ConnectionFactoryJNDIName.  Please ensure they are mutually exclusive for ejb " + string + ".");
        }
        boolean bl5 = set.contains("RESOURCEADAPTERJNDINAME") || messageDrivenDescriptorBean.getResourceAdapterJNDIName() != null;
        boolean bl6 = bl = set.contains("JMSCLIENTID") || messageDrivenDescriptorBean.getJmsClientId() != null || set.contains("JMSPOLLINGINTERVALSECONDS") || Ejb30MessageDrivenBeanClassChecker.isSet("JmsPollingIntervalSeconds", messageDrivenDescriptorBean) || set.contains("MAXMESSAGESINTRANSACTION") || Ejb30MessageDrivenBeanClassChecker.isSet("MaxMessagesInTransaction", messageDrivenDescriptorBean) || set.contains("DURABLESUBSCRIPTIONDELETION") || Ejb30MessageDrivenBeanClassChecker.isSet("DurableSubscriptionDeletion", messageDrivenDescriptorBean) || set.contains("DISTRIBUTEDDESTINATIONCONNECTION") || Ejb30MessageDrivenBeanClassChecker.isSet("DistributedDestinationConnection", messageDrivenDescriptorBean) || set.contains("USE81STYLEPOLLING") || Ejb30MessageDrivenBeanClassChecker.isSet("Use81StylePolling", messageDrivenDescriptorBean) || set.contains("MINIMIZEAQSESSIONS") || Ejb30MessageDrivenBeanClassChecker.isSet("GenerateUniqueJmsClientId", messageDrivenDescriptorBean);
        if (bl5 && (bl3 || bl2 || bl)) {
            throw new ComplianceException("The ResourceAdapterJNDIName configuration attributes cannot be mixed with any of the following settings: JmsClientId, JmsPollingIntervalSeconds, MaxMessagesInTransaction, DurableSubscriptionDeletion, DistributedDestinationConnection,use81StylePolling,ConnectionFactoryResourceLink, DestinationResourceLink, InitialContextFactory, providerUrl, connectionFactoryJNDIName, destinationJNDIName. .  Please ensure they are mutually exclusive for ejb " + string + ".");
        }
        return true;
    }

    private static boolean isSet(String string, Object object) {
        return ((DescriptorBean)object).isSet(string);
    }
}

