/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.SessionBean;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.SessionBeanClassChecker;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.utils.ErrorCollectionException;

public final class Ejb30SessionBeanClassChecker
extends SessionBeanClassChecker {
    private Ejb3SessionBeanInfo sbi;
    private DeploymentInfo di;
    private EjbJarBean ejbJarBean;
    private boolean isStateful;

    public Ejb30SessionBeanClassChecker(ClientDrivenBeanInfo clientDrivenBeanInfo) throws ClassNotFoundException {
        super(clientDrivenBeanInfo);
        this.sbi = (Ejb3SessionBeanInfo)clientDrivenBeanInfo;
        this.di = this.sbi.getDeploymentInfo();
        EjbDescriptorBean ejbDescriptorBean = this.di.getEjbDescriptorBean();
        this.ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        this.isStateful = this.sbi.isStateful();
    }

    public void checkSBInterfaceConstraints() throws ComplianceException {
        Object object;
        String string;
        Object object2;
        String string2 = this.sbi.getBeanClassName();
        String string3 = this.sbi.getEJBName();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = null;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray2 = null;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray3 = null;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray4 = null;
        SessionBeanBean[] sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            object2 = this.di.getBeanInfo(sessionBeanBeanArray[i].getEjbName());
            if (!object2.isEJB30() || !(string = (object = sessionBeanBeanArray[i]).getEjbClass()).equals(string2)) continue;
            lifecycleCallbackBeanArray4 = object.getPostConstructs();
            lifecycleCallbackBeanArray = object.getPreDestroys();
            if (!this.isStateful) break;
            lifecycleCallbackBeanArray2 = object.getPostActivates();
            lifecycleCallbackBeanArray3 = object.getPrePassivates();
            break;
        }
        Class clazz = this.sbi.getBeanClass();
        if (!this.sbi.isStateful()) {
            try {
                object2 = clazz.getMethod("ejbCreate", null);
                if (lifecycleCallbackBeanArray4 != null && lifecycleCallbackBeanArray4.length > 0) {
                    for (int i = 0; i < lifecycleCallbackBeanArray4.length; ++i) {
                        string = lifecycleCallbackBeanArray4[i].getLifecycleCallbackMethod();
                        String string4 = lifecycleCallbackBeanArray4[i].getLifecycleCallbackClass();
                        if (!string4.equals(clazz.getName()) || string.equals("ejbCreate")) continue;
                        throw new ComplianceException(EJBComplianceTextFormatter.getInstance().SLSB_POSTCONSTRUCT_NOT_APPLY_EJBCREATE(string3));
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (SessionBean.class.isAssignableFrom(clazz)) {
            if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length > 0) {
                for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                    object = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                    string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                    if (!string.equals(clazz.getName()) || ((String)object).equals("ejbRemove")) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().SESSION_BEAN_PREDESTROY_NOT_APPLY_EJBREMOVE(string3));
                }
            }
            if (lifecycleCallbackBeanArray2 != null && lifecycleCallbackBeanArray2.length > 0) {
                for (int i = 0; i < lifecycleCallbackBeanArray2.length; ++i) {
                    object = lifecycleCallbackBeanArray2[i].getLifecycleCallbackMethod();
                    string = lifecycleCallbackBeanArray2[i].getLifecycleCallbackClass();
                    if (!string.equals(clazz.getName()) || ((String)object).equals("ejbActivate")) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().SESSION_BEAN_POSTACTIVATE_NOT_APPLY_EJBACTIVE(string3));
                }
            }
            if (lifecycleCallbackBeanArray3 != null && lifecycleCallbackBeanArray3.length > 0) {
                for (int i = 0; i < lifecycleCallbackBeanArray3.length; ++i) {
                    object = lifecycleCallbackBeanArray3[i].getLifecycleCallbackMethod();
                    string = lifecycleCallbackBeanArray3[i].getLifecycleCallbackClass();
                    if (!string.equals(clazz.getName()) || ((String)object).equals("ejbPassivate")) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().SESSION_BEAN_PREPASSIVATE_NOT_APPLY_EJBPASSIVATE(string3));
                }
            }
        }
    }

    public void checkBusinessMethods() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Set set = this.getAllBusinessMethods();
        for (Method method : set) {
            try {
                this.validateBusinessMethod(method);
            }
            catch (ErrorCollectionException errorCollectionException2) {
                errorCollectionException.add((Throwable)errorCollectionException2);
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateBusinessMethod(Method method) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = method.getModifiers();
        if (method.getName().startsWith("ejb")) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().METHOD_CANNOT_START_WITH_EJB(method.getName(), method.getDeclaringClass().getName())));
        }
        if (!Modifier.isPublic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().BUSINESS_METHOD_MUST_BE_PUBLIC(method.getName(), method.getDeclaringClass().getName())));
        }
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().BUSINESS_METHOD_MUST_NOT_BE_FINAL(method.getName(), method.getDeclaringClass().getName())));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().BUSINESS_METHOD_MUST_NOT_BE_STATIC(method.getName(), method.getDeclaringClass().getName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private Set getAllBusinessMethods() {
        Object object;
        Object object2;
        Object object32;
        HashSet<Method> hashSet = new HashSet<Method>();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        Method[] methodArray = this.sbi.getBeanClass().getMethods();
        String[] stringArray = new String[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            stringArray[i] = DDUtils.getMethodSignature(methodArray[i]);
            hashMap.put(stringArray[i], methodArray[i]);
        }
        Set set = this.sbi.getBusinessLocals();
        for (Object object32 : set) {
            object2 = ((Class)object32).getMethods();
            for (int i = 0; i < ((Method[])object2).length; ++i) {
                String string = DDUtils.getMethodSignature(object2[i]);
                object = (Method)hashMap.get(string);
                if (object == null) continue;
                hashSet.add((Method)object);
            }
        }
        Set set2 = this.sbi.getBusinessRemotes();
        object32 = set2.iterator();
        while (object32.hasNext()) {
            object2 = (Class)object32.next();
            Method[] methodArray2 = ((Class)object2).getMethods();
            for (int i = 0; i < methodArray2.length; ++i) {
                object = DDUtils.getMethodSignature(methodArray2[i]);
                Method method = (Method)hashMap.get(object);
                if (method == null) continue;
                hashSet.add(method);
            }
        }
        return hashSet;
    }

    public static void validateRemoveMethodToBeBusinessMethod(SessionBeanBean sessionBeanBean, MethodInfo methodInfo, String string) throws ComplianceException {
        if (methodInfo == null) {
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().REMOVE_METHOD_NOT_BE_BUSINESS_METHOD(string.toString(), sessionBeanBean.getEjbName()));
        }
    }
}

